/*     */ package org.jboss.wsf.spi.metadata.j2ee.serviceref;
/*     */ 
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URL;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.List;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.ws.WebServiceException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.wsf.spi.SPIProvider;
/*     */ import org.jboss.wsf.spi.SPIProviderResolver;
/*     */ import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
/*     */ import org.jboss.wsf.spi.serviceref.ServiceRefMetaData;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class UnifiedServiceRefMetaData extends ServiceRefMetaData
/*     */ {
/*  51 */   private static Logger log = Logger.getLogger(UnifiedServiceRefMetaData.class);
/*     */   private UnifiedVirtualFile vfsRoot;
/*     */   private String serviceRefName;
/*     */   private String serviceInterface;
/*     */   private String serviceRefType;
/*     */   private String wsdlFile;
/*     */   private String mappingFile;
/*     */   private QName serviceQName;
/*  70 */   private List<UnifiedPortComponentRefMetaData> portComponentRefs = new ArrayList();
/*     */ 
/*  72 */   private List<UnifiedHandlerMetaData> handlers = new ArrayList();
/*     */   private UnifiedHandlerChainsMetaData handlerChains;
/*     */   private String serviceImplClass;
/*     */   private String configName;
/*     */   private String configFile;
/*     */   private String wsdlOverride;
/*     */   private String handlerChain;
/*  89 */   private List<UnifiedCallPropertyMetaData> callProperties = new ArrayList();
/*     */   private transient Object anElement;
/*     */   private transient boolean processed;
/*     */ 
/*     */   public UnifiedServiceRefMetaData(UnifiedVirtualFile vfRoot)
/*     */   {
/*  98 */     this.vfsRoot = vfRoot;
/*     */   }
/*     */ 
/*     */   public UnifiedServiceRefMetaData()
/*     */   {
/*     */   }
/*     */ 
/*     */   public void merge(ServiceRefMetaData sref)
/*     */   {
/* 107 */     UnifiedServiceRefMetaData sourceRef = (UnifiedServiceRefMetaData)sref;
/* 108 */     this.serviceImplClass = sourceRef.serviceImplClass;
/* 109 */     this.configName = sourceRef.configName;
/* 110 */     this.configFile = sourceRef.configFile;
/* 111 */     this.wsdlOverride = sourceRef.wsdlOverride;
/* 112 */     this.handlerChain = sourceRef.handlerChain;
/* 113 */     this.callProperties = sourceRef.callProperties;
/*     */ 
/* 115 */     if ((this.serviceQName == null) && (sourceRef.serviceQName != null)) {
/* 116 */       this.serviceQName = sourceRef.serviceQName;
/*     */     }
/* 118 */     for (UnifiedPortComponentRefMetaData pcref : sourceRef.getPortComponentRefs())
/*     */     {
/* 120 */       String seiName = pcref.getServiceEndpointInterface();
/* 121 */       QName portQName = pcref.getPortQName();
/* 122 */       UnifiedPortComponentRefMetaData targetPCRef = getPortComponentRef(seiName, portQName);
/*     */ 
/* 124 */       if (targetPCRef == null)
/*     */       {
/* 126 */         log.warn("Cannot find port component ref: [sei=" + seiName + ",port=" + portQName + "]");
/* 127 */         if (seiName != null)
/* 128 */           addPortComponentRef(pcref);
/*     */         else {
/* 130 */           log.warn("Ingore port component ref without SEI declaration: " + pcref);
/*     */         }
/* 132 */         targetPCRef = pcref;
/*     */       }
/*     */ 
/* 135 */       targetPCRef.merge(pcref);
/*     */     }
/*     */   }
/*     */ 
/*     */   public UnifiedVirtualFile getVfsRoot()
/*     */   {
/* 141 */     return this.vfsRoot;
/*     */   }
/*     */ 
/*     */   public void setVfsRoot(UnifiedVirtualFile vfsRoot)
/*     */   {
/* 146 */     this.vfsRoot = vfsRoot;
/*     */   }
/*     */ 
/*     */   public String getServiceRefName()
/*     */   {
/* 151 */     return this.serviceRefName;
/*     */   }
/*     */ 
/*     */   public void setServiceRefName(String serviceRefName)
/*     */   {
/* 156 */     this.serviceRefName = serviceRefName;
/*     */   }
/*     */ 
/*     */   public String getMappingFile()
/*     */   {
/* 161 */     return this.mappingFile;
/*     */   }
/*     */ 
/*     */   public void setMappingFile(String mappingFile)
/*     */   {
/* 166 */     this.mappingFile = mappingFile;
/*     */   }
/*     */ 
/*     */   public URL getMappingLocation()
/*     */   {
/* 171 */     URL mappingURL = null;
/* 172 */     if (this.mappingFile != null)
/*     */     {
/*     */       try
/*     */       {
/* 176 */         mappingURL = this.vfsRoot.findChild(this.mappingFile).toURL();
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 180 */         throw new WebServiceException("Cannot find jaxrcp-mapping-file: " + this.mappingFile, e);
/*     */       }
/*     */     }
/* 183 */     return mappingURL;
/*     */   }
/*     */ 
/*     */   public Collection<UnifiedPortComponentRefMetaData> getPortComponentRefs()
/*     */   {
/* 188 */     return this.portComponentRefs;
/*     */   }
/*     */ 
/*     */   public UnifiedPortComponentRefMetaData getPortComponentRef(String seiName, QName portName)
/*     */   {
/* 193 */     UnifiedPortComponentRefMetaData matchingRef = null;
/* 194 */     for (UnifiedPortComponentRefMetaData ref : this.portComponentRefs)
/*     */     {
/* 196 */       if (ref.matches(seiName, portName))
/*     */       {
/* 198 */         if (matchingRef != null) {
/* 199 */           log.warn("Multiple matching port component ref: [sei=" + seiName + ",port=" + portName + "]");
/*     */         }
/* 201 */         matchingRef = ref;
/*     */       }
/*     */     }
/* 204 */     return matchingRef;
/*     */   }
/*     */ 
/*     */   public void addPortComponentRef(UnifiedPortComponentRefMetaData pcRef)
/*     */   {
/* 209 */     this.portComponentRefs.add(pcRef);
/*     */   }
/*     */ 
/*     */   public List<UnifiedHandlerMetaData> getHandlers()
/*     */   {
/* 214 */     return this.handlers;
/*     */   }
/*     */ 
/*     */   public void addHandler(UnifiedHandlerMetaData handler)
/*     */   {
/* 219 */     this.handlers.add(handler);
/*     */   }
/*     */ 
/*     */   public String getServiceInterface()
/*     */   {
/* 224 */     return this.serviceInterface;
/*     */   }
/*     */ 
/*     */   public void setServiceInterface(String serviceInterface)
/*     */   {
/* 229 */     this.serviceInterface = serviceInterface;
/*     */   }
/*     */ 
/*     */   public String getServiceImplClass()
/*     */   {
/* 234 */     return this.serviceImplClass;
/*     */   }
/*     */ 
/*     */   public void setServiceImplClass(String serviceImplClass)
/*     */   {
/* 239 */     this.serviceImplClass = serviceImplClass;
/*     */   }
/*     */ 
/*     */   public QName getServiceQName()
/*     */   {
/* 244 */     return this.serviceQName;
/*     */   }
/*     */ 
/*     */   public void setServiceQName(QName serviceQName)
/*     */   {
/* 249 */     this.serviceQName = serviceQName;
/*     */   }
/*     */ 
/*     */   public String getServiceRefType()
/*     */   {
/* 254 */     return this.serviceRefType;
/*     */   }
/*     */ 
/*     */   public void setServiceRefType(String serviceResType)
/*     */   {
/* 259 */     this.serviceRefType = serviceResType;
/*     */   }
/*     */ 
/*     */   public String getWsdlFile()
/*     */   {
/* 264 */     return this.wsdlFile;
/*     */   }
/*     */ 
/*     */   public void setWsdlFile(String wsdlFile)
/*     */   {
/* 269 */     this.wsdlFile = wsdlFile;
/*     */   }
/*     */ 
/*     */   public URL getWsdlLocation()
/*     */   {
/* 274 */     URL wsdlLocation = null;
/* 275 */     if (this.wsdlOverride != null)
/*     */     {
/*     */       try
/*     */       {
/* 279 */         wsdlLocation = new URL(this.wsdlOverride);
/*     */       }
/*     */       catch (MalformedURLException e1)
/*     */       {
/*     */         try
/*     */         {
/* 285 */           wsdlLocation = this.vfsRoot.findChild(this.wsdlOverride).toURL();
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 289 */           throw new WebServiceException("Cannot find wsdl-override: " + this.wsdlOverride, e);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 294 */     if ((wsdlLocation == null) && (this.wsdlFile != null))
/*     */     {
/*     */       try
/*     */       {
/* 298 */         wsdlLocation = this.vfsRoot.findChild(this.wsdlFile).toURL();
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 302 */         throw new WebServiceException("Cannot find wsdl-file: " + this.wsdlFile, e);
/*     */       }
/*     */     }
/*     */ 
/* 306 */     return wsdlLocation;
/*     */   }
/*     */ 
/*     */   public String getConfigFile()
/*     */   {
/* 311 */     return this.configFile;
/*     */   }
/*     */ 
/*     */   public void setConfigFile(String configFile)
/*     */   {
/* 316 */     this.configFile = configFile;
/*     */   }
/*     */ 
/*     */   public String getConfigName()
/*     */   {
/* 321 */     return this.configName;
/*     */   }
/*     */ 
/*     */   public void setConfigName(String configName)
/*     */   {
/* 326 */     this.configName = configName;
/*     */   }
/*     */ 
/*     */   public String getWsdlOverride()
/*     */   {
/* 331 */     return this.wsdlOverride;
/*     */   }
/*     */ 
/*     */   public void setWsdlOverride(String wsdlOverride)
/*     */   {
/* 336 */     this.wsdlOverride = wsdlOverride;
/*     */   }
/*     */ 
/*     */   public List<UnifiedCallPropertyMetaData> getCallProperties()
/*     */   {
/* 341 */     return this.callProperties;
/*     */   }
/*     */ 
/*     */   public void setCallProperties(List<UnifiedCallPropertyMetaData> callProps)
/*     */   {
/* 346 */     this.callProperties = callProps;
/*     */   }
/*     */ 
/*     */   public void addCallProperty(UnifiedCallPropertyMetaData callProp)
/*     */   {
/* 351 */     this.callProperties.add(callProp);
/*     */   }
/*     */ 
/*     */   public UnifiedHandlerChainsMetaData getHandlerChains()
/*     */   {
/* 356 */     return this.handlerChains;
/*     */   }
/*     */ 
/*     */   public void setHandlerChains(UnifiedHandlerChainsMetaData handlerChains)
/*     */   {
/* 361 */     this.handlerChains = handlerChains;
/*     */   }
/*     */ 
/*     */   public String getHandlerChain()
/*     */   {
/* 366 */     return this.handlerChain;
/*     */   }
/*     */ 
/*     */   public void setHandlerChain(String handlerChain)
/*     */   {
/* 371 */     this.handlerChain = handlerChain;
/*     */   }
/*     */ 
/*     */   public Object getAnnotatedElement()
/*     */   {
/* 376 */     return this.anElement;
/*     */   }
/*     */ 
/*     */   public boolean isProcessed()
/*     */   {
/* 382 */     return this.processed;
/*     */   }
/*     */ 
/*     */   public void setProcessed(boolean flag)
/*     */   {
/* 387 */     this.processed = flag;
/*     */   }
/*     */ 
/*     */   public void setAnnotatedElement(Object anElement)
/*     */   {
/* 392 */     this.anElement = anElement;
/*     */   }
/*     */ 
/*     */   public void importStandardXml(Element root)
/*     */   {
/* 398 */     SPIProvider provider = SPIProviderResolver.getInstance().getProvider();
/* 399 */     ServiceRefMetaDataParserFactory factory = (ServiceRefMetaDataParserFactory)provider.getSPI(ServiceRefMetaDataParserFactory.class);
/* 400 */     factory.getServiceRefMetaDataParser().importStandardXml(root, this);
/*     */   }
/*     */ 
/*     */   public void importJBossXml(Element root)
/*     */   {
/* 406 */     SPIProvider provider = SPIProviderResolver.getInstance().getProvider();
/* 407 */     ServiceRefMetaDataParserFactory factory = (ServiceRefMetaDataParserFactory)provider.getSPI(ServiceRefMetaDataParserFactory.class);
/* 408 */     factory.getServiceRefMetaDataParser().importJBossXml(root, this);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 413 */     StringBuilder str = new StringBuilder();
/* 414 */     str.append("\nUnifiedServiceRef");
/* 415 */     str.append("\n serviceRefName=" + this.serviceRefName);
/* 416 */     str.append("\n serviceInterface=" + this.serviceInterface);
/* 417 */     str.append("\n serviceImplClass=" + this.serviceImplClass);
/* 418 */     str.append("\n serviceRefType=" + this.serviceRefType);
/* 419 */     str.append("\n serviceQName=" + this.serviceQName);
/* 420 */     str.append("\n anElement=" + this.anElement);
/* 421 */     str.append("\n wsdlFile=" + this.wsdlFile);
/* 422 */     str.append("\n wsdlOverride=" + this.wsdlOverride);
/* 423 */     str.append("\n mappingFile=" + this.mappingFile);
/* 424 */     str.append("\n configName=" + this.configName);
/* 425 */     str.append("\n configFile=" + this.configFile);
/* 426 */     str.append("\n callProperties=" + this.callProperties);
/* 427 */     str.append("\n processed=" + this.processed);
/* 428 */     str.append("\n handlerChains=" + this.handlerChains);
/* 429 */     str.append("\n handlerChain=" + this.handlerChain);
/* 430 */     for (UnifiedHandlerMetaData uhmd : this.handlers)
/* 431 */       str.append(uhmd.toString());
/* 432 */     for (UnifiedPortComponentRefMetaData pcref : this.portComponentRefs)
/* 433 */       str.append(pcref.toString());
/* 434 */     return str.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData
 * JD-Core Version:    0.6.0
 */