/*     */ package org.jboss.wsf.spi.metadata.j2ee.serviceref;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.wsf.spi.SPIProvider;
/*     */ import org.jboss.wsf.spi.SPIProviderResolver;
/*     */ import org.jboss.wsf.spi.serviceref.ServiceRefElement;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class UnifiedPortComponentRefMetaData extends ServiceRefElement
/*     */ {
/*     */   private UnifiedServiceRefMetaData serviceRefMetaData;
/*     */   private String serviceEndpointInterface;
/*  48 */   private Boolean enableMTOM = Boolean.FALSE;
/*     */   private String portComponentLink;
/*     */   private QName portQName;
/*  54 */   private List<UnifiedCallPropertyMetaData> callProperties = new ArrayList();
/*     */ 
/*  56 */   private List<UnifiedStubPropertyMetaData> stubProperties = new ArrayList();
/*     */   private String configName;
/*     */   private String configFile;
/*     */ 
/*     */   public UnifiedPortComponentRefMetaData(UnifiedServiceRefMetaData serviceRefMetaData)
/*     */   {
/*  64 */     this.serviceRefMetaData = serviceRefMetaData;
/*     */   }
/*     */ 
/*     */   public void merge(UnifiedPortComponentRefMetaData pcref)
/*     */   {
/*  69 */     this.portQName = pcref.portQName;
/*  70 */     this.configName = pcref.configName;
/*  71 */     this.configFile = pcref.configFile;
/*  72 */     this.callProperties = pcref.callProperties;
/*  73 */     this.stubProperties = pcref.stubProperties;
/*     */   }
/*     */ 
/*     */   public UnifiedServiceRefMetaData getServiceRefMetaData()
/*     */   {
/*  78 */     return this.serviceRefMetaData;
/*     */   }
/*     */ 
/*     */   public Boolean getEnableMTOM()
/*     */   {
/*  83 */     return this.enableMTOM;
/*     */   }
/*     */ 
/*     */   public void setEnableMTOM(Boolean enableMTOM)
/*     */   {
/*  88 */     this.enableMTOM = enableMTOM;
/*     */   }
/*     */ 
/*     */   public String getPortComponentLink()
/*     */   {
/* 104 */     return this.portComponentLink;
/*     */   }
/*     */ 
/*     */   public void setPortComponentLink(String portComponentLink)
/*     */   {
/* 109 */     this.portComponentLink = portComponentLink;
/*     */   }
/*     */ 
/*     */   public String getServiceEndpointInterface()
/*     */   {
/* 114 */     return this.serviceEndpointInterface;
/*     */   }
/*     */ 
/*     */   public void setServiceEndpointInterface(String serviceEndpointInterface)
/*     */   {
/* 119 */     this.serviceEndpointInterface = serviceEndpointInterface;
/*     */   }
/*     */ 
/*     */   public QName getPortQName()
/*     */   {
/* 124 */     return this.portQName;
/*     */   }
/*     */ 
/*     */   public void setPortQName(QName portQName)
/*     */   {
/* 129 */     this.portQName = portQName;
/*     */   }
/*     */ 
/*     */   public List<UnifiedCallPropertyMetaData> getCallProperties()
/*     */   {
/* 134 */     return this.callProperties;
/*     */   }
/*     */ 
/*     */   public void setCallProperties(List<UnifiedCallPropertyMetaData> callProps)
/*     */   {
/* 139 */     this.callProperties = callProps;
/*     */   }
/*     */ 
/*     */   public void addCallProperty(UnifiedCallPropertyMetaData callProp)
/*     */   {
/* 144 */     this.callProperties.add(callProp);
/*     */   }
/*     */ 
/*     */   public List<UnifiedStubPropertyMetaData> getStubProperties()
/*     */   {
/* 149 */     return this.stubProperties;
/*     */   }
/*     */ 
/*     */   public void setStubProperties(List<UnifiedStubPropertyMetaData> stubProps)
/*     */   {
/* 154 */     this.stubProperties = stubProps;
/*     */   }
/*     */ 
/*     */   public void addStubProperty(UnifiedStubPropertyMetaData stubProp)
/*     */   {
/* 159 */     this.stubProperties.add(stubProp);
/*     */   }
/*     */ 
/*     */   public String getConfigFile()
/*     */   {
/* 164 */     return this.configFile;
/*     */   }
/*     */ 
/*     */   public void setConfigFile(String configFile)
/*     */   {
/* 169 */     this.configFile = configFile;
/*     */   }
/*     */ 
/*     */   public String getConfigName()
/*     */   {
/* 174 */     return this.configName;
/*     */   }
/*     */ 
/*     */   public void setConfigName(String configName)
/*     */   {
/* 179 */     this.configName = configName;
/*     */   }
/*     */ 
/*     */   public void importStandardXml(Element root)
/*     */   {
/* 184 */     SPIProvider provider = SPIProviderResolver.getInstance().getProvider();
/* 185 */     ServiceRefMetaDataParserFactory factory = (ServiceRefMetaDataParserFactory)provider.getSPI(ServiceRefMetaDataParserFactory.class);
/* 186 */     factory.getServiceRefMetaDataParser().importStandardXml(root, this);
/*     */   }
/*     */ 
/*     */   public void importJBossXml(Element root)
/*     */   {
/* 191 */     SPIProvider provider = SPIProviderResolver.getInstance().getProvider();
/* 192 */     ServiceRefMetaDataParserFactory factory = (ServiceRefMetaDataParserFactory)provider.getSPI(ServiceRefMetaDataParserFactory.class);
/* 193 */     factory.getServiceRefMetaDataParser().importJBossXml(root, this);
/*     */   }
/*     */ 
/*     */   public boolean matches(String seiName, QName portName)
/*     */   {
/* 198 */     if ((seiName == null) && (portName == null)) {
/* 199 */       throw new IllegalArgumentException("Cannot match against seiName=null && portName=null.");
/*     */     }
/* 201 */     boolean match = false;
/*     */ 
/* 204 */     if (portName != null) {
/* 205 */       match = portName.equals(getPortQName());
/*     */     }
/*     */ 
/* 208 */     if (!match) {
/* 209 */       match = seiName.equals(getServiceEndpointInterface());
/*     */     }
/* 211 */     return match;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 216 */     StringBuilder str = new StringBuilder();
/* 217 */     str.append("\nUnifiedPortComponentRef");
/* 218 */     str.append("\n serviceEndpointInterface=" + this.serviceEndpointInterface);
/* 219 */     str.append("\n portQName=" + this.portQName);
/* 220 */     str.append("\n enableMTOM=" + this.enableMTOM);
/* 221 */     str.append("\n portComponentLink=" + this.portComponentLink);
/* 222 */     str.append("\n callProperties=" + this.callProperties);
/* 223 */     str.append("\n stubProperties=" + this.stubProperties);
/* 224 */     str.append("\n configName=" + this.configName);
/* 225 */     str.append("\n configFile=" + this.configFile);
/* 226 */     return str.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedPortComponentRefMetaData
 * JD-Core Version:    0.6.0
 */