/*     */ package org.jboss.wsf.spi.metadata.j2ee.serviceref;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashSet;
/*     */ import java.util.List;
/*     */ import java.util.Set;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.wsf.spi.SPIProvider;
/*     */ import org.jboss.wsf.spi.SPIProviderResolver;
/*     */ import org.jboss.wsf.spi.serviceref.ServiceRefElement;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class UnifiedHandlerMetaData extends ServiceRefElement
/*     */ {
/*     */   private UnifiedHandlerChainMetaData handlerChain;
/*     */   private String handlerName;
/*     */   private String handlerClass;
/*  57 */   private List<UnifiedInitParamMetaData> initParams = new ArrayList();
/*     */ 
/*  59 */   private Set<QName> soapHeaders = new HashSet();
/*     */ 
/*  61 */   private Set<String> soapRoles = new HashSet();
/*     */ 
/*  63 */   private Set<String> portNames = new HashSet();
/*     */ 
/*     */   public UnifiedHandlerMetaData(UnifiedHandlerChainMetaData handlerChain)
/*     */   {
/*  67 */     this.handlerChain = handlerChain;
/*     */   }
/*     */ 
/*     */   public UnifiedHandlerMetaData()
/*     */   {
/*     */   }
/*     */ 
/*     */   public UnifiedHandlerChainMetaData getHandlerChain()
/*     */   {
/*  76 */     return this.handlerChain;
/*     */   }
/*     */ 
/*     */   public void setHandlerName(String value)
/*     */   {
/*  81 */     this.handlerName = value;
/*     */   }
/*     */ 
/*     */   public String getHandlerName()
/*     */   {
/*  86 */     return this.handlerName;
/*     */   }
/*     */ 
/*     */   public void setHandlerClass(String handlerClass)
/*     */   {
/*  91 */     this.handlerClass = handlerClass;
/*     */   }
/*     */ 
/*     */   public String getHandlerClass()
/*     */   {
/*  96 */     return this.handlerClass;
/*     */   }
/*     */ 
/*     */   public void addInitParam(UnifiedInitParamMetaData param)
/*     */   {
/* 101 */     this.initParams.add(param);
/*     */   }
/*     */ 
/*     */   public List<UnifiedInitParamMetaData> getInitParams()
/*     */   {
/* 106 */     return this.initParams;
/*     */   }
/*     */ 
/*     */   public void addSoapHeader(QName qName)
/*     */   {
/* 111 */     this.soapHeaders.add(qName);
/*     */   }
/*     */ 
/*     */   public Set<QName> getSoapHeaders()
/*     */   {
/* 116 */     return this.soapHeaders;
/*     */   }
/*     */ 
/*     */   public void addSoapRole(String value)
/*     */   {
/* 121 */     this.soapRoles.add(value);
/*     */   }
/*     */ 
/*     */   public Set<String> getSoapRoles()
/*     */   {
/* 126 */     return this.soapRoles;
/*     */   }
/*     */ 
/*     */   public Set<String> getPortNames()
/*     */   {
/* 131 */     return this.portNames;
/*     */   }
/*     */ 
/*     */   public void addPortName(String value)
/*     */   {
/* 136 */     this.portNames.add(value);
/*     */   }
/*     */ 
/*     */   public void importStandardXml(Element root)
/*     */   {
/* 141 */     SPIProvider provider = SPIProviderResolver.getInstance().getProvider();
/* 142 */     ServiceRefMetaDataParserFactory factory = (ServiceRefMetaDataParserFactory)provider.getSPI(ServiceRefMetaDataParserFactory.class);
/* 143 */     factory.getServiceRefMetaDataParser().importStandardXml(root, this);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 148 */     StringBuilder str = new StringBuilder();
/* 149 */     str.append("\nUnifiedHandlerMetaData");
/* 150 */     str.append("\n handlerName=" + this.handlerName);
/* 151 */     str.append("\n handlerClass=" + this.handlerClass);
/* 152 */     str.append("\n soapHeaders=" + this.soapHeaders);
/* 153 */     str.append("\n soapRoles=" + this.soapRoles);
/* 154 */     str.append("\n portNames=" + this.portNames);
/* 155 */     str.append("\n initParams=" + this.initParams);
/* 156 */     return str.toString();
/*     */   }
/*     */ 
/*     */   public static enum HandlerType
/*     */   {
/*  47 */     PRE, ENDPOINT, POST, ALL;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData
 * JD-Core Version:    0.6.0
 */