/*     */ package org.jboss.wsf.spi.metadata.j2ee.serviceref;
/*     */ 
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.xb.binding.ObjectModelFactory;
/*     */ import org.jboss.xb.binding.UnmarshallingContext;
/*     */ import org.xml.sax.Attributes;
/*     */ 
/*     */ public class HandlerChainsObjectFactory
/*     */   implements ObjectModelFactory
/*     */ {
/*  41 */   private static final Logger log = Logger.getLogger(HandlerChainsObjectFactory.class);
/*     */ 
/*     */   public Object newRoot(Object root, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/*  54 */     UnifiedHandlerChainsMetaData handlerConfigMetaData = new UnifiedHandlerChainsMetaData(UnifiedHandlerMetaData.HandlerType.ENDPOINT);
/*  55 */     return handlerConfigMetaData;
/*     */   }
/*     */ 
/*     */   public Object completeRoot(Object root, UnmarshallingContext ctx, String uri, String name)
/*     */   {
/*  60 */     return root;
/*     */   }
/*     */ 
/*     */   public Object newChild(UnifiedHandlerChainsMetaData handlerConfig, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/*  68 */     if ("handler-chain".equals(localName))
/*  69 */       return new UnifiedHandlerChainMetaData(handlerConfig);
/*  70 */     return null;
/*     */   }
/*     */ 
/*     */   public void addChild(UnifiedHandlerChainsMetaData handlerConfig, UnifiedHandlerChainMetaData handlerChain, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/*  79 */     handlerConfig.addHandlerChain(handlerChain);
/*     */   }
/*     */ 
/*     */   public Object newChild(UnifiedHandlerChainMetaData chainConfig, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/*  87 */     if ("handler".equals(localName))
/*  88 */       return new UnifiedHandlerMetaData(chainConfig);
/*  89 */     return null;
/*     */   }
/*     */ 
/*     */   public void addChild(UnifiedHandlerChainMetaData handlerConfig, UnifiedHandlerMetaData handler, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/*  97 */     handlerConfig.addHandler(handler);
/*     */   }
/*     */ 
/*     */   public Object newChild(UnifiedHandlerMetaData handler, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/* 105 */     if ("init-param".equals(localName))
/* 106 */       return new UnifiedInitParamMetaData();
/* 107 */     return null;
/*     */   }
/*     */ 
/*     */   public void addChild(UnifiedHandlerMetaData handler, UnifiedInitParamMetaData param, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 115 */     handler.addInitParam(param);
/*     */   }
/*     */ 
/*     */   public void setValue(UnifiedHandlerChainMetaData handlerChain, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*     */   {
/* 123 */     if (log.isTraceEnabled()) {
/* 124 */       log.trace("UnifiedHandlerChainMetaData setValue: nuri=" + namespaceURI + " localName=" + localName + " value=" + value);
/*     */     }
/* 126 */     if (localName.equals("protocol-bindings"))
/* 127 */       handlerChain.setProtocolBindings(value);
/* 128 */     else if (localName.equals("service-name-pattern"))
/* 129 */       handlerChain.setServiceNamePattern(navigator.resolveQName(value));
/* 130 */     else if (localName.equals("port-name-pattern"))
/* 131 */       handlerChain.setPortNamePattern(navigator.resolveQName(value));
/*     */   }
/*     */ 
/*     */   public void setValue(UnifiedHandlerMetaData handler, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*     */   {
/* 139 */     if (log.isTraceEnabled()) {
/* 140 */       log.trace("UnifiedHandlerMetaData setValue: nuri=" + namespaceURI + " localName=" + localName + " value=" + value);
/*     */     }
/* 142 */     if (localName.equals("handler-name"))
/* 143 */       handler.setHandlerName(value);
/* 144 */     else if (localName.equals("handler-class"))
/* 145 */       handler.setHandlerClass(value);
/*     */   }
/*     */ 
/*     */   public void setValue(UnifiedInitParamMetaData param, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*     */   {
/* 153 */     if (log.isTraceEnabled()) {
/* 154 */       log.trace("UnifiedInitParamMetaData setValue: nuri=" + namespaceURI + " localName=" + localName + " value=" + value);
/*     */     }
/* 156 */     if (localName.equals("param-name"))
/* 157 */       param.setParamName(value);
/* 158 */     else if (localName.equals("param-value"))
/* 159 */       param.setParamValue(value);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.wsf.spi.metadata.j2ee.serviceref.HandlerChainsObjectFactory
 * JD-Core Version:    0.6.0
 */