/*     */ package org.jboss.wsf.spi.deployment;
/*     */ 
/*     */ import java.util.HashSet;
/*     */ import java.util.Set;
/*     */ import java.util.StringTokenizer;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public abstract class DeploymentAspect
/*     */ {
/*  44 */   protected final Logger log = Logger.getLogger(getClass());
/*     */   public static final String LAST_DEPLOYMENT_ASPECT = "LAST_DEPLOYMENT_ASPECT";
/*     */   private String provides;
/*     */   private String requires;
/*     */ 
/*     */   public String getProvides()
/*     */   {
/*  53 */     return this.provides;
/*     */   }
/*     */ 
/*     */   public void setProvides(String provides)
/*     */   {
/*  58 */     this.provides = provides;
/*     */   }
/*     */ 
/*     */   public String getRequires()
/*     */   {
/*  63 */     return this.requires;
/*     */   }
/*     */ 
/*     */   public void setRequires(String requires)
/*     */   {
/*  68 */     this.requires = requires;
/*     */   }
/*     */ 
/*     */   public void create(Deployment dep)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void destroy(Deployment dep)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void start(Deployment dep)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void stop(Deployment dep)
/*     */   {
/*     */   }
/*     */ 
/*     */   public Set<String> getProvidesAsSet()
/*     */   {
/*  89 */     Set condset = new HashSet();
/*  90 */     if (this.provides != null)
/*     */     {
/*  92 */       StringTokenizer st = new StringTokenizer(this.provides, ", ");
/*  93 */       while (st.hasMoreTokens())
/*  94 */         condset.add(st.nextToken());
/*     */     }
/*  96 */     return condset;
/*     */   }
/*     */ 
/*     */   public Set<String> getRequiresAsSet()
/*     */   {
/* 101 */     Set condset = new HashSet();
/* 102 */     if (this.requires != null)
/*     */     {
/* 104 */       StringTokenizer st = new StringTokenizer(this.requires, ", ");
/* 105 */       while (st.hasMoreTokens())
/* 106 */         condset.add(st.nextToken());
/*     */     }
/* 108 */     return condset;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.wsf.spi.deployment.DeploymentAspect
 * JD-Core Version:    0.6.0
 */