/*    */ package org.jboss.wsf.spi.deployment;
/*    */ 
/*    */ import java.util.Collection;
/*    */ import java.util.HashMap;
/*    */ import java.util.Map;
/*    */ import java.util.Set;
/*    */ 
/*    */ public abstract class AbstractExtensible
/*    */   implements Extensible
/*    */ {
/* 41 */   private Map<Class, Object> attachments = new HashMap();
/* 42 */   private Map<String, Object> properties = new HashMap();
/*    */ 
/*    */   public Collection<Object> getAttachments()
/*    */   {
/* 46 */     return this.attachments.values();
/*    */   }
/*    */ 
/*    */   public <T> T getAttachment(Class<T> clazz)
/*    */   {
/* 51 */     return this.attachments.get(clazz);
/*    */   }
/*    */ 
/*    */   public <T> T addAttachment(Class<T> clazz, Object obj)
/*    */   {
/* 56 */     return this.attachments.put(clazz, obj);
/*    */   }
/*    */ 
/*    */   public <T> T removeAttachment(Class<T> key)
/*    */   {
/* 61 */     return this.attachments.remove(key);
/*    */   }
/*    */ 
/*    */   public Set<String> getProperties()
/*    */   {
/* 66 */     return this.properties.keySet();
/*    */   }
/*    */ 
/*    */   public Object getProperty(String key)
/*    */   {
/* 71 */     return this.properties.get(key);
/*    */   }
/*    */ 
/*    */   public void removeProperty(String key)
/*    */   {
/* 76 */     this.properties.remove(key);
/*    */   }
/*    */ 
/*    */   public void setProperty(String key, Object value)
/*    */   {
/* 81 */     this.properties.put(key, value);
/*    */   }
/*    */ 
/*    */   public void setProperties(Map<String, Object> props)
/*    */   {
/* 86 */     this.properties.putAll(props);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.wsf.spi.deployment.AbstractExtensible
 * JD-Core Version:    0.6.0
 */