/*     */ package org.jboss.ws.tools.wsdl;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.Writer;
/*     */ import java.util.Iterator;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.metadata.wsdl.DOMTypes;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLService;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLTypes;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLUtils;
/*     */ import org.jboss.ws.metadata.wsdl.XSModelTypes;
/*     */ import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
/*     */ import org.jboss.wsf.common.DOMUtils;
/*     */ import org.jboss.wsf.common.DOMWriter;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class WSDLWriter
/*     */ {
/*  56 */   protected static final Logger log = Logger.getLogger(WSDLWriter.class);
/*     */   protected WSDLDefinitions wsdl;
/*  59 */   protected WSDLUtils utils = WSDLUtils.getInstance();
/*     */ 
/*  62 */   protected String soapPrefix = "soap";
/*     */ 
/*  67 */   protected boolean includeSchemaInWSDL = true;
/*     */ 
/*     */   public WSDLWriter(WSDLDefinitions wsdl)
/*     */   {
/*  71 */     if (wsdl == null) {
/*  72 */       throw new IllegalArgumentException("WSDL definitions is NULL");
/*     */     }
/*  74 */     this.wsdl = wsdl;
/*     */   }
/*     */ 
/*     */   public void write(Writer writer, String charset)
/*     */     throws IOException
/*     */   {
/*  80 */     write(writer, charset, null);
/*     */   }
/*     */ 
/*     */   public void write(Writer writer, String charset, WSDLWriterResolver resolver) throws IOException
/*     */   {
/*  85 */     String wsdlNamespace = this.wsdl.getWsdlNamespace();
/*  86 */     if ("http://schemas.xmlsoap.org/wsdl/".equals(wsdlNamespace))
/*     */     {
/*  88 */       WSDL11Writer wsdl11Writer = new WSDL11Writer(this.wsdl);
/*  89 */       wsdl11Writer.write(writer, charset, resolver);
/*     */     }
/*     */     else
/*     */     {
/*  93 */       throw new WSException("Unsupported wsdl version: " + wsdlNamespace);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void write(Writer writer) throws IOException
/*     */   {
/*  99 */     StringBuilder buffer = new StringBuilder();
/* 100 */     buffer.append("<?xml version='1.0' encoding='UTF-8'?>");
/*     */ 
/* 102 */     appendDefinitions(buffer, this.wsdl.getTargetNamespace());
/* 103 */     appendTypes(buffer, this.wsdl.getTargetNamespace());
/* 104 */     appendInterfaces(buffer, this.wsdl.getTargetNamespace());
/* 105 */     appendBindings(buffer, this.wsdl.getTargetNamespace());
/* 106 */     appendServices(buffer, this.wsdl.getTargetNamespace());
/*     */ 
/* 108 */     buffer.append("</definitions>");
/*     */ 
/* 110 */     Element element = DOMUtils.parse(buffer.toString());
/* 111 */     new DOMWriter(writer).setPrettyprint(true).print(element);
/*     */   }
/*     */ 
/*     */   protected void appendDefinitions(StringBuilder buffer, String namespace)
/*     */   {
/* 116 */     buffer.append("<definitions");
/*     */ 
/* 118 */     WSDLService[] services = this.wsdl.getServices();
/* 119 */     if ((services != null) && (services.length == 1))
/*     */     {
/* 121 */       WSDLService ser = services[0];
/* 122 */       buffer.append(" name='" + ser.getName().getLocalPart() + "'");
/*     */     }
/* 124 */     buffer.append(" targetNamespace='" + namespace + "'");
/* 125 */     buffer.append(" xmlns='" + this.wsdl.getWsdlNamespace() + "'");
/*     */ 
/* 127 */     Iterator it = this.wsdl.getRegisteredNamespaceURIs();
/* 128 */     while (it.hasNext())
/*     */     {
/* 130 */       String namespaceURI = (String)it.next();
/* 131 */       String prefix = this.wsdl.getPrefix(namespaceURI);
/* 132 */       if (prefix.length() > 0)
/*     */       {
/* 134 */         buffer.append(" xmlns:" + prefix + "='" + namespaceURI + "'");
/* 135 */         if (prefix.startsWith("soap"))
/* 136 */           this.soapPrefix = prefix;
/*     */       }
/*     */     }
/* 139 */     buffer.append(">");
/*     */   }
/*     */ 
/*     */   protected void appendTypes(StringBuilder buffer, String namespace)
/*     */   {
/* 144 */     WSDLTypes wsdlTypes = this.wsdl.getWsdlTypes();
/*     */ 
/* 146 */     if ((wsdlTypes.getNamespace() != null) && (!wsdlTypes.getNamespace().equals(namespace))) {
/* 147 */       return;
/*     */     }
/* 149 */     if ((wsdlTypes instanceof XSModelTypes))
/*     */     {
/* 151 */       buffer.append("<types>");
/* 152 */       JBossXSModel xsM = WSDLUtils.getSchemaModel(wsdlTypes);
/* 153 */       String schema = xsM.serialize();
/* 154 */       buffer.append(schema);
/* 155 */       buffer.append("</types>");
/*     */     }
/* 157 */     else if ((wsdlTypes instanceof DOMTypes))
/*     */     {
/* 159 */       synchronized (wsdlTypes)
/*     */       {
/* 161 */         buffer.append(DOMWriter.printNode(((DOMTypes)wsdlTypes).getElement(), true));
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void appendInterfaces(StringBuilder buffer, String namespace)
/*     */   {
/*     */   }
/*     */ 
/*     */   protected void appendBindings(StringBuilder buffer, String namespace)
/*     */   {
/*     */   }
/*     */ 
/*     */   protected void appendServices(StringBuilder buffer, String namespace)
/*     */   {
/*     */   }
/*     */ 
/*     */   protected String getQNameRef(QName qname)
/*     */   {
/* 181 */     String retStr = qname.getLocalPart();
/*     */ 
/* 183 */     String prefix = qname.getPrefix();
/* 184 */     String nsURI = qname.getNamespaceURI();
/* 185 */     if ((prefix.length() == 0) && (nsURI.length() > 0))
/*     */     {
/* 187 */       qname = this.wsdl.registerQName(qname);
/* 188 */       prefix = qname.getPrefix();
/*     */     }
/*     */ 
/* 191 */     if (prefix.length() > 0) {
/* 192 */       retStr = prefix + ":" + retStr;
/*     */     }
/* 194 */     return retStr;
/*     */   }
/*     */ 
/*     */   public WSDLDefinitions getWsdl()
/*     */   {
/* 199 */     return this.wsdl;
/*     */   }
/*     */ 
/*     */   public void setWsdl(WSDLDefinitions wsdl)
/*     */   {
/* 204 */     this.wsdl = wsdl;
/*     */   }
/*     */ 
/*     */   public boolean isIncludeTypesInWSDL()
/*     */   {
/* 209 */     return this.includeSchemaInWSDL;
/*     */   }
/*     */ 
/*     */   public void logException(Exception e)
/*     */   {
/* 214 */     if (log.isTraceEnabled())
/*     */     {
/* 216 */       log.trace(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void logMessage(String msg)
/*     */   {
/* 222 */     if (log.isTraceEnabled())
/*     */     {
/* 224 */       log.trace(msg);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.tools.wsdl.WSDLWriter
 * JD-Core Version:    0.6.0
 */