/*     */ package org.jboss.ws.tools.wsdl;
/*     */ 
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.rpc.ParameterMode;
/*     */ import org.apache.ws.policy.Policy;
/*     */ import org.apache.ws.policy.util.PolicyFactory;
/*     */ import org.apache.ws.policy.util.PolicyWriter;
/*     */ import org.jboss.ws.Constants;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.core.soap.Style;
/*     */ import org.jboss.ws.extensions.policy.PolicyScopeLevel;
/*     */ import org.jboss.ws.extensions.policy.metadata.PolicyMetaExtension;
/*     */ import org.jboss.ws.metadata.umdm.EndpointMetaData;
/*     */ import org.jboss.ws.metadata.umdm.FaultMetaData;
/*     */ import org.jboss.ws.metadata.umdm.MetaDataExtension;
/*     */ import org.jboss.ws.metadata.umdm.OperationMetaData;
/*     */ import org.jboss.ws.metadata.umdm.ParameterMetaData;
/*     */ import org.jboss.ws.metadata.umdm.ServiceMetaData;
/*     */ import org.jboss.ws.metadata.wsdl.Extendable;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLBinding;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLBindingFault;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLBindingOperation;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLBindingOperationInput;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLBindingOperationOutput;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLEndpoint;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLExtensibilityElement;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLImport;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLInterface;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLInterfaceFault;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperation;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationInput;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationOutfault;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationOutput;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLProperty;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLRPCPart;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLRPCSignatureItem;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLRPCSignatureItem.Direction;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLSOAPHeader;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLService;
/*     */ import org.jboss.wsf.common.DOMUtils;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public abstract class WSDLGenerator
/*     */ {
/*     */   protected WSDLDefinitions wsdl;
/*     */ 
/*     */   protected abstract void processTypes();
/*     */ 
/*     */   protected void processEndpoint(WSDLService service, EndpointMetaData endpoint)
/*     */   {
/*  86 */     WSDLEndpoint wsdlEndpoint = new WSDLEndpoint(service, endpoint.getPortName());
/*  87 */     String address = endpoint.getEndpointAddress();
/*  88 */     wsdlEndpoint.setAddress(address == null ? "REPLACE_WITH_ACTUAL_URL" : address);
/*  89 */     service.addEndpoint(wsdlEndpoint);
/*     */ 
/*  91 */     QName interfaceQName = endpoint.getPortTypeName();
/*  92 */     WSDLInterface wsdlInterface = new WSDLInterface(this.wsdl, interfaceQName);
/*  93 */     this.wsdl.addInterface(wsdlInterface);
/*     */ 
/*  96 */     if (!interfaceQName.getNamespaceURI().equals(endpoint.getServiceMetaData().getServiceName().getNamespaceURI()))
/*     */     {
/*  98 */       WSDLImport wsdlImport = new WSDLImport(this.wsdl);
/*  99 */       wsdlImport.setLocation(interfaceQName.getLocalPart() + "_PortType");
/* 100 */       wsdlImport.setNamespace(interfaceQName.getNamespaceURI());
/* 101 */       this.wsdl.addImport(wsdlImport);
/* 102 */       this.wsdl.registerNamespaceURI(interfaceQName.getNamespaceURI(), null);
/*     */     }
/*     */ 
/* 105 */     QName bindingQName = new QName(interfaceQName.getNamespaceURI(), interfaceQName.getLocalPart() + "Binding");
/* 106 */     WSDLBinding wsdlBinding = new WSDLBinding(this.wsdl, bindingQName);
/* 107 */     wsdlBinding.setInterfaceName(interfaceQName);
/* 108 */     wsdlBinding.setType(endpoint.getBindingId());
/* 109 */     this.wsdl.addBinding(wsdlBinding);
/* 110 */     wsdlEndpoint.setBinding(bindingQName);
/*     */ 
/* 112 */     for (OperationMetaData operation : endpoint.getOperations())
/*     */     {
/* 114 */       processOperation(wsdlInterface, wsdlBinding, operation);
/*     */     }
/*     */ 
/* 118 */     MetaDataExtension ext = endpoint.getExtension("http://schemas.xmlsoap.org/ws/2004/09/policy");
/* 119 */     if (ext != null)
/*     */     {
/* 121 */       PolicyMetaExtension policyExt = (PolicyMetaExtension)ext;
/* 122 */       for (Policy policy : policyExt.getPolicies(PolicyScopeLevel.WSDL_PORT))
/*     */       {
/* 124 */         addPolicyDefinition(policy);
/* 125 */         addPolicyReference(policy, wsdlEndpoint);
/*     */       }
/* 127 */       for (Policy policy : policyExt.getPolicies(PolicyScopeLevel.WSDL_PORT_TYPE))
/*     */       {
/* 129 */         addPolicyDefinition(policy);
/* 130 */         addPolicyURIAttribute(policy, wsdlInterface);
/*     */       }
/* 132 */       for (Policy policy : policyExt.getPolicies(PolicyScopeLevel.WSDL_BINDING))
/*     */       {
/* 134 */         addPolicyDefinition(policy);
/* 135 */         addPolicyReference(policy, wsdlBinding);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void addPolicyDefinition(Policy policy)
/*     */   {
/*     */     try
/*     */     {
/* 144 */       PolicyWriter writer = PolicyFactory.getPolicyWriter(2);
/* 145 */       ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
/* 146 */       writer.writePolicy(policy, outputStream);
/* 147 */       Element element = DOMUtils.parse(outputStream.toString("UTF-8"));
/* 148 */       WSDLExtensibilityElement ext = new WSDLExtensibilityElement("http://www.jboss.org/jbossws/wsp/policy", element);
/* 149 */       this.wsdl.addExtensibilityElement(ext);
/*     */ 
/* 152 */       if (this.wsdl.getPrefix(element.getNamespaceURI()) == null)
/*     */       {
/* 154 */         this.wsdl.registerNamespaceURI(element.getNamespaceURI(), element.getPrefix());
/*     */       }
/*     */     }
/*     */     catch (IOException ioe)
/*     */     {
/* 159 */       throw new WSException("Error while converting policy to element!");
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void addPolicyReference(Policy policy, Extendable extendable)
/*     */   {
/* 165 */     QName policyRefQName = Constants.WSDL_ELEMENT_WSP_POLICYREFERENCE;
/* 166 */     String prefix = this.wsdl.getPrefix(policyRefQName.getNamespaceURI());
/* 167 */     if (prefix == null)
/*     */     {
/* 169 */       prefix = "wsp";
/* 170 */       this.wsdl.registerNamespaceURI(policyRefQName.getNamespaceURI(), prefix);
/*     */     }
/* 172 */     Element element = DOMUtils.createElement(policyRefQName.getLocalPart(), prefix);
/* 173 */     element.setAttribute("URI", policy.getPolicyURI());
/*     */ 
/* 175 */     WSDLExtensibilityElement ext = new WSDLExtensibilityElement("http://www.jboss.org/jbossws/wsp/policyReference", element);
/* 176 */     extendable.addExtensibilityElement(ext);
/*     */   }
/*     */ 
/*     */   protected void addPolicyURIAttribute(Policy policy, Extendable extendable)
/*     */   {
/* 182 */     WSDLProperty prop = extendable.getProperty("http://www.jboss.org/jbossws/wsp/policyURIs");
/* 183 */     if (prop == null)
/*     */     {
/* 185 */       extendable.addProperty(new WSDLProperty("http://www.jboss.org/jbossws/wsp/policyURIs", policy.getPolicyURI()));
/*     */     }
/*     */     else
/*     */     {
/* 190 */       prop.setValue(prop.getValue() + "," + policy.getPolicyURI());
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void processOperation(WSDLInterface wsdlInterface, WSDLBinding wsdlBinding, OperationMetaData operation)
/*     */   {
/* 197 */     WSDLInterfaceOperation interfaceOperation = new WSDLInterfaceOperation(wsdlInterface, operation.getQName());
/* 198 */     WSDLBindingOperation bindingOperation = new WSDLBindingOperation(wsdlBinding);
/*     */ 
/* 200 */     interfaceOperation.setPattern(operation.isOneWay() ? "http://www.w3.org/2004/08/wsdl/in-only" : "http://www.w3.org/2004/08/wsdl/in-out");
/*     */ 
/* 203 */     bindingOperation.setRef(operation.getQName());
/* 204 */     bindingOperation.setSOAPAction(operation.getSOAPAction());
/*     */ 
/* 206 */     if (operation.getStyle() == Style.DOCUMENT)
/* 207 */       processOperationDOC(interfaceOperation, bindingOperation, operation);
/*     */     else {
/* 209 */       processOperationRPC(interfaceOperation, bindingOperation, operation);
/*     */     }
/* 211 */     for (FaultMetaData fault : operation.getFaults())
/*     */     {
/* 213 */       QName faultName = new QName(operation.getQName().getNamespaceURI(), fault.getXmlName().getLocalPart());
/* 214 */       WSDLInterfaceFault interfaceFault = new WSDLInterfaceFault(wsdlInterface, faultName);
/* 215 */       interfaceFault.setElement(fault.getXmlName());
/* 216 */       wsdlInterface.addFault(interfaceFault);
/*     */ 
/* 218 */       WSDLInterfaceOperationOutfault outfault = new WSDLInterfaceOperationOutfault(interfaceOperation);
/* 219 */       outfault.setRef(faultName);
/* 220 */       interfaceOperation.addOutfault(outfault);
/*     */ 
/* 222 */       WSDLBindingFault bindingFault = new WSDLBindingFault(wsdlBinding);
/* 223 */       bindingFault.setRef(faultName);
/* 224 */       wsdlBinding.addFault(bindingFault);
/*     */     }
/*     */ 
/* 227 */     wsdlInterface.addOperation(interfaceOperation);
/* 228 */     wsdlBinding.addOperation(bindingOperation);
/*     */   }
/*     */ 
/*     */   protected void addSignatureItem(WSDLInterfaceOperation operation, ParameterMetaData param, boolean isReturn)
/*     */   {
/*     */     WSDLRPCSignatureItem.Direction direction;
/*     */     WSDLRPCSignatureItem.Direction direction;
/* 234 */     if (isReturn)
/*     */     {
/* 236 */       direction = WSDLRPCSignatureItem.Direction.RETURN;
/*     */     }
/*     */     else
/*     */     {
/*     */       WSDLRPCSignatureItem.Direction direction;
/* 238 */       if (param.getMode() == ParameterMode.INOUT)
/*     */       {
/* 240 */         direction = WSDLRPCSignatureItem.Direction.INOUT;
/*     */       }
/*     */       else
/*     */       {
/*     */         WSDLRPCSignatureItem.Direction direction;
/* 242 */         if (param.getMode() == ParameterMode.OUT)
/*     */         {
/* 244 */           direction = WSDLRPCSignatureItem.Direction.OUT;
/*     */         }
/*     */         else
/*     */         {
/* 248 */           direction = WSDLRPCSignatureItem.Direction.IN;
/*     */         }
/*     */       }
/*     */     }
/* 251 */     operation.addRpcSignatureItem(new WSDLRPCSignatureItem(param.getPartName(), direction));
/*     */   }
/*     */ 
/*     */   protected void processOperationDOC(WSDLInterfaceOperation interfaceOperation, WSDLBindingOperation bindingOperation, OperationMetaData operation)
/*     */   {
/* 256 */     interfaceOperation.setStyle("http://www.w3.org/2004/03/wsdl/style/iri");
/*     */ 
/* 258 */     WSDLInterfaceOperationInput input = new WSDLInterfaceOperationInput(interfaceOperation);
/* 259 */     WSDLBindingOperationInput bindingInput = new WSDLBindingOperationInput(bindingOperation);
/*     */ 
/* 261 */     WSDLInterfaceOperationOutput output = null;
/* 262 */     WSDLBindingOperationOutput bindingOutput = null;
/*     */ 
/* 264 */     boolean twoWay = !operation.isOneWay();
/* 265 */     if (twoWay)
/*     */     {
/* 267 */       output = new WSDLInterfaceOperationOutput(interfaceOperation);
/* 268 */       bindingOutput = new WSDLBindingOperationOutput(bindingOperation);
/*     */ 
/* 270 */       ParameterMetaData returnParameter = operation.getReturnParameter();
/* 271 */       if (returnParameter != null)
/*     */       {
/* 273 */         QName xmlName = returnParameter.getXmlName();
/* 274 */         String partName = returnParameter.getPartName();
/* 275 */         if (returnParameter.isInHeader())
/*     */         {
/* 277 */           WSDLSOAPHeader header = new WSDLSOAPHeader(xmlName, partName);
/* 278 */           header.setIncludeInSignature(true);
/* 279 */           bindingOutput.addSoapHeader(header);
/*     */         }
/*     */         else
/*     */         {
/* 283 */           output.setElement(xmlName);
/* 284 */           output.setPartName(partName);
/*     */         }
/* 286 */         addSignatureItem(interfaceOperation, returnParameter, true);
/*     */       }
/*     */ 
/* 291 */       interfaceOperation.addOutput(output);
/* 292 */       bindingOperation.addOutput(bindingOutput);
/*     */     }
/*     */ 
/* 295 */     for (ParameterMetaData param : operation.getParameters())
/*     */     {
/* 297 */       if (param.isInHeader())
/*     */       {
/* 299 */         WSDLSOAPHeader header = new WSDLSOAPHeader(param.getXmlName(), param.getPartName());
/* 300 */         header.setIncludeInSignature(true);
/* 301 */         if (param.getMode() != ParameterMode.OUT)
/* 302 */           bindingInput.addSoapHeader(header);
/* 303 */         if ((twoWay) && (param.getMode() != ParameterMode.IN))
/* 304 */           bindingOutput.addSoapHeader(header);
/*     */       }
/*     */       else
/*     */       {
/* 308 */         if (param.getMode() != ParameterMode.OUT)
/*     */         {
/* 310 */           input.setElement(param.getXmlName());
/* 311 */           input.setPartName(param.getPartName());
/*     */         }
/* 313 */         if ((twoWay) && (param.getMode() != ParameterMode.IN))
/*     */         {
/* 315 */           output.setElement(param.getXmlName());
/* 316 */           output.setPartName(param.getPartName());
/*     */         }
/*     */       }
/* 319 */       addSignatureItem(interfaceOperation, param, false);
/*     */     }
/*     */ 
/* 322 */     interfaceOperation.addInput(input);
/* 323 */     bindingOperation.addInput(bindingInput);
/*     */   }
/*     */ 
/*     */   protected void processOperationRPC(WSDLInterfaceOperation interfaceOperation, WSDLBindingOperation bindingOperation, OperationMetaData operation)
/*     */   {
/* 328 */     interfaceOperation.setStyle("http://www.w3.org/2004/03/wsdl/style/rpc");
/*     */ 
/* 330 */     WSDLInterfaceOperationInput input = new WSDLInterfaceOperationInput(interfaceOperation);
/* 331 */     WSDLBindingOperationInput bindingInput = new WSDLBindingOperationInput(bindingOperation);
/* 332 */     QName operationName = operation.getQName();
/* 333 */     input.setElement(operationName);
/*     */ 
/* 335 */     WSDLInterfaceOperationOutput output = null;
/* 336 */     WSDLBindingOperationOutput bindingOutput = null;
/*     */ 
/* 338 */     boolean twoWay = !operation.isOneWay();
/* 339 */     if (twoWay)
/*     */     {
/* 341 */       output = new WSDLInterfaceOperationOutput(interfaceOperation);
/* 342 */       bindingOutput = new WSDLBindingOperationOutput(bindingOperation);
/* 343 */       output.setElement(new QName(operationName.getNamespaceURI(), operationName.getLocalPart() + "Response"));
/*     */ 
/* 345 */       ParameterMetaData returnParameter = operation.getReturnParameter();
/* 346 */       if (returnParameter != null)
/*     */       {
/* 348 */         QName xmlName = returnParameter.getXmlName();
/* 349 */         String partName = returnParameter.getPartName();
/* 350 */         if (returnParameter.isInHeader())
/*     */         {
/* 352 */           WSDLSOAPHeader header = new WSDLSOAPHeader(xmlName, partName);
/* 353 */           header.setIncludeInSignature(true);
/* 354 */           bindingOutput.addSoapHeader(header);
/*     */         }
/*     */         else
/*     */         {
/* 358 */           WSDLRPCPart part = new WSDLRPCPart(returnParameter.getPartName(), returnParameter.getXmlType());
/* 359 */           output.addChildPart(part);
/*     */         }
/* 361 */         addSignatureItem(interfaceOperation, returnParameter, true);
/*     */       }
/*     */ 
/* 364 */       interfaceOperation.addOutput(output);
/* 365 */       bindingOperation.addOutput(bindingOutput);
/*     */     }
/*     */ 
/* 368 */     for (ParameterMetaData param : operation.getParameters())
/*     */     {
/* 370 */       if (param.isInHeader())
/*     */       {
/* 372 */         WSDLSOAPHeader header = new WSDLSOAPHeader(param.getXmlName(), param.getPartName());
/* 373 */         header.setIncludeInSignature(true);
/* 374 */         if (param.getMode() != ParameterMode.OUT)
/* 375 */           bindingInput.addSoapHeader(header);
/* 376 */         if ((twoWay) && (param.getMode() != ParameterMode.IN))
/* 377 */           bindingOutput.addSoapHeader(header);
/*     */       }
/*     */       else
/*     */       {
/* 381 */         WSDLRPCPart part = new WSDLRPCPart(param.getPartName(), param.getXmlType());
/* 382 */         if (param.getMode() != ParameterMode.OUT)
/* 383 */           input.addChildPart(part);
/* 384 */         if ((twoWay) && (param.getMode() != ParameterMode.IN))
/* 385 */           output.addChildPart(part);
/*     */       }
/* 387 */       addSignatureItem(interfaceOperation, param, false);
/*     */     }
/*     */ 
/* 390 */     interfaceOperation.addInput(input);
/* 391 */     bindingOperation.addInput(bindingInput);
/*     */   }
/*     */ 
/*     */   protected void processService(ServiceMetaData service)
/*     */   {
/* 397 */     WSDLService wsdlService = new WSDLService(this.wsdl, service.getServiceName());
/* 398 */     this.wsdl.addService(wsdlService);
/*     */ 
/* 400 */     EndpointMetaData endpoint = null;
/* 401 */     for (Iterator iter = service.getEndpoints().iterator(); iter.hasNext(); )
/*     */     {
/* 403 */       endpoint = (EndpointMetaData)iter.next();
/* 404 */       processEndpoint(wsdlService, endpoint);
/*     */     }
/*     */ 
/* 407 */     if (endpoint == null) {
/* 408 */       throw new IllegalStateException("A service must have an endpoint");
/*     */     }
/* 410 */     wsdlService.setInterfaceName(endpoint.getPortName());
/*     */   }
/*     */ 
/*     */   public WSDLDefinitions generate(ServiceMetaData service)
/*     */   {
/* 422 */     this.wsdl = new WSDLDefinitions();
/* 423 */     this.wsdl.setWsdlNamespace("http://schemas.xmlsoap.org/wsdl/");
/*     */ 
/* 426 */     String ns = service.getServiceName().getNamespaceURI();
/* 427 */     this.wsdl.setTargetNamespace(ns);
/* 428 */     this.wsdl.registerNamespaceURI(ns, "tns");
/* 429 */     this.wsdl.registerNamespaceURI("http://www.w3.org/2001/XMLSchema", "xsd");
/*     */ 
/* 431 */     String soapURI = null;
/* 432 */     String soapPrefix = null;
/* 433 */     for (EndpointMetaData ep : service.getEndpoints())
/*     */     {
/* 435 */       String bindingId = ep.getBindingId();
/* 436 */       if (bindingId.startsWith("http://schemas.xmlsoap.org/wsdl/soap/http"))
/*     */       {
/* 438 */         soapPrefix = "soap";
/* 439 */         soapURI = "http://schemas.xmlsoap.org/wsdl/soap/";
/*     */       }
/* 441 */       else if (bindingId.startsWith("http://www.w3.org/2003/05/soap/bindings/HTTP/"))
/*     */       {
/* 443 */         soapPrefix = "soap12";
/* 444 */         soapURI = "http://schemas.xmlsoap.org/wsdl/soap12/";
/*     */       }
/*     */     }
/*     */ 
/* 448 */     if ((soapURI != null) && (soapPrefix != null)) {
/* 449 */       this.wsdl.registerNamespaceURI(soapURI, soapPrefix);
/*     */     }
/* 451 */     processTypes();
/* 452 */     processService(service);
/*     */ 
/* 454 */     return this.wsdl;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.tools.wsdl.WSDLGenerator
 * JD-Core Version:    0.6.0
 */