/*     */ package org.jboss.ws.tools.wsdl;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.Writer;
/*     */ import java.util.Arrays;
/*     */ import java.util.HashSet;
/*     */ import javax.wsdl.Definition;
/*     */ import javax.wsdl.WSDLException;
/*     */ import javax.wsdl.factory.WSDLFactory;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.ws.Constants;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.metadata.wsdl.Extendable;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLBinding;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLBindingMessageReference;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLBindingOperation;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLBindingOperationInput;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLBindingOperationOutput;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLEndpoint;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLExtensibilityElement;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLImport;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLInterface;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLInterfaceFault;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLInterfaceMessageReference;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperation;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationInput;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationOutfault;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationOutput;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLProperty;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLRPCPart;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLRPCSignatureItem;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLRPCSignatureItem.Direction;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLSOAPHeader;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLService;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLUtils;
/*     */ import org.jboss.wsf.common.DOMUtils;
/*     */ import org.jboss.wsf.common.DOMWriter;
/*     */ import org.w3c.dom.Attr;
/*     */ import org.w3c.dom.Element;
/*     */ import org.w3c.dom.NamedNodeMap;
/*     */ import org.w3c.dom.Node;
/*     */ import org.w3c.dom.NodeList;
/*     */ 
/*     */ public class WSDL11Writer extends WSDLWriter
/*     */ {
/*  75 */   private String wsdlStyle = "RPC/Literal";
/*     */ 
/*  78 */   private HashSet<String> writtenFaultMessages = new HashSet();
/*     */ 
/*     */   public WSDL11Writer(WSDLDefinitions wsdl)
/*     */   {
/*  83 */     super(wsdl);
/*     */   }
/*     */ 
/*     */   public void write(Writer writer) throws IOException
/*     */   {
/*  88 */     write(writer, null);
/*     */   }
/*     */ 
/*     */   public void write(Writer writer, String charset)
/*     */     throws IOException
/*     */   {
/*  94 */     write(writer, charset, null);
/*     */   }
/*     */ 
/*     */   public void write(Writer writer, String charset, WSDLWriterResolver resolver)
/*     */     throws IOException
/*     */   {
/* 100 */     if (this.wsdl.getWsdlOneOneDefinition() != null)
/*     */     {
/* 102 */       Definition wsdlDefinition = this.wsdl.getWsdlOneOneDefinition();
/*     */       try
/*     */       {
/* 105 */         WSDLFactory wsdlFactory = WSDLFactory.newInstance();
/* 106 */         javax.wsdl.xml.WSDLWriter wsdlWriter = wsdlFactory.newWSDLWriter();
/* 107 */         wsdlWriter.writeWSDL(wsdlDefinition, writer);
/*     */       }
/*     */       catch (WSDLException e)
/*     */       {
/* 111 */         logException(e);
/* 112 */         throw new IOException(e.toString());
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 117 */       StringBuilder buffer = new StringBuilder();
/*     */ 
/* 120 */       this.wsdlStyle = this.utils.getWSDLStyle(this.wsdl);
/*     */ 
/* 122 */       StringBuilder importBuffer = new StringBuilder();
/* 123 */       for (WSDLImport wsdlImport : this.wsdl.getImports())
/*     */       {
/* 125 */         if (resolver == null) {
/*     */           continue;
/*     */         }
/* 128 */         WSDLWriterResolver resolved = resolver.resolve(wsdlImport.getLocation());
/* 129 */         if (resolved == null) {
/*     */           continue;
/*     */         }
/* 132 */         String namespace = wsdlImport.getNamespace();
/* 133 */         importBuffer.append("<import namespace='" + namespace + "' location='" + resolved.actualFile + "'/>");
/* 134 */         if (resolved == null)
/*     */           continue;
/* 136 */         StringBuilder builder = new StringBuilder();
/*     */ 
/* 138 */         appendDefinitions(builder, namespace);
/* 139 */         appendBody(builder, namespace);
/* 140 */         writeBuilder(builder, resolved.writer, resolved.charset);
/* 141 */         resolved.writer.close();
/*     */       }
/*     */ 
/* 145 */       appendDefinitions(buffer, this.wsdl.getTargetNamespace());
/* 146 */       if (importBuffer.length() > 0) {
/* 147 */         buffer.append(importBuffer);
/*     */       }
/* 149 */       appendBody(buffer, this.wsdl.getTargetNamespace());
/* 150 */       writeBuilder(buffer, writer, charset);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void writeBuilder(StringBuilder builder, Writer writer, String charset) throws IOException
/*     */   {
/* 156 */     Element element = DOMUtils.parse(builder.toString());
/*     */ 
/* 158 */     if (charset != null)
/* 159 */       writer.write("<?xml version=\"1.0\" encoding=\"" + charset + "\"?>\n");
/* 160 */     new DOMWriter(writer).setPrettyprint(true).print(element);
/*     */   }
/*     */ 
/*     */   protected void appendBody(StringBuilder builder, String namespace)
/*     */   {
/* 165 */     this.writtenFaultMessages.clear();
/*     */ 
/* 167 */     appendTypes(builder, namespace);
/* 168 */     appendUnknownExtensibilityElements(builder, this.wsdl);
/* 169 */     appendMessages(builder, namespace);
/* 170 */     appendInterfaces(builder, namespace);
/* 171 */     appendBindings(builder, namespace);
/* 172 */     appendServices(builder, namespace);
/* 173 */     builder.append("</definitions>");
/*     */   }
/*     */ 
/*     */   protected void appendUnknownExtensibilityElements(StringBuilder builder, Extendable extendable)
/*     */   {
/* 178 */     for (WSDLExtensibilityElement ext : extendable.getAllExtensibilityElements())
/*     */     {
/* 180 */       appendPolicyElements(builder, ext);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void appendPolicyElements(StringBuilder builder, WSDLExtensibilityElement extElem)
/*     */   {
/* 187 */     if (("http://www.jboss.org/jbossws/wsp/policy".equalsIgnoreCase(extElem.getUri())) || ("http://www.jboss.org/jbossws/wsp/policyReference".equalsIgnoreCase(extElem.getUri())))
/*     */     {
/* 190 */       appendElementSkippingKnownNs(builder, extElem.getElement());
/*     */     }
/*     */   }
/*     */ 
/*     */   private void appendElementSkippingKnownNs(StringBuilder builder, Element el)
/*     */   {
/* 196 */     builder.append("<" + el.getNodeName());
/* 197 */     NamedNodeMap attributes = el.getAttributes();
/* 198 */     for (int i = 0; i < attributes.getLength(); i++)
/*     */     {
/* 200 */       Attr attr = (Attr)attributes.item(i);
/* 201 */       if ((attr.getName().startsWith("xmlns:")) && (attr.getValue() != null))
/*     */       {
/* 203 */         String prefix = attr.getName().substring(6);
/* 204 */         if (attr.getValue().equalsIgnoreCase(this.wsdl.getNamespaceURI(prefix)))
/*     */           continue;
/*     */       }
/* 207 */       builder.append(" " + attr.getName() + "='" + attr.getValue() + "'");
/*     */     }
/* 209 */     builder.append(">");
/* 210 */     NodeList childrenList = el.getChildNodes();
/* 211 */     for (int i = 0; i < childrenList.getLength(); i++)
/*     */     {
/* 213 */       Node node = childrenList.item(i);
/* 214 */       if ((node instanceof Element))
/*     */       {
/* 216 */         appendElementSkippingKnownNs(builder, (Element)node);
/*     */       }
/*     */       else
/*     */       {
/* 220 */         builder.append(DOMWriter.printNode(node, false));
/*     */       }
/*     */     }
/* 223 */     builder.append("</" + el.getNodeName() + ">");
/*     */   }
/*     */ 
/*     */   protected void appendMessages(StringBuilder buffer, String namespace)
/*     */   {
/* 228 */     WSDLInterface[] interfaces = this.wsdl.getInterfaces();
/* 229 */     int len = interfaces != null ? interfaces.length : 0;
/* 230 */     for (int i = 0; i < len; i++)
/*     */     {
/* 232 */       WSDLInterface intf = interfaces[i];
/* 233 */       if (!namespace.equals(intf.getName().getNamespaceURI())) {
/*     */         continue;
/*     */       }
/* 236 */       WSDLInterfaceOperation[] operations = intf.getSortedOperations();
/* 237 */       int lenOps = operations.length;
/* 238 */       for (int j = 0; j < lenOps; j++)
/*     */       {
/* 240 */         appendMessage(buffer, operations[j]);
/* 241 */         appendMessagesForExceptions(buffer, operations[j]);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void appendMessage(StringBuilder buffer, WSDLInterfaceOperation operation)
/*     */   {
/* 248 */     String opname = operation.getName().getLocalPart();
/*     */ 
/* 250 */     if (!"http://www.w3.org/2004/03/wsdl/style/rpc".equals(operation.getStyle())) {
/* 251 */       this.wsdlStyle = "Document/Literal";
/*     */     }
/* 253 */     String interfaceName = operation.getWsdlInterface().getName().getLocalPart();
/* 254 */     buffer.append("<message name='" + interfaceName + "_" + opname + "' >");
/* 255 */     for (WSDLInterfaceOperationInput input : operation.getInputs())
/*     */     {
/* 257 */       appendUnknownExtensibilityElements(buffer, input);
/* 258 */       appendMessageParts(buffer, input);
/*     */     }
/* 260 */     buffer.append("</message>");
/*     */ 
/* 262 */     if (!"http://www.w3.org/2004/08/wsdl/in-only".equals(operation.getPattern()))
/*     */     {
/* 264 */       buffer.append("<message name='" + interfaceName + "_" + opname + "Response' >");
/* 265 */       WSDLInterfaceOperationOutput[] outputs = operation.getOutputs();
/* 266 */       for (WSDLInterfaceOperationOutput output : outputs)
/* 267 */         appendMessageParts(buffer, output);
/* 268 */       buffer.append("</message>");
/*     */     }
/*     */   }
/*     */ 
/*     */   private void appendMessagesForExceptions(StringBuilder buffer, WSDLInterfaceOperation operation)
/*     */   {
/* 275 */     WSDLInterfaceOperationOutfault[] faults = operation.getOutfaults();
/* 276 */     int len = faults != null ? faults.length : 0;
/*     */ 
/* 278 */     for (int i = 0; i < len; i++)
/*     */     {
/* 280 */       WSDLInterfaceOperationOutfault fault = faults[i];
/* 281 */       String exceptionName = fault.getRef().getLocalPart();
/* 282 */       if (this.writtenFaultMessages.contains(exceptionName)) {
/*     */         continue;
/*     */       }
/* 285 */       WSDLInterfaceFault interfaceFault = operation.getWsdlInterface().getFault(fault.getRef());
/* 286 */       QName xmlName = interfaceFault.getElement();
/*     */ 
/* 288 */       buffer.append("<message name='" + exceptionName + "' >");
/* 289 */       String prefix = this.wsdl.getPrefix(xmlName.getNamespaceURI());
/* 290 */       String xmlNameStr = prefix + ":" + xmlName.getLocalPart();
/* 291 */       buffer.append("<part name='" + exceptionName + "' element='" + xmlNameStr + "' />");
/* 292 */       buffer.append("</message>");
/*     */ 
/* 294 */       this.writtenFaultMessages.add(exceptionName);
/*     */     }
/*     */   }
/*     */ 
/*     */   private String getReferenceString(QName name)
/*     */   {
/* 300 */     String namespaceURI = name.getNamespaceURI();
/* 301 */     String prefix = this.wsdl.getPrefix(namespaceURI);
/* 302 */     if (prefix == null) {
/* 303 */       throw new WSException("Prefix not bound for namespace: " + namespaceURI);
/*     */     }
/* 305 */     return prefix + ":" + name.getLocalPart();
/*     */   }
/*     */ 
/*     */   private void appendMessageParts(StringBuilder buffer, WSDLInterfaceMessageReference reference)
/*     */   {
/* 310 */     if (this.wsdlStyle.equals("RPC/Literal"))
/*     */     {
/* 312 */       for (WSDLRPCPart part : reference.getChildParts())
/*     */       {
/* 314 */         buffer.append("<part name='" + part.getName()).append('\'');
/* 315 */         buffer.append(" type='" + getReferenceString(part.getType()) + "'/>");
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 320 */       QName element = reference.getElement();
/*     */ 
/* 322 */       if (element != null)
/*     */       {
/* 324 */         buffer.append("<part name='" + reference.getPartName() + '\'');
/* 325 */         buffer.append(" element='" + getReferenceString(element) + "'/>");
/*     */       }
/*     */     }
/*     */ 
/* 329 */     WSDLBindingMessageReference bindingReference = getBindingReference(reference);
/* 330 */     if (bindingReference == null) {
/* 331 */       return;
/*     */     }
/* 333 */     for (WSDLSOAPHeader header : bindingReference.getSoapHeaders())
/*     */     {
/* 335 */       if (header.isIncludeInSignature());
/* 337 */       QName element = header.getElement();
/* 338 */       buffer.append("<part name='" + header.getPartName() + '\'');
/* 339 */       buffer.append(" element='" + getReferenceString(element) + "'/>");
/*     */     }
/*     */   }
/*     */ 
/*     */   private WSDLBindingMessageReference getBindingReference(WSDLInterfaceMessageReference reference)
/*     */   {
/* 346 */     WSDLInterfaceOperation wsdlOperation = reference.getWsdlOperation();
/* 347 */     WSDLInterface wsdlInterface = wsdlOperation.getWsdlInterface();
/* 348 */     WSDLBinding binding = wsdlInterface.getWsdlDefinitions().getBindingByInterfaceName(wsdlInterface.getName());
/* 349 */     WSDLBindingOperation bindingOperation = binding.getOperationByRef(wsdlOperation.getName());
/*     */     WSDLBindingMessageReference[] bindingReferences;
/*     */     WSDLBindingMessageReference[] bindingReferences;
/* 352 */     if ((reference instanceof WSDLInterfaceOperationInput))
/* 353 */       bindingReferences = bindingOperation.getInputs();
/*     */     else {
/* 355 */       bindingReferences = bindingOperation.getOutputs();
/*     */     }
/* 357 */     if (bindingReferences.length > 1) {
/* 358 */       throw new IllegalArgumentException("WSDl 1.1 only supports In-Only, and In-Out MEPS, more than reference input found");
/*     */     }
/* 360 */     if (bindingReferences.length == 1) {
/* 361 */       return bindingReferences[0];
/*     */     }
/* 363 */     return null;
/*     */   }
/*     */ 
/*     */   protected void appendInterfaces(StringBuilder buffer, String namespace)
/*     */   {
/* 368 */     WSDLInterface[] intfs = this.wsdl.getInterfaces();
/* 369 */     for (int i = 0; i < intfs.length; i++)
/*     */     {
/* 371 */       WSDLInterface intf = intfs[i];
/* 372 */       if (!namespace.equals(intf.getName().getNamespaceURI())) {
/*     */         continue;
/*     */       }
/* 375 */       buffer.append("<portType name='" + intf.getName().getLocalPart() + "'");
/* 376 */       WSDLProperty policyProp = intf.getProperty("http://www.jboss.org/jbossws/wsp/policyURIs");
/* 377 */       if (policyProp != null)
/*     */       {
/* 379 */         String prefix = this.wsdl.getPrefix("http://schemas.xmlsoap.org/ws/2004/09/policy");
/* 380 */         buffer.append(" ");
/* 381 */         buffer.append(prefix);
/* 382 */         buffer.append(":");
/* 383 */         buffer.append(Constants.WSDL_ATTRIBUTE_WSP_POLICYURIS.getLocalPart());
/* 384 */         buffer.append("='");
/* 385 */         buffer.append(policyProp.getValue());
/* 386 */         buffer.append("'");
/*     */       }
/* 388 */       buffer.append(">");
/* 389 */       appendPortOperations(buffer, intf);
/* 390 */       buffer.append("</portType>");
/*     */     }
/*     */   }
/*     */ 
/*     */   private String getParameterOrder(WSDLInterfaceOperation operation)
/*     */   {
/* 396 */     StringBuilder builder = new StringBuilder();
/* 397 */     for (WSDLRPCSignatureItem item : operation.getRpcSignatureItems())
/*     */     {
/* 399 */       if (item.getDirection() != WSDLRPCSignatureItem.Direction.RETURN)
/*     */       {
/* 401 */         if (builder.length() > 0)
/* 402 */           builder.append(' ');
/* 403 */         builder.append(item.getName());
/*     */       }
/*     */     }
/*     */ 
/* 407 */     return builder.toString();
/*     */   }
/*     */ 
/*     */   protected void appendPortOperations(StringBuilder buffer, WSDLInterface intf)
/*     */   {
/* 412 */     String prefix = this.wsdl.getPrefix(intf.getName().getNamespaceURI());
/* 413 */     WSDLInterfaceOperation[] operations = intf.getSortedOperations();
/* 414 */     for (int i = 0; i < operations.length; i++)
/*     */     {
/* 416 */       WSDLInterfaceOperation operation = operations[i];
/* 417 */       buffer.append("<operation name='" + operation.getName().getLocalPart() + "'");
/*     */ 
/* 420 */       if (!"http://www.w3.org/2004/08/wsdl/in-only".equals(operation.getPattern()))
/*     */       {
/* 422 */         String parameterOrder = getParameterOrder(operation);
/* 423 */         if (parameterOrder.length() > 0) {
/* 424 */           buffer.append(" parameterOrder='").append(parameterOrder).append("'");
/*     */         }
/*     */       }
/* 427 */       buffer.append(">");
/* 428 */       appendUnknownExtensibilityElements(buffer, operation);
/*     */ 
/* 430 */       String opname = operation.getName().getLocalPart();
/* 431 */       String interfaceName = operation.getWsdlInterface().getName().getLocalPart();
/* 432 */       String msgEl = prefix + ":" + interfaceName + "_" + opname;
/*     */ 
/* 434 */       buffer.append("<input message='" + msgEl + "'>").append("</input>");
/*     */ 
/* 436 */       if (!"http://www.w3.org/2004/08/wsdl/in-only".equals(operation.getPattern()))
/*     */       {
/* 438 */         buffer.append("<output message='" + msgEl + "Response'>");
/* 439 */         buffer.append("</output>");
/*     */       }
/*     */ 
/* 443 */       for (WSDLInterfaceOperationOutfault fault : operation.getOutfaults())
/*     */       {
/* 445 */         QName element = fault.getRef();
/* 446 */         String faultPrefix = this.wsdl.getPrefix(element.getNamespaceURI());
/* 447 */         buffer.append("<fault  message='" + faultPrefix + ":" + element.getLocalPart());
/* 448 */         buffer.append("' name='" + element.getLocalPart() + "'/>");
/*     */       }
/*     */ 
/* 451 */       buffer.append("</operation>");
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void appendBindings(StringBuilder buffer, String namespace)
/*     */   {
/* 457 */     WSDLBinding[] bindings = this.wsdl.getBindings();
/* 458 */     for (int i = 0; i < bindings.length; i++)
/*     */     {
/* 460 */       WSDLBinding binding = bindings[i];
/* 461 */       if (!namespace.equals(binding.getName().getNamespaceURI()))
/*     */         continue;
/* 463 */       buffer.append("<binding name='" + binding.getName().getLocalPart() + "' type='" + getQNameRef(binding.getInterfaceName()) + "'>");
/*     */ 
/* 465 */       if (this.wsdlStyle == null)
/* 466 */         throw new IllegalArgumentException("WSDL Style is null (should be rpc or document");
/* 467 */       String style = "rpc";
/* 468 */       if (this.wsdlStyle.equals("Document/Literal"))
/* 469 */         style = "document";
/* 470 */       appendUnknownExtensibilityElements(buffer, binding);
/*     */ 
/* 476 */       buffer.append("<" + this.soapPrefix + ":binding transport='" + "http://schemas.xmlsoap.org/soap/http" + "' style='" + style + "'/>");
/* 477 */       appendBindingOperations(buffer, binding);
/* 478 */       buffer.append("</binding>");
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void appendBindingOperations(StringBuilder buffer, WSDLBinding binding)
/*     */   {
/* 484 */     WSDLBindingOperation[] operations = binding.getOperations();
/* 485 */     Arrays.sort(operations);
/*     */ 
/* 487 */     for (int i = 0; i < operations.length; i++)
/*     */     {
/* 489 */       WSDLBindingOperation operation = operations[i];
/* 490 */       QName interfaceName = operation.getWsdlBinding().getInterfaceName();
/*     */ 
/* 492 */       WSDLInterface wsdlInterface = this.wsdl.getInterface(interfaceName);
/* 493 */       if (wsdlInterface == null)
/* 494 */         throw new WSException("WSDL Interface should not be null");
/* 495 */       WSDLInterfaceOperation interfaceOperation = wsdlInterface.getOperation(operation.getRef());
/*     */ 
/* 497 */       buffer.append("<operation name='" + interfaceOperation.getName().getLocalPart() + "'>");
/* 498 */       String soapAction = operation.getSOAPAction() != null ? operation.getSOAPAction() : "";
/* 499 */       appendUnknownExtensibilityElements(buffer, operation);
/* 500 */       buffer.append("<" + this.soapPrefix + ":operation soapAction=\"" + soapAction + "\"/>");
/*     */ 
/* 502 */       WSDLBindingOperationInput[] inputs = operation.getInputs();
/* 503 */       if (inputs.length != 1) {
/* 504 */         throw new WSException("WSDl 1.1 only supports In-Only, and In-Out MEPS.");
/*     */       }
/* 506 */       buffer.append("<input>");
/* 507 */       appendUnknownExtensibilityElements(buffer, inputs[0]);
/* 508 */       appendSOAPBinding(buffer, wsdlInterface, operation, inputs);
/* 509 */       buffer.append("</input>");
/*     */ 
/* 511 */       if (!"http://www.w3.org/2004/08/wsdl/in-only".equals(getBindingOperationPattern(operation)))
/*     */       {
/* 513 */         buffer.append("<output>");
/* 514 */         WSDLBindingOperationOutput[] outputs = operation.getOutputs();
/* 515 */         appendSOAPBinding(buffer, wsdlInterface, operation, outputs);
/* 516 */         buffer.append("</output>");
/*     */       }
/*     */ 
/* 520 */       WSDLInterfaceOperationOutfault[] faults = interfaceOperation.getOutfaults();
/* 521 */       if (faults == null)
/*     */         continue;
/* 523 */       for (WSDLInterfaceOperationOutfault fault : faults)
/*     */       {
/* 525 */         String n = "name='" + fault.getRef().getLocalPart() + "'";
/* 526 */         buffer.append("<fault  " + n + ">");
/* 527 */         buffer.append("<" + this.soapPrefix + ":fault  " + n + " use='literal' />");
/* 528 */         buffer.append("</fault>");
/*     */       }
/* 530 */       buffer.append("</operation>");
/*     */     }
/*     */   }
/*     */ 
/*     */   private void appendSOAPBinding(StringBuilder buffer, WSDLInterface wsdlInterface, WSDLBindingOperation operation, WSDLBindingMessageReference[] inputs)
/*     */   {
/* 537 */     String tns = this.wsdl.getTargetNamespace();
/* 538 */     WSDLInterfaceOperation interfaceOperation = wsdlInterface.getOperation(operation.getRef());
/* 539 */     WSDLInterfaceMessageReference reference = (inputs instanceof WSDLBindingOperationInput[]) ? interfaceOperation.getInputs()[0] : interfaceOperation.getOutputs()[0];
/*     */ 
/* 542 */     StringBuilder bodyParts = new StringBuilder();
/* 543 */     if ("Document/Literal" == this.wsdlStyle)
/*     */     {
/* 546 */       if (reference.getPartName() != null) {
/* 547 */         bodyParts.append(reference.getPartName());
/*     */       }
/*     */     }
/*     */     else {
/* 551 */       for (WSDLRPCPart part : reference.getChildParts())
/*     */       {
/* 553 */         if (bodyParts.length() > 0)
/* 554 */           bodyParts.append(" ");
/* 555 */         bodyParts.append(part.getName());
/*     */       }
/*     */     }
/*     */ 
/* 559 */     StringBuilder soapHeader = new StringBuilder();
/* 560 */     for (WSDLSOAPHeader header : inputs[0].getSoapHeaders())
/*     */     {
/* 562 */       if (header.isIncludeInSignature())
/*     */       {
/* 564 */         String messageName = wsdlInterface.getName().getLocalPart() + "_" + operation.getRef().getLocalPart();
/* 565 */         if ((reference instanceof WSDLInterfaceOperationOutput))
/* 566 */           messageName = messageName + "Response";
/* 567 */         soapHeader.append("<").append(this.soapPrefix).append(":header use='literal' message='tns:").append(messageName);
/* 568 */         soapHeader.append("' part='").append(header.getPartName()).append("'/>");
/*     */       }
/*     */     }
/*     */ 
/* 572 */     buffer.append("<" + this.soapPrefix + ":body use='literal'");
/* 573 */     if (this.wsdlStyle != "Document/Literal")
/* 574 */       buffer.append(" namespace='" + tns + "'");
/* 575 */     if (soapHeader.length() > 0)
/*     */     {
/* 577 */       buffer.append(" parts='").append(bodyParts).append("'/>");
/* 578 */       buffer.append(soapHeader);
/*     */     }
/*     */     else
/*     */     {
/* 582 */       buffer.append("/>");
/*     */     }
/*     */   }
/*     */ 
/*     */   private String getBindingOperationPattern(WSDLBindingOperation operation)
/*     */   {
/* 588 */     WSDLBinding binding = operation.getWsdlBinding();
/* 589 */     String pattern = binding.getInterface().getOperation(operation.getRef()).getPattern();
/*     */ 
/* 591 */     return pattern;
/*     */   }
/*     */ 
/*     */   protected void appendServices(StringBuilder buffer, String namespace)
/*     */   {
/* 596 */     WSDLService[] services = this.wsdl.getServices();
/* 597 */     int len = services.length;
/* 598 */     for (int i = 0; i < len; i++)
/*     */     {
/* 601 */       WSDLService service = services[i];
/* 602 */       if (!namespace.equals(service.getName().getNamespaceURI()))
/*     */         continue;
/* 604 */       buffer.append("<service name='" + service.getName().getLocalPart() + "'>");
/* 605 */       appendUnknownExtensibilityElements(buffer, service);
/* 606 */       WSDLEndpoint[] endpoints = service.getEndpoints();
/* 607 */       int lenend = endpoints.length;
/* 608 */       for (int j = 0; j < lenend; j++)
/*     */       {
/* 610 */         WSDLEndpoint endpoint = endpoints[j];
/* 611 */         appendServicePort(buffer, endpoint);
/*     */       }
/*     */ 
/* 614 */       buffer.append("</service>");
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void appendServicePort(StringBuilder buffer, WSDLEndpoint endpoint)
/*     */   {
/* 620 */     String name = endpoint.getName().getLocalPart();
/* 621 */     QName endpointBinding = endpoint.getBinding();
/* 622 */     String prefix = endpointBinding.getPrefix();
/* 623 */     prefix = this.wsdl.getPrefix(endpointBinding.getNamespaceURI());
/* 624 */     String ebname = prefix + ":" + endpointBinding.getLocalPart();
/* 625 */     buffer.append("<port name='" + name + "' binding='" + ebname + "'>");
/* 626 */     buffer.append("<" + this.soapPrefix + ":address location='" + endpoint.getAddress() + "'/>");
/* 627 */     appendUnknownExtensibilityElements(buffer, endpoint);
/* 628 */     buffer.append("</port>");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.tools.wsdl.WSDL11Writer
 * JD-Core Version:    0.6.0
 */