/*      */ package org.jboss.ws.tools.wsdl;
/*      */ 
/*      */ import com.ibm.wsdl.Constants;
/*      */ import com.ibm.wsdl.extensions.schema.SchemaConstants;
/*      */ import com.ibm.wsdl.util.StringUtils;
/*      */ import com.ibm.wsdl.util.xml.DOMUtils;
/*      */ import com.ibm.wsdl.util.xml.QNameUtils;
/*      */ import com.ibm.wsdl.util.xml.XPathUtils;
/*      */ import java.io.InputStream;
/*      */ import java.io.PrintStream;
/*      */ import java.net.URL;
/*      */ import java.util.ArrayList;
/*      */ import java.util.Arrays;
/*      */ import java.util.Collection;
/*      */ import java.util.Hashtable;
/*      */ import java.util.Iterator;
/*      */ import java.util.List;
/*      */ import java.util.ListIterator;
/*      */ import java.util.Map;
/*      */ import java.util.Vector;
/*      */ import javax.wsdl.Binding;
/*      */ import javax.wsdl.BindingFault;
/*      */ import javax.wsdl.BindingInput;
/*      */ import javax.wsdl.BindingOperation;
/*      */ import javax.wsdl.BindingOutput;
/*      */ import javax.wsdl.Definition;
/*      */ import javax.wsdl.Fault;
/*      */ import javax.wsdl.Import;
/*      */ import javax.wsdl.Input;
/*      */ import javax.wsdl.Message;
/*      */ import javax.wsdl.Operation;
/*      */ import javax.wsdl.OperationType;
/*      */ import javax.wsdl.Output;
/*      */ import javax.wsdl.Part;
/*      */ import javax.wsdl.Port;
/*      */ import javax.wsdl.PortType;
/*      */ import javax.wsdl.Service;
/*      */ import javax.wsdl.Types;
/*      */ import javax.wsdl.WSDLException;
/*      */ import javax.wsdl.extensions.AttributeExtensible;
/*      */ import javax.wsdl.extensions.ExtensibilityElement;
/*      */ import javax.wsdl.extensions.ExtensionDeserializer;
/*      */ import javax.wsdl.extensions.ExtensionRegistry;
/*      */ import javax.wsdl.extensions.schema.Schema;
/*      */ import javax.wsdl.extensions.schema.SchemaReference;
/*      */ import javax.wsdl.factory.WSDLFactory;
/*      */ import javax.wsdl.xml.WSDLLocator;
/*      */ import javax.wsdl.xml.WSDLReader;
/*      */ import javax.xml.namespace.QName;
/*      */ import javax.xml.parsers.DocumentBuilder;
/*      */ import javax.xml.parsers.DocumentBuilderFactory;
/*      */ import org.jboss.ws.core.utils.JBossWSEntityResolver;
/*      */ import org.w3c.dom.Attr;
/*      */ import org.w3c.dom.Document;
/*      */ import org.w3c.dom.Element;
/*      */ import org.w3c.dom.NamedNodeMap;
/*      */ import org.xml.sax.InputSource;
/*      */ 
/*      */ public class JBossWSDLReaderImpl
/*      */   implements WSDLReader
/*      */ {
/*   67 */   private static final List STYLE_ONE_WAY = Arrays.asList(new String[] { "input" });
/*      */ 
/*   69 */   private static final List STYLE_REQUEST_RESPONSE = Arrays.asList(new String[] { "input", "output" });
/*      */ 
/*   71 */   private static final List STYLE_SOLICIT_RESPONSE = Arrays.asList(new String[] { "output", "input" });
/*      */ 
/*   73 */   private static final List STYLE_NOTIFICATION = Arrays.asList(new String[] { "output" });
/*      */ 
/*   76 */   protected boolean verbose = true;
/*   77 */   protected boolean importDocuments = true;
/*   78 */   protected ExtensionRegistry extReg = null;
/*   79 */   protected String factoryImplName = null;
/*   80 */   protected WSDLLocator loc = null;
/*   81 */   protected WSDLFactory factory = null;
/*      */ 
/*   85 */   protected Map allSchemas = new Hashtable();
/*      */ 
/*      */   public void setFeature(String name, boolean value)
/*      */     throws IllegalArgumentException
/*      */   {
/*  126 */     if (name == null)
/*      */     {
/*  128 */       throw new IllegalArgumentException("Feature name must not be null.");
/*      */     }
/*      */ 
/*  131 */     if (name.equals("javax.wsdl.verbose"))
/*      */     {
/*  133 */       this.verbose = value;
/*      */     }
/*  135 */     else if (name.equals("javax.wsdl.importDocuments"))
/*      */     {
/*  137 */       this.importDocuments = value;
/*      */     }
/*      */     else
/*      */     {
/*  141 */       throw new IllegalArgumentException("Feature name '" + name + "' not recognized.");
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean getFeature(String name)
/*      */     throws IllegalArgumentException
/*      */   {
/*  156 */     if (name == null)
/*      */     {
/*  158 */       throw new IllegalArgumentException("Feature name must not be null.");
/*      */     }
/*      */ 
/*  161 */     if (name.equals("javax.wsdl.verbose"))
/*      */     {
/*  163 */       return this.verbose;
/*      */     }
/*  165 */     if (name.equals("javax.wsdl.importDocuments"))
/*      */     {
/*  167 */       return this.importDocuments;
/*      */     }
/*      */ 
/*  171 */     throw new IllegalArgumentException("Feature name '" + name + "' not recognized.");
/*      */   }
/*      */ 
/*      */   public void setExtensionRegistry(ExtensionRegistry extReg)
/*      */   {
/*  189 */     this.extReg = extReg;
/*      */   }
/*      */ 
/*      */   public ExtensionRegistry getExtensionRegistry()
/*      */   {
/*  198 */     return this.extReg;
/*      */   }
/*      */ 
/*      */   protected WSDLFactory getWSDLFactory()
/*      */     throws WSDLException
/*      */   {
/*  207 */     if (this.factory == null)
/*      */     {
/*  209 */       this.factory = (this.factoryImplName != null ? WSDLFactory.newInstance(this.factoryImplName) : WSDLFactory.newInstance());
/*      */     }
/*      */ 
/*  213 */     return this.factory;
/*      */   }
/*      */ 
/*      */   public void setFactoryImplName(String factoryImplName)
/*      */     throws UnsupportedOperationException
/*      */   {
/*  235 */     if (((this.factoryImplName == null) && (factoryImplName != null)) || ((this.factoryImplName != null) && (!this.factoryImplName.equals(factoryImplName))))
/*      */     {
/*  240 */       this.factory = null;
/*      */ 
/*  242 */       this.factoryImplName = factoryImplName;
/*      */     }
/*      */   }
/*      */ 
/*      */   public String getFactoryImplName()
/*      */   {
/*  252 */     return this.factoryImplName;
/*      */   }
/*      */ 
/*      */   protected Definition parseDefinitions(String documentBaseURI, Element defEl, Map importedDefs)
/*      */     throws WSDLException
/*      */   {
/*  260 */     checkElementName(defEl, Constants.Q_ELEM_DEFINITIONS);
/*      */ 
/*  262 */     WSDLFactory factory = getWSDLFactory();
/*  263 */     Definition def = factory.newDefinition();
/*      */ 
/*  265 */     if (this.extReg != null)
/*      */     {
/*  267 */       def.setExtensionRegistry(this.extReg);
/*      */     }
/*      */ 
/*  270 */     String name = DOMUtils.getAttribute(defEl, "name");
/*  271 */     String targetNamespace = DOMUtils.getAttribute(defEl, "targetNamespace");
/*      */ 
/*  273 */     NamedNodeMap attrs = defEl.getAttributes();
/*      */ 
/*  275 */     if (importedDefs == null)
/*      */     {
/*  277 */       importedDefs = new Hashtable();
/*      */     }
/*      */ 
/*  280 */     if (documentBaseURI != null)
/*      */     {
/*  282 */       def.setDocumentBaseURI(documentBaseURI);
/*  283 */       importedDefs.put(documentBaseURI, def);
/*      */     }
/*      */ 
/*  286 */     if (name != null)
/*      */     {
/*  288 */       def.setQName(new QName(targetNamespace, name));
/*      */     }
/*      */ 
/*  291 */     if (targetNamespace != null)
/*      */     {
/*  293 */       def.setTargetNamespace(targetNamespace);
/*      */     }
/*      */ 
/*  296 */     int size = attrs.getLength();
/*      */ 
/*  298 */     for (int i = 0; i < size; i++)
/*      */     {
/*  300 */       Attr attr = (Attr)attrs.item(i);
/*  301 */       String namespaceURI = attr.getNamespaceURI();
/*  302 */       String localPart = attr.getLocalName();
/*  303 */       String value = attr.getValue();
/*      */ 
/*  305 */       if ((namespaceURI == null) || (!namespaceURI.equals("http://www.w3.org/2000/xmlns/")))
/*      */         continue;
/*  307 */       if ((localPart != null) && (!localPart.equals("xmlns")))
/*      */       {
/*  309 */         def.addNamespace(localPart, value);
/*      */       }
/*      */       else
/*      */       {
/*  313 */         def.addNamespace(null, value);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  318 */     Element tempEl = DOMUtils.getFirstChildElement(defEl);
/*      */ 
/*  320 */     while (tempEl != null)
/*      */     {
/*  322 */       if (QNameUtils.matches(Constants.Q_ELEM_IMPORT, tempEl))
/*      */       {
/*  324 */         def.addImport(parseImport(tempEl, def, importedDefs));
/*      */       }
/*  326 */       else if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, tempEl))
/*      */       {
/*  328 */         def.setDocumentationElement(tempEl);
/*      */       }
/*  330 */       else if (QNameUtils.matches(Constants.Q_ELEM_TYPES, tempEl))
/*      */       {
/*  332 */         def.setTypes(parseTypes(tempEl, def));
/*      */       }
/*  334 */       else if (QNameUtils.matches(Constants.Q_ELEM_MESSAGE, tempEl))
/*      */       {
/*  336 */         def.addMessage(parseMessage(tempEl, def));
/*      */       }
/*  338 */       else if (QNameUtils.matches(Constants.Q_ELEM_PORT_TYPE, tempEl))
/*      */       {
/*  340 */         def.addPortType(parsePortType(tempEl, def));
/*      */       }
/*  342 */       else if (QNameUtils.matches(Constants.Q_ELEM_BINDING, tempEl))
/*      */       {
/*  344 */         def.addBinding(parseBinding(tempEl, def));
/*      */       }
/*  346 */       else if (QNameUtils.matches(Constants.Q_ELEM_SERVICE, tempEl))
/*      */       {
/*  348 */         def.addService(parseService(tempEl, def));
/*      */       }
/*      */       else
/*      */       {
/*  352 */         def.addExtensibilityElement(parseExtensibilityElement(Definition.class, tempEl, def));
/*      */       }
/*      */ 
/*  356 */       tempEl = DOMUtils.getNextSiblingElement(tempEl);
/*      */     }
/*      */ 
/*  359 */     parseExtensibilityAttributes(defEl, Definition.class, def, def);
/*      */ 
/*  361 */     return def;
/*      */   }
/*      */ 
/*      */   protected Import parseImport(Element importEl, Definition def, Map importedDefs)
/*      */     throws WSDLException
/*      */   {
/*  369 */     Import importDef = def.createImport();
/*      */     try
/*      */     {
/*  373 */       String namespaceURI = DOMUtils.getAttribute(importEl, "namespace");
/*      */ 
/*  375 */       String locationURI = DOMUtils.getAttribute(importEl, "location");
/*      */ 
/*  377 */       String contextURI = null;
/*      */ 
/*  379 */       if (namespaceURI != null)
/*      */       {
/*  381 */         importDef.setNamespaceURI(namespaceURI);
/*      */       }
/*      */ 
/*  384 */       if (locationURI != null)
/*      */       {
/*  386 */         importDef.setLocationURI(locationURI);
/*      */ 
/*  388 */         if (this.importDocuments)
/*      */         {
/*      */           try
/*      */           {
/*  392 */             contextURI = def.getDocumentBaseURI();
/*  393 */             Definition importedDef = null;
/*  394 */             InputStream inputStream = null;
/*  395 */             InputSource inputSource = null;
/*  396 */             URL url = null;
/*      */ 
/*  398 */             if (this.loc != null)
/*      */             {
/*  400 */               inputSource = this.loc.getImportInputSource(contextURI, locationURI);
/*      */ 
/*  407 */               String liu = this.loc.getLatestImportURI();
/*      */ 
/*  409 */               importedDef = (Definition)importedDefs.get(liu);
/*      */ 
/*  411 */               inputSource.setSystemId(liu);
/*      */             }
/*      */             else
/*      */             {
/*  415 */               URL contextURL = contextURI != null ? StringUtils.getURL(null, contextURI) : null;
/*      */ 
/*  419 */               url = StringUtils.getURL(contextURL, locationURI);
/*  420 */               importedDef = (Definition)importedDefs.get(url.toString());
/*      */ 
/*  422 */               if (importedDef == null)
/*      */               {
/*  424 */                 inputStream = StringUtils.getContentAsInputStream(url);
/*      */ 
/*  426 */                 if (inputStream != null)
/*      */                 {
/*  428 */                   inputSource = new InputSource(inputStream);
/*  429 */                   inputSource.setSystemId(url.toString());
/*      */                 }
/*      */               }
/*      */             }
/*      */ 
/*  434 */             if (importedDef == null)
/*      */             {
/*  436 */               if (inputSource == null)
/*      */               {
/*  438 */                 throw new WSDLException("OTHER_ERROR", "Unable to locate imported document at '" + locationURI + "'" + (contextURI == null ? "." : new StringBuilder().append(", relative to '").append(contextURI).append("'.").toString()));
/*      */               }
/*      */ 
/*  447 */               Document doc = getDocument(inputSource, inputSource.getSystemId());
/*      */ 
/*  449 */               if (inputStream != null)
/*      */               {
/*  451 */                 inputStream.close();
/*      */               }
/*      */ 
/*  454 */               Element documentElement = doc.getDocumentElement();
/*      */ 
/*  463 */               if (QNameUtils.matches(Constants.Q_ELEM_DEFINITIONS, documentElement))
/*      */               {
/*  466 */                 if (this.verbose)
/*      */                 {
/*  468 */                   System.out.println("Retrieving document at '" + locationURI + "'" + (contextURI == null ? "." : new StringBuilder().append(", relative to '").append(contextURI).append("'.").toString()));
/*      */                 }
/*      */ 
/*  475 */                 String urlString = url != null ? url.toString() : this.loc != null ? this.loc.getLatestImportURI() : locationURI;
/*      */ 
/*  482 */                 importedDef = readWSDL(urlString, documentElement, importedDefs);
/*      */               }
/*      */               else
/*      */               {
/*  488 */                 QName docElementQName = QNameUtils.newQName(documentElement);
/*      */ 
/*  490 */                 if (SchemaConstants.XSD_QNAME_LIST.contains(docElementQName))
/*      */                 {
/*  492 */                   if (this.verbose)
/*      */                   {
/*  494 */                     System.out.println("Retrieving schema wsdl:imported from '" + locationURI + "'" + (contextURI == null ? "." : new StringBuilder().append(", relative to '").append(contextURI).append("'.").toString()));
/*      */                   }
/*      */ 
/*  501 */                   WSDLFactory factory = getWSDLFactory();
/*      */ 
/*  503 */                   importedDef = factory.newDefinition();
/*      */ 
/*  505 */                   if (this.extReg != null)
/*      */                   {
/*  507 */                     importedDef.setExtensionRegistry(this.extReg);
/*      */                   }
/*      */ 
/*  510 */                   String urlString = url != null ? url.toString() : this.loc != null ? this.loc.getLatestImportURI() : locationURI;
/*      */ 
/*  517 */                   importedDef.setDocumentBaseURI(urlString);
/*      */ 
/*  519 */                   Types types = importedDef.createTypes();
/*  520 */                   types.addExtensibilityElement(parseSchema(Types.class, documentElement, importedDef));
/*      */ 
/*  522 */                   importedDef.setTypes(types);
/*      */                 }
/*      */               }
/*      */             }
/*      */ 
/*  527 */             if (importedDef != null)
/*      */             {
/*  529 */               importDef.setDefinition(importedDef);
/*      */             }
/*      */           }
/*      */           catch (WSDLException e)
/*      */           {
/*  534 */             throw e;
/*      */           }
/*      */           catch (RuntimeException e)
/*      */           {
/*  538 */             throw e;
/*      */           }
/*      */           catch (Exception e)
/*      */           {
/*  542 */             throw new WSDLException("OTHER_ERROR", "Unable to resolve imported document at '" + locationURI + (contextURI == null ? "'." : new StringBuilder().append("', relative to '").append(contextURI).append("'").toString()), e);
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */     catch (WSDLException e)
/*      */     {
/*  555 */       if (e.getLocation() == null)
/*      */       {
/*  557 */         e.setLocation(XPathUtils.getXPathExprFromNode(importEl));
/*      */       }
/*      */       else
/*      */       {
/*  564 */         String loc = XPathUtils.getXPathExprFromNode(importEl) + e.getLocation();
/*  565 */         e.setLocation(loc);
/*      */       }
/*      */ 
/*  568 */       throw e;
/*      */     }
/*      */ 
/*  572 */     NamedNodeMap attrs = importEl.getAttributes();
/*  573 */     registerNSDeclarations(attrs, def);
/*      */ 
/*  575 */     Element tempEl = DOMUtils.getFirstChildElement(importEl);
/*      */ 
/*  577 */     while (tempEl != null)
/*      */     {
/*  579 */       if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, tempEl))
/*      */       {
/*  581 */         importDef.setDocumentationElement(tempEl);
/*      */       }
/*      */       else
/*      */       {
/*  585 */         importDef.addExtensibilityElement(parseExtensibilityElement(Import.class, tempEl, def));
/*      */       }
/*      */ 
/*  589 */       tempEl = DOMUtils.getNextSiblingElement(tempEl);
/*      */     }
/*      */ 
/*  592 */     parseExtensibilityAttributes(importEl, Import.class, importDef, def);
/*      */ 
/*  594 */     return importDef;
/*      */   }
/*      */ 
/*      */   protected Types parseTypes(Element typesEl, Definition def)
/*      */     throws WSDLException
/*      */   {
/*  602 */     NamedNodeMap attrs = typesEl.getAttributes();
/*  603 */     registerNSDeclarations(attrs, def);
/*      */ 
/*  605 */     Types types = def.createTypes();
/*  606 */     Element tempEl = DOMUtils.getFirstChildElement(typesEl);
/*      */ 
/*  609 */     while (tempEl != null)
/*      */     {
/*  611 */       QName tempElType = QNameUtils.newQName(tempEl);
/*      */ 
/*  613 */       if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, tempEl))
/*      */       {
/*  615 */         types.setDocumentationElement(tempEl);
/*      */       }
/*  617 */       else if (SchemaConstants.XSD_QNAME_LIST.contains(tempElType))
/*      */       {
/*  620 */         types.addExtensibilityElement(parseSchema(Types.class, tempEl, def));
/*      */       }
/*      */       else
/*      */       {
/*  625 */         types.addExtensibilityElement(parseExtensibilityElement(Types.class, tempEl, def));
/*      */       }
/*      */ 
/*  629 */       tempEl = DOMUtils.getNextSiblingElement(tempEl);
/*      */     }
/*      */ 
/*  632 */     parseExtensibilityAttributes(typesEl, Types.class, types, def);
/*      */ 
/*  634 */     return types;
/*      */   }
/*      */ 
/*      */   protected ExtensibilityElement parseSchema(Class parentType, Element el, Definition def)
/*      */     throws WSDLException
/*      */   {
/*  642 */     QName elementType = null;
/*  643 */     ExtensionRegistry extReg = null;
/*      */     try
/*      */     {
/*  647 */       extReg = def.getExtensionRegistry();
/*      */ 
/*  649 */       if (extReg == null)
/*      */       {
/*  651 */         throw new WSDLException("CONFIGURATION_ERROR", "No ExtensionRegistry set for this Definition, so unable to deserialize a '" + elementType + "' element in the " + "context of a '" + parentType.getName() + "'.");
/*      */       }
/*      */ 
/*  659 */       return parseSchema(parentType, el, def, extReg);
/*      */     }
/*      */     catch (WSDLException e)
/*      */     {
/*  663 */       if (e.getLocation() == null)
/*      */       {
/*  665 */         e.setLocation(XPathUtils.getXPathExprFromNode(el));
/*      */       }
/*      */     }
/*  668 */     throw e;
/*      */   }
/*      */ 
/*      */   protected ExtensibilityElement parseSchema(Class parentType, Element el, Definition def, ExtensionRegistry extReg)
/*      */     throws WSDLException
/*      */   {
/*  687 */     Schema schema = null;
/*  688 */     SchemaReference schemaRef = null;
/*      */     try
/*      */     {
/*  692 */       QName elementType = QNameUtils.newQName(el);
/*      */ 
/*  694 */       ExtensionDeserializer exDS = extReg.queryDeserializer(parentType, elementType);
/*      */ 
/*  698 */       ExtensibilityElement ee = exDS.unmarshall(parentType, elementType, el, def, extReg);
/*      */ 
/*  701 */       if ((ee instanceof Schema))
/*      */       {
/*  703 */         schema = (Schema)ee;
/*      */       }
/*      */       else
/*      */       {
/*  708 */         return ee;
/*      */       }
/*      */ 
/*  714 */       if (schema.getDocumentBaseURI() != null)
/*      */       {
/*  716 */         this.allSchemas.put(schema.getDocumentBaseURI(), schema);
/*      */       }
/*      */ 
/*  726 */       ArrayList allSchemaRefs = new ArrayList();
/*      */ 
/*  728 */       Collection ic = schema.getImports().values();
/*  729 */       Iterator importsIterator = ic.iterator();
/*  730 */       while (importsIterator.hasNext())
/*      */       {
/*  732 */         allSchemaRefs.addAll((Collection)importsIterator.next());
/*      */       }
/*      */ 
/*  735 */       allSchemaRefs.addAll(schema.getIncludes());
/*  736 */       allSchemaRefs.addAll(schema.getRedefines());
/*      */ 
/*  742 */       ListIterator schemaRefIterator = allSchemaRefs.listIterator();
/*      */ 
/*  744 */       while (schemaRefIterator.hasNext())
/*      */       {
/*      */         try
/*      */         {
/*  748 */           schemaRef = (SchemaReference)schemaRefIterator.next();
/*      */ 
/*  750 */           if (schemaRef.getSchemaLocationURI() == null)
/*      */           {
/*      */             continue;
/*      */           }
/*      */ 
/*  756 */           if (this.verbose)
/*      */           {
/*  758 */             System.out.println("Retrieving schema at '" + schemaRef.getSchemaLocationURI() + (schema.getDocumentBaseURI() == null ? "'." : new StringBuilder().append("', relative to '").append(schema.getDocumentBaseURI()).append("'.").toString()));
/*      */           }
/*      */ 
/*  767 */           InputStream inputStream = null;
/*  768 */           InputSource inputSource = null;
/*      */ 
/*  771 */           Schema referencedSchema = null;
/*      */ 
/*  774 */           String location = null;
/*      */ 
/*  776 */           if (this.loc != null)
/*      */           {
/*  779 */             inputSource = this.loc.getImportInputSource(schema.getDocumentBaseURI(), schemaRef.getSchemaLocationURI());
/*      */ 
/*  782 */             if (inputSource == null)
/*      */             {
/*  784 */               throw new WSDLException("OTHER_ERROR", "Unable to locate with a locator the schema referenced at '" + schemaRef.getSchemaLocationURI() + "' relative to document base '" + schema.getDocumentBaseURI() + "'");
/*      */             }
/*      */ 
/*  791 */             location = this.loc.getLatestImportURI();
/*      */ 
/*  794 */             referencedSchema = (Schema)this.allSchemas.get(location);
/*      */           }
/*      */           else
/*      */           {
/*  799 */             String contextURI = schema.getDocumentBaseURI();
/*  800 */             URL contextURL = contextURI != null ? StringUtils.getURL(null, contextURI) : null;
/*  801 */             URL url = StringUtils.getURL(contextURL, schemaRef.getSchemaLocationURI());
/*  802 */             location = url.toExternalForm();
/*      */ 
/*  805 */             referencedSchema = (Schema)this.allSchemas.get(location);
/*      */ 
/*  807 */             if (referencedSchema == null)
/*      */             {
/*  810 */               inputStream = StringUtils.getContentAsInputStream(url);
/*      */ 
/*  812 */               if (inputStream != null)
/*      */               {
/*  814 */                 inputSource = new InputSource(inputStream);
/*      */               }
/*      */ 
/*  817 */               if (inputSource == null)
/*      */               {
/*  819 */                 throw new WSDLException("OTHER_ERROR", "Unable to locate with a url the document referenced at '" + schemaRef.getSchemaLocationURI() + "'" + (contextURI == null ? "." : new StringBuilder().append(", relative to '").append(contextURI).append("'.").toString()));
/*      */               }
/*      */ 
/*      */             }
/*      */ 
/*      */           }
/*      */ 
/*  832 */           if (referencedSchema == null)
/*      */           {
/*  834 */             inputSource.setSystemId(location);
/*  835 */             Document doc = getDocument(inputSource, location);
/*      */ 
/*  837 */             if (inputStream != null)
/*      */             {
/*  839 */               inputStream.close();
/*      */             }
/*      */ 
/*  842 */             Element documentElement = doc.getDocumentElement();
/*      */ 
/*  846 */             QName docElementQName = QNameUtils.newQName(documentElement);
/*      */ 
/*  848 */             if (SchemaConstants.XSD_QNAME_LIST.contains(docElementQName))
/*      */             {
/*  862 */               WSDLFactory factory = getWSDLFactory();
/*  863 */               Definition dummyDef = factory.newDefinition();
/*      */ 
/*  865 */               dummyDef.setDocumentBaseURI(location);
/*      */ 
/*  869 */               referencedSchema = (Schema)parseSchema(parentType, documentElement, dummyDef, extReg);
/*      */             }
/*      */ 
/*      */           }
/*      */ 
/*  877 */           schemaRef.setReferencedSchema(referencedSchema);
/*      */         }
/*      */         catch (WSDLException e)
/*      */         {
/*  881 */           throw e;
/*      */         }
/*      */         catch (RuntimeException e)
/*      */         {
/*  885 */           throw e;
/*      */         }
/*      */         catch (Exception e)
/*      */         {
/*  889 */           throw new WSDLException("OTHER_ERROR", "An error occurred trying to resolve schema referenced at '" + schemaRef.getSchemaLocationURI() + "'" + (schema.getDocumentBaseURI() == null ? "." : new StringBuilder().append(", relative to '").append(schema.getDocumentBaseURI()).append("'.").toString()), e);
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  900 */       return schema;
/*      */     }
/*      */     catch (WSDLException e)
/*      */     {
/*  905 */       if (e.getLocation() == null)
/*      */       {
/*  907 */         e.setLocation(XPathUtils.getXPathExprFromNode(el));
/*      */       }
/*      */       else
/*      */       {
/*  914 */         String loc = XPathUtils.getXPathExprFromNode(el) + e.getLocation();
/*  915 */         e.setLocation(loc);
/*      */       }
/*      */     }
/*  918 */     throw e;
/*      */   }
/*      */ 
/*      */   protected Binding parseBinding(Element bindingEl, Definition def)
/*      */     throws WSDLException
/*      */   {
/*  927 */     Binding binding = null;
/*      */ 
/*  929 */     List remainingAttrs = DOMUtils.getAttributes(bindingEl);
/*  930 */     String name = DOMUtils.getAttribute(bindingEl, "name", remainingAttrs);
/*  931 */     QName portTypeName = getQualifiedAttributeValue(bindingEl, "type", "binding", def, remainingAttrs);
/*      */ 
/*  937 */     PortType portType = null;
/*      */ 
/*  939 */     if (name != null)
/*      */     {
/*  941 */       QName bindingName = new QName(def.getTargetNamespace(), name);
/*      */ 
/*  943 */       binding = def.getBinding(bindingName);
/*      */ 
/*  945 */       if (binding == null)
/*      */       {
/*  947 */         binding = def.createBinding();
/*  948 */         binding.setQName(bindingName);
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/*  953 */       binding = def.createBinding();
/*      */     }
/*      */ 
/*  957 */     binding.setUndefined(false);
/*      */ 
/*  959 */     if (portTypeName != null)
/*      */     {
/*  961 */       portType = def.getPortType(portTypeName);
/*      */ 
/*  963 */       if (portType == null)
/*      */       {
/*  965 */         portType = def.createPortType();
/*  966 */         portType.setQName(portTypeName);
/*  967 */         def.addPortType(portType);
/*      */       }
/*      */ 
/*  970 */       binding.setPortType(portType);
/*      */     }
/*      */ 
/*  974 */     NamedNodeMap attrs = bindingEl.getAttributes();
/*  975 */     registerNSDeclarations(attrs, def);
/*      */ 
/*  977 */     Element tempEl = DOMUtils.getFirstChildElement(bindingEl);
/*      */ 
/*  979 */     while (tempEl != null)
/*      */     {
/*  981 */       if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, tempEl))
/*      */       {
/*  983 */         binding.setDocumentationElement(tempEl);
/*      */       }
/*  985 */       else if (QNameUtils.matches(Constants.Q_ELEM_OPERATION, tempEl))
/*      */       {
/*  987 */         binding.addBindingOperation(parseBindingOperation(tempEl, portType, def));
/*      */       }
/*      */       else
/*      */       {
/*  993 */         binding.addExtensibilityElement(parseExtensibilityElement(Binding.class, tempEl, def));
/*      */       }
/*      */ 
/*  997 */       tempEl = DOMUtils.getNextSiblingElement(tempEl);
/*      */     }
/*      */ 
/* 1000 */     return binding;
/*      */   }
/*      */ 
/*      */   protected BindingOperation parseBindingOperation(Element bindingOperationEl, PortType portType, Definition def)
/*      */     throws WSDLException
/*      */   {
/* 1009 */     BindingOperation bindingOperation = def.createBindingOperation();
/*      */ 
/* 1011 */     List remainingAttrs = DOMUtils.getAttributes(bindingOperationEl);
/* 1012 */     String name = DOMUtils.getAttribute(bindingOperationEl, "name", remainingAttrs);
/*      */ 
/* 1016 */     if (name != null)
/*      */     {
/* 1018 */       bindingOperation.setName(name);
/*      */     }
/*      */ 
/* 1022 */     NamedNodeMap attrs = bindingOperationEl.getAttributes();
/* 1023 */     registerNSDeclarations(attrs, def);
/*      */ 
/* 1025 */     Element tempEl = DOMUtils.getFirstChildElement(bindingOperationEl);
/*      */ 
/* 1027 */     while (tempEl != null)
/*      */     {
/* 1029 */       if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, tempEl))
/*      */       {
/* 1031 */         bindingOperation.setDocumentationElement(tempEl);
/*      */       }
/* 1033 */       else if (QNameUtils.matches(Constants.Q_ELEM_INPUT, tempEl))
/*      */       {
/* 1035 */         bindingOperation.setBindingInput(parseBindingInput(tempEl, def));
/*      */       }
/* 1037 */       else if (QNameUtils.matches(Constants.Q_ELEM_OUTPUT, tempEl))
/*      */       {
/* 1039 */         bindingOperation.setBindingOutput(parseBindingOutput(tempEl, def));
/*      */       }
/* 1041 */       else if (QNameUtils.matches(Constants.Q_ELEM_FAULT, tempEl))
/*      */       {
/* 1043 */         bindingOperation.addBindingFault(parseBindingFault(tempEl, def));
/*      */       }
/*      */       else
/*      */       {
/* 1047 */         bindingOperation.addExtensibilityElement(parseExtensibilityElement(BindingOperation.class, tempEl, def));
/*      */       }
/*      */ 
/* 1051 */       tempEl = DOMUtils.getNextSiblingElement(tempEl);
/*      */     }
/*      */ 
/* 1054 */     if (portType != null)
/*      */     {
/* 1056 */       BindingInput bindingInput = bindingOperation.getBindingInput();
/* 1057 */       BindingOutput bindingOutput = bindingOperation.getBindingOutput();
/* 1058 */       String inputName = bindingInput != null ? ":none" : bindingInput.getName() != null ? bindingInput.getName() : null;
/*      */ 
/* 1061 */       String outputName = bindingOutput != null ? ":none" : bindingOutput.getName() != null ? bindingOutput.getName() : null;
/*      */ 
/* 1064 */       Operation op = portType.getOperation(name, inputName, outputName);
/*      */ 
/* 1076 */       if (op == null)
/*      */       {
/* 1078 */         if ((":none".equals(inputName)) && (":none".equals(outputName)))
/*      */         {
/* 1082 */           op = portType.getOperation(name, null, null);
/*      */         }
/* 1084 */         else if (":none".equals(inputName))
/*      */         {
/* 1088 */           op = portType.getOperation(name, null, outputName);
/*      */         }
/* 1090 */         else if (":none".equals(outputName))
/*      */         {
/* 1094 */           op = portType.getOperation(name, inputName, null);
/*      */         }
/*      */       }
/*      */ 
/* 1098 */       if (op == null)
/*      */       {
/* 1100 */         Input input = def.createInput();
/* 1101 */         Output output = def.createOutput();
/*      */ 
/* 1103 */         op = def.createOperation();
/* 1104 */         op.setName(name);
/* 1105 */         input.setName(inputName);
/* 1106 */         output.setName(outputName);
/* 1107 */         op.setInput(input);
/* 1108 */         op.setOutput(output);
/* 1109 */         portType.addOperation(op);
/*      */       }
/*      */ 
/* 1112 */       bindingOperation.setOperation(op);
/*      */     }
/*      */ 
/* 1115 */     parseExtensibilityAttributes(bindingOperationEl, BindingOperation.class, bindingOperation, def);
/*      */ 
/* 1117 */     return bindingOperation;
/*      */   }
/*      */ 
/*      */   protected BindingInput parseBindingInput(Element bindingInputEl, Definition def)
/*      */     throws WSDLException
/*      */   {
/* 1124 */     BindingInput bindingInput = def.createBindingInput();
/*      */ 
/* 1126 */     List remainingAttrs = DOMUtils.getAttributes(bindingInputEl);
/* 1127 */     String name = DOMUtils.getAttribute(bindingInputEl, "name", remainingAttrs);
/*      */ 
/* 1131 */     if (name != null)
/*      */     {
/* 1133 */       bindingInput.setName(name);
/*      */     }
/*      */ 
/* 1137 */     NamedNodeMap attrs = bindingInputEl.getAttributes();
/* 1138 */     registerNSDeclarations(attrs, def);
/*      */ 
/* 1140 */     Element tempEl = DOMUtils.getFirstChildElement(bindingInputEl);
/*      */ 
/* 1142 */     while (tempEl != null)
/*      */     {
/* 1144 */       if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, tempEl))
/*      */       {
/* 1146 */         bindingInput.setDocumentationElement(tempEl);
/*      */       }
/*      */       else
/*      */       {
/* 1150 */         bindingInput.addExtensibilityElement(parseExtensibilityElement(BindingInput.class, tempEl, def));
/*      */       }
/*      */ 
/* 1154 */       tempEl = DOMUtils.getNextSiblingElement(tempEl);
/*      */     }
/*      */ 
/* 1157 */     return bindingInput;
/*      */   }
/*      */ 
/*      */   protected BindingOutput parseBindingOutput(Element bindingOutputEl, Definition def)
/*      */     throws WSDLException
/*      */   {
/* 1164 */     BindingOutput bindingOutput = def.createBindingOutput();
/*      */ 
/* 1166 */     List remainingAttrs = DOMUtils.getAttributes(bindingOutputEl);
/* 1167 */     String name = DOMUtils.getAttribute(bindingOutputEl, "name", remainingAttrs);
/*      */ 
/* 1171 */     if (name != null)
/*      */     {
/* 1173 */       bindingOutput.setName(name);
/*      */     }
/*      */ 
/* 1177 */     NamedNodeMap attrs = bindingOutputEl.getAttributes();
/* 1178 */     registerNSDeclarations(attrs, def);
/*      */ 
/* 1180 */     Element tempEl = DOMUtils.getFirstChildElement(bindingOutputEl);
/*      */ 
/* 1182 */     while (tempEl != null)
/*      */     {
/* 1184 */       if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, tempEl))
/*      */       {
/* 1186 */         bindingOutput.setDocumentationElement(tempEl);
/*      */       }
/*      */       else
/*      */       {
/* 1190 */         bindingOutput.addExtensibilityElement(parseExtensibilityElement(BindingOutput.class, tempEl, def));
/*      */       }
/*      */ 
/* 1194 */       tempEl = DOMUtils.getNextSiblingElement(tempEl);
/*      */     }
/*      */ 
/* 1197 */     return bindingOutput;
/*      */   }
/*      */ 
/*      */   protected BindingFault parseBindingFault(Element bindingFaultEl, Definition def)
/*      */     throws WSDLException
/*      */   {
/* 1204 */     BindingFault bindingFault = def.createBindingFault();
/*      */ 
/* 1206 */     List remainingAttrs = DOMUtils.getAttributes(bindingFaultEl);
/* 1207 */     String name = DOMUtils.getAttribute(bindingFaultEl, "name", remainingAttrs);
/*      */ 
/* 1211 */     if (name != null)
/*      */     {
/* 1213 */       bindingFault.setName(name);
/*      */     }
/*      */ 
/* 1217 */     NamedNodeMap attrs = bindingFaultEl.getAttributes();
/* 1218 */     registerNSDeclarations(attrs, def);
/*      */ 
/* 1220 */     Element tempEl = DOMUtils.getFirstChildElement(bindingFaultEl);
/*      */ 
/* 1222 */     while (tempEl != null)
/*      */     {
/* 1224 */       if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, tempEl))
/*      */       {
/* 1226 */         bindingFault.setDocumentationElement(tempEl);
/*      */       }
/*      */       else
/*      */       {
/* 1230 */         bindingFault.addExtensibilityElement(parseExtensibilityElement(BindingFault.class, tempEl, def));
/*      */       }
/*      */ 
/* 1234 */       tempEl = DOMUtils.getNextSiblingElement(tempEl);
/*      */     }
/*      */ 
/* 1237 */     parseExtensibilityAttributes(bindingFaultEl, BindingFault.class, bindingFault, def);
/*      */ 
/* 1239 */     return bindingFault;
/*      */   }
/*      */ 
/*      */   protected Message parseMessage(Element msgEl, Definition def)
/*      */     throws WSDLException
/*      */   {
/* 1245 */     Message msg = null;
/*      */ 
/* 1247 */     List remainingAttrs = DOMUtils.getAttributes(msgEl);
/* 1248 */     String name = DOMUtils.getAttribute(msgEl, "name", remainingAttrs);
/*      */ 
/* 1250 */     if (name != null)
/*      */     {
/* 1252 */       QName messageName = new QName(def.getTargetNamespace(), name);
/*      */ 
/* 1254 */       msg = def.getMessage(messageName);
/*      */ 
/* 1256 */       if (msg == null)
/*      */       {
/* 1258 */         msg = def.createMessage();
/* 1259 */         msg.setQName(messageName);
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/* 1264 */       msg = def.createMessage();
/*      */     }
/*      */ 
/* 1268 */     msg.setUndefined(false);
/*      */ 
/* 1271 */     NamedNodeMap attrs = msgEl.getAttributes();
/* 1272 */     registerNSDeclarations(attrs, def);
/*      */ 
/* 1274 */     Element tempEl = DOMUtils.getFirstChildElement(msgEl);
/*      */ 
/* 1276 */     while (tempEl != null)
/*      */     {
/* 1278 */       if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, tempEl))
/*      */       {
/* 1280 */         msg.setDocumentationElement(tempEl);
/*      */       }
/* 1282 */       else if (QNameUtils.matches(Constants.Q_ELEM_PART, tempEl))
/*      */       {
/* 1284 */         msg.addPart(parsePart(tempEl, def));
/*      */       }
/*      */       else
/*      */       {
/* 1288 */         msg.addExtensibilityElement(parseExtensibilityElement(Message.class, tempEl, def));
/*      */       }
/*      */ 
/* 1292 */       tempEl = DOMUtils.getNextSiblingElement(tempEl);
/*      */     }
/*      */ 
/* 1295 */     parseExtensibilityAttributes(msgEl, Message.class, msg, def);
/*      */ 
/* 1297 */     return msg;
/*      */   }
/*      */ 
/*      */   protected Part parsePart(Element partEl, Definition def)
/*      */     throws WSDLException
/*      */   {
/* 1303 */     Part part = def.createPart();
/* 1304 */     String name = DOMUtils.getAttribute(partEl, "name");
/* 1305 */     QName elementName = getQualifiedAttributeValue(partEl, "element", "message", def);
/*      */ 
/* 1309 */     QName typeName = getQualifiedAttributeValue(partEl, "type", "message", def);
/*      */ 
/* 1314 */     if (name != null)
/*      */     {
/* 1316 */       part.setName(name);
/*      */     }
/*      */ 
/* 1319 */     if (elementName != null)
/*      */     {
/* 1321 */       part.setElementName(elementName);
/*      */     }
/*      */ 
/* 1324 */     if (typeName != null)
/*      */     {
/* 1326 */       part.setTypeName(typeName);
/*      */     }
/*      */ 
/* 1330 */     NamedNodeMap attrs = partEl.getAttributes();
/* 1331 */     registerNSDeclarations(attrs, def);
/*      */ 
/* 1333 */     Element tempEl = DOMUtils.getFirstChildElement(partEl);
/*      */ 
/* 1335 */     while (tempEl != null)
/*      */     {
/* 1337 */       if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, tempEl))
/*      */       {
/* 1339 */         part.setDocumentationElement(tempEl);
/*      */       }
/*      */       else
/*      */       {
/* 1343 */         part.addExtensibilityElement(parseExtensibilityElement(Part.class, tempEl, def));
/*      */       }
/*      */ 
/* 1347 */       tempEl = DOMUtils.getNextSiblingElement(tempEl);
/*      */     }
/*      */ 
/* 1350 */     parseExtensibilityAttributes(partEl, Part.class, part, def);
/*      */ 
/* 1352 */     return part;
/*      */   }
/*      */ 
/*      */   protected void parseExtensibilityAttributes(Element el, Class parentType, AttributeExtensible attrExt, Definition def)
/*      */     throws WSDLException
/*      */   {
/* 1361 */     List nativeAttributeNames = attrExt.getNativeAttributeNames();
/* 1362 */     NamedNodeMap nodeMap = el.getAttributes();
/* 1363 */     int length = nodeMap.getLength();
/*      */ 
/* 1365 */     for (int i = 0; i < length; i++)
/*      */     {
/* 1367 */       Attr attribute = (Attr)nodeMap.item(i);
/* 1368 */       String localName = attribute.getLocalName();
/* 1369 */       String namespaceURI = attribute.getNamespaceURI();
/* 1370 */       String prefix = attribute.getPrefix();
/* 1371 */       QName qname = new QName(namespaceURI, localName);
/*      */ 
/* 1373 */       if ((namespaceURI != null) && (!namespaceURI.equals("http://schemas.xmlsoap.org/wsdl/")))
/*      */       {
/* 1375 */         if (namespaceURI.equals("http://www.w3.org/2000/xmlns/"))
/*      */           continue;
/* 1377 */         DOMUtils.registerUniquePrefix(prefix, namespaceURI, def);
/*      */ 
/* 1379 */         String strValue = attribute.getValue();
/* 1380 */         int attrType = -1;
/* 1381 */         ExtensionRegistry extReg = def.getExtensionRegistry();
/*      */ 
/* 1383 */         if (extReg != null)
/*      */         {
/* 1385 */           attrType = extReg.queryExtensionAttributeType(parentType, qname);
/*      */         }
/*      */ 
/* 1388 */         Object val = parseExtensibilityAttribute(el, attrType, strValue, def);
/*      */ 
/* 1390 */         attrExt.setExtensionAttribute(qname, val);
/*      */       }
/*      */       else {
/* 1393 */         if (nativeAttributeNames.contains(localName))
/*      */           continue;
/* 1395 */         WSDLException wsdlExc = new WSDLException("INVALID_WSDL", "Encountered illegal extension attribute '" + qname + "'. Extension " + "attributes must be in " + "a namespace other than " + "WSDL's.");
/*      */ 
/* 1403 */         wsdlExc.setLocation(XPathUtils.getXPathExprFromNode(el));
/*      */ 
/* 1405 */         throw wsdlExc;
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected Object parseExtensibilityAttribute(Element el, int attrType, String attrValue, Definition def)
/*      */     throws WSDLException
/*      */   {
/* 1416 */     if (attrType == 1)
/*      */     {
/* 1418 */       return DOMUtils.getQName(attrValue, el, def);
/*      */     }
/* 1420 */     if (attrType == 2)
/*      */     {
/* 1422 */       return StringUtils.parseNMTokens(attrValue);
/*      */     }
/* 1424 */     if (attrType == 3)
/*      */     {
/* 1426 */       List oldList = StringUtils.parseNMTokens(attrValue);
/* 1427 */       int size = oldList.size();
/* 1428 */       List newList = new Vector(size);
/*      */ 
/* 1430 */       for (int i = 0; i < size; i++)
/*      */       {
/* 1432 */         String str = (String)oldList.get(i);
/* 1433 */         QName qValue = DOMUtils.getQName(str, el, def);
/*      */ 
/* 1435 */         newList.add(qValue);
/*      */       }
/*      */ 
/* 1438 */       return newList;
/*      */     }
/* 1440 */     if (attrType == 0)
/*      */     {
/* 1442 */       return attrValue;
/*      */     }
/*      */ 
/* 1446 */     QName qValue = null;
/*      */     try
/*      */     {
/* 1450 */       qValue = DOMUtils.getQName(attrValue, el, def);
/*      */     }
/*      */     catch (WSDLException e)
/*      */     {
/* 1454 */       qValue = new QName(attrValue);
/*      */     }
/*      */ 
/* 1457 */     return qValue;
/*      */   }
/*      */ 
/*      */   protected PortType parsePortType(Element portTypeEl, Definition def)
/*      */     throws WSDLException
/*      */   {
/* 1464 */     PortType portType = null;
/* 1465 */     String name = DOMUtils.getAttribute(portTypeEl, "name");
/*      */ 
/* 1467 */     if (name != null)
/*      */     {
/* 1469 */       QName portTypeName = new QName(def.getTargetNamespace(), name);
/*      */ 
/* 1471 */       portType = def.getPortType(portTypeName);
/*      */ 
/* 1473 */       if (portType == null)
/*      */       {
/* 1475 */         portType = def.createPortType();
/* 1476 */         portType.setQName(portTypeName);
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/* 1481 */       portType = def.createPortType();
/*      */     }
/*      */ 
/* 1485 */     portType.setUndefined(false);
/*      */ 
/* 1488 */     NamedNodeMap attrs = portTypeEl.getAttributes();
/* 1489 */     registerNSDeclarations(attrs, def);
/*      */ 
/* 1491 */     Element tempEl = DOMUtils.getFirstChildElement(portTypeEl);
/*      */ 
/* 1493 */     while (tempEl != null)
/*      */     {
/* 1495 */       if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, tempEl))
/*      */       {
/* 1497 */         portType.setDocumentationElement(tempEl);
/*      */       }
/* 1499 */       else if (QNameUtils.matches(Constants.Q_ELEM_OPERATION, tempEl))
/*      */       {
/* 1501 */         Operation op = parseOperation(tempEl, portType, def);
/*      */ 
/* 1503 */         if (op != null)
/*      */         {
/* 1505 */           portType.addOperation(op);
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/* 1510 */         portType.addExtensibilityElement(parseExtensibilityElement(PortType.class, tempEl, def));
/*      */       }
/*      */ 
/* 1514 */       tempEl = DOMUtils.getNextSiblingElement(tempEl);
/*      */     }
/*      */ 
/* 1517 */     parseExtensibilityAttributes(portTypeEl, PortType.class, portType, def);
/*      */ 
/* 1519 */     return portType;
/*      */   }
/*      */ 
/*      */   protected Operation parseOperation(Element opEl, PortType portType, Definition def)
/*      */     throws WSDLException
/*      */   {
/* 1527 */     Operation op = null;
/*      */ 
/* 1529 */     List remainingAttrs = DOMUtils.getAttributes(opEl);
/* 1530 */     String name = DOMUtils.getAttribute(opEl, "name", remainingAttrs);
/* 1531 */     String parameterOrderStr = DOMUtils.getAttribute(opEl, "parameterOrder", remainingAttrs);
/*      */ 
/* 1536 */     NamedNodeMap attrs = opEl.getAttributes();
/* 1537 */     registerNSDeclarations(attrs, def);
/*      */ 
/* 1539 */     Element tempEl = DOMUtils.getFirstChildElement(opEl);
/* 1540 */     List messageOrder = new Vector();
/* 1541 */     Element docEl = null;
/* 1542 */     Input input = null;
/* 1543 */     Output output = null;
/* 1544 */     List faults = new Vector();
/* 1545 */     List extElements = new Vector();
/* 1546 */     boolean retrieved = true;
/*      */ 
/* 1548 */     while (tempEl != null)
/*      */     {
/* 1550 */       if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, tempEl))
/*      */       {
/* 1552 */         docEl = tempEl;
/*      */       }
/* 1554 */       else if (QNameUtils.matches(Constants.Q_ELEM_INPUT, tempEl))
/*      */       {
/* 1556 */         input = parseInput(tempEl, def);
/* 1557 */         messageOrder.add("input");
/*      */       }
/* 1559 */       else if (QNameUtils.matches(Constants.Q_ELEM_OUTPUT, tempEl))
/*      */       {
/* 1561 */         output = parseOutput(tempEl, def);
/* 1562 */         messageOrder.add("output");
/*      */       }
/* 1564 */       else if (QNameUtils.matches(Constants.Q_ELEM_FAULT, tempEl))
/*      */       {
/* 1566 */         faults.add(parseFault(tempEl, def));
/*      */       }
/*      */       else
/*      */       {
/* 1570 */         extElements.add(parseExtensibilityElement(Operation.class, tempEl, def));
/*      */       }
/*      */ 
/* 1574 */       tempEl = DOMUtils.getNextSiblingElement(tempEl);
/*      */     }
/*      */ 
/* 1577 */     if (name != null)
/*      */     {
/* 1579 */       String inputName = input != null ? ":none" : input.getName() != null ? input.getName() : null;
/*      */ 
/* 1582 */       String outputName = output != null ? ":none" : output.getName() != null ? output.getName() : null;
/*      */ 
/* 1586 */       op = portType.getOperation(name, inputName, outputName);
/*      */ 
/* 1588 */       if ((op != null) && (!op.isUndefined()))
/*      */       {
/* 1590 */         op = null;
/*      */       }
/*      */ 
/* 1593 */       if (op != null)
/*      */       {
/* 1595 */         if (inputName == null)
/*      */         {
/* 1597 */           Input tempIn = op.getInput();
/*      */ 
/* 1599 */           if (tempIn != null)
/*      */           {
/* 1601 */             if (tempIn.getName() != null)
/*      */             {
/* 1603 */               op = null;
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */ 
/* 1609 */       if (op != null)
/*      */       {
/* 1611 */         if (outputName == null)
/*      */         {
/* 1613 */           Output tempOut = op.getOutput();
/*      */ 
/* 1615 */           if (tempOut != null)
/*      */           {
/* 1617 */             if (tempOut.getName() != null)
/*      */             {
/* 1619 */               op = null;
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */ 
/* 1625 */       if (op == null)
/*      */       {
/* 1627 */         op = def.createOperation();
/* 1628 */         op.setName(name);
/* 1629 */         retrieved = false;
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/* 1634 */       op = def.createOperation();
/* 1635 */       retrieved = false;
/*      */     }
/*      */ 
/* 1639 */     op.setUndefined(false);
/*      */ 
/* 1641 */     if (parameterOrderStr != null)
/*      */     {
/* 1643 */       op.setParameterOrdering(StringUtils.parseNMTokens(parameterOrderStr));
/*      */     }
/*      */ 
/* 1646 */     if (docEl != null)
/*      */     {
/* 1648 */       op.setDocumentationElement(docEl);
/*      */     }
/*      */ 
/* 1651 */     if (input != null)
/*      */     {
/* 1653 */       op.setInput(input);
/*      */     }
/*      */ 
/* 1656 */     if (output != null)
/*      */     {
/* 1658 */       op.setOutput(output);
/*      */     }
/*      */ 
/* 1661 */     if (faults.size() > 0)
/*      */     {
/* 1663 */       Iterator faultIterator = faults.iterator();
/*      */ 
/* 1665 */       while (faultIterator.hasNext())
/*      */       {
/* 1667 */         op.addFault((Fault)faultIterator.next());
/*      */       }
/*      */     }
/*      */ 
/* 1671 */     if (extElements.size() > 0)
/*      */     {
/* 1673 */       Iterator eeIterator = extElements.iterator();
/*      */ 
/* 1675 */       while (eeIterator.hasNext())
/*      */       {
/* 1677 */         op.addExtensibilityElement((ExtensibilityElement)eeIterator.next());
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1682 */     OperationType style = null;
/*      */ 
/* 1684 */     if (messageOrder.equals(STYLE_ONE_WAY))
/*      */     {
/* 1686 */       style = OperationType.ONE_WAY;
/*      */     }
/* 1688 */     else if (messageOrder.equals(STYLE_REQUEST_RESPONSE))
/*      */     {
/* 1690 */       style = OperationType.REQUEST_RESPONSE;
/*      */     }
/* 1692 */     else if (messageOrder.equals(STYLE_SOLICIT_RESPONSE))
/*      */     {
/* 1694 */       style = OperationType.SOLICIT_RESPONSE;
/*      */     }
/* 1696 */     else if (messageOrder.equals(STYLE_NOTIFICATION))
/*      */     {
/* 1698 */       style = OperationType.NOTIFICATION;
/*      */     }
/*      */ 
/* 1701 */     if (style != null)
/*      */     {
/* 1703 */       op.setStyle(style);
/*      */     }
/*      */ 
/* 1706 */     if (retrieved)
/*      */     {
/* 1708 */       op = null;
/*      */     }
/*      */ 
/* 1711 */     parseExtensibilityAttributes(opEl, Operation.class, op, def);
/*      */ 
/* 1713 */     return op;
/*      */   }
/*      */ 
/*      */   protected Service parseService(Element serviceEl, Definition def)
/*      */     throws WSDLException
/*      */   {
/* 1719 */     Service service = def.createService();
/*      */ 
/* 1721 */     List remainingAttrs = DOMUtils.getAttributes(serviceEl);
/* 1722 */     String name = DOMUtils.getAttribute(serviceEl, "name", remainingAttrs);
/*      */ 
/* 1724 */     if (name != null)
/*      */     {
/* 1726 */       service.setQName(new QName(def.getTargetNamespace(), name));
/*      */     }
/*      */ 
/* 1730 */     NamedNodeMap attrs = serviceEl.getAttributes();
/* 1731 */     registerNSDeclarations(attrs, def);
/*      */ 
/* 1733 */     Element tempEl = DOMUtils.getFirstChildElement(serviceEl);
/*      */ 
/* 1735 */     while (tempEl != null)
/*      */     {
/* 1737 */       if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, tempEl))
/*      */       {
/* 1739 */         service.setDocumentationElement(tempEl);
/*      */       }
/* 1741 */       else if (QNameUtils.matches(Constants.Q_ELEM_PORT, tempEl))
/*      */       {
/* 1743 */         service.addPort(parsePort(tempEl, def));
/*      */       }
/*      */       else
/*      */       {
/* 1747 */         service.addExtensibilityElement(parseExtensibilityElement(Service.class, tempEl, def));
/*      */       }
/*      */ 
/* 1751 */       tempEl = DOMUtils.getNextSiblingElement(tempEl);
/*      */     }
/*      */ 
/* 1754 */     parseExtensibilityAttributes(serviceEl, Service.class, service, def);
/*      */ 
/* 1756 */     return service;
/*      */   }
/*      */ 
/*      */   protected Port parsePort(Element portEl, Definition def)
/*      */     throws WSDLException
/*      */   {
/* 1762 */     Port port = def.createPort();
/*      */ 
/* 1764 */     List remainingAttrs = DOMUtils.getAttributes(portEl);
/* 1765 */     String name = DOMUtils.getAttribute(portEl, "name", remainingAttrs);
/* 1766 */     QName bindingStr = getQualifiedAttributeValue(portEl, "binding", "port", def, remainingAttrs);
/*      */ 
/* 1772 */     if (name != null)
/*      */     {
/* 1774 */       port.setName(name);
/*      */     }
/*      */ 
/* 1777 */     if (bindingStr != null)
/*      */     {
/* 1779 */       Binding binding = def.getBinding(bindingStr);
/*      */ 
/* 1781 */       if (binding == null)
/*      */       {
/* 1783 */         binding = def.createBinding();
/* 1784 */         binding.setQName(bindingStr);
/* 1785 */         def.addBinding(binding);
/*      */       }
/*      */ 
/* 1788 */       port.setBinding(binding);
/*      */     }
/*      */ 
/* 1792 */     NamedNodeMap attrs = portEl.getAttributes();
/* 1793 */     registerNSDeclarations(attrs, def);
/*      */ 
/* 1795 */     Element tempEl = DOMUtils.getFirstChildElement(portEl);
/*      */ 
/* 1797 */     while (tempEl != null)
/*      */     {
/* 1799 */       if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, tempEl))
/*      */       {
/* 1801 */         port.setDocumentationElement(tempEl);
/*      */       }
/*      */       else
/*      */       {
/* 1805 */         port.addExtensibilityElement(parseExtensibilityElement(Port.class, tempEl, def));
/*      */       }
/*      */ 
/* 1810 */       tempEl = DOMUtils.getNextSiblingElement(tempEl);
/*      */     }
/*      */ 
/* 1813 */     parseExtensibilityAttributes(portEl, Port.class, port, def);
/*      */ 
/* 1815 */     return port;
/*      */   }
/*      */ 
/*      */   protected ExtensibilityElement parseExtensibilityElement(Class parentType, Element el, Definition def)
/*      */     throws WSDLException
/*      */   {
/* 1824 */     QName elementType = QNameUtils.newQName(el);
/*      */ 
/* 1826 */     String namespaceURI = el.getNamespaceURI();
/*      */     try
/*      */     {
/* 1830 */       if ((namespaceURI == null) || (namespaceURI.equals("http://schemas.xmlsoap.org/wsdl/")))
/*      */       {
/* 1832 */         throw new WSDLException("INVALID_WSDL", "Encountered illegal extension element '" + elementType + "' in the context of a '" + parentType.getName() + "'. Extension elements must be in " + "a namespace other than WSDL's.");
/*      */       }
/*      */ 
/* 1841 */       ExtensionRegistry extReg = def.getExtensionRegistry();
/*      */ 
/* 1843 */       if (extReg == null)
/*      */       {
/* 1845 */         throw new WSDLException("CONFIGURATION_ERROR", "No ExtensionRegistry set for this Definition, so unable to deserialize a '" + elementType + "' element in the " + "context of a '" + parentType.getName() + "'.");
/*      */       }
/*      */ 
/* 1853 */       ExtensionDeserializer extDS = extReg.queryDeserializer(parentType, elementType);
/*      */ 
/* 1856 */       return extDS.unmarshall(parentType, elementType, el, def, extReg);
/*      */     }
/*      */     catch (WSDLException e)
/*      */     {
/* 1860 */       if (e.getLocation() == null)
/*      */       {
/* 1862 */         e.setLocation(XPathUtils.getXPathExprFromNode(el));
/*      */       }
/*      */     }
/* 1865 */     throw e;
/*      */   }
/*      */ 
/*      */   protected Input parseInput(Element inputEl, Definition def)
/*      */     throws WSDLException
/*      */   {
/* 1872 */     Input input = def.createInput();
/* 1873 */     String name = DOMUtils.getAttribute(inputEl, "name");
/* 1874 */     QName messageName = getQualifiedAttributeValue(inputEl, "message", "input", def);
/*      */ 
/* 1879 */     if (name != null)
/*      */     {
/* 1881 */       input.setName(name);
/*      */     }
/*      */ 
/* 1884 */     if (messageName != null)
/*      */     {
/* 1886 */       Message message = def.getMessage(messageName);
/*      */ 
/* 1888 */       if (message == null)
/*      */       {
/* 1890 */         message = def.createMessage();
/* 1891 */         message.setQName(messageName);
/* 1892 */         def.addMessage(message);
/*      */       }
/*      */ 
/* 1895 */       input.setMessage(message);
/*      */     }
/*      */ 
/* 1899 */     NamedNodeMap attrs = inputEl.getAttributes();
/* 1900 */     registerNSDeclarations(attrs, def);
/*      */ 
/* 1902 */     Element tempEl = DOMUtils.getFirstChildElement(inputEl);
/*      */ 
/* 1904 */     while (tempEl != null)
/*      */     {
/* 1906 */       if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, tempEl))
/*      */       {
/* 1908 */         input.setDocumentationElement(tempEl);
/*      */       }
/*      */       else
/*      */       {
/* 1912 */         input.addExtensibilityElement(parseExtensibilityElement(Input.class, tempEl, def));
/*      */       }
/*      */ 
/* 1916 */       tempEl = DOMUtils.getNextSiblingElement(tempEl);
/*      */     }
/*      */ 
/* 1919 */     parseExtensibilityAttributes(inputEl, Input.class, input, def);
/*      */ 
/* 1921 */     return input;
/*      */   }
/*      */ 
/*      */   protected Output parseOutput(Element outputEl, Definition def)
/*      */     throws WSDLException
/*      */   {
/* 1927 */     Output output = def.createOutput();
/* 1928 */     String name = DOMUtils.getAttribute(outputEl, "name");
/* 1929 */     QName messageName = getQualifiedAttributeValue(outputEl, "message", "output", def);
/*      */ 
/* 1934 */     if (name != null)
/*      */     {
/* 1936 */       output.setName(name);
/*      */     }
/*      */ 
/* 1939 */     if (messageName != null)
/*      */     {
/* 1941 */       Message message = def.getMessage(messageName);
/*      */ 
/* 1943 */       if (message == null)
/*      */       {
/* 1945 */         message = def.createMessage();
/* 1946 */         message.setQName(messageName);
/* 1947 */         def.addMessage(message);
/*      */       }
/*      */ 
/* 1950 */       output.setMessage(message);
/*      */     }
/*      */ 
/* 1954 */     NamedNodeMap attrs = outputEl.getAttributes();
/* 1955 */     registerNSDeclarations(attrs, def);
/*      */ 
/* 1957 */     Element tempEl = DOMUtils.getFirstChildElement(outputEl);
/*      */ 
/* 1959 */     while (tempEl != null)
/*      */     {
/* 1961 */       if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, tempEl))
/*      */       {
/* 1963 */         output.setDocumentationElement(tempEl);
/*      */       }
/*      */       else
/*      */       {
/* 1967 */         output.addExtensibilityElement(parseExtensibilityElement(Output.class, tempEl, def));
/*      */       }
/*      */ 
/* 1971 */       tempEl = DOMUtils.getNextSiblingElement(tempEl);
/*      */     }
/*      */ 
/* 1974 */     parseExtensibilityAttributes(outputEl, Output.class, output, def);
/*      */ 
/* 1976 */     return output;
/*      */   }
/*      */ 
/*      */   protected Fault parseFault(Element faultEl, Definition def)
/*      */     throws WSDLException
/*      */   {
/* 1982 */     Fault fault = def.createFault();
/* 1983 */     String name = DOMUtils.getAttribute(faultEl, "name");
/* 1984 */     QName messageName = getQualifiedAttributeValue(faultEl, "message", "fault", def);
/*      */ 
/* 1989 */     if (name != null)
/*      */     {
/* 1991 */       fault.setName(name);
/*      */     }
/*      */ 
/* 1994 */     if (messageName != null)
/*      */     {
/* 1996 */       Message message = def.getMessage(messageName);
/*      */ 
/* 1998 */       if (message == null)
/*      */       {
/* 2000 */         message = def.createMessage();
/* 2001 */         message.setQName(messageName);
/* 2002 */         def.addMessage(message);
/*      */       }
/*      */ 
/* 2005 */       fault.setMessage(message);
/*      */     }
/*      */ 
/* 2009 */     NamedNodeMap attrs = faultEl.getAttributes();
/* 2010 */     registerNSDeclarations(attrs, def);
/*      */ 
/* 2012 */     Element tempEl = DOMUtils.getFirstChildElement(faultEl);
/*      */ 
/* 2014 */     while (tempEl != null)
/*      */     {
/* 2016 */       if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, tempEl))
/*      */       {
/* 2018 */         fault.setDocumentationElement(tempEl);
/*      */       }
/*      */       else
/*      */       {
/* 2022 */         fault.addExtensibilityElement(parseExtensibilityElement(Fault.class, tempEl, def));
/*      */       }
/*      */ 
/* 2026 */       tempEl = DOMUtils.getNextSiblingElement(tempEl);
/*      */     }
/*      */ 
/* 2029 */     parseExtensibilityAttributes(faultEl, Fault.class, fault, def);
/*      */ 
/* 2031 */     return fault;
/*      */   }
/*      */ 
/*      */   private static QName getQualifiedAttributeValue(Element el, String attrName, String elDesc, Definition def)
/*      */     throws WSDLException
/*      */   {
/*      */     try
/*      */     {
/* 2046 */       return DOMUtils.getQualifiedAttributeValue(el, attrName, elDesc, false, def);
/*      */     }
/*      */     catch (WSDLException e)
/*      */     {
/* 2054 */       if (e.getFaultCode().equals("NO_PREFIX_SPECIFIED"))
/*      */       {
/* 2056 */         String attrValue = DOMUtils.getAttribute(el, attrName);
/*      */ 
/* 2058 */         return new QName(attrValue);
/*      */       }
/*      */     }
/*      */ 
/* 2062 */     throw e;
/*      */   }
/*      */ 
/*      */   private static QName getQualifiedAttributeValue(Element el, String attrName, String elDesc, Definition def, List remainingAttrs)
/*      */     throws WSDLException
/*      */   {
/*      */     try
/*      */     {
/* 2080 */       return DOMUtils.getQualifiedAttributeValue(el, attrName, elDesc, false, def, remainingAttrs);
/*      */     }
/*      */     catch (WSDLException e)
/*      */     {
/* 2089 */       if (e.getFaultCode().equals("NO_PREFIX_SPECIFIED"))
/*      */       {
/* 2091 */         String attrValue = DOMUtils.getAttribute(el, attrName, remainingAttrs);
/*      */ 
/* 2093 */         return new QName(attrValue);
/*      */       }
/*      */     }
/*      */ 
/* 2097 */     throw e;
/*      */   }
/*      */ 
/*      */   private static void checkElementName(Element el, QName qname)
/*      */     throws WSDLException
/*      */   {
/* 2105 */     if (!QNameUtils.matches(qname, el))
/*      */     {
/* 2107 */       WSDLException wsdlExc = new WSDLException("INVALID_WSDL", "Expected element '" + qname + "'.");
/*      */ 
/* 2111 */       wsdlExc.setLocation(XPathUtils.getXPathExprFromNode(el));
/*      */ 
/* 2113 */       throw wsdlExc;
/*      */     }
/*      */   }
/*      */ 
/*      */   private static Document getDocument(InputSource inputSource, String desc)
/*      */     throws WSDLException
/*      */   {
/* 2120 */     DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
/*      */ 
/* 2122 */     factory.setNamespaceAware(true);
/* 2123 */     factory.setValidating(false);
/*      */     try
/*      */     {
/* 2127 */       DocumentBuilder builder = factory.newDocumentBuilder();
/* 2128 */       builder.setEntityResolver(new JBossWSEntityResolver());
/* 2129 */       Document doc = builder.parse(inputSource);
/*      */ 
/* 2131 */       return doc;
/*      */     }
/*      */     catch (RuntimeException e)
/*      */     {
/* 2135 */       throw e;
/*      */     }
/*      */     catch (Exception e) {
/*      */     }
/* 2139 */     throw new WSDLException("PARSER_ERROR", "Problem parsing '" + desc + "'.", e);
/*      */   }
/*      */ 
/*      */   private static void registerNSDeclarations(NamedNodeMap attrs, Definition def)
/*      */   {
/* 2147 */     int size = attrs.getLength();
/*      */ 
/* 2149 */     for (int i = 0; i < size; i++)
/*      */     {
/* 2151 */       Attr attr = (Attr)attrs.item(i);
/* 2152 */       String namespaceURI = attr.getNamespaceURI();
/* 2153 */       String localPart = attr.getLocalName();
/* 2154 */       String value = attr.getValue();
/*      */ 
/* 2156 */       if ((namespaceURI == null) || (!namespaceURI.equals("http://www.w3.org/2000/xmlns/")))
/*      */         continue;
/* 2158 */       if ((localPart != null) && (!localPart.equals("xmlns")))
/*      */       {
/* 2160 */         DOMUtils.registerUniquePrefix(localPart, value, def);
/*      */       }
/*      */       else
/*      */       {
/* 2164 */         DOMUtils.registerUniquePrefix(null, value, def);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public Definition readWSDL(String wsdlURI)
/*      */     throws WSDLException
/*      */   {
/* 2180 */     return readWSDL(null, wsdlURI);
/*      */   }
/*      */ 
/*      */   public Definition readWSDL(String contextURI, String wsdlURI)
/*      */     throws WSDLException
/*      */   {
/*      */     try
/*      */     {
/* 2199 */       if (this.verbose)
/*      */       {
/* 2201 */         System.out.println("Retrieving document at '" + wsdlURI + "'" + (contextURI == null ? "." : new StringBuilder().append(", relative to '").append(contextURI).append("'.").toString()));
/*      */       }
/*      */ 
/* 2207 */       URL contextURL = contextURI != null ? StringUtils.getURL(null, contextURI) : null;
/*      */ 
/* 2210 */       URL url = StringUtils.getURL(contextURL, wsdlURI);
/* 2211 */       InputStream inputStream = StringUtils.getContentAsInputStream(url);
/* 2212 */       InputSource inputSource = new InputSource(inputStream);
/* 2213 */       inputSource.setSystemId(url.toString());
/* 2214 */       Document doc = getDocument(inputSource, url.toString());
/*      */ 
/* 2216 */       inputStream.close();
/*      */ 
/* 2218 */       Definition def = readWSDL(url.toString(), doc);
/*      */ 
/* 2220 */       return def;
/*      */     }
/*      */     catch (WSDLException e)
/*      */     {
/* 2224 */       throw e;
/*      */     }
/*      */     catch (RuntimeException e)
/*      */     {
/* 2228 */       throw e;
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/* 2232 */       if (contextURI == null) tmpTernaryOp = "'."; 
/* 2232 */     }throw new WSDLException("OTHER_ERROR", "Unable to resolve imported document at '" + wsdlURI + new StringBuilder().append("', relative to '").append(contextURI).append("'.").toString(), e);
/*      */   }
/*      */ 
/*      */   public Definition readWSDL(String documentBaseURI, Element definitionsElement)
/*      */     throws WSDLException
/*      */   {
/* 2257 */     return readWSDL(documentBaseURI, definitionsElement, null);
/*      */   }
/*      */ 
/*      */   public Definition readWSDL(WSDLLocator locator, Element definitionsElement)
/*      */     throws WSDLException
/*      */   {
/*      */     try
/*      */     {
/* 2278 */       this.loc = locator;
/* 2279 */       Definition localDefinition = readWSDL(locator.getBaseURI(), definitionsElement, null);
/*      */       return localDefinition;
/*      */     }
/*      */     finally
/*      */     {
/* 2283 */       locator.close();
/* 2284 */       this.loc = null; } throw localObject;
/*      */   }
/*      */ 
/*      */   protected Definition readWSDL(String documentBaseURI, Element definitionsElement, Map importedDefs)
/*      */     throws WSDLException
/*      */   {
/* 2293 */     return parseDefinitions(documentBaseURI, definitionsElement, importedDefs);
/*      */   }
/*      */ 
/*      */   public Definition readWSDL(String documentBaseURI, Document wsdlDocument)
/*      */     throws WSDLException
/*      */   {
/* 2310 */     return readWSDL(documentBaseURI, wsdlDocument.getDocumentElement());
/*      */   }
/*      */ 
/*      */   public Definition readWSDL(String documentBaseURI, InputSource inputSource)
/*      */     throws WSDLException
/*      */   {
/* 2328 */     String location = inputSource.getSystemId() != null ? inputSource.getSystemId() : "- WSDL Document -";
/*      */ 
/* 2331 */     return readWSDL(documentBaseURI, getDocument(inputSource, location));
/*      */   }
/*      */ 
/*      */   public Definition readWSDL(WSDLLocator locator)
/*      */     throws WSDLException
/*      */   {
/* 2344 */     InputSource is = locator.getBaseInputSource();
/* 2345 */     String base = locator.getBaseURI();
/*      */ 
/* 2347 */     if (is == null)
/*      */     {
/* 2349 */       throw new WSDLException("OTHER_ERROR", "Unable to locate document at '" + base + "'.");
/*      */     }
/*      */ 
/* 2352 */     is.setSystemId(base);
/*      */ 
/* 2354 */     this.loc = locator;
/*      */ 
/* 2356 */     if (this.verbose)
/*      */     {
/* 2358 */       System.out.println("Retrieving document at '" + base + "'.");
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/* 2363 */       Definition localDefinition = readWSDL(base, is);
/*      */       return localDefinition;
/*      */     }
/*      */     finally
/*      */     {
/* 2367 */       this.loc.close();
/* 2368 */       this.loc = null; } throw localObject;
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.tools.wsdl.JBossWSDLReaderImpl
 * JD-Core Version:    0.6.0
 */