/*     */ package org.jboss.ws.tools.wsdl;
/*     */ 
/*     */ import com.sun.xml.bind.api.JAXBRIContext;
/*     */ import java.io.IOException;
/*     */ import javax.xml.bind.SchemaOutputResolver;
/*     */ import javax.xml.parsers.DocumentBuilder;
/*     */ import javax.xml.parsers.DocumentBuilderFactory;
/*     */ import javax.xml.transform.Result;
/*     */ import javax.xml.transform.dom.DOMResult;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.extensions.security.Util;
/*     */ import org.jboss.ws.metadata.wsdl.DOMTypes;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
/*     */ import org.w3c.dom.Document;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class JAXBWSDLGenerator extends WSDLGenerator
/*     */ {
/*     */   private JAXBRIContext ctx;
/*     */ 
/*     */   public JAXBWSDLGenerator(JAXBRIContext ctx)
/*     */   {
/*  51 */     this.ctx = ctx;
/*     */   }
/*     */ 
/*     */   protected void processTypes()
/*     */   {
/*  60 */     for (String ns : this.ctx.getKnownNamespaceURIs()) {
/*  61 */       if (ns.length() > 0)
/*  62 */         this.wsdl.registerNamespaceURI(ns, null);
/*     */     }
/*     */     try
/*     */     {
/*  66 */       DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
/*  67 */       Document doc = builder.newDocument();
/*  68 */       DOMTypes types = new DOMTypes(doc);
/*  69 */       Element element = types.getElement();
/*  70 */       Element throwAway = doc.createElement("throw-away");
/*     */ 
/*  72 */       this.ctx.generateSchema(new SchemaOutputResolver(throwAway, element)
/*     */       {
/*     */         public Result createOutput(String namespace, String file)
/*     */           throws IOException
/*     */         {
/*  78 */           if ((namespace.length() > 0) && (JAXBWSDLGenerator.this.wsdl.getPrefix(namespace) == null)) {
/*  79 */             JAXBWSDLGenerator.this.wsdl.registerNamespaceURI(namespace, null);
/*     */           }
/*     */ 
/*  82 */           DOMResult result = new DOMResult((namespace == null) || (namespace.length() == 0) ? this.val$throwAway : this.val$element);
/*  83 */           result.setSystemId("replace-me");
/*  84 */           return result;
/*     */         }
/*     */       });
/*  89 */       removeSchemaLocations(element);
/*     */ 
/*  91 */       this.wsdl.setWsdlTypes(types);
/*     */     }
/*     */     catch (Exception exception)
/*     */     {
/*  95 */       throw new WSException("Could not generate schema: " + exception.getMessage(), exception);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void removeSchemaLocations(Element element)
/*     */   {
/* 101 */     for (Element child = Util.getFirstChildElement(element); child != null; child = Util.getNextSiblingElement(child))
/*     */     {
/* 103 */       if (("import".equals(child.getLocalName())) && ("http://www.w3.org/2001/XMLSchema".equals(child.getNamespaceURI())) && ("replace-me".equals(child.getAttribute("schemaLocation"))))
/*     */       {
/* 105 */         child.removeAttribute("schemaLocation");
/*     */       }
/*     */       else
/*     */       {
/* 109 */         removeSchemaLocations(child);
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.tools.wsdl.JAXBWSDLGenerator
 * JD-Core Version:    0.6.0
 */