/*     */ package org.jboss.ws.tools.metadata;
/*     */ 
/*     */ import java.rmi.Remote;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import javax.jws.soap.SOAPBinding.ParameterStyle;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.core.soap.Style;
/*     */ import org.jboss.ws.metadata.umdm.ServiceMetaData;
/*     */ import org.jboss.ws.metadata.umdm.UnifiedMetaData;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLUtils;
/*     */ import org.jboss.ws.tools.Configuration.OperationConfig;
/*     */ import org.jboss.wsf.common.ResourceLoaderAdapter;
/*     */ 
/*     */ public class ToolsUnifiedMetaDataBuilder
/*     */ {
/*  49 */   private static Logger log = Logger.getLogger(ToolsUnifiedMetaDataBuilder.class);
/*     */   private Class seiClass;
/*     */   private UnifiedMetaData um;
/*  53 */   private String targetNamespace = null;
/*  54 */   private String typeNamespace = null;
/*  55 */   private String serviceName = null;
/*  56 */   private Map<String, List<Configuration.OperationConfig>> operationMap = null;
/*     */   private Style style;
/*     */   private SOAPBinding.ParameterStyle parameterStyle;
/*     */ 
/*     */   public ToolsUnifiedMetaDataBuilder(Class epClass, String targetNamespace, String typeNamespace, String serviceName, Style style, SOAPBinding.ParameterStyle parameterStyle, Map<String, List<Configuration.OperationConfig>> operationMap)
/*     */   {
/*  64 */     this.seiClass = epClass;
/*  65 */     this.targetNamespace = targetNamespace;
/*  66 */     this.typeNamespace = (typeNamespace != null ? typeNamespace : targetNamespace);
/*  67 */     this.serviceName = serviceName;
/*  68 */     this.style = style;
/*  69 */     this.parameterStyle = parameterStyle;
/*  70 */     this.operationMap = operationMap;
/*     */ 
/*  72 */     buildMetaData();
/*     */   }
/*     */ 
/*     */   public UnifiedMetaData getUnifiedMetaData()
/*     */   {
/*  77 */     return this.um;
/*     */   }
/*     */ 
/*     */   private void buildMetaData()
/*     */   {
/*  84 */     if (!Remote.class.isAssignableFrom(this.seiClass)) {
/*  85 */       throw new WSException("A service endpoint interface should extend Remote");
/*     */     }
/*  87 */     ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
/*  88 */     ResourceLoaderAdapter vfsRoot = new ResourceLoaderAdapter();
/*  89 */     this.um = new UnifiedMetaData(vfsRoot);
/*  90 */     this.um.setClassLoader(contextClassLoader);
/*     */ 
/*  92 */     WSDLUtils.getInstance(); String seiName = WSDLUtils.getJustClassName(this.seiClass.getName());
/*  93 */     if (this.serviceName == null) {
/*  94 */       this.serviceName = (seiName + "Service");
/*     */     }
/*  96 */     this.um.addService(getServiceMetaData(this.um, this.targetNamespace, this.serviceName, seiName, this.seiClass));
/*     */ 
/*  98 */     generateOperationMetaData(this.seiClass);
/*     */   }
/*     */ 
/*     */   private void generateOperationMetaData(Class seiClass)
/*     */   {
/* 103 */     ServiceMetaData sm = (ServiceMetaData)this.um.getServices().get(0);
/* 104 */     ToolsEndpointMetaData em = (ToolsEndpointMetaData)sm.getEndpointByServiceEndpointInterface(seiClass.getName());
/* 105 */     if (em == null)
/* 106 */       throw new WSException("EndpointMetadata is null");
/* 107 */     ReflectiveMetaDataBuilder rmb = new ReflectiveMetaDataBuilder(em);
/* 108 */     rmb.setOperationMap(this.operationMap);
/* 109 */     em = rmb.generate();
/*     */   }
/*     */ 
/*     */   private ServiceMetaData getServiceMetaData(UnifiedMetaData um, String targetNamespace, String serviceName, String portTypeName, Class seiClass)
/*     */   {
/* 114 */     ServiceMetaData sm = new ServiceMetaData(um, new QName(targetNamespace, serviceName));
/* 115 */     QName name = new QName(targetNamespace, portTypeName + "Port");
/* 116 */     QName interfaceName = new QName(targetNamespace, portTypeName);
/* 117 */     ToolsEndpointMetaData tm = new ToolsEndpointMetaData(sm, name, interfaceName);
/* 118 */     tm.typeNamespace = this.typeNamespace;
/* 119 */     tm.setServiceEndpointInterfaceName(seiClass.getName());
/* 120 */     tm.setStyle(this.style);
/* 121 */     tm.setParameterStyle(this.parameterStyle);
/*     */ 
/* 123 */     sm.addEndpoint(tm);
/* 124 */     return sm;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.tools.metadata.ToolsUnifiedMetaDataBuilder
 * JD-Core Version:    0.6.0
 */