/*     */ package org.jboss.ws.tools.metadata;
/*     */ 
/*     */ import java.lang.reflect.Array;
/*     */ import java.lang.reflect.Method;
/*     */ import java.rmi.Remote;
/*     */ import java.rmi.RemoteException;
/*     */ import javax.jws.Oneway;
/*     */ import javax.jws.WebMethod;
/*     */ import javax.jws.WebParam;
/*     */ import javax.jws.WebParam.Mode;
/*     */ import javax.jws.WebResult;
/*     */ import javax.jws.soap.SOAPBinding;
/*     */ import javax.jws.soap.SOAPBinding.Style;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.rpc.ParameterMode;
/*     */ import javax.xml.rpc.holders.Holder;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.core.soap.Style;
/*     */ import org.jboss.ws.metadata.umdm.FaultMetaData;
/*     */ import org.jboss.ws.metadata.umdm.OperationMetaData;
/*     */ import org.jboss.ws.metadata.umdm.ParameterMetaData;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLUtils;
/*     */ import org.jboss.ws.tools.ToolsUtils;
/*     */ 
/*     */ public class ToolsAnnotationMetaDataBuilder
/*     */ {
/*  54 */   private ToolsEndpointMetaData tmd = null;
/*  55 */   private String targetNamespace = null;
/*  56 */   private String typeNamespace = null;
/*     */ 
/*  58 */   private Class endpoint = null;
/*     */ 
/*     */   public ToolsAnnotationMetaDataBuilder(ToolsEndpointMetaData tmd, String targetNamespace, String typeNamespace2)
/*     */   {
/*  62 */     this.tmd = tmd;
/*  63 */     this.targetNamespace = targetNamespace;
/*  64 */     this.typeNamespace = this.typeNamespace;
/*  65 */     this.endpoint = tmd.getServiceEndpointInterface();
/*     */   }
/*     */ 
/*     */   public ToolsEndpointMetaData generate()
/*     */   {
/*  70 */     generateOperationMetaData();
/*  71 */     return this.tmd;
/*     */   }
/*     */ 
/*     */   private void generateOperationMetaData()
/*     */   {
/*  78 */     Method[] marr = this.endpoint.getDeclaredMethods();
/*  79 */     if (marr != null)
/*     */     {
/*  81 */       int len = Array.getLength(marr);
/*  82 */       for (int i = 0; i < len; i++)
/*     */       {
/*  84 */         Method m = marr[i];
/*  85 */         if (WSDLUtils.getInstance().checkIgnoreMethod(m))
/*     */           continue;
/*  87 */         this.tmd.addOperation(getOperationMetaData(m, this.tmd));
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private OperationMetaData getOperationMetaData(Method m, ToolsEndpointMetaData em)
/*     */   {
/*  94 */     String opname = null;
/*  95 */     String soapAction = null;
/*     */ 
/*  97 */     WebMethod an = (WebMethod)m.getAnnotation(WebMethod.class);
/*  98 */     if (an != null)
/*     */     {
/* 100 */       opname = an.operationName();
/* 101 */       soapAction = an.action();
/*     */     }
/* 103 */     if ((opname == null) || (opname.length() == 0)) {
/* 104 */       opname = m.getName();
/*     */     }
/* 106 */     OperationMetaData om = new OperationMetaData(em, new QName(this.targetNamespace, opname), m.getName());
/*     */ 
/* 108 */     om.setSOAPAction(soapAction);
/*     */ 
/* 110 */     Style style = Style.RPC;
/*     */ 
/* 112 */     SOAPBinding sb = (SOAPBinding)this.endpoint.getAnnotation(SOAPBinding.class);
/* 113 */     if (sb != null)
/*     */     {
/* 115 */       String wsdlStyle = sb.style().name();
/* 116 */       if ((wsdlStyle != null) && (wsdlStyle.equalsIgnoreCase("DOCUMENT")))
/* 117 */         style = Style.DOCUMENT;
/*     */     }
/* 119 */     em.setStyle(style);
/*     */ 
/* 121 */     Class[] paramTypes = m.getParameterTypes();
/* 122 */     int lenparam = paramTypes != null ? paramTypes.length : 0;
/*     */ 
/* 124 */     for (int j = 0; j < lenparam; j++)
/*     */     {
/* 126 */       Class paramType = paramTypes[j];
/* 127 */       if (Remote.class.isAssignableFrom(paramType)) {
/* 128 */         throw new WSException("OpName:" + opname + " param:" + paramType.getName() + " should not extend Remote");
/*     */       }
/*     */ 
/* 131 */       om.addParameter(getParameterMetaData(paramType, om, j + 1));
/*     */     }
/*     */ 
/* 136 */     Oneway ow = (Oneway)m.getAnnotation(Oneway.class);
/* 137 */     if (ow != null) {
/* 138 */       om.setOneWay(true);
/*     */     }
/* 140 */     Class ret = m.getReturnType();
/* 141 */     ParameterMetaData retPmd = getParameterMetaDataForReturnType(ret, om, 1);
/* 142 */     if (retPmd != null) {
/* 143 */       om.setReturnParameter(retPmd);
/*     */     }
/*     */ 
/* 146 */     Class[] exarr = m.getExceptionTypes();
/* 147 */     if (exarr != null)
/*     */     {
/* 149 */       int len = Array.getLength(exarr);
/* 150 */       int i = 0;
/* 151 */       for (i = 0; i < len; i++)
/*     */       {
/* 153 */         Class exClass = exarr[i];
/* 154 */         if (!RemoteException.class.isAssignableFrom(exClass))
/* 155 */           om.addFault(getFaultMetaData(exClass, om));
/*     */       }
/*     */     }
/* 158 */     return om;
/*     */   }
/*     */ 
/*     */   private ParameterMetaData getParameterMetaData(Class type, OperationMetaData om, int index)
/*     */   {
/* 164 */     WebParam wp = (WebParam)type.getAnnotation(WebParam.class);
/* 165 */     String tns = this.targetNamespace;
/* 166 */     String name = "";
/* 167 */     ParameterMode mode = ParameterMode.IN;
/*     */ 
/* 169 */     if (wp != null)
/*     */     {
/* 171 */       tns = wp.targetNamespace();
/* 172 */       if ((tns == null) || (tns == ""))
/* 173 */         tns = this.targetNamespace;
/* 174 */       name = wp.name() == "" ? type.getName() + "_" + index : type.getName();
/* 175 */       if (wp.mode() == WebParam.Mode.INOUT) {
/* 176 */         mode = ParameterMode.INOUT;
/*     */       }
/* 178 */       else if (wp.mode() == WebParam.Mode.OUT) {
/* 179 */         mode = ParameterMode.OUT;
/*     */       }
/*     */     }
/* 182 */     if ((name == null) || (name.length() == 0)) {
/* 183 */       name = getXMLName(type) + "_" + index;
/*     */     }
/* 185 */     if ((this.typeNamespace != null) && (!this.typeNamespace.equals(tns))) {
/* 186 */       tns = this.typeNamespace;
/*     */     }
/* 188 */     boolean header = wp != null ? wp.header() : false;
/* 189 */     QName xmlType = ToolsUtils.getXMLType(type, tns);
/* 190 */     ParameterMetaData pm = new ParameterMetaData(om, new QName(tns, name), xmlType, type.getName());
/*     */ 
/* 193 */     return pm;
/*     */   }
/*     */ 
/*     */   private ParameterMetaData getParameterMetaDataForReturnType(Class type, OperationMetaData om, int index)
/*     */   {
/* 199 */     if (type == Void.TYPE) {
/* 200 */       return null;
/*     */     }
/* 202 */     if (Remote.class.isAssignableFrom(type)) {
/* 203 */       throw new WSException(om.getJavaName() + " has return type which " + "should not extend java.rmi.Remote");
/*     */     }
/* 205 */     WebResult wr = (WebResult)type.getAnnotation(WebResult.class);
/* 206 */     String tns = this.targetNamespace;
/* 207 */     String name = "result";
/*     */ 
/* 209 */     if (wr != null)
/*     */     {
/* 211 */       tns = wr.targetNamespace();
/* 212 */       if ((tns == null) || (tns == ""))
/* 213 */         tns = this.targetNamespace;
/* 214 */       name = wr.name() == "" ? type.getName() + "_" + index : type.getName();
/*     */     }
/* 219 */     else if (Holder.class.isAssignableFrom(type))
/*     */     {
/* 221 */       type = WSDLUtils.getInstance().getJavaTypeForHolder(type);
/*     */     }
/*     */ 
/* 225 */     if ((this.typeNamespace != null) && (!tns.equals(this.typeNamespace)))
/* 226 */       tns = this.typeNamespace;
/* 227 */     QName xmlType = ToolsUtils.getXMLType(type, tns);
/* 228 */     ParameterMetaData pm = new ParameterMetaData(om, new QName(tns, name), xmlType, type.getName());
/*     */ 
/* 230 */     return pm;
/*     */   }
/*     */ 
/*     */   private FaultMetaData getFaultMetaData(Class exType, OperationMetaData om)
/*     */   {
/* 235 */     WSDLUtils.getInstance(); String exname = WSDLUtils.getJustClassName(exType);
/* 236 */     QName xmlName = new QName(this.typeNamespace, exname);
/*     */ 
/* 238 */     FaultMetaData fm = new FaultMetaData(om, xmlName, xmlName, exType.getName());
/* 239 */     return fm;
/*     */   }
/*     */ 
/*     */   private String getXMLName(Class javaClass)
/*     */   {
/* 244 */     String name = "";
/* 245 */     WSDLUtils utils = WSDLUtils.getInstance();
/* 246 */     if (Holder.class.isAssignableFrom(javaClass))
/* 247 */       javaClass = utils.getJavaTypeForHolder(javaClass);
/* 248 */     if (javaClass.isArray())
/*     */     {
/* 250 */       int len = utils.getArrayDimension(javaClass);
/* 251 */       for (int i = 0; i < len; i++) {
/* 252 */         javaClass = javaClass.getComponentType();
/*     */       }
/* 254 */       name = utils.getMessagePartForArray(javaClass);
/*     */     }
/*     */     else {
/* 257 */       name = WSDLUtils.getJustClassName(javaClass);
/* 258 */     }return name;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.tools.metadata.ToolsAnnotationMetaDataBuilder
 * JD-Core Version:    0.6.0
 */