/*     */ package org.jboss.ws.tools.metadata;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.rmi.Remote;
/*     */ import java.rmi.RemoteException;
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashMap;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.rpc.ParameterMode;
/*     */ import javax.xml.rpc.holders.Holder;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.core.jaxrpc.ParameterWrapping;
/*     */ import org.jboss.ws.core.utils.HolderUtils;
/*     */ import org.jboss.ws.metadata.umdm.FaultMetaData;
/*     */ import org.jboss.ws.metadata.umdm.OperationMetaData;
/*     */ import org.jboss.ws.metadata.umdm.ParameterMetaData;
/*     */ import org.jboss.ws.metadata.umdm.WrappedParameter;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLUtils;
/*     */ import org.jboss.ws.tools.Configuration.OperationConfig;
/*     */ import org.jboss.ws.tools.Configuration.ParameterConfig;
/*     */ import org.jboss.ws.tools.ToolsUtils;
/*     */ import org.jboss.wsf.common.JavaUtils;
/*     */ 
/*     */ public class ReflectiveMetaDataBuilder
/*     */ {
/*  57 */   private Class seiClass = null;
/*     */ 
/*  59 */   private ToolsEndpointMetaData tmd = null;
/*     */ 
/*  61 */   private String targetNamespace = null;
/*     */ 
/*  63 */   private Map<String, List<Configuration.OperationConfig>> operationMap = null;
/*     */ 
/*  65 */   private Map<String, Integer> operationNameCount = new HashMap();
/*     */ 
/*     */   public ReflectiveMetaDataBuilder(ToolsEndpointMetaData tmd)
/*     */   {
/*  69 */     this.seiClass = tmd.getServiceEndpointInterface();
/*  70 */     checkServiceEndpointInterface();
/*  71 */     this.targetNamespace = tmd.getPortName().getNamespaceURI();
/*  72 */     this.tmd = tmd;
/*     */   }
/*     */ 
/*     */   public void setOperationMap(Map<String, List<Configuration.OperationConfig>> operationMap)
/*     */   {
/*  77 */     this.operationMap = operationMap;
/*     */   }
/*     */ 
/*     */   public ToolsEndpointMetaData generate()
/*     */   {
/*  82 */     generateOperationMetaData(this.seiClass.getMethods());
/*  83 */     return this.tmd;
/*     */   }
/*     */ 
/*     */   private void checkServiceEndpointInterface()
/*     */   {
/*  89 */     if (this.seiClass == null)
/*  90 */       throw new IllegalArgumentException("Illegal Null Argument: seiClass");
/*  91 */     if (!this.seiClass.isInterface())
/*  92 */       throw new IllegalArgumentException("Illegal seiClass : not an interface");
/*  93 */     if (!Remote.class.isAssignableFrom(this.seiClass))
/*  94 */       throw new WSException("A service endpoint interface MUST extend java.rmi.Remote: " + this.seiClass.getName());
/*     */   }
/*     */ 
/*     */   private FaultMetaData getFaultMetaData(Class exType, OperationMetaData om)
/*     */   {
/*  99 */     WSDLUtils.getInstance(); String exname = WSDLUtils.getJustClassName(exType);
/* 100 */     QName xmlName = new QName(this.tmd.typeNamespace, exname);
/*     */ 
/* 102 */     FaultMetaData fm = new FaultMetaData(om, xmlName, xmlName, exType.getName());
/* 103 */     return fm;
/*     */   }
/*     */ 
/*     */   private Configuration.OperationConfig getOperationConfig(String name, Class<?>[] types)
/*     */   {
/* 108 */     if (this.operationMap == null) {
/* 109 */       return null;
/*     */     }
/* 111 */     List configs = (List)this.operationMap.get(name);
/* 112 */     if (configs == null) {
/* 113 */       return null;
/*     */     }
/* 115 */     for (Configuration.OperationConfig config : configs)
/*     */     {
/* 117 */       if (config.params.size() == types.length)
/*     */       {
/* 120 */         for (int i = 0; i < types.length; i++)
/*     */         {
/* 122 */           String typeName = ((Configuration.ParameterConfig)config.params.get(i)).javaType;
/* 123 */           if (!JavaUtils.getSourceName(types[i]).equals(typeName)) {
/*     */             break;
/*     */           }
/*     */         }
/* 127 */         if (i == types.length) {
/* 128 */           return config;
/*     */         }
/*     */       }
/*     */     }
/* 132 */     return null;
/*     */   }
/*     */ 
/*     */   private void generateOperationMetaData(Method[] marr)
/*     */   {
/* 137 */     if (marr == null) {
/* 138 */       throw new WSException("Number of methods in the seiClass is zero");
/*     */     }
/* 140 */     for (Method m : marr)
/*     */     {
/* 142 */       String methodname = m.getName();
/* 143 */       Class[] paramTypes = m.getParameterTypes();
/* 144 */       int len = paramTypes.length;
/*     */ 
/* 146 */       OperationMetaData om = getOperationMetaData(m);
/* 147 */       Configuration.OperationConfig opc = getOperationConfig(methodname, m.getParameterTypes());
/* 148 */       if (opc != null) {
/* 149 */         om.setOneWay(opc.isOneWay);
/*     */       }
/* 151 */       ParameterMetaData wrappedParameter = null;
/* 152 */       List wrappedParameters = null;
/*     */ 
/* 154 */       if (om.isDocumentWrapped())
/*     */       {
/* 156 */         QName xmlName = new QName(this.tmd.typeNamespace, om.getQName().getLocalPart());
/* 157 */         QName xmlType = xmlName;
/*     */ 
/* 159 */         wrappedParameter = new ParameterMetaData(om, xmlName, xmlType, null);
/* 160 */         wrappedParameters = new ArrayList(len);
/* 161 */         wrappedParameter.setWrappedParameters(wrappedParameters);
/*     */ 
/* 163 */         om.addParameter(wrappedParameter);
/*     */ 
/* 165 */         if (!om.isOneWay())
/*     */         {
/* 167 */           xmlType = xmlName = new QName(this.tmd.typeNamespace, om.getResponseName().getLocalPart());
/* 168 */           ParameterMetaData retMetaData = new ParameterMetaData(om, xmlName, xmlType, null);
/* 169 */           retMetaData.setWrappedParameters(new ArrayList(0));
/* 170 */           om.setReturnParameter(retMetaData);
/*     */         }
/*     */       }
/*     */ 
/* 174 */       for (int i = 0; i < len; i++)
/*     */       {
/* 176 */         Class paramType = paramTypes[i];
/*     */ 
/* 180 */         if (Remote.class.isAssignableFrom(paramType)) {
/* 181 */           throw new WSException("Param Type " + paramType.getName() + " should not extend java.rmi.Remote");
/*     */         }
/* 183 */         if ((om.isDocumentWrapped()) && (!isHeaderParameter(opc, i)))
/*     */         {
/* 185 */           QName xmlName = getXmlName(paramType, opc, i, null);
/* 186 */           wrappedParameters.add(new WrappedParameter(xmlName, paramType.getName(), convertToProperty(xmlName.getLocalPart()), i));
/*     */         }
/*     */         else
/*     */         {
/* 190 */           om.addParameter(getParameterMetaData(paramType, om, opc, i));
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 195 */       Class returnType = m.getReturnType();
/* 196 */       if (Void.TYPE != returnType)
/*     */       {
/* 198 */         if (Remote.class.isAssignableFrom(returnType)) {
/* 199 */           throw new WSException("Return Type " + returnType.getName() + " should not extend java.rmi.Remote");
/*     */         }
/* 201 */         if (om.isDocumentWrapped())
/*     */         {
/* 203 */           QName name = getReturnXmlName(opc, null);
/*     */ 
/* 205 */           WrappedParameter wrapped = new WrappedParameter(name, returnType.getName(), convertToProperty(name.getLocalPart()), -1);
/* 206 */           ParameterMetaData retMetaData = om.getReturnParameter();
/* 207 */           retMetaData.getWrappedParameters().add(wrapped);
/*     */         }
/*     */         else
/*     */         {
/* 211 */           om.setReturnParameter(getParameterMetaDataForReturnType(returnType, om, opc));
/*     */         }
/*     */       }
/*     */ 
/* 215 */       if (om.isDocumentWrapped())
/*     */       {
/* 217 */         ParameterWrapping.generateWrapper(wrappedParameter, false);
/* 218 */         if (!om.isOneWay()) {
/* 219 */           ParameterWrapping.generateWrapper(om.getReturnParameter(), false);
/*     */         }
/*     */       }
/* 222 */       Class[] exceptionTypes = m.getExceptionTypes();
/* 223 */       boolean remoteExceptionFound = false;
/* 224 */       if (exceptionTypes != null)
/*     */       {
/* 226 */         for (int i = 0; i < exceptionTypes.length; i++)
/*     */         {
/* 228 */           if (RemoteException.class.isAssignableFrom(exceptionTypes[i]))
/* 229 */             remoteExceptionFound = true;
/*     */           else {
/* 231 */             om.addFault(getFaultMetaData(exceptionTypes[i], om));
/*     */           }
/*     */         }
/*     */       }
/* 235 */       if (!remoteExceptionFound) {
/* 236 */         throw new WSException(m.getName() + " does not throw RemoteException.");
/*     */       }
/* 238 */       om.assertDocumentBare();
/* 239 */       this.tmd.addOperation(om);
/*     */     }
/*     */   }
/*     */ 
/*     */   private OperationMetaData getOperationMetaData(Method m)
/*     */   {
/* 245 */     String methodName = m.getName();
/* 246 */     int count = 0;
/* 247 */     if (this.operationNameCount.containsKey(methodName)) {
/* 248 */       count = ((Integer)this.operationNameCount.get(methodName)).intValue();
/*     */     }
/* 250 */     count++; this.operationNameCount.put(methodName, Integer.valueOf(count));
/*     */ 
/* 252 */     String localName = count > 1 ? methodName + count : methodName;
/* 253 */     OperationMetaData om = new OperationMetaData(this.tmd, new QName(this.targetNamespace, localName), methodName);
/* 254 */     om.setSOAPAction("");
/* 255 */     return om;
/*     */   }
/*     */ 
/*     */   private boolean isHeaderParameter(Configuration.OperationConfig config, int index)
/*     */   {
/* 260 */     if (config == null) {
/* 261 */       return false;
/*     */     }
/* 263 */     return ((Configuration.ParameterConfig)config.params.get(index)).header;
/*     */   }
/*     */ 
/*     */   private ParameterMetaData getParameterMetaData(Class type, OperationMetaData om, Configuration.OperationConfig config, int index)
/*     */   {
/* 268 */     QName xmlType = ToolsUtils.getXMLType(type, this.tmd.typeNamespace);
/* 269 */     QName xmlName = getXmlName(type, config, index, om.isDocumentBare() ? om.getQName().getLocalPart() : null);
/* 270 */     ParameterMetaData pm = new ParameterMetaData(om, xmlName, xmlType, type.getName());
/*     */ 
/* 272 */     pm.setInHeader(isHeaderParameter(config, index));
/*     */ 
/* 274 */     String mode = null;
/* 275 */     if (config != null) {
/* 276 */       mode = ((Configuration.ParameterConfig)config.params.get(index)).mode;
/*     */     }
/* 278 */     boolean holder = Holder.class.isAssignableFrom(type);
/*     */ 
/* 280 */     if (holder)
/*     */     {
/* 282 */       pm.setJavaTypeName(HolderUtils.getValueType(type).getName());
/* 283 */       if (mode != null)
/*     */       {
/* 285 */         if (mode.equals("OUT"))
/* 286 */           pm.setMode(ParameterMode.OUT);
/* 287 */         else if (mode.equals("INOUT")) {
/* 288 */           pm.setMode(ParameterMode.INOUT);
/*     */         }
/*     */       }
/*     */       else {
/* 292 */         pm.setMode(ParameterMode.INOUT);
/*     */       }
/*     */     }
/*     */ 
/* 296 */     return pm;
/*     */   }
/*     */ 
/*     */   private QName getXmlName(Class type, Configuration.OperationConfig config, int index, String defaultName)
/*     */   {
/* 301 */     if (config != null)
/*     */     {
/* 303 */       QName name = ((Configuration.ParameterConfig)config.params.get(index)).xmlName;
/* 304 */       if (name != null)
/*     */       {
/* 306 */         if ("".equals(name.getNamespaceURI())) {
/* 307 */           name = new QName(this.tmd.typeNamespace, name.getLocalPart());
/*     */         }
/* 309 */         return name;
/*     */       }
/*     */     }
/*     */ 
/* 313 */     if (defaultName == null) {
/* 314 */       defaultName = getDefaultName(type) + "_" + (index + 1);
/*     */     }
/* 316 */     QName xmlName = new QName(this.tmd.typeNamespace, defaultName);
/* 317 */     return xmlName;
/*     */   }
/*     */ 
/*     */   private QName getReturnXmlName(Configuration.OperationConfig config, String defaultName)
/*     */   {
/* 322 */     if (config != null)
/*     */     {
/* 324 */       QName name = config.returnXmlName;
/* 325 */       if (name != null)
/*     */       {
/* 327 */         if ("".equals(name.getNamespaceURI())) {
/* 328 */           name = new QName(this.tmd.typeNamespace, name.getLocalPart());
/*     */         }
/* 330 */         return name;
/*     */       }
/*     */     }
/*     */ 
/* 334 */     if (defaultName == null) {
/* 335 */       defaultName = "result";
/*     */     }
/* 337 */     return new QName(this.tmd.typeNamespace, defaultName);
/*     */   }
/*     */ 
/*     */   private ParameterMetaData getParameterMetaDataForReturnType(Class type, OperationMetaData om, Configuration.OperationConfig config)
/*     */   {
/* 343 */     QName xmlType = ToolsUtils.getXMLType(type, this.tmd.typeNamespace);
/* 344 */     QName xmlName = getReturnXmlName(config, om.isDocumentBare() ? om.getResponseName().getLocalPart() : null);
/* 345 */     ParameterMetaData pm = new ParameterMetaData(om, xmlName, xmlType, type.getName());
/*     */ 
/* 347 */     return pm;
/*     */   }
/*     */ 
/*     */   private String getDefaultName(Class javaClass)
/*     */   {
/* 352 */     String name = "";
/* 353 */     WSDLUtils utils = WSDLUtils.getInstance();
/* 354 */     if (Holder.class.isAssignableFrom(javaClass))
/* 355 */       javaClass = utils.getJavaTypeForHolder(javaClass);
/* 356 */     if (javaClass.isArray())
/*     */     {
/* 358 */       name = utils.getMessagePartForArray(javaClass);
/*     */     }
/*     */     else
/* 361 */       name = WSDLUtils.getJustClassName(javaClass);
/* 362 */     return name;
/*     */   }
/*     */ 
/*     */   private String convertToProperty(String variable)
/*     */   {
/* 367 */     if (Character.isUpperCase(variable.charAt(0)))
/*     */     {
/* 369 */       char c = Character.toLowerCase(variable.charAt(0));
/* 370 */       StringBuilder builder = new StringBuilder(variable);
/* 371 */       builder.setCharAt(0, c);
/* 372 */       variable = builder.toString();
/*     */     }
/*     */ 
/* 375 */     return variable;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.tools.metadata.ReflectiveMetaDataBuilder
 * JD-Core Version:    0.6.0
 */