/*     */ package org.jboss.ws.tools.jaxws.impl;
/*     */ 
/*     */ import com.sun.tools.ws.wscompile.WsimportTool;
/*     */ import java.io.File;
/*     */ import java.io.PrintStream;
/*     */ import java.net.URL;
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import org.jboss.ws.tools.io.NullPrintStream;
/*     */ import org.jboss.wsf.spi.tools.WSContractConsumer;
/*     */ 
/*     */ public class SunRIConsumerImpl extends WSContractConsumer
/*     */ {
/*     */   private List<File> bindingFiles;
/*     */   private File catalog;
/*     */   private boolean generateSource;
/*  47 */   private File outputDir = new File("output");
/*     */   private File sourceDir;
/*     */   private String targetPackage;
/*     */   private PrintStream messageStream;
/*     */   private String wsdlLocation;
/*  52 */   private List<String> additionalCompilerClassPath = new ArrayList();
/*  53 */   private String target = "2.0";
/*     */ 
/*     */   public void setBindingFiles(List<File> bindingFiles)
/*     */   {
/*  58 */     this.bindingFiles = bindingFiles;
/*     */   }
/*     */ 
/*     */   public void setCatalog(File catalog)
/*     */   {
/*  64 */     this.catalog = catalog;
/*     */   }
/*     */ 
/*     */   public void setGenerateSource(boolean generateSource)
/*     */   {
/*  70 */     this.generateSource = generateSource;
/*     */   }
/*     */ 
/*     */   public void setMessageStream(PrintStream messageStream)
/*     */   {
/*  76 */     this.messageStream = messageStream;
/*     */   }
/*     */ 
/*     */   public void setOutputDirectory(File directory)
/*     */   {
/*  82 */     this.outputDir = directory;
/*     */   }
/*     */ 
/*     */   public void setSourceDirectory(File directory)
/*     */   {
/*  88 */     this.sourceDir = directory;
/*     */   }
/*     */ 
/*     */   public void setTargetPackage(String targetPackage)
/*     */   {
/*  94 */     this.targetPackage = targetPackage;
/*     */   }
/*     */ 
/*     */   public void setWsdlLocation(String wsdlLocation)
/*     */   {
/* 100 */     this.wsdlLocation = wsdlLocation;
/*     */   }
/*     */ 
/*     */   public void setAdditionalCompilerClassPath(List<String> additionalCompilerClassPath)
/*     */   {
/* 105 */     this.additionalCompilerClassPath = additionalCompilerClassPath;
/*     */   }
/*     */ 
/*     */   public void setTarget(String target)
/*     */   {
/* 110 */     this.target = target;
/*     */   }
/*     */ 
/*     */   public void consume(URL wsdl)
/*     */   {
/* 116 */     List args = new ArrayList();
/* 117 */     if (this.bindingFiles != null)
/*     */     {
/* 119 */       for (File file : this.bindingFiles)
/*     */       {
/* 121 */         args.add("-b");
/* 122 */         args.add(file.getAbsolutePath());
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 127 */     if (this.catalog != null)
/*     */     {
/* 129 */       args.add("-catalog");
/* 130 */       args.add(this.catalog.getAbsolutePath());
/*     */     }
/*     */ 
/* 133 */     if (this.generateSource)
/*     */     {
/* 135 */       args.add("-keep");
/* 136 */       if (this.sourceDir != null)
/*     */       {
/* 138 */         if ((!this.sourceDir.exists()) && (!this.sourceDir.mkdirs())) {
/* 139 */           throw new IllegalStateException("Could not make directory: " + this.sourceDir.getName());
/*     */         }
/* 141 */         args.add("-s");
/* 142 */         args.add(this.sourceDir.getAbsolutePath());
/*     */       }
/*     */     }
/*     */ 
/* 146 */     if (this.targetPackage != null)
/*     */     {
/* 148 */       args.add("-p");
/* 149 */       args.add(this.targetPackage);
/*     */     }
/*     */ 
/* 152 */     if (this.wsdlLocation != null)
/*     */     {
/* 154 */       args.add("-wsdllocation");
/* 155 */       args.add(this.wsdlLocation);
/*     */     }
/*     */ 
/* 158 */     PrintStream stream = this.messageStream;
/* 159 */     if (stream != null)
/*     */     {
/* 161 */       args.add("-verbose");
/*     */     }
/*     */     else
/*     */     {
/* 165 */       stream = NullPrintStream.getInstance();
/*     */     }
/*     */ 
/* 168 */     if ((!this.outputDir.exists()) && (!this.outputDir.mkdirs())) {
/* 169 */       throw new IllegalStateException("Could not make directory: " + this.outputDir.getName());
/*     */     }
/*     */ 
/* 172 */     args.add("-d");
/* 173 */     args.add(this.outputDir.getAbsolutePath());
/*     */ 
/* 176 */     if (!this.target.equals("2.0")) {
/* 177 */       throw new IllegalArgumentException("WSConsume (native) only supports JAX-WS 2.0");
/*     */     }
/* 179 */     args.add("-target");
/* 180 */     args.add(this.target);
/*     */ 
/* 183 */     args.add(wsdl.toString());
/*     */ 
/* 186 */     if (!this.additionalCompilerClassPath.isEmpty())
/*     */     {
/* 188 */       StringBuffer javaCP = new StringBuffer();
/* 189 */       for (String s : this.additionalCompilerClassPath)
/*     */       {
/* 191 */         javaCP.append(s).append(File.pathSeparator);
/*     */       }
/* 193 */       System.setProperty("java.class.path", javaCP.toString());
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 199 */       if (null == System.getProperty("javax.xml.stream.XMLInputFactory")) {
/* 200 */         System.setProperty("javax.xml.stream.XMLInputFactory", "com.ctc.wstx.stax.WstxInputFactory");
/*     */       }
/*     */ 
/* 204 */       WsimportTool compileTool = new WsimportTool(stream);
/* 205 */       boolean success = compileTool.run((String[])args.toArray(new String[args.size()]));
/*     */ 
/* 207 */       if (!success)
/* 208 */         throw new IllegalStateException("WsImport invocation failed. Try the verbose switch for more information");
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 212 */       if (this.messageStream != null)
/*     */       {
/* 214 */         this.messageStream.println("Failed to invoke WsImport");
/* 215 */         t.printStackTrace(this.messageStream);
/*     */       }
/*     */       else
/*     */       {
/* 219 */         t.printStackTrace();
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.tools.jaxws.impl.SunRIConsumerImpl
 * JD-Core Version:    0.6.0
 */