/*     */ package org.jboss.ws.tools.jaxws.impl;
/*     */ 
/*     */ import com.sun.codemodel.JAnnotationArrayMember;
/*     */ import com.sun.codemodel.JAnnotationUse;
/*     */ import com.sun.codemodel.JBlock;
/*     */ import com.sun.codemodel.JCodeModel;
/*     */ import com.sun.codemodel.JDefinedClass;
/*     */ import com.sun.codemodel.JExpr;
/*     */ import com.sun.codemodel.JExpression;
/*     */ import com.sun.codemodel.JFieldVar;
/*     */ import com.sun.codemodel.JMethod;
/*     */ import java.io.File;
/*     */ import java.io.IOException;
/*     */ import java.io.PrintStream;
/*     */ import java.util.List;
/*     */ import java.util.Set;
/*     */ import java.util.SortedMap;
/*     */ import javax.xml.bind.annotation.XmlAccessType;
/*     */ import javax.xml.bind.annotation.XmlAccessorType;
/*     */ import javax.xml.bind.annotation.XmlElement;
/*     */ import javax.xml.bind.annotation.XmlRootElement;
/*     */ import javax.xml.bind.annotation.XmlType;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.core.jaxws.AbstractWrapperGenerator;
/*     */ import org.jboss.ws.metadata.umdm.FaultMetaData;
/*     */ import org.jboss.ws.metadata.umdm.OperationMetaData;
/*     */ import org.jboss.ws.metadata.umdm.ParameterMetaData;
/*     */ import org.jboss.ws.metadata.umdm.WrappedParameter;
/*     */ import org.jboss.wsf.common.JavaUtils;
/*     */ 
/*     */ public class SourceWrapperGenerator extends AbstractWrapperGenerator
/*     */   implements WritableWrapperGenerator
/*     */ {
/*  50 */   private static Logger log = Logger.getLogger(SourceWrapperGenerator.class);
/*     */   private PrintStream stream;
/*     */   private JCodeModel codeModel;
/*     */ 
/*     */   public SourceWrapperGenerator(ClassLoader loader, PrintStream stream)
/*     */   {
/*  57 */     super(loader);
/*  58 */     this.stream = stream;
/*  59 */     this.codeModel = new JCodeModel();
/*     */   }
/*     */ 
/*     */   public void reset(ClassLoader loader)
/*     */   {
/*  65 */     super.reset(loader);
/*  66 */     this.codeModel = new JCodeModel();
/*     */   }
/*     */ 
/*     */   public void write(File directory) throws IOException
/*     */   {
/*  71 */     this.stream.println("Writing Source:");
/*  72 */     this.codeModel.build(directory, this.stream);
/*     */   }
/*     */ 
/*     */   public void generate(ParameterMetaData pmd)
/*     */   {
/*  77 */     List wrappedParameters = pmd.getWrappedParameters();
/*  78 */     OperationMetaData operationMetaData = pmd.getOperationMetaData();
/*     */ 
/*  80 */     if (!operationMetaData.isDocumentWrapped()) {
/*  81 */       throw new WSException("Operation is not document/literal (wrapped)");
/*     */     }
/*  83 */     if (wrappedParameters == null) {
/*  84 */       throw new WSException("Cannot generate a type when their is no type information");
/*     */     }
/*  86 */     String wrapperName = pmd.getJavaTypeName();
/*  87 */     if ((log.isDebugEnabled()) && 
/*  88 */       (log.isDebugEnabled())) log.debug("Generating wrapper: " + wrapperName);
/*     */ 
/*     */     try
/*     */     {
/*  93 */       clazz = this.codeModel._class(wrapperName);
/*  94 */       addClassAnnotations(clazz, pmd.getXmlName(), pmd.getXmlType(), null);
/*  95 */       for (WrappedParameter wrapped : wrappedParameters)
/*     */       {
/*  97 */         addProperty(clazz, wrapped.getType(), wrapped.getName(), wrapped.getVariable());
/*     */       }
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*     */       JDefinedClass clazz;
/* 102 */       throw new WSException("Could not generate wrapper type: " + wrapperName, e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void generate(FaultMetaData fmd) {
/* 107 */     String faultBeanName = fmd.getFaultBeanName();
/* 108 */     Class exception = fmd.getJavaType();
/*     */     try
/*     */     {
/* 112 */       SortedMap properties = getExceptionProperties(exception);
/* 113 */       String[] propertyOrder = (String[])properties.keySet().toArray(new String[0]);
/*     */ 
/* 115 */       JDefinedClass clazz = this.codeModel._class(faultBeanName);
/* 116 */       addClassAnnotations(clazz, fmd.getXmlName(), fmd.getXmlType(), propertyOrder);
/*     */ 
/* 118 */       for (String property : propertyOrder)
/* 119 */         addProperty(clazz, ((Class)properties.get(property)).getName(), new QName(property), property);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 123 */       throw new WSException("Could not generate wrapper type: " + faultBeanName, e);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static String getterPrefix(Class type)
/*     */   {
/* 129 */     return (Boolean.TYPE == type) || (Boolean.class == type) ? "is" : "get";
/*     */   }
/*     */ 
/*     */   private void addProperty(JDefinedClass clazz, String typeName, QName name, String variable)
/*     */     throws ClassNotFoundException
/*     */   {
/* 135 */     Class type = JavaUtils.loadJavaType(typeName, this.loader);
/* 136 */     JFieldVar field = clazz.field(4, type, variable);
/* 137 */     JAnnotationUse annotation = field.annotate(XmlElement.class);
/* 138 */     if (name.getNamespaceURI() != null)
/* 139 */       annotation.param("namespace", name.getNamespaceURI());
/* 140 */     annotation.param("name", name.getLocalPart());
/*     */ 
/* 143 */     JMethod method = clazz.method(1, type, getterPrefix(type) + JavaUtils.capitalize(variable));
/* 144 */     method.body()._return(JExpr._this().ref(variable));
/*     */ 
/* 146 */     method = clazz.method(1, Void.TYPE, "set" + JavaUtils.capitalize(variable));
/* 147 */     method.body().assign(JExpr._this().ref(variable), method.param(type, variable));
/*     */   }
/*     */ 
/*     */   private static void addClassAnnotations(JDefinedClass clazz, QName xmlName, QName xmlType, String[] propertyOrder)
/*     */   {
/* 152 */     JAnnotationUse annotation = clazz.annotate(XmlRootElement.class);
/* 153 */     if ((xmlName.getNamespaceURI() != null) && (xmlName.getNamespaceURI().length() > 0))
/* 154 */       annotation.param("namespace", xmlName.getNamespaceURI());
/* 155 */     annotation.param("name", xmlName.getLocalPart());
/*     */ 
/* 157 */     annotation = clazz.annotate(XmlType.class);
/* 158 */     if (((xmlType.getNamespaceURI() != null ? 1 : 0) & (xmlType.getNamespaceURI().length() > 0 ? 1 : 0)) != 0)
/* 159 */       annotation.param("namespace", xmlType.getNamespaceURI());
/* 160 */     annotation.param("name", xmlType.getLocalPart());
/* 161 */     if (propertyOrder != null)
/*     */     {
/* 163 */       JAnnotationArrayMember paramArray = annotation.paramArray("propOrder");
/* 164 */       for (String property : propertyOrder) {
/* 165 */         paramArray.param(property);
/*     */       }
/*     */     }
/* 168 */     annotation = clazz.annotate(XmlAccessorType.class);
/* 169 */     annotation.param("value", XmlAccessType.FIELD);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.tools.jaxws.impl.SourceWrapperGenerator
 * JD-Core Version:    0.6.0
 */