/*     */ package org.jboss.ws.tools.jaxws.impl;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.IOException;
/*     */ import java.io.PrintStream;
/*     */ import java.net.URL;
/*     */ import java.net.URLClassLoader;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.metadata.builder.jaxws.JAXWSWebServiceMetaDataBuilder;
/*     */ import org.jboss.ws.metadata.umdm.UnifiedMetaData;
/*     */ import org.jboss.ws.tools.io.NullPrintStream;
/*     */ import org.jboss.wsf.common.ResourceLoaderAdapter;
/*     */ import org.jboss.wsf.spi.SPIProvider;
/*     */ import org.jboss.wsf.spi.SPIProviderResolver;
/*     */ import org.jboss.wsf.spi.deployment.Deployment;
/*     */ import org.jboss.wsf.spi.deployment.DeploymentModelFactory;
/*     */ import org.jboss.wsf.spi.tools.WSContractProvider;
/*     */ 
/*     */ final class JBossWSProviderImpl extends WSContractProvider
/*     */ {
/*     */   private ClassLoader loader;
/*  49 */   private boolean generateWsdl = false;
/*  50 */   private boolean generateSource = false;
/*  51 */   private File outputDir = new File("output");
/*  52 */   private File resourceDir = null;
/*  53 */   private File sourceDir = null;
/*  54 */   private PrintStream messageStream = NullPrintStream.getInstance();
/*     */ 
/*     */   private void createDirectories(File resourceDir, File sourceDir)
/*     */   {
/*  58 */     if ((!this.outputDir.exists()) && 
/*  59 */       (!this.outputDir.mkdirs())) {
/*  60 */       throw new WSException("Could not create directory: " + this.outputDir);
/*     */     }
/*  62 */     if ((this.generateWsdl) && (!resourceDir.exists()) && 
/*  63 */       (!resourceDir.mkdirs())) {
/*  64 */       throw new WSException("Could not create directory: " + resourceDir);
/*     */     }
/*  66 */     if ((this.generateSource) && (!sourceDir.exists()) && 
/*  67 */       (!sourceDir.mkdirs()))
/*  68 */       throw new WSException("Could not create directory: " + sourceDir);
/*     */   }
/*     */ 
/*     */   public void provide(Class<?> endpointClass)
/*     */   {
/*  75 */     File resourceDir = this.resourceDir != null ? this.resourceDir : this.outputDir;
/*  76 */     File sourceDir = this.sourceDir != null ? this.sourceDir : this.outputDir;
/*     */ 
/*  78 */     createDirectories(resourceDir, sourceDir);
/*     */ 
/*  80 */     this.messageStream.println("Output directory: " + this.outputDir.getAbsolutePath());
/*  81 */     this.messageStream.println("Source directory: " + sourceDir.getAbsolutePath());
/*     */ 
/*  84 */     ClassLoader loader = new URLClassLoader(new URL[0], this.loader);
/*  85 */     UnifiedMetaData umd = new UnifiedMetaData(new ResourceLoaderAdapter(loader));
/*  86 */     umd.setClassLoader(loader);
/*     */ 
/*  88 */     ChainedWritableWrapperGenerator generator = new ChainedWritableWrapperGenerator();
/*  89 */     if (this.generateSource)
/*  90 */       generator.add(new SourceWrapperGenerator(loader, this.messageStream), sourceDir);
/*  91 */     generator.add(new BytecodeWrapperGenerator(loader, this.messageStream), this.outputDir);
/*     */ 
/*  93 */     JAXWSWebServiceMetaDataBuilder builder = new JAXWSWebServiceMetaDataBuilder();
/*  94 */     builder.setWrapperGenerator(generator);
/*  95 */     builder.setGenerateWsdl(this.generateWsdl);
/*  96 */     builder.setToolMode(true);
/*  97 */     builder.setWsdlDirectory(resourceDir);
/*  98 */     builder.setMessageStream(this.messageStream);
/*     */ 
/* 100 */     if (this.generateWsdl) {
/* 101 */       this.messageStream.println("Generating WSDL:");
/*     */     }
/* 103 */     SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
/* 104 */     DeploymentModelFactory factory = (DeploymentModelFactory)spiProvider.getSPI(DeploymentModelFactory.class);
/* 105 */     Deployment dep = factory.newDeployment("wsprovide-deployment", loader);
/* 106 */     dep.setRuntimeClassLoader(loader);
/*     */ 
/* 108 */     builder.buildWebServiceMetaData(dep, umd, endpointClass, null);
/*     */     try
/*     */     {
/* 111 */       generator.write();
/*     */     }
/*     */     catch (IOException io)
/*     */     {
/* 115 */       throw new WSException("Could not write output files:", io);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void provide(String endpointClass)
/*     */   {
/*     */     try
/*     */     {
/* 124 */       provide(this.loader.loadClass(endpointClass));
/*     */     }
/*     */     catch (ClassNotFoundException e)
/*     */     {
/* 128 */       throw new WSException("Class not found: " + endpointClass);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setClassLoader(ClassLoader loader)
/*     */   {
/* 135 */     this.loader = loader;
/*     */   }
/*     */ 
/*     */   public void setGenerateWsdl(boolean generateWsdl)
/*     */   {
/* 141 */     this.generateWsdl = generateWsdl;
/*     */   }
/*     */ 
/*     */   public void setOutputDirectory(File directory)
/*     */   {
/* 147 */     this.outputDir = directory;
/*     */   }
/*     */ 
/*     */   public void setGenerateSource(boolean generateSource)
/*     */   {
/* 153 */     this.generateSource = generateSource;
/*     */   }
/*     */ 
/*     */   public void setResourceDirectory(File directory)
/*     */   {
/* 159 */     this.resourceDir = directory;
/*     */   }
/*     */ 
/*     */   public void setSourceDirectory(File directory)
/*     */   {
/* 165 */     this.sourceDir = directory;
/*     */   }
/*     */ 
/*     */   public void setMessageStream(PrintStream messageStream)
/*     */   {
/* 171 */     this.messageStream = messageStream;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.tools.jaxws.impl.JBossWSProviderImpl
 * JD-Core Version:    0.6.0
 */