/*    */ package org.jboss.ws.tools.jaxws.impl;
/*    */ 
/*    */ import java.io.File;
/*    */ import java.io.IOException;
/*    */ import java.util.ArrayList;
/*    */ import java.util.List;
/*    */ import org.jboss.ws.core.jaxws.WrapperGenerator;
/*    */ import org.jboss.ws.metadata.umdm.FaultMetaData;
/*    */ import org.jboss.ws.metadata.umdm.ParameterMetaData;
/*    */ 
/*    */ public class ChainedWritableWrapperGenerator
/*    */   implements WrapperGenerator
/*    */ {
/* 35 */   private List<Entry> chain = new ArrayList();
/*    */ 
/*    */   public void reset(ClassLoader loader)
/*    */   {
/* 55 */     for (Entry entry : this.chain)
/* 56 */       entry.generator.reset(loader);
/*    */   }
/*    */ 
/*    */   public void write() throws IOException
/*    */   {
/* 61 */     for (Entry entry : this.chain)
/* 62 */       entry.generator.write(entry.directory);
/*    */   }
/*    */ 
/*    */   public void generate(FaultMetaData fmd)
/*    */   {
/* 67 */     for (Entry entry : this.chain)
/* 68 */       entry.generator.generate(fmd);
/*    */   }
/*    */ 
/*    */   public void generate(ParameterMetaData pmd)
/*    */   {
/* 73 */     for (Entry entry : this.chain)
/* 74 */       entry.generator.generate(pmd);
/*    */   }
/*    */ 
/*    */   public void add(WritableWrapperGenerator generator, File directory)
/*    */   {
/* 79 */     this.chain.add(new Entry(generator, directory));
/*    */   }
/*    */ 
/*    */   static class Entry
/*    */   {
/*    */     WritableWrapperGenerator generator;
/*    */     File directory;
/*    */ 
/*    */     Entry(WritableWrapperGenerator generator, File directory)
/*    */     {
/* 41 */       this.generator = generator;
/* 42 */       this.directory = directory;
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.tools.jaxws.impl.ChainedWritableWrapperGenerator
 * JD-Core Version:    0.6.0
 */