/*    */ package org.jboss.ws.tools.jaxws.impl;
/*    */ 
/*    */ import java.io.File;
/*    */ import java.io.IOException;
/*    */ import java.io.PrintStream;
/*    */ import java.util.ArrayList;
/*    */ import java.util.List;
/*    */ import javassist.CannotCompileException;
/*    */ import javassist.ClassPool;
/*    */ import javassist.CtClass;
/*    */ import javassist.NotFoundException;
/*    */ import org.jboss.ws.WSException;
/*    */ import org.jboss.ws.core.jaxws.DynamicWrapperGenerator;
/*    */ import org.jboss.ws.metadata.umdm.FaultMetaData;
/*    */ import org.jboss.ws.metadata.umdm.ParameterMetaData;
/*    */ 
/*    */ public class BytecodeWrapperGenerator extends DynamicWrapperGenerator
/*    */   implements WritableWrapperGenerator
/*    */ {
/* 39 */   private List<String> typeNames = new ArrayList();
/*    */   PrintStream stream;
/*    */ 
/*    */   public BytecodeWrapperGenerator(ClassLoader loader, PrintStream stream)
/*    */   {
/* 44 */     super(loader);
/* 45 */     this.stream = stream;
/* 46 */     this.prune = false;
/*    */   }
/*    */ 
/*    */   public void reset(ClassLoader loader)
/*    */   {
/* 52 */     super.reset(loader);
/* 53 */     this.typeNames.clear();
/*    */   }
/*    */ 
/*    */   public void generate(FaultMetaData fmd)
/*    */   {
/* 59 */     super.generate(fmd);
/*    */ 
/* 61 */     this.typeNames.add(fmd.getFaultBeanName());
/*    */   }
/*    */ 
/*    */   public void generate(ParameterMetaData pmd)
/*    */   {
/* 67 */     super.generate(pmd);
/*    */ 
/* 69 */     this.typeNames.add(pmd.getJavaTypeName());
/*    */   }
/*    */ 
/*    */   public void write(File directory)
/*    */     throws IOException
/*    */   {
/* 75 */     if (this.typeNames.isEmpty())
/*    */     {
/* 77 */       System.out.println("No Classes to generate...");
/* 78 */       return;
/*    */     }
/*    */ 
/* 81 */     this.stream.println("Writing Classes:");
/* 82 */     for (String name : this.typeNames)
/*    */     {
/*    */       try
/*    */       {
/* 86 */         this.stream.println(name.replace('.', '/') + ".class");
/* 87 */         this.pool.get(name).writeFile(directory.getAbsolutePath());
/*    */       }
/*    */       catch (CannotCompileException e)
/*    */       {
/* 91 */         throw new WSException(e);
/*    */       }
/*    */       catch (NotFoundException e)
/*    */       {
/* 95 */         throw new WSException(e);
/*    */       }
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.tools.jaxws.impl.BytecodeWrapperGenerator
 * JD-Core Version:    0.6.0
 */