/*     */ package org.jboss.ws.tools.helpers;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.IOException;
/*     */ import java.io.Writer;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URL;
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import javax.jws.soap.SOAPBinding.ParameterStyle;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.core.jaxrpc.LiteralTypeMapping;
/*     */ import org.jboss.ws.core.soap.Style;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMapping;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.JavaXmlTypeMapping;
/*     */ import org.jboss.ws.metadata.umdm.EndpointMetaData;
/*     */ import org.jboss.ws.metadata.umdm.OperationMetaData;
/*     */ import org.jboss.ws.metadata.umdm.ParameterMetaData;
/*     */ import org.jboss.ws.metadata.umdm.ServiceMetaData;
/*     */ import org.jboss.ws.metadata.umdm.UnifiedMetaData;
/*     */ import org.jboss.ws.metadata.umdm.WrappedParameter;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLEndpoint;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLService;
/*     */ import org.jboss.ws.tools.Configuration;
/*     */ import org.jboss.ws.tools.Configuration.GlobalConfig;
/*     */ import org.jboss.ws.tools.Configuration.JavaToWSDLConfig;
/*     */ import org.jboss.ws.tools.Configuration.WSDLToJavaConfig;
/*     */ import org.jboss.ws.tools.JavaToWSDL;
/*     */ import org.jboss.ws.tools.JavaWriter;
/*     */ import org.jboss.ws.tools.NamespacePackageMapping;
/*     */ import org.jboss.ws.tools.WSDLToJava;
/*     */ import org.jboss.ws.tools.WebservicesXMLCreatorImpl;
/*     */ import org.jboss.ws.tools.XSDTypeToJava.VAR;
/*     */ import org.jboss.ws.tools.client.ServiceCreator;
/*     */ import org.jboss.ws.tools.interfaces.WebservicesXMLCreator;
/*     */ import org.jboss.ws.tools.mapping.MappingFileGenerator;
/*     */ import org.jboss.ws.tools.wsdl.WSDLWriter;
/*     */ import org.jboss.wsf.common.DOMUtils;
/*     */ import org.jboss.wsf.common.DOMWriter;
/*     */ import org.jboss.wsf.common.IOUtils;
/*     */ import org.jboss.wsf.common.JavaUtils;
/*     */ 
/*     */ public class ToolsHelper
/*     */ {
/*  79 */   private static Logger log = Logger.getLogger(ToolsHelper.class);
/*     */ 
/*     */   public void handleJavaToWSDLGeneration(Configuration config, String outDir)
/*     */     throws IOException
/*     */   {
/*  90 */     Configuration.JavaToWSDLConfig j2wc = config.getJavaToWSDLConfig(false);
/*  91 */     JavaToWSDL jwsdl = new JavaToWSDL("http://schemas.xmlsoap.org/wsdl/");
/*  92 */     jwsdl.setServiceName(j2wc.serviceName);
/*  93 */     jwsdl.setTargetNamespace(j2wc.targetNamespace);
/*  94 */     jwsdl.setTypeNamespace(j2wc.typeNamespace);
/*  95 */     jwsdl.setOperationMap(j2wc.operations);
/*     */ 
/*  97 */     if ("document".equals(j2wc.wsdlStyle))
/*  98 */       jwsdl.setStyle(Style.DOCUMENT);
/*  99 */     else if ("rpc".equals(j2wc.wsdlStyle))
/* 100 */       jwsdl.setStyle(Style.RPC);
/* 101 */     else throw new WSException("Unrecognized Style:" + j2wc.wsdlStyle);
/*     */ 
/* 103 */     if ("wrapped".equals(j2wc.parameterStyle))
/* 104 */       jwsdl.setParameterStyle(SOAPBinding.ParameterStyle.WRAPPED);
/* 105 */     else if ("bare".equals(j2wc.parameterStyle))
/* 106 */       jwsdl.setParameterStyle(SOAPBinding.ParameterStyle.BARE);
/* 107 */     else throw new WSException("Unrecognized Parameter Style:" + j2wc.parameterStyle);
/*     */ 
/* 109 */     Class endpointClass = loadClass(j2wc.endpointName);
/*     */ 
/* 111 */     if (endpointClass == null) {
/* 112 */       throw new WSException("Endpoint " + j2wc.endpointName + " cannot be loaded");
/*     */     }
/*     */ 
/* 115 */     Configuration.GlobalConfig gcfg = config.getGlobalConfig(false);
/* 116 */     if (gcfg != null)
/*     */     {
/* 118 */       if (gcfg.packageNamespaceMap != null)
/* 119 */         jwsdl.setPackageNamespaceMap(gcfg.packageNamespaceMap);
/*     */     }
/* 121 */     WSDLDefinitions wsdl = jwsdl.generate(endpointClass);
/*     */ 
/* 123 */     createDir(outDir + "/wsdl");
/* 124 */     String wsdlPath = outDir + "/wsdl/" + j2wc.serviceName + ".wsdl";
/*     */ 
/* 126 */     Writer fw = IOUtils.getCharsetFileWriter(new File(wsdlPath), "UTF-8");
/* 127 */     new WSDLWriter(wsdl).write(fw, "UTF-8");
/* 128 */     fw.close();
/*     */ 
/* 131 */     if (j2wc.mappingFileNeeded)
/*     */     {
/* 133 */       UnifiedMetaData unifiedMetaData = jwsdl.getUnifiedMetaData();
/* 134 */       JavaWsdlMapping mapping = jwsdl.getJavaWsdlMapping();
/*     */ 
/* 136 */       createWrapperTypes(j2wc, outDir, unifiedMetaData, mapping, endpointClass);
/* 137 */       Writer writer = IOUtils.getCharsetFileWriter(new File(outDir + "/" + j2wc.mappingFileName), "UTF-8");
/* 138 */       writer.write("<?xml version='1.0' encoding='UTF-8'?>");
/* 139 */       writer.write(DOMWriter.printNode(DOMUtils.parse(mapping.serialize()), true));
/* 140 */       writer.close();
/*     */     }
/*     */ 
/* 144 */     if (j2wc.wsxmlFileNeeded)
/*     */     {
/* 146 */       WebservicesXMLCreator wscr = new WebservicesXMLCreatorImpl();
/* 147 */       wscr.setTargetNamespace(j2wc.targetNamespace);
/*     */ 
/* 149 */       wscr.setSeiName(j2wc.endpointName);
/* 150 */       wscr.setServiceName(j2wc.serviceName);
/*     */ 
/* 152 */       WSDLService wsdlService = wsdl.getService(j2wc.serviceName);
/* 153 */       String portName = wsdlService.getEndpoints()[0].getName().getLocalPart();
/*     */ 
/* 155 */       wscr.setPortName(portName);
/*     */ 
/* 157 */       if (j2wc.servletLink != null)
/*     */       {
/* 159 */         wscr.setMappingFile("WEB-INF/" + j2wc.mappingFileName);
/* 160 */         wscr.setWsdlFile("WEB-INF/wsdl/" + j2wc.serviceName + ".wsdl");
/* 161 */         wscr.setServletLink(j2wc.servletLink);
/*     */       }
/*     */       else
/*     */       {
/* 165 */         wscr.setMappingFile("META-INF/" + j2wc.mappingFileName);
/* 166 */         wscr.setWsdlFile("META-INF/wsdl/" + j2wc.serviceName + ".wsdl");
/* 167 */         wscr.setEjbLink(j2wc.ejbLink);
/*     */       }
/* 169 */       wscr.setAppend(j2wc.wsxmlFileAppend);
/* 170 */       wscr.generateWSXMLDescriptor(new File(outDir + "/webservices.xml"));
/*     */     }
/*     */   }
/*     */ 
/*     */   private void createWrapperTypes(Configuration.JavaToWSDLConfig j2wc, String outDir, UnifiedMetaData wsMetaData, JavaWsdlMapping mapping, Class endpointClass) throws IOException
/*     */   {
/* 176 */     Map index = indexMappingTypes(mapping);
/*     */ 
/* 178 */     EndpointMetaData epMetaData = null;
/* 179 */     for (ServiceMetaData service : wsMetaData.getServices())
/*     */     {
/* 181 */       epMetaData = service.getEndpointByServiceEndpointInterface(j2wc.endpointName);
/* 182 */       if (epMetaData != null) {
/*     */         break;
/*     */       }
/*     */     }
/* 186 */     if (epMetaData == null) {
/* 187 */       throw new WSException("Could not find endpoint in metadata: " + j2wc.endpointName);
/*     */     }
/* 189 */     String packageName = endpointClass.getPackage().getName();
/* 190 */     ClassLoader classLoader = wsMetaData.getClassLoader();
/*     */ 
/* 192 */     for (OperationMetaData opMetaData : epMetaData.getOperations())
/*     */     {
/* 194 */       if (opMetaData.isDocumentWrapped())
/*     */       {
/* 196 */         for (ParameterMetaData parameter : opMetaData.getParameters())
/*     */         {
/* 198 */           String name = endpointClass.getSimpleName() + "_" + opMetaData.getQName().getLocalPart() + "_RequestStruct";
/* 199 */           createWrapperType(parameter, name, packageName, index, classLoader, outDir);
/*     */         }
/*     */ 
/* 202 */         ParameterMetaData returnParameter = opMetaData.getReturnParameter();
/* 203 */         if (returnParameter != null)
/*     */         {
/* 205 */           String name = endpointClass.getSimpleName() + "_" + opMetaData.getQName().getLocalPart() + "_ResponseStruct";
/* 206 */           createWrapperType(returnParameter, name, packageName, index, classLoader, outDir);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void createWrapperType(ParameterMetaData parameter, String name, String packageName, Map<QName, JavaXmlTypeMapping> mappingIndex, ClassLoader classLoader, String outDir)
/*     */     throws IOException
/*     */   {
/* 215 */     List wrappedParameters = parameter.getWrappedParameters();
/*     */ 
/* 217 */     if (wrappedParameters == null) {
/* 218 */       return;
/*     */     }
/* 220 */     List vars = new ArrayList();
/* 221 */     for (WrappedParameter wrapped : wrappedParameters)
/*     */     {
/* 223 */       String typeName = JavaUtils.convertJVMNameToSourceName(wrapped.getType(), classLoader);
/* 224 */       vars.add(new XSDTypeToJava.VAR(wrapped.getVariable(), typeName, false));
/*     */     }
/*     */ 
/* 227 */     JavaWriter writer = new JavaWriter();
/* 228 */     writer.createJavaFile(new File(outDir), name + ".java", packageName, vars, null, null, false, null);
/*     */ 
/* 230 */     JavaXmlTypeMapping type = (JavaXmlTypeMapping)mappingIndex.get(parameter.getXmlType());
/* 231 */     if (type == null) {
/* 232 */       throw new WSException("JAX-RPC mapping metadata is missing a wrapper type: " + parameter.getXmlType());
/*     */     }
/* 234 */     type.setJavaType(packageName + "." + name);
/*     */   }
/*     */ 
/*     */   private Map<QName, JavaXmlTypeMapping> indexMappingTypes(JavaWsdlMapping mapping)
/*     */   {
/* 239 */     Map index = new HashMap();
/* 240 */     for (JavaXmlTypeMapping type : mapping.getJavaXmlTypeMappings())
/*     */     {
/* 242 */       QName qname = type.getRootTypeQName();
/* 243 */       if (qname == null) {
/*     */         continue;
/*     */       }
/* 246 */       index.put(qname, type);
/*     */     }
/*     */ 
/* 249 */     return index;
/*     */   }
/*     */ 
/*     */   public void handleWSDLToJavaGeneration(Configuration config, String outDir)
/*     */   {
/* 260 */     Configuration.WSDLToJavaConfig w2jc = config.getWSDLToJavaConfig(false);
/* 261 */     Configuration.GlobalConfig glc = config.getGlobalConfig(false);
/*     */ 
/* 263 */     WSDLToJava wsdlToJava = new WSDLToJava();
/* 264 */     wsdlToJava.setTypeMapping(new LiteralTypeMapping());
/*     */ 
/* 266 */     WSDLDefinitions wsdl = null;
/*     */     try
/*     */     {
/* 269 */       URL wsdlURL = null;
/*     */       try
/*     */       {
/* 272 */         wsdlURL = new URL(w2jc.wsdlLocation);
/*     */       }
/*     */       catch (MalformedURLException e)
/*     */       {
/*     */       }
/*     */ 
/* 279 */       if (wsdlURL == null)
/*     */       {
/* 281 */         File wsdlFile = new File(w2jc.wsdlLocation);
/* 282 */         if (wsdlFile.exists())
/*     */         {
/* 284 */           wsdlURL = wsdlFile.toURL();
/*     */         }
/*     */       }
/*     */ 
/* 288 */       if (wsdlURL == null)
/*     */       {
/* 290 */         ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
/* 291 */         wsdlURL = ctxLoader.getResource(w2jc.wsdlLocation);
/*     */       }
/*     */ 
/* 294 */       if (wsdlURL == null) {
/* 295 */         throw new IllegalArgumentException("Cannot load wsdl: " + w2jc.wsdlLocation);
/*     */       }
/* 297 */       wsdl = wsdlToJava.convertWSDL2Java(wsdlURL);
/* 298 */       if (glc != null) {
/* 299 */         wsdlToJava.setNamespacePackageMap(glc.packageNamespaceMap);
/*     */       }
/* 301 */       wsdlToJava.setParameterStyle(w2jc.parameterStyle);
/* 302 */       wsdlToJava.generateSEI(wsdl, new File(outDir));
/*     */ 
/* 305 */       generateServiceFile(getPackageName(wsdl, glc), wsdl, outDir);
/*     */ 
/* 308 */       if (w2jc.mappingFileNeeded)
/*     */       {
/* 310 */         MappingFileGenerator mgf = new MappingFileGenerator(wsdl, new LiteralTypeMapping());
/* 311 */         mgf.setPackageName(getPackageName(wsdl, glc));
/* 312 */         mgf.setServiceName(wsdl.getServices()[0].getName().getLocalPart());
/* 313 */         mgf.setParameterStyle(w2jc.parameterStyle);
/*     */ 
/* 315 */         JavaWsdlMapping jwm = mgf.generate();
/* 316 */         Writer writer = IOUtils.getCharsetFileWriter(new File(outDir + "/" + w2jc.mappingFileName), "UTF-8");
/* 317 */         writer.write("<?xml version='1.0' encoding='UTF-8'?>");
/* 318 */         writer.write(DOMWriter.printNode(DOMUtils.parse(jwm.serialize()), true));
/* 319 */         writer.close();
/*     */       }
/*     */ 
/* 323 */       if (w2jc.wsxmlFileNeeded)
/*     */       {
/* 325 */         String seiName = "mypackage.MyServiceEndpointInterface";
/* 326 */         String serviceName = "MyServiceName";
/*     */ 
/* 328 */         if (wsdl.getServices().length == 1) {
/* 329 */           serviceName = wsdl.getServices()[0].getName().getLocalPart();
/*     */         }
/* 331 */         if (wsdl.getInterfaces().length == 1)
/*     */         {
/* 333 */           String seiPackage = getPackageName(wsdl, glc);
/* 334 */           seiName = seiPackage + "." + wsdlToJava.getServiceEndpointInterfaceName(wsdl.getInterfaces()[0]);
/*     */         }
/*     */ 
/* 337 */         WebservicesXMLCreator wscr = new WebservicesXMLCreatorImpl();
/* 338 */         wscr.setTargetNamespace(wsdl.getTargetNamespace());
/* 339 */         wscr.setSeiName(seiName);
/* 340 */         wscr.setServiceName(serviceName);
/* 341 */         WSDLService wsdlService = wsdl.getService(serviceName);
/* 342 */         String portName = wsdlService.getEndpoints()[0].getName().getLocalPart();
/* 343 */         wscr.setPortName(portName);
/*     */ 
/* 345 */         String wsdlShortName = wsdlURL.getPath();
/* 346 */         wsdlShortName = wsdlShortName.substring(wsdlShortName.lastIndexOf("/"));
/*     */ 
/* 348 */         if (w2jc.servletLink != null)
/*     */         {
/* 350 */           wscr.setMappingFile("WEB-INF/" + w2jc.mappingFileName);
/* 351 */           wscr.setWsdlFile("WEB-INF/wsdl" + wsdlShortName);
/* 352 */           wscr.setServletLink(w2jc.servletLink);
/*     */         }
/*     */         else
/*     */         {
/* 356 */           wscr.setMappingFile("META-INF/" + w2jc.mappingFileName);
/* 357 */           wscr.setWsdlFile("META-INF/wsdl" + wsdlShortName);
/* 358 */           wscr.setEjbLink(w2jc.ejbLink);
/*     */         }
/* 360 */         wscr.generateWSXMLDescriptor(new File(outDir + "/webservices.xml"));
/*     */       }
/*     */     }
/*     */     catch (RuntimeException rte)
/*     */     {
/* 365 */       throw rte;
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 369 */       throw new WSException(ex);
/*     */     }
/*     */   }
/*     */ 
/*     */   private Class loadClass(String cls)
/*     */   {
/* 376 */     Class clazz = null;
/*     */     try
/*     */     {
/* 379 */       clazz = Thread.currentThread().getContextClassLoader().loadClass(cls);
/*     */     }
/*     */     catch (ClassNotFoundException e)
/*     */     {
/* 383 */       log.error("Cannot load endpoint:" + e.getLocalizedMessage());
/*     */     }
/* 385 */     return clazz;
/*     */   }
/*     */ 
/*     */   private void generateServiceFile(String packageName, WSDLDefinitions wsdl, String location) throws IOException
/*     */   {
/* 390 */     ServiceCreator sc = new ServiceCreator();
/* 391 */     sc.setPackageName(packageName);
/* 392 */     sc.setDirLocation(new File(location));
/* 393 */     sc.setWsdl(wsdl);
/* 394 */     sc.createServiceDescriptor();
/*     */   }
/*     */ 
/*     */   private String getPackageName(WSDLDefinitions wsdl, Configuration.GlobalConfig glc)
/*     */   {
/* 399 */     String targetNamespace = wsdl.getTargetNamespace();
/*     */ 
/* 401 */     if ((glc != null) && (glc.packageNamespaceMap != null))
/*     */     {
/* 403 */       Map map = glc.packageNamespaceMap;
/* 404 */       Iterator iter = map.keySet().iterator();
/* 405 */       while (iter.hasNext())
/*     */       {
/* 407 */         String pkg = (String)iter.next();
/* 408 */         String ns = (String)map.get(pkg);
/* 409 */         if (ns.equals(targetNamespace)) {
/* 410 */           return pkg;
/*     */         }
/*     */       }
/*     */     }
/* 414 */     return NamespacePackageMapping.getJavaPackageName(wsdl.getTargetNamespace());
/*     */   }
/*     */ 
/*     */   private void createDir(String path)
/*     */   {
/* 419 */     File file = new File(path);
/* 420 */     if (!file.exists())
/* 421 */       file.mkdirs();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.tools.helpers.ToolsHelper
 * JD-Core Version:    0.6.0
 */