/*     */ package org.jboss.ws.tools.helpers;
/*     */ 
/*     */ import javax.xml.namespace.QName;
/*     */ import org.apache.xerces.xs.XSComplexTypeDefinition;
/*     */ import org.apache.xerces.xs.XSElementDeclaration;
/*     */ import org.apache.xerces.xs.XSModelGroup;
/*     */ import org.apache.xerces.xs.XSObjectList;
/*     */ import org.apache.xerces.xs.XSParticle;
/*     */ import org.apache.xerces.xs.XSTerm;
/*     */ import org.apache.xerces.xs.XSTypeDefinition;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
/*     */ 
/*     */ public class ReturnTypeUnwrapper
/*     */ {
/*     */   public JBossXSModel xsmodel;
/*     */   public QName xmlType;
/*     */   public XSElementDeclaration unwrappedElement;
/*  48 */   public boolean array = false;
/*  49 */   public boolean primitive = false;
/*     */   private boolean wrapped;
/*     */ 
/*     */   public ReturnTypeUnwrapper(QName xmlType, JBossXSModel xsmodel, boolean wrapped)
/*     */   {
/*  54 */     this.xmlType = xmlType;
/*  55 */     this.xsmodel = xsmodel;
/*  56 */     this.wrapped = wrapped;
/*     */   }
/*     */ 
/*     */   public boolean unwrap()
/*     */   {
/*  61 */     if (!this.wrapped) {
/*  62 */       return false;
/*     */     }
/*  64 */     XSTypeDefinition xt = this.xsmodel.getTypeDefinition(this.xmlType.getLocalPart(), this.xmlType.getNamespaceURI());
/*     */ 
/*  66 */     if (!(xt instanceof XSComplexTypeDefinition)) {
/*  67 */       throw new WSException("[JAX-RPC 2.3.1.2] Tried to unwrap a non-complex type.");
/*     */     }
/*  69 */     XSComplexTypeDefinition wrapper = (XSComplexTypeDefinition)xt;
/*     */ 
/*  71 */     boolean hasAttributes = wrapper.getAttributeUses().getLength() > 0;
/*  72 */     if (hasAttributes) {
/*  73 */       throw new WSException("[JAX-RPC 2.3.1.2] Can not unwrap, complex type contains attributes.");
/*     */     }
/*  75 */     boolean unwrapped = false;
/*     */ 
/*  77 */     XSParticle particle = wrapper.getParticle();
/*  78 */     if (particle != null)
/*     */     {
/*  80 */       XSTerm term = particle.getTerm();
/*     */ 
/*  82 */       if (!(term instanceof XSModelGroup)) {
/*  83 */         throw new WSException("[JAX-RPC 2.3.1.2] Expected model group, could not unwrap");
/*     */       }
/*  85 */       XSModelGroup group = (XSModelGroup)term;
/*     */ 
/*  87 */       unwrapped = unwrapModelGroup(group);
/*     */     }
/*     */ 
/*  90 */     return unwrapped;
/*     */   }
/*     */ 
/*     */   private boolean unwrapModelGroup(XSModelGroup group)
/*     */   {
/*  95 */     XSObjectList particles = group.getParticles();
/*  96 */     if (particles.getLength() == 1)
/*     */     {
/*  98 */       XSParticle particle = (XSParticle)particles.item(0);
/*  99 */       boolean array = (particle.getMaxOccursUnbounded()) || (particle.getMaxOccurs() > 1);
/* 100 */       XSTerm term = particle.getTerm();
/*     */ 
/* 102 */       if ((term instanceof XSModelGroup))
/*     */       {
/* 104 */         return unwrapModelGroup((XSModelGroup)term);
/*     */       }
/* 106 */       if ((term instanceof XSElementDeclaration))
/*     */       {
/* 108 */         this.unwrappedElement = ((XSElementDeclaration)term);
/* 109 */         XSTypeDefinition type = this.unwrappedElement.getTypeDefinition();
/* 110 */         if (!type.getAnonymous()) {
/* 111 */           this.xmlType = new QName(this.unwrappedElement.getTypeDefinition().getNamespace(), this.unwrappedElement.getTypeDefinition().getName());
/*     */         }
/* 113 */         this.array = array;
/* 114 */         this.primitive = ((!this.unwrappedElement.getNillable()) && ((particle.getMinOccurs() != 0) || (particle.getMaxOccurs() != 1)));
/*     */       }
/*     */ 
/*     */     }
/*     */     else
/*     */     {
/* 120 */       throw new WSException("[JAX-RPC 2.3.1.2] Unable to unwrap model group with multiple particles.");
/*     */     }
/*     */ 
/* 123 */     return this.unwrappedElement != null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.tools.helpers.ReturnTypeUnwrapper
 * JD-Core Version:    0.6.0
 */