/*     */ package org.jboss.ws.tools.helpers;
/*     */ 
/*     */ import java.util.Map;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.apache.xerces.xs.XSModel;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLUtils;
/*     */ import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
/*     */ import org.jboss.ws.metadata.wsdl.xsd.SchemaUtils;
/*     */ import org.jboss.ws.tools.interfaces.SchemaCreatorIntf;
/*     */ import org.jboss.ws.tools.schema.SchemaTypeCreator;
/*     */ 
/*     */ public class JavaToXSDHelper
/*     */ {
/*  43 */   protected WSDLUtils utils = WSDLUtils.getInstance();
/*  44 */   protected SchemaUtils schemautils = SchemaUtils.getInstance();
/*  45 */   private SchemaCreatorIntf creator = null;
/*     */ 
/*  47 */   private String wsdlStyle = "RPC/Literal";
/*     */ 
/*  49 */   protected String jaxwsAssert = "JAXRPC2.0 Assertion:";
/*     */ 
/*     */   public JavaToXSDHelper()
/*     */   {
/*  53 */     this.creator = new SchemaTypeCreator();
/*     */   }
/*     */ 
/*     */   public JBossXSModel generateXSModel(QName xmlType, Class javaType, String targetNamespace)
/*     */   {
/*  67 */     if (targetNamespace == null) {
/*  68 */       throw new IllegalArgumentException("Illegal Null Argument: targetNamespace");
/*     */     }
/*  70 */     XSModel xsmodel = this.creator.getXSModel();
/*  71 */     if (xsmodel == null) this.creator.setXSModel(new JBossXSModel());
/*     */ 
/*  73 */     Class cls = this.utils.getJavaTypeForHolder(javaType);
/*  74 */     if (cls != null) return null;
/*  75 */     this.creator.generateType(null, javaType);
/*  76 */     return this.creator.getXSModel();
/*     */   }
/*     */ 
/*     */   public SchemaCreatorIntf getSchemaCreator()
/*     */   {
/*  86 */     return this.creator;
/*     */   }
/*     */ 
/*     */   public String getWsdlStyle()
/*     */   {
/*  97 */     return this.wsdlStyle;
/*     */   }
/*     */ 
/*     */   public void setPackageNamespaceMap(Map<String, String> map)
/*     */   {
/* 107 */     this.creator.setPackageNamespaceMap(map);
/*     */   }
/*     */ 
/*     */   public void setWsdlStyle(String wsdlStyle)
/*     */   {
/* 117 */     this.wsdlStyle = wsdlStyle;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.tools.helpers.JavaToXSDHelper
 * JD-Core Version:    0.6.0
 */