/*     */ package org.jboss.ws.tools.config;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URL;
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.tools.Configuration;
/*     */ import org.jboss.ws.tools.Configuration.GlobalConfig;
/*     */ import org.jboss.ws.tools.Configuration.JavaToWSDLConfig;
/*     */ import org.jboss.ws.tools.Configuration.OperationConfig;
/*     */ import org.jboss.ws.tools.Configuration.ParameterConfig;
/*     */ import org.jboss.ws.tools.Configuration.WSDLToJavaConfig;
/*     */ import org.jboss.xb.binding.JBossXBException;
/*     */ import org.jboss.xb.binding.ObjectModelFactory;
/*     */ import org.jboss.xb.binding.Unmarshaller;
/*     */ import org.jboss.xb.binding.UnmarshallerFactory;
/*     */ import org.jboss.xb.binding.UnmarshallingContext;
/*     */ import org.xml.sax.Attributes;
/*     */ 
/*     */ public class ToolsSchemaConfigReader
/*     */   implements ObjectModelFactory
/*     */ {
/*     */   private static final String PARAMETER_TAG = "parameter";
/*     */   private static final String WEBSERVICES_TAG = "webservices";
/*     */   private static final String MAPPING_TAG = "mapping";
/*     */   private static final String PACKAGE_NAMESPACE_TAG = "package-namespace";
/*     */   private static final String NAMESPACES_TAG = "namespaces";
/*     */   private static final String SERVICE_TAG = "service";
/*     */   private static final String GLOBAL_TAG = "global";
/*     */   private static final String JAVA_WSDL_TAG = "java-wsdl";
/*     */   private static final String WSDL_JAVA_TAG = "wsdl-java";
/*     */   private static final String OPERATION_TAG = "operation";
/*     */   private static final String HEADER_ATTRIBUTE = "header";
/*     */   private static final String MODE_ATTRIBUTE = "mode";
/*     */   private static final String XML_NAME_ATTRIBUTE = "xml-name";
/*     */   private static final String TYPE_ATTRIBUTE = "type";
/*     */   private static final String NAMESPACE_ATTRIBUTE = "namespace";
/*     */   private static final String PACKAGE_ATTRIBUTE = "package";
/*     */   private static final String EJB_LINK_ATTRIBUTE = "ejb-link";
/*     */   private static final String SERVLET_LINK_ATTRIBUTE = "servlet-link";
/*     */   private static final String APPEND_ATTRIBUTE = "append";
/*     */   private static final String TYPE_NAMESPACE_ATTRIBUTE = "type-namespace";
/*     */   private static final String TARGET_NAMESPACE_ATTRIBUTE = "target-namespace";
/*     */   private static final String RETURN_XML_NAME_ATTRIBUTE = "return-xml-name";
/*     */   private static final String ONEWAY_ATTRIBUTE = "one-way";
/*     */   private static final String PARAMETER_STYLE_ATTRIBUTE = "parameter-style";
/*     */   private static final String STYLE_ATTRIBUTE = "style";
/*     */   private static final String ENDPOINT_ATTRIBUTE = "endpoint";
/*     */   private static final String NAME_ATTRIBUTE = "name";
/*     */   private static final String LOCATION_ATTRIBUTE = "location";
/*     */   private static final String FILE_ATTRIBUTE = "file";
/*  91 */   private static final Logger log = Logger.getLogger(ToolsSchemaConfigReader.class);
/*     */ 
/*     */   public Configuration readConfig(String configLocation)
/*     */     throws IOException
/*     */   {
/*  99 */     log.trace("Inside readConfig: " + configLocation);
/* 100 */     if (configLocation == null) {
/* 101 */       throw new IllegalArgumentException("Config URL passed is null");
/*     */     }
/* 103 */     URL configURL = null;
/*     */     try
/*     */     {
/* 106 */       configURL = new URL(configLocation);
/*     */     }
/*     */     catch (MalformedURLException e)
/*     */     {
/*     */     }
/*     */ 
/* 113 */     if (configURL == null)
/*     */     {
/* 115 */       File configFile = new File(configLocation);
/* 116 */       if (configFile.exists()) {
/* 117 */         configURL = configFile.toURL();
/*     */       }
/*     */     }
/* 120 */     if (configURL == null)
/*     */     {
/* 122 */       ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
/* 123 */       configURL = ctxLoader.getResource(configLocation);
/*     */     }
/*     */ 
/* 126 */     if (configURL == null) {
/* 127 */       throw new IllegalArgumentException("Cannot load config from: " + configLocation);
/*     */     }
/* 129 */     Configuration config = new Configuration();
/* 130 */     InputStream is = configURL.openStream();
/*     */     try
/*     */     {
/* 133 */       Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
/* 134 */       unmarshaller.setNamespaceAware(true);
/* 135 */       unmarshaller.setSchemaValidation(true);
/* 136 */       unmarshaller.setValidation(true);
/* 137 */       unmarshaller.unmarshal(is, this, config);
/*     */     }
/*     */     catch (JBossXBException ex)
/*     */     {
/* 141 */       IOException ioex = new IOException("Cannot parse config: " + ex.getMessage());
/* 142 */       ioex.initCause(ex);
/* 143 */       throw ioex;
/*     */     }
/*     */     finally
/*     */     {
/* 147 */       is.close();
/*     */     }
/*     */ 
/* 150 */     if ((config.getJavaToWSDLConfig(false) == null) && (config.getWSDLToJavaConfig(false) == null)) {
/* 151 */       throw new WSException("Invalid configuration file, either java-wsdl, or wsdl-java must be present");
/*     */     }
/* 153 */     log.trace("Exit readConfig");
/* 154 */     return config;
/*     */   }
/*     */ 
/*     */   public Object newRoot(Object root, UnmarshallingContext ctx, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/* 159 */     if ((root instanceof Configuration))
/* 160 */       return root;
/* 161 */     return null;
/*     */   }
/*     */ 
/*     */   public Object newChild(Configuration config, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/* 169 */     log.trace("Inside newChild:localName=" + localName);
/* 170 */     if ("java-wsdl".equals(localName))
/*     */     {
/* 172 */       Configuration.JavaToWSDLConfig j2wsdlc = config.getJavaToWSDLConfig(true);
/* 173 */       return j2wsdlc;
/*     */     }
/* 175 */     if ("wsdl-java".equals(localName))
/*     */     {
/* 177 */       Configuration.WSDLToJavaConfig wsdl2jc = config.getWSDLToJavaConfig(true);
/* 178 */       wsdl2jc.wsdlLocation = attrs.getValue("location");
/* 179 */       String paramStyle = attrs.getValue("parameter-style");
/* 180 */       if (paramStyle != null) {
/* 181 */         wsdl2jc.parameterStyle = paramStyle;
/*     */       }
/* 183 */       return wsdl2jc;
/*     */     }
/* 185 */     if ("global".equals(localName))
/*     */     {
/* 187 */       Configuration.GlobalConfig globalc = config.getGlobalConfig(true);
/* 188 */       return globalc;
/*     */     }
/* 190 */     return config;
/*     */   }
/*     */ 
/*     */   public Object newChild(Configuration.JavaToWSDLConfig j2wsdlc, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/* 198 */     String errorStr = "Problem parsing tag:java-wsdl";
/*     */ 
/* 200 */     if ("service".equals(localName))
/*     */     {
/* 202 */       j2wsdlc.serviceName = attrs.getValue("name");
/* 203 */       j2wsdlc.endpointName = attrs.getValue("endpoint");
/* 204 */       j2wsdlc.wsdlStyle = getOptionalAttribute(attrs, "style", "document");
/* 205 */       j2wsdlc.parameterStyle = getOptionalAttribute(attrs, "parameter-style", "wrapped");
/*     */     } else {
/* 207 */       if ("operation".equals(localName))
/*     */       {
/* 209 */         Configuration.OperationConfig operation = j2wsdlc.createOperationConfig();
/* 210 */         operation.name = attrs.getValue("name");
/* 211 */         String oneWay = attrs.getValue("one-way");
/* 212 */         operation.isOneWay = (("true".equals(oneWay)) || ("1".equals(oneWay)));
/* 213 */         String returnXmlName = attrs.getValue("return-xml-name");
/* 214 */         if (returnXmlName != null) {
/* 215 */           operation.returnXmlName = navigator.resolveQName(returnXmlName);
/*     */         }
/* 217 */         return operation;
/*     */       }
/* 219 */       if ("namespaces".equals(localName))
/*     */       {
/* 221 */         errorStr = errorStr + "namespaces";
/* 222 */         j2wsdlc.targetNamespace = getNamespace(navigator, "target-namespace", errorStr, attrs);
/* 223 */         j2wsdlc.typeNamespace = getNamespace(navigator, "type-namespace", errorStr, attrs);
/* 224 */         if (j2wsdlc.typeNamespace == null)
/* 225 */           j2wsdlc.typeNamespace = j2wsdlc.targetNamespace;
/*     */       }
/* 227 */       else if ("mapping".equals(localName))
/*     */       {
/* 229 */         j2wsdlc.mappingFileNeeded = true;
/* 230 */         j2wsdlc.mappingFileName = getOptionalAttribute(attrs, "file", "jaxrpc-mapping.xml");
/*     */       }
/* 232 */       else if ("webservices".equals(localName))
/*     */       {
/* 234 */         j2wsdlc.wsxmlFileNeeded = true;
/* 235 */         j2wsdlc.servletLink = getOptionalAttribute(attrs, "servlet-link", null);
/* 236 */         j2wsdlc.ejbLink = getOptionalAttribute(attrs, "ejb-link", null);
/* 237 */         if ((j2wsdlc.ejbLink == null) && (j2wsdlc.servletLink == null))
/* 238 */           throw new WSException("Either servletLink or ejbLink should be specified");
/* 239 */         String wsxmlFileAppend = attrs.getValue("append");
/* 240 */         j2wsdlc.wsxmlFileAppend = (("true".equals(wsxmlFileAppend)) || ("1".equals(wsxmlFileAppend)));
/*     */       }
/*     */     }
/* 242 */     return j2wsdlc;
/*     */   }
/*     */ 
/*     */   public Object newChild(Configuration.GlobalConfig globalc, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/* 250 */     if ("package-namespace".equals(localName))
/*     */     {
/* 252 */       String pkgname = attrs.getValue("package");
/* 253 */       String ns = attrs.getValue("namespace");
/* 254 */       globalc.packageNamespaceMap.put(pkgname, ns);
/*     */     }
/* 256 */     return globalc;
/*     */   }
/*     */ 
/*     */   public Object newChild(Configuration.WSDLToJavaConfig wsdl2jc, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/* 264 */     if ("mapping".equals(localName))
/*     */     {
/* 266 */       wsdl2jc.mappingFileNeeded = true;
/* 267 */       wsdl2jc.mappingFileName = getOptionalAttribute(attrs, "file", "jaxrpc-mapping.xml");
/*     */     }
/* 269 */     else if ("webservices".equals(localName))
/*     */     {
/* 271 */       wsdl2jc.wsxmlFileNeeded = true;
/* 272 */       wsdl2jc.servletLink = getOptionalAttribute(attrs, "servlet-link", null);
/* 273 */       wsdl2jc.ejbLink = getOptionalAttribute(attrs, "ejb-link", null);
/* 274 */       if ((wsdl2jc.ejbLink == null) && (wsdl2jc.servletLink == null))
/* 275 */         throw new WSException("Either servletLink or ejbLink should be specified");
/*     */     }
/* 277 */     return wsdl2jc;
/*     */   }
/*     */ 
/*     */   public Object newChild(Configuration.OperationConfig op, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/* 285 */     if ("parameter".equals(localName))
/*     */     {
/* 287 */       Configuration.ParameterConfig parameter = op.createParameterConfig();
/* 288 */       parameter.javaType = attrs.getValue("type");
/* 289 */       String xmlName = attrs.getValue("xml-name");
/* 290 */       if (xmlName != null)
/* 291 */         parameter.xmlName = navigator.resolveQName(xmlName);
/* 292 */       parameter.mode = attrs.getValue("mode");
/* 293 */       String header = attrs.getValue("header");
/* 294 */       if (header != null) {
/* 295 */         parameter.header = (("true".equals(header)) || ("1".equals(header)));
/*     */       }
/* 297 */       return parameter;
/*     */     }
/*     */ 
/* 300 */     return null;
/*     */   }
/*     */ 
/*     */   public Object addChild(Configuration config, Configuration.WSDLToJavaConfig wsdl2jc, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 307 */     config.setWSDLToJavaConfig(wsdl2jc);
/* 308 */     return config;
/*     */   }
/*     */ 
/*     */   public Object addChild(Configuration config, Configuration.GlobalConfig global, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 315 */     config.setGlobalConfig(global);
/* 316 */     return config;
/*     */   }
/*     */ 
/*     */   public Object addChild(Configuration config, Configuration.JavaToWSDLConfig j2wc, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 323 */     config.setJavaToWSDLConfig(j2wc);
/* 324 */     return config;
/*     */   }
/*     */ 
/*     */   public Object addChild(Configuration.JavaToWSDLConfig j2wc, Configuration.OperationConfig opc, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 331 */     List list = (List)j2wc.operations.get(opc.name);
/* 332 */     if (list == null)
/*     */     {
/* 334 */       list = new ArrayList();
/* 335 */       list.add(opc);
/* 336 */       j2wc.operations.put(opc.name, list);
/*     */     }
/*     */     else
/*     */     {
/* 340 */       list.add(opc);
/*     */     }
/*     */ 
/* 343 */     return j2wc;
/*     */   }
/*     */ 
/*     */   public Object addChild(Configuration.OperationConfig opc, Configuration.ParameterConfig pc, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 348 */     opc.params.add(pc);
/* 349 */     return opc;
/*     */   }
/*     */ 
/*     */   public Object completeRoot(Object root, UnmarshallingContext ctx, String namespaceURI, String localName)
/*     */   {
/* 354 */     return root;
/*     */   }
/*     */ 
/*     */   private String getOptionalAttribute(Attributes attrs, String attribName, String defaultValue)
/*     */   {
/* 360 */     String value = attrs.getValue(attribName);
/* 361 */     if (value == null) {
/* 362 */       return defaultValue;
/*     */     }
/* 364 */     return value;
/*     */   }
/*     */ 
/*     */   private String getNamespace(UnmarshallingContext navigator, String attribName, String errorStr, Attributes attrs)
/*     */   {
/*     */     try
/*     */     {
/* 371 */       return attrs.getValue(attribName);
/*     */     }
/*     */     catch (RuntimeException e) {
/*     */     }
/* 375 */     throw new WSException(errorStr + " attribute=" + attribName);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.tools.config.ToolsSchemaConfigReader
 * JD-Core Version:    0.6.0
 */