/*     */ package org.jboss.ws.tools;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.FileInputStream;
/*     */ import java.io.FileWriter;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.tools.interfaces.WebservicesXMLCreator;
/*     */ import org.jboss.wsf.common.DOMUtils;
/*     */ import org.jboss.wsf.common.DOMWriter;
/*     */ import org.jboss.wsf.spi.metadata.webservices.PortComponentMetaData;
/*     */ import org.jboss.wsf.spi.metadata.webservices.WebserviceDescriptionMetaData;
/*     */ import org.jboss.wsf.spi.metadata.webservices.WebservicesFactory;
/*     */ import org.jboss.wsf.spi.metadata.webservices.WebservicesMetaData;
/*     */ import org.jboss.xb.binding.JBossXBException;
/*     */ import org.jboss.xb.binding.ObjectModelFactory;
/*     */ import org.jboss.xb.binding.Unmarshaller;
/*     */ import org.jboss.xb.binding.UnmarshallerFactory;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class WebservicesXMLCreatorImpl
/*     */   implements WebservicesXMLCreator
/*     */ {
/*  55 */   protected static final Logger log = Logger.getLogger(WebservicesXMLCreatorImpl.class);
/*  56 */   protected String targetNamespace = null;
/*     */ 
/*  58 */   protected String seiName = null;
/*     */ 
/*  60 */   protected String portName = null;
/*     */ 
/*  62 */   protected String serviceName = null;
/*     */ 
/*  64 */   protected String servletLink = null;
/*     */ 
/*  66 */   protected String ejbLink = null;
/*     */ 
/*  68 */   protected String wsdlFile = null;
/*  69 */   protected String mappingFile = null;
/*     */ 
/*  71 */   protected boolean append = false;
/*     */ 
/*     */   public void setTargetNamespace(String targetNamespace)
/*     */   {
/*  79 */     this.targetNamespace = targetNamespace;
/*     */   }
/*     */ 
/*     */   public void setSeiName(String seiName)
/*     */   {
/*  84 */     this.seiName = seiName;
/*     */   }
/*     */ 
/*     */   public void setPortName(String portName)
/*     */   {
/*  89 */     this.portName = portName;
/*     */   }
/*     */ 
/*     */   public void setServiceName(String serviceName)
/*     */   {
/*  94 */     this.serviceName = serviceName;
/*     */   }
/*     */ 
/*     */   public void setEjbLink(String ejbLink)
/*     */   {
/*  99 */     this.ejbLink = ejbLink;
/*     */   }
/*     */ 
/*     */   public void setServletLink(String servletLink)
/*     */   {
/* 104 */     this.servletLink = servletLink;
/*     */   }
/*     */ 
/*     */   public void setMappingFile(String mappingFile)
/*     */   {
/* 109 */     this.mappingFile = mappingFile;
/*     */   }
/*     */ 
/*     */   public void setWsdlFile(String wsdlFile)
/*     */   {
/* 114 */     this.wsdlFile = wsdlFile;
/*     */   }
/*     */ 
/*     */   public void setAppend(boolean append)
/*     */   {
/* 119 */     this.append = append;
/*     */   }
/*     */ 
/*     */   public void generateWSXMLDescriptor(File wsXmlFile) throws IOException
/*     */   {
/* 124 */     WebservicesMetaData webservices = constructWSMetaData();
/*     */ 
/* 127 */     if ((this.append) && (wsXmlFile.exists()))
/*     */     {
/* 132 */       InputStream wsXmlStream = new FileInputStream(wsXmlFile);
/*     */       WebservicesMetaData existingWebservices;
/*     */       try
/*     */       {
/* 135 */         Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
/* 136 */         ObjectModelFactory factory = new WebservicesFactory(wsXmlFile.toURL());
/* 137 */         existingWebservices = (WebservicesMetaData)unmarshaller.unmarshal(wsXmlStream, factory, null);
/*     */       }
/*     */       catch (JBossXBException e)
/*     */       {
/* 141 */         throw new WSException("Could not unmarshal existing webservices descriptor: " + wsXmlFile, e);
/*     */       }
/*     */       finally
/*     */       {
/* 145 */         wsXmlStream.close();
/*     */       }
/*     */ 
/* 149 */       for (WebserviceDescriptionMetaData webserviceDescription : webservices.getWebserviceDescriptions()) {
/* 150 */         existingWebservices.addWebserviceDescription(webserviceDescription);
/*     */       }
/* 152 */       webservices = existingWebservices;
/*     */     }
/*     */ 
/* 156 */     Element root = DOMUtils.parse(webservices.serialize());
/* 157 */     FileWriter fwriter = new FileWriter(wsXmlFile);
/* 158 */     new DOMWriter(fwriter).setPrettyprint(true).print(root);
/* 159 */     fwriter.close();
/*     */   }
/*     */ 
/*     */   private WebservicesMetaData constructWSMetaData()
/*     */   {
/* 166 */     WebservicesMetaData wm = new WebservicesMetaData();
/* 167 */     WebserviceDescriptionMetaData wsdm = new WebserviceDescriptionMetaData(wm);
/* 168 */     populateWebserviceDescriptionMetaData(wsdm);
/* 169 */     wm.addWebserviceDescription(wsdm);
/* 170 */     return wm;
/*     */   }
/*     */ 
/*     */   private void populateWebserviceDescriptionMetaData(WebserviceDescriptionMetaData wsdm)
/*     */   {
/* 175 */     checkEssentials();
/* 176 */     wsdm.setWebserviceDescriptionName(this.serviceName);
/* 177 */     wsdm.setWsdlFile(this.wsdlFile);
/* 178 */     wsdm.setJaxrpcMappingFile(this.mappingFile);
/* 179 */     PortComponentMetaData pm1 = new PortComponentMetaData(wsdm);
/* 180 */     pm1.setPortComponentName(this.portName);
/* 181 */     pm1.setWsdlPort(new QName(this.targetNamespace, this.portName, "portNS"));
/* 182 */     pm1.setServiceEndpointInterface(this.seiName);
/* 183 */     if ((this.servletLink != null) && (this.servletLink.length() > 0))
/* 184 */       pm1.setServletLink(this.servletLink);
/* 185 */     else pm1.setEjbLink(this.ejbLink);
/* 186 */     wsdm.addPortComponent(pm1);
/*     */   }
/*     */ 
/*     */   private void checkEssentials()
/*     */   {
/* 191 */     if (this.serviceName == null)
/* 192 */       throw new WSException("serviceName is null");
/* 193 */     if (this.wsdlFile == null)
/* 194 */       throw new WSException("wsdlFile is null");
/* 195 */     if (this.mappingFile == null)
/* 196 */       throw new WSException("mappingFile is null");
/* 197 */     if (this.targetNamespace == null)
/* 198 */       throw new WSException("targetNamespace is null");
/* 199 */     if (this.portName == null)
/* 200 */       throw new WSException("portName is null");
/* 201 */     if (this.seiName == null)
/* 202 */       throw new WSException("seiName is null");
/* 203 */     if ((this.servletLink == null) && (this.ejbLink == null))
/* 204 */       throw new WSException("Either servletLink or ejbLink should not be null");
/* 205 */     if ((this.servletLink != null) && (this.ejbLink != null))
/* 206 */       throw new WSException("One of servletLink or ejbLink should be null");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.tools.WebservicesXMLCreatorImpl
 * JD-Core Version:    0.6.0
 */