/*     */ package org.jboss.ws.tools;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.FileWriter;
/*     */ import java.io.IOException;
/*     */ import java.net.URL;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.soap.SOAPElement;
/*     */ import org.apache.xerces.xs.XSComplexTypeDefinition;
/*     */ import org.apache.xerces.xs.XSElementDeclaration;
/*     */ import org.apache.xerces.xs.XSModelGroup;
/*     */ import org.apache.xerces.xs.XSObjectList;
/*     */ import org.apache.xerces.xs.XSParticle;
/*     */ import org.apache.xerces.xs.XSSimpleTypeDefinition;
/*     */ import org.apache.xerces.xs.XSTerm;
/*     */ import org.apache.xerces.xs.XSTypeDefinition;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.core.jaxrpc.LiteralTypeMapping;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLBindingOperation;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLException;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLInterface;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLInterfaceFault;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperation;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationInput;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationOutfault;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationOutput;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLRPCPart;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLSOAPHeader;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLTypes;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLUtils;
/*     */ import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
/*     */ import org.jboss.ws.metadata.wsdl.xsd.SchemaUtils;
/*     */ import org.jboss.ws.tools.helpers.ReturnTypeUnwrapper;
/*     */ import org.jboss.ws.tools.interfaces.WSDLToJavaIntf;
/*     */ import org.jboss.ws.tools.wsdl.WSDLDefinitionsFactory;
/*     */ import org.jboss.wsf.common.JavaUtils;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class WSDLToJava
/*     */   implements WSDLToJavaIntf
/*     */ {
/*  84 */   private String newline = "\n";
/*     */ 
/*  86 */   protected LiteralTypeMapping typeMapping = null;
/*     */ 
/*  88 */   protected WSDLDefinitions wsdl = null;
/*     */ 
/*  93 */   protected WSDLUtils utils = WSDLUtils.getInstance();
/*     */ 
/*  96 */   protected boolean annotate = false;
/*     */ 
/*  98 */   protected Map<String, String> namespacePackageMap = null;
/*     */ 
/* 100 */   protected HolderWriter holderWriter = new HolderWriter();
/*     */ 
/* 102 */   private String seiPkgName = "";
/*     */ 
/* 104 */   private String directoryToGenerate = "";
/*     */   private String style;
/*     */   private String parameterStyle;
/*     */ 
/*     */   public WSDLDefinitions convertWSDL2Java(URL wsdlfileurl)
/*     */     throws WSDLException
/*     */   {
/* 118 */     checkTypeMapping();
/* 119 */     WSDLDefinitionsFactory wsdlFactory = WSDLDefinitionsFactory.newInstance();
/* 120 */     this.wsdl = wsdlFactory.parse(wsdlfileurl);
/*     */ 
/* 122 */     return this.wsdl;
/*     */   }
/*     */ 
/*     */   public boolean getFeature(String name)
/*     */   {
/* 130 */     if (name == null) {
/* 131 */       throw new IllegalArgumentException("Illegal null argument:name");
/*     */     }
/* 133 */     if (name.equalsIgnoreCase("http://www.jboss.org/wstools/Use_Annotations")) {
/* 134 */       return this.annotate;
/*     */     }
/* 136 */     throw new WSException("Feature:" + name + " not recognized");
/*     */   }
/*     */ 
/*     */   public void setFeature(String name, boolean value)
/*     */   {
/* 144 */     if (name == null) {
/* 145 */       throw new IllegalArgumentException("Illegal null argument:name");
/*     */     }
/* 147 */     if (name.equalsIgnoreCase("http://www.jboss.org/wstools/Use_Annotations"))
/* 148 */       this.annotate = value;
/*     */   }
/*     */ 
/*     */   public void generateSEI(URL wsdlFile, File dir, boolean annotate)
/*     */     throws IOException
/*     */   {
/* 156 */     checkTypeMapping();
/* 157 */     WSDLDefinitions wsdl = convertWSDL2Java(wsdlFile);
/* 158 */     this.annotate = annotate;
/* 159 */     this.directoryToGenerate = dir.getAbsolutePath();
/* 160 */     generateSEI(wsdl, dir);
/*     */   }
/*     */ 
/*     */   public void generateSEI(WSDLDefinitions wsdl, File dir)
/*     */     throws IOException
/*     */   {
/* 168 */     checkTypeMapping();
/* 169 */     this.directoryToGenerate = dir.getAbsolutePath();
/* 170 */     this.wsdl = wsdl;
/* 171 */     this.style = this.utils.getWSDLStyle(wsdl);
/*     */ 
/* 177 */     String targetNS = wsdl.getTargetNamespace();
/*     */ 
/* 179 */     String packageName = this.namespacePackageMap != null ? (String)this.namespacePackageMap.get(targetNS) : null;
/* 180 */     if ((packageName == null) || (packageName.length() == 0)) {
/* 181 */       packageName = NamespacePackageMapping.getJavaPackageName(targetNS);
/*     */     }
/* 183 */     this.seiPkgName = packageName;
/*     */ 
/* 185 */     File dirloc = this.utils.createPackage(dir.getAbsolutePath(), packageName);
/* 186 */     createSEI(dirloc, wsdl);
/*     */   }
/*     */ 
/*     */   public Map<String, String> getNamespacePackageMap()
/*     */   {
/* 191 */     return this.namespacePackageMap;
/*     */   }
/*     */ 
/*     */   public void setNamespacePackageMap(Map<String, String> map)
/*     */   {
/* 200 */     Set keys = map.keySet();
/* 201 */     Iterator iter = keys.iterator();
/* 202 */     while ((iter != null) && (iter.hasNext()))
/*     */     {
/* 204 */       if (this.namespacePackageMap == null)
/* 205 */         this.namespacePackageMap = new HashMap();
/* 206 */       String pkg = (String)iter.next();
/* 207 */       this.namespacePackageMap.put(map.get(pkg), pkg);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setTypeMapping(LiteralTypeMapping tm)
/*     */   {
/* 213 */     this.typeMapping = tm;
/*     */   }
/*     */ 
/*     */   private boolean isDocument()
/*     */   {
/* 259 */     return "Document/Literal".equals(this.style);
/*     */   }
/*     */ 
/*     */   private boolean isWrapped()
/*     */   {
/* 264 */     return ("wrapped".equals(this.parameterStyle)) && ("Document/Literal".equals(this.style));
/*     */   }
/*     */ 
/*     */   private void appendMethods(WSDLInterface intf, StringBuilder buf) throws IOException
/*     */   {
/* 269 */     buf.append(this.newline);
/* 270 */     String itfname = intf.getName().getLocalPart();
/* 271 */     WSDLInterfaceOperation[] ops = intf.getOperations();
/* 272 */     if ((ops == null) || (ops.length == 0))
/* 273 */       throw new IllegalArgumentException("Interface " + itfname + " doesn't have operations");
/* 274 */     int len = ops != null ? ops.length : 0;
/*     */ 
/* 276 */     for (int i = 0; i < len; i++)
/*     */     {
/* 278 */       WSDLInterfaceOperation op = ops[i];
/*     */ 
/* 280 */       WSDLBindingOperation bindingOperation = HeaderUtil.getWSDLBindingOperation(this.wsdl, op);
/*     */ 
/* 283 */       String returnType = null;
/*     */ 
/* 285 */       StringBuilder paramBuffer = new StringBuilder();
/*     */ 
/* 287 */       WSDLInterfaceOperationInput input = WSDLUtils.getWsdl11Input(op);
/* 288 */       WSDLInterfaceOperationOutput output = WSDLUtils.getWsdl11Output(op);
/* 289 */       if (isDocument())
/*     */       {
/* 291 */         returnType = appendDocParameters(paramBuffer, input, output, bindingOperation);
/*     */       }
/*     */       else
/*     */       {
/* 295 */         returnType = appendRpcParameters(paramBuffer, op, output, bindingOperation);
/*     */       }
/*     */ 
/* 298 */       if (returnType == null) {
/* 299 */         returnType = "void";
/*     */       }
/* 301 */       buf.append("  public " + returnType + "  ");
/* 302 */       buf.append(ToolsUtils.firstLetterLowerCase(op.getName().getLocalPart()));
/* 303 */       buf.append("(").append(paramBuffer);
/*     */ 
/* 305 */       buf.append(") throws ");
/*     */ 
/* 307 */       WSDLInterfaceOperationOutfault[] outfaults = op.getOutfaults();
/* 308 */       for (int k = 0; k < outfaults.length; k++)
/*     */       {
/* 310 */         WSDLInterfaceOperationOutfault fault = outfaults[k];
/* 311 */         QName faultName = fault.getRef();
/*     */ 
/* 314 */         WSDLInterfaceFault intfFault = fault.getWsdlInterfaceOperation().getWsdlInterface().getFault(faultName);
/* 315 */         JBossXSModel xsmodel = WSDLUtils.getSchemaModel(this.wsdl.getWsdlTypes());
/* 316 */         QName faultXMLName = intfFault.getElement();
/* 317 */         QName faultXMLType = intfFault.getXmlType();
/*     */ 
/* 319 */         XSElementDeclaration xe = xsmodel.getElementDeclaration(faultXMLName.getLocalPart(), faultXMLName.getNamespaceURI());
/* 320 */         XSTypeDefinition xt = xe.getTypeDefinition();
/* 321 */         if (!xt.getAnonymous())
/* 322 */           xt = xsmodel.getTypeDefinition(xt.getName(), xt.getNamespace());
/* 323 */         if ((xt instanceof XSComplexTypeDefinition)) {
/* 324 */           generateJavaSource((XSComplexTypeDefinition)xt, xsmodel, faultXMLName.getLocalPart(), true);
/*     */         }
/* 326 */         Class cl = getJavaType(faultXMLType, false);
/* 327 */         if (cl == null)
/*     */         {
/* 329 */           String faultTypeName = !xt.getAnonymous() ? faultXMLType.getLocalPart() : faultXMLName.getLocalPart();
/* 330 */           buf.append(this.seiPkgName + "." + JavaUtils.capitalize(faultTypeName));
/*     */         } else {
/* 332 */           buf.append(cl.getName());
/* 333 */         }buf.append(",");
/*     */       }
/* 335 */       buf.append(" java.rmi.RemoteException");
/* 336 */       buf.append(";");
/* 337 */       buf.append(this.newline);
/*     */     }
/*     */   }
/*     */ 
/*     */   private String appendRpcParameters(StringBuilder paramBuffer, WSDLInterfaceOperation op, WSDLInterfaceOperationOutput output, WSDLBindingOperation bindingOperation)
/*     */     throws IOException
/*     */   {
/* 344 */     String returnType = null;
/* 345 */     boolean first = true;
/*     */ 
/* 347 */     RPCSignature signature = new RPCSignature(op);
/* 348 */     for (WSDLRPCPart part : signature.parameters())
/*     */     {
/* 351 */       if (first)
/* 352 */         first = false;
/* 353 */       else paramBuffer.append(", ");
/*     */ 
/* 355 */       QName xmlName = new QName(part.getName());
/* 356 */       QName xmlType = part.getType();
/* 357 */       JBossXSModel xsmodel = WSDLUtils.getSchemaModel(this.wsdl.getWsdlTypes());
/* 358 */       XSTypeDefinition xt = xsmodel.getTypeDefinition(xmlType.getLocalPart(), xmlType.getNamespaceURI());
/*     */ 
/* 360 */       boolean holder = (output != null) && (output.getChildPart(part.getName()) != null);
/* 361 */       generateParameter(paramBuffer, xmlName.getLocalPart(), xmlType, xsmodel, xt, false, true, holder);
/* 362 */       paramBuffer.append(" ").append(getMethodParam(xmlName.getLocalPart()));
/*     */     }
/*     */ 
/* 365 */     if (signature.returnParameter() != null)
/*     */     {
/* 367 */       QName xmlName = new QName(signature.returnParameter().getName());
/* 368 */       QName xmlType = signature.returnParameter().getType();
/* 369 */       JBossXSModel xsmodel = WSDLUtils.getSchemaModel(this.wsdl.getWsdlTypes());
/* 370 */       XSTypeDefinition xt = xsmodel.getTypeDefinition(xmlType.getLocalPart(), xmlType.getNamespaceURI());
/* 371 */       returnType = getReturnType(xmlName, xmlType, xt);
/*     */     }
/*     */ 
/* 374 */     if (bindingOperation != null)
/*     */     {
/* 376 */       appendHeaderParameters(paramBuffer, bindingOperation);
/*     */     }
/*     */ 
/* 379 */     return returnType;
/*     */   }
/*     */ 
/*     */   private String appendDocParameters(StringBuilder paramBuffer, WSDLInterfaceOperationInput input, WSDLInterfaceOperationOutput output, WSDLBindingOperation bindingOperation)
/*     */     throws IOException
/*     */   {
/* 385 */     String returnType = null;
/* 386 */     boolean holder = false;
/* 387 */     if ((input != null) && (input.getElement() != null))
/*     */     {
/* 389 */       QName xmlName = input.getElement();
/* 390 */       holder = (output != null) && (xmlName.equals(output.getElement()));
/*     */ 
/* 392 */       appendParameters(paramBuffer, input, output, xmlName.getLocalPart());
/*     */     }
/*     */ 
/* 395 */     if ((!holder) && (output != null) && (output.getElement() != null))
/*     */     {
/* 397 */       QName xmlName = output.getElement();
/* 398 */       QName xmlType = output.getXMLType();
/* 399 */       JBossXSModel xsmodel = WSDLUtils.getSchemaModel(this.wsdl.getWsdlTypes());
/* 400 */       XSTypeDefinition xt = xsmodel.getTypeDefinition(xmlType.getLocalPart(), xmlType.getNamespaceURI());
/*     */ 
/* 402 */       returnType = getReturnType(xmlName, xmlType, xt);
/*     */     }
/*     */ 
/* 405 */     if (bindingOperation != null)
/*     */     {
/* 407 */       appendHeaderParameters(paramBuffer, bindingOperation);
/*     */     }
/*     */ 
/* 410 */     return returnType;
/*     */   }
/*     */ 
/*     */   private void appendHeaderParameters(StringBuilder buf, WSDLBindingOperation bindingOperation) throws IOException
/*     */   {
/* 415 */     WSDLSOAPHeader[] inputHeaders = HeaderUtil.getSignatureHeaders(bindingOperation.getInputs());
/* 416 */     WSDLSOAPHeader[] outputHeaders = HeaderUtil.getSignatureHeaders(bindingOperation.getOutputs());
/*     */ 
/* 419 */     for (WSDLSOAPHeader currentInput : inputHeaders)
/*     */     {
/* 421 */       boolean holder = HeaderUtil.containsMatchingPart(outputHeaders, currentInput);
/* 422 */       appendHeaderParameter(buf, currentInput, holder);
/*     */     }
/*     */ 
/* 425 */     for (WSDLSOAPHeader currentOutput : outputHeaders)
/*     */     {
/* 427 */       boolean input = HeaderUtil.containsMatchingPart(inputHeaders, currentOutput);
/*     */ 
/* 429 */       if (input == true) {
/*     */         continue;
/*     */       }
/* 432 */       appendHeaderParameter(buf, currentOutput, true);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void appendHeaderParameter(StringBuilder buf, WSDLSOAPHeader header, boolean holder) throws IOException
/*     */   {
/* 438 */     QName elementName = header.getElement();
/*     */ 
/* 440 */     JBossXSModel xsmodel = WSDLUtils.getSchemaModel(this.wsdl.getWsdlTypes());
/* 441 */     XSElementDeclaration xe = xsmodel.getElementDeclaration(elementName.getLocalPart(), elementName.getNamespaceURI());
/* 442 */     XSTypeDefinition xt = xe.getTypeDefinition();
/* 443 */     WSDLTypes wsdlTypes = this.wsdl.getWsdlTypes();
/* 444 */     QName xmlType = wsdlTypes.getXMLType(header.getElement());
/*     */ 
/* 447 */     xt = xsmodel.getTypeDefinition(xmlType.getLocalPart(), xmlType.getNamespaceURI());
/*     */ 
/* 449 */     if (buf.length() > 0)
/*     */     {
/* 451 */       buf.append(", ");
/*     */     }
/*     */ 
/* 454 */     generateParameter(buf, xe.getName(), xmlType, xsmodel, xt, false, true, holder);
/* 455 */     buf.append(" ").append(header.getPartName());
/*     */   }
/*     */ 
/*     */   private void appendParameters(StringBuilder buf, WSDLInterfaceOperationInput in, WSDLInterfaceOperationOutput output, String containingElement)
/*     */     throws IOException
/*     */   {
/* 461 */     QName xmlType = in.getXMLType();
/* 462 */     JBossXSModel xsmodel = WSDLUtils.getSchemaModel(this.wsdl.getWsdlTypes());
/* 463 */     XSTypeDefinition xt = xsmodel.getTypeDefinition(xmlType.getLocalPart(), xmlType.getNamespaceURI());
/*     */ 
/* 465 */     boolean wrapped = isWrapped();
/*     */ 
/* 467 */     if (wrapped)
/*     */     {
/* 469 */       int inputs = in.getWsdlOperation().getInputs().length;
/* 470 */       if (inputs > 1) {
/* 471 */         throw new WSException("[JAX-RPC - 2.3.1.2] Can not unwrap parameters for operation with mutliple inputs. inputs=" + inputs);
/*     */       }
/* 473 */       String operationName = in.getWsdlOperation().getName().getLocalPart();
/* 474 */       String elementName = in.getElement().getLocalPart();
/*     */ 
/* 476 */       if (!elementName.equals(operationName)) {
/* 477 */         throw new WSException("[JAX-RPC - 2.3.1.2] Unable to unwrap parameters, wrapper element name must match operation name. operationName=" + operationName + " elementName=" + elementName);
/*     */       }
/*     */ 
/* 480 */       wrapped = unwrapElementParameters(buf, containingElement, xt);
/*     */     }
/*     */ 
/* 483 */     if (!wrapped)
/*     */     {
/* 485 */       QName xmlName = in.getElement();
/* 486 */       boolean holder = (output != null) && (xmlName.equals(output.getElement()));
/* 487 */       generateParameter(buf, containingElement, xmlType, xsmodel, xt, false, true, holder);
/* 488 */       buf.append(" ").append(getMethodParam(containingElement));
/*     */     }
/*     */   }
/*     */ 
/*     */   private boolean unwrapElementParameters(StringBuilder buf, String containingElement, XSTypeDefinition xt)
/*     */     throws IOException
/*     */   {
/* 497 */     if (!(xt instanceof XSComplexTypeDefinition)) {
/* 498 */       return false;
/*     */     }
/* 500 */     StringBuilder tempBuf = new StringBuilder();
/* 501 */     XSComplexTypeDefinition wrapper = (XSComplexTypeDefinition)xt;
/*     */ 
/* 503 */     boolean hasAttributes = wrapper.getAttributeUses().getLength() > 0;
/* 504 */     if (hasAttributes) {
/* 505 */       throw new WSException("[JAX-RPC 2.3.1.2] Can not unwrap, complex type contains attributes.");
/*     */     }
/* 507 */     boolean unwrappedElement = false;
/*     */ 
/* 509 */     XSParticle particle = wrapper.getParticle();
/* 510 */     if (particle == null)
/*     */     {
/* 512 */       unwrappedElement = true;
/*     */     }
/*     */     else
/*     */     {
/* 516 */       XSTerm term = particle.getTerm();
/* 517 */       if ((term instanceof XSModelGroup))
/*     */       {
/* 519 */         unwrappedElement = unwrapGroup(tempBuf, containingElement, (XSModelGroup)term);
/*     */       }
/*     */     }
/*     */ 
/* 523 */     if (unwrappedElement)
/*     */     {
/* 525 */       buf.append(tempBuf);
/*     */ 
/* 528 */       generateJavaSource(wrapper, WSDLUtils.getSchemaModel(this.wsdl.getWsdlTypes()), containingElement);
/*     */ 
/* 530 */       return true;
/*     */     }
/*     */ 
/* 533 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean unwrapGroup(StringBuilder buf, String containingElement, XSModelGroup group) throws IOException
/*     */   {
/* 538 */     if (group.getCompositor() != 1) {
/* 539 */       return false;
/*     */     }
/* 541 */     XSObjectList particles = group.getParticles();
/* 542 */     for (int i = 0; i < particles.getLength(); i++)
/*     */     {
/* 544 */       XSParticle particle = (XSParticle)particles.item(i);
/* 545 */       XSTerm term = particle.getTerm();
/* 546 */       if ((term instanceof XSModelGroup))
/*     */       {
/* 548 */         if (!unwrapGroup(buf, containingElement, (XSModelGroup)term))
/* 549 */           return false;
/*     */       } else {
/* 551 */         if (!(term instanceof XSElementDeclaration))
/*     */           continue;
/* 553 */         if (buf.length() > 0) {
/* 554 */           buf.append(", ");
/*     */         }
/* 556 */         XSElementDeclaration element = (XSElementDeclaration)term;
/* 557 */         XSTypeDefinition type = element.getTypeDefinition();
/* 558 */         String tempContainingElement = containingElement + element.getName();
/*     */ 
/* 560 */         QName xmlType = null;
/* 561 */         if (!type.getAnonymous()) {
/* 562 */           xmlType = new QName(type.getNamespace(), type.getName());
/*     */         }
/* 564 */         JBossXSModel xsmodel = WSDLUtils.getSchemaModel(this.wsdl.getWsdlTypes());
/* 565 */         boolean array = (particle.getMaxOccursUnbounded()) || (particle.getMaxOccurs() > 1);
/* 566 */         boolean primitive = (!element.getNillable()) && ((particle.getMinOccurs() != 0) || (particle.getMaxOccurs() != 1));
/* 567 */         generateParameter(buf, tempContainingElement, xmlType, xsmodel, type, array, primitive, false);
/*     */         String paramName;
/*     */         String paramName;
/* 570 */         if (type.getAnonymous())
/*     */         {
/* 572 */           paramName = containingElement;
/*     */         }
/*     */         else
/*     */         {
/* 576 */           paramName = element.getName();
/*     */         }
/*     */ 
/* 579 */         buf.append(" ").append(getMethodParam(paramName));
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 584 */     return true;
/*     */   }
/*     */ 
/*     */   private void generateParameter(StringBuilder buf, String containingElement, QName xmlType, JBossXSModel xsmodel, XSTypeDefinition xt, boolean array, boolean primitive, boolean holder)
/*     */     throws IOException
/*     */   {
/* 590 */     WrappedArray wrappedArray = new WrappedArray(xt);
/* 591 */     String arraySuffix = array ? "[]" : "";
/* 592 */     if (wrappedArray.unwrap())
/*     */     {
/* 594 */       xt = wrappedArray.xt;
/* 595 */       xmlType = wrappedArray.xmlType;
/* 596 */       primitive = !wrappedArray.nillable;
/* 597 */       arraySuffix = wrappedArray.suffix;
/*     */     }
/*     */ 
/* 600 */     if ((xt instanceof XSSimpleTypeDefinition)) {
/* 601 */       xmlType = SchemaUtils.handleSimpleType((XSSimpleTypeDefinition)xt);
/*     */     }
/* 603 */     Class cl = null;
/*     */ 
/* 605 */     if (xmlType != null) {
/* 606 */       cl = getJavaType(xmlType, primitive);
/*     */     }
/* 608 */     if (cl != null)
/*     */     {
/* 610 */       if (holder) {
/* 611 */         cl = this.utils.getHolder(cl);
/*     */       }
/* 613 */       buf.append(JavaUtils.getSourceName(cl) + arraySuffix);
/*     */     }
/*     */     else
/*     */     {
/*     */       String className;
/* 618 */       if ((xt == null) || (xt.getAnonymous()))
/*     */       {
/* 620 */         className = containingElement;
/*     */       }
/*     */       else
/*     */       {
/* 624 */         className = xmlType.getLocalPart();
/*     */       }
/*     */ 
/* 627 */       if (className.charAt(0) == '>')
/* 628 */         className = className.substring(1);
/* 629 */       String className = ToolsUtils.convertInvalidCharacters(className);
/* 630 */       className = this.utils.firstLetterUpperCase(className);
/* 631 */       className = this.seiPkgName + "." + className + arraySuffix;
/*     */ 
/* 633 */       if (holder)
/*     */       {
/* 635 */         className = this.holderWriter.getOrCreateHolder(className, getLocationForJavaGeneration());
/*     */       }
/*     */ 
/* 638 */       buf.append(className);
/*     */ 
/* 640 */       if ((xt instanceof XSComplexTypeDefinition))
/* 641 */         generateJavaSource((XSComplexTypeDefinition)xt, xsmodel, containingElement);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void createSEIFile(WSDLInterface intf, File loc) throws IOException
/*     */   {
/* 647 */     String seiName = getServiceEndpointInterfaceName(intf);
/*     */ 
/* 649 */     StringBuilder buf = new StringBuilder();
/* 650 */     this.utils.writeJbossHeader(buf);
/* 651 */     buf.append("package " + this.seiPkgName + ";" + this.newline);
/* 652 */     buf.append("public interface  " + seiName + " extends java.rmi.Remote" + this.newline + "{" + this.newline);
/* 653 */     appendMethods(intf, buf);
/* 654 */     buf.append("}" + this.newline);
/*     */ 
/* 656 */     File sei = this.utils.createPhysicalFile(loc, seiName);
/* 657 */     FileWriter writer = new FileWriter(sei);
/* 658 */     writer.write(buf.toString());
/* 659 */     writer.flush();
/* 660 */     writer.close();
/*     */   }
/*     */ 
/*     */   public String getServiceEndpointInterfaceName(WSDLInterface wsdlInterface)
/*     */   {
/* 665 */     String seiName = this.utils.chopPortType(wsdlInterface.getName().getLocalPart());
/*     */ 
/* 668 */     if (this.wsdl.getService(seiName) != null) {
/* 669 */       seiName = seiName + "_PortType";
/*     */     }
/* 671 */     seiName = JavaUtils.capitalize(seiName);
/*     */ 
/* 673 */     return seiName;
/*     */   }
/*     */ 
/*     */   private void createSEI(File loc, WSDLDefinitions wsdl) throws IOException
/*     */   {
/* 678 */     WSDLInterface[] intarr = wsdl.getInterfaces();
/* 679 */     if ((intarr == null) || (intarr.length == 0))
/* 680 */       throw new IllegalArgumentException("Interfaces cannot be zero");
/* 681 */     int len = intarr.length;
/* 682 */     for (int i = 0; i < len; i++)
/*     */     {
/* 684 */       WSDLInterface intf = intarr[i];
/* 685 */       createSEIFile(intf, loc);
/*     */     }
/*     */   }
/*     */ 
/*     */   private String getReturnType(QName xmlName, QName xmlType, XSTypeDefinition xt) throws IOException
/*     */   {
/* 691 */     String containingElement = xmlName.getLocalPart();
/* 692 */     String arraySuffix = "";
/* 693 */     boolean primitive = true;
/*     */ 
/* 695 */     JBossXSModel xsmodel = WSDLUtils.getSchemaModel(this.wsdl.getWsdlTypes());
/* 696 */     xt = xsmodel.getTypeDefinition(xmlType.getLocalPart(), xmlType.getNamespaceURI());
/*     */ 
/* 698 */     ReturnTypeUnwrapper unwrapper = new ReturnTypeUnwrapper(xmlType, xsmodel, isWrapped());
/* 699 */     if (unwrapper.unwrap())
/*     */     {
/* 702 */       if ((xt instanceof XSComplexTypeDefinition)) {
/* 703 */         generateJavaSource((XSComplexTypeDefinition)xt, xsmodel, containingElement);
/*     */       }
/* 705 */       if (unwrapper.unwrappedElement != null)
/*     */       {
/* 707 */         XSElementDeclaration element = unwrapper.unwrappedElement;
/* 708 */         xt = element.getTypeDefinition();
/* 709 */         primitive = unwrapper.primitive;
/*     */ 
/* 711 */         if (unwrapper.xmlType != null) {
/* 712 */           xmlType = unwrapper.xmlType;
/*     */         }
/* 714 */         containingElement = containingElement + unwrapper.unwrappedElement.getName();
/*     */ 
/* 716 */         if (unwrapper.array) {
/* 717 */           arraySuffix = "[]";
/*     */         }
/*     */       }
/*     */     }
/* 721 */     WrappedArray wrappedArray = new WrappedArray(xt);
/* 722 */     if (wrappedArray.unwrap())
/*     */     {
/* 724 */       xt = wrappedArray.xt;
/* 725 */       xmlType = wrappedArray.xmlType;
/* 726 */       primitive = !wrappedArray.nillable;
/* 727 */       arraySuffix = wrappedArray.suffix;
/*     */     }
/*     */ 
/* 730 */     if ((xt instanceof XSSimpleTypeDefinition)) {
/* 731 */       xmlType = SchemaUtils.handleSimpleType((XSSimpleTypeDefinition)xt);
/*     */     }
/* 733 */     Class cls = getJavaType(xmlType, primitive);
/*     */ 
/* 735 */     if ((xt instanceof XSComplexTypeDefinition)) {
/* 736 */       generateJavaSource((XSComplexTypeDefinition)xt, xsmodel, containingElement);
/*     */     }
/* 738 */     if (cls == null)
/*     */     {
/*     */       String className;
/* 741 */       if (xt.getAnonymous() == true)
/*     */       {
/* 743 */         className = containingElement;
/*     */       }
/*     */       else
/*     */       {
/* 747 */         className = xmlType.getLocalPart();
/*     */       }
/*     */ 
/* 750 */       if (className.charAt(0) == '>')
/* 751 */         className = className.substring(1);
/* 752 */       String className = ToolsUtils.convertInvalidCharacters(className);
/* 753 */       className = this.utils.firstLetterUpperCase(className);
/* 754 */       return this.seiPkgName + "." + className + arraySuffix;
/*     */     }
/*     */ 
/* 757 */     if (cls.isArray())
/* 758 */       return JavaUtils.getSourceName(cls);
/* 759 */     return cls.getName() + arraySuffix;
/*     */   }
/*     */ 
/*     */   private void checkTypeMapping()
/*     */   {
/* 764 */     if (this.typeMapping == null)
/* 765 */       throw new WSException("TypeMapping has not been set.");
/*     */   }
/*     */ 
/*     */   private Class getJavaType(QName qname, boolean primitive)
/*     */   {
/* 770 */     Class cls = this.typeMapping.getJavaType(qname, primitive);
/*     */ 
/* 775 */     if ((qname.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) && ("anyType".equals(qname.getLocalPart())) && (cls == Element.class))
/* 776 */       cls = SOAPElement.class;
/* 777 */     return cls;
/*     */   }
/*     */ 
/*     */   private String getMethodParam(String name)
/*     */   {
/* 789 */     String paramName = ToolsUtils.firstLetterLowerCase(name);
/* 790 */     if (JavaKeywords.isJavaKeyword(paramName))
/*     */     {
/* 792 */       paramName = "_" + paramName;
/*     */     }
/*     */ 
/* 795 */     return paramName;
/*     */   }
/*     */ 
/*     */   private File getLocationForJavaGeneration()
/*     */   {
/* 800 */     return new File(this.directoryToGenerate + "/" + this.seiPkgName.replace('.', '/'));
/*     */   }
/*     */ 
/*     */   private void generateJavaSource(XSComplexTypeDefinition xt, JBossXSModel xsmodel, String containingElement) throws IOException
/*     */   {
/* 805 */     generateJavaSource(xt, xsmodel, containingElement, false);
/*     */   }
/*     */ 
/*     */   private void generateJavaSource(XSComplexTypeDefinition xt, JBossXSModel xsmodel, String containingElement, boolean exception) throws IOException
/*     */   {
/* 810 */     XSDTypeToJava xtj = new XSDTypeToJava();
/* 811 */     xtj.setTypeMapping(this.typeMapping);
/* 812 */     xtj.createJavaFile(xt, containingElement, getLocationForJavaGeneration(), this.seiPkgName, xsmodel, exception);
/*     */   }
/*     */ 
/*     */   public void setParameterStyle(String paramStyle)
/*     */   {
/* 817 */     this.parameterStyle = paramStyle;
/*     */   }
/*     */ 
/*     */   private class WrappedArray
/*     */   {
/*     */     public QName xmlType;
/*     */     public XSTypeDefinition xt;
/*     */     public String suffix;
/*     */     public boolean nillable;
/*     */ 
/*     */     public WrappedArray(XSTypeDefinition xt)
/*     */     {
/* 225 */       this.xt = xt;
/*     */     }
/*     */ 
/*     */     public boolean unwrap()
/*     */     {
/* 230 */       if (!"Document/Literal".equals(WSDLToJava.this.style))
/*     */       {
/* 232 */         XSElementDeclaration unwrapped = SchemaUtils.unwrapArrayType(this.xt);
/* 233 */         StringBuilder builder = new StringBuilder();
/* 234 */         while (unwrapped != null)
/*     */         {
/* 236 */           this.xt = unwrapped.getTypeDefinition();
/* 237 */           this.nillable = unwrapped.getNillable();
/* 238 */           builder.append("[]");
/* 239 */           unwrapped = SchemaUtils.unwrapArrayType(this.xt);
/*     */         }
/* 241 */         if (builder.length() > 0)
/*     */         {
/* 243 */           this.xmlType = new QName(this.xt.getNamespace(), this.xt.getName());
/* 244 */           this.suffix = builder.toString();
/* 245 */           return true;
/*     */         }
/*     */       }
/*     */ 
/* 249 */       return false;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.tools.WSDLToJava
 * JD-Core Version:    0.6.0
 */