/*     */ package org.jboss.ws.tools;
/*     */ 
/*     */ import java.util.HashSet;
/*     */ import java.util.Set;
/*     */ 
/*     */ public class NamespacePackageMapping
/*     */ {
/*  39 */   private static final NamespacePackageMapping npm = new NamespacePackageMapping();
/*     */ 
/*  56 */   private final String[] countryCodesArray = { "ac", "ad", "ae", "af", "ag", "ai", "al", "am", "an", "ao", "aq", "ar", "as", "at", "au", "aw", "az", "ax", "ba", "bb", "bd", "be", "bf", "bg", "bh", "bi", "bj", "bm", "bn", "bo", "br", "bs", "bt", "bv", "bw", "by", "bz", "ca", "cc", "cd", "cf", "cg", "ch", "ci", "ck", "cl", "cm", "cn", "co", "cr", "cs", "cu", "cv", "cx", "cy", "cz", "de", "dj", "dk", "dm", "do", "dz", "ec", "ee", "eg", "eh", "er", "es", "et", "eu", "fi", "fj", "fk", "fm", "fo", "fr", "ga", "gb", "gd", "ge", "gf", "gg", "gh", "gi", "gl", "gm", "gn", "gp", "gq", "gr", "gs", "gt", "gu", "gw", "gy", "hk", "hm", "hn", "hr", "ht", "hu", "id", "ie", "il", "im", "in", "io", "iq", "ir", "is", "it", "je", "jm", "jo", "jp", "ke", "kg", "kh", "ki", "km", "kn", "kp", "kr", "kw", "ky", "kz", "la", "lb", "lc", "li", "lk", "lr", "ls", "lt", "lu", "lv", "ly", "ma", "mc", "md", "mg", "mh", "mk", "ml", "mm", "mn", "mo", "mp", "mq", "mr", "ms", "mt", "mu", "mv", "mw", "mx", "my", "mz", "na", "nc", "ne", "nf", "ng", "ni", "nl", "no", "np", "nr", "nu", "nz", "om", "pa", "pe", "pf", "pg", "ph", "pk", "pl", "pm", "pn", "pr", "ps", "pt", "pw", "py", "qa", "re", "ro", "ru", "rw", "sa", "sb", "sc", "sd", "se", "sg", "sh", "si", "sj", "sk", "sl", "sm", "sn", "so", "sr", "st", "sv", "sy", "sz", "tc", "td", "tf", "tg", "th", "tj", "tk", "tl", "tm", "tn", "to", "tp", "tr", "tt", "tv", "tw", "tz", "ua", "ug", "uk", "um", "us", "uy", "uz", "va", "vc", "ve", "vg", "vi", "vn", "vu", "wf", "ws", "ye", "yt", "yu", "za", "zm", "zw" };
/*     */ 
/*  67 */   private final String[] topLevelDomainsArray = { "com", "gov", "net", "org", "edu" };
/*     */   private final Set<String> topLevelDomains;
/*     */ 
/*     */   public static String getJavaPackageName(String targetNS)
/*     */   {
/*  80 */     return npm.convertNamespaceToPackage(targetNS);
/*     */   }
/*     */ 
/*     */   private NamespacePackageMapping()
/*     */   {
/*  85 */     int topLevelSize = this.countryCodesArray.length + this.topLevelDomainsArray.length;
/*  86 */     topLevelSize = (int)(topLevelSize / 0.75D) + 1;
/*     */ 
/*  88 */     this.topLevelDomains = new HashSet(topLevelSize);
/*  89 */     addAll(this.topLevelDomains, this.countryCodesArray);
/*  90 */     addAll(this.topLevelDomains, this.topLevelDomainsArray);
/*     */   }
/*     */ 
/*     */   private void addAll(Set<String> set, String[] data)
/*     */   {
/*  95 */     for (String current : data)
/*     */     {
/*  97 */       set.add(current);
/*     */     }
/*     */   }
/*     */ 
/*     */   private String convertNamespaceToPackage(String targetNS)
/*     */   {
/* 103 */     String workingNS = targetNS;
/*     */ 
/* 105 */     boolean schemeIsURN = workingNS.startsWith("urn:");
/*     */ 
/* 107 */     if (workingNS.startsWith("http://"))
/*     */     {
/* 109 */       workingNS = workingNS.substring(7);
/*     */     }
/* 111 */     else if (workingNS.startsWith("https://"))
/*     */     {
/* 113 */       workingNS = workingNS.substring(8);
/*     */     }
/* 115 */     else if (workingNS.startsWith("urn:"))
/*     */     {
/* 117 */       workingNS = workingNS.substring(4);
/*     */     }
/*     */     else
/*     */     {
/* 121 */       throw new IllegalArgumentException("TargetNS should start with http:// / https:// / urn:");
/*     */     }
/*     */ 
/* 125 */     boolean hasExtension = workingNS.matches("^.*\\/.*\\.((.{2,3})|(html))$");
/* 126 */     if (hasExtension)
/*     */     {
/* 128 */       workingNS = workingNS.substring(0, workingNS.lastIndexOf("."));
/*     */     }
/*     */ 
/* 131 */     String[] tokens = workingNS.split("[\\/\\:]+");
/*     */ 
/* 133 */     if (schemeIsURN)
/*     */     {
/* 135 */       tokens[0] = tokens[0].replace('-', '.');
/*     */     }
/*     */ 
/* 138 */     String[] packagePrefix = convertDomainToPackage(tokens[0]);
/* 139 */     String[] temp = tokens;
/*     */ 
/* 141 */     tokens = new String[packagePrefix.length + temp.length - 1];
/* 142 */     System.arraycopy(packagePrefix, 0, tokens, 0, packagePrefix.length);
/* 143 */     System.arraycopy(temp, 1, tokens, packagePrefix.length, temp.length - 1);
/*     */ 
/* 145 */     StringBuilder packageName = new StringBuilder();
/*     */ 
/* 147 */     for (int i = 0; i < tokens.length; i++)
/*     */     {
/* 149 */       String current = tokens[i];
/* 150 */       current = current.toLowerCase();
/* 151 */       current = convertReserved(current);
/* 152 */       current = convertStart(current);
/* 153 */       current = ToolsUtils.convertInvalidCharacters(current);
/*     */ 
/* 155 */       packageName.append(current);
/* 156 */       if (i >= tokens.length - 1)
/*     */         continue;
/* 158 */       packageName.append(".");
/*     */     }
/*     */ 
/* 162 */     return packageName.toString();
/*     */   }
/*     */ 
/*     */   private String convertReserved(String component)
/*     */   {
/* 171 */     String result = component;
/* 172 */     if (JavaKeywords.isJavaKeyword(result))
/*     */     {
/* 174 */       result = result + "_";
/*     */     }
/*     */ 
/* 177 */     return result;
/*     */   }
/*     */ 
/*     */   private String convertStart(String component)
/*     */   {
/* 186 */     String result = component;
/*     */ 
/* 188 */     if (!Character.isJavaIdentifierStart(result.charAt(0)))
/*     */     {
/* 190 */       result = "_" + result;
/*     */     }
/*     */ 
/* 193 */     return result;
/*     */   }
/*     */ 
/*     */   private String[] convertDomainToPackage(String domain)
/*     */   {
/* 205 */     String[] parts = domain.split("\\.");
/*     */     String[] packge;
/* 209 */     if (this.topLevelDomains.contains(parts[(parts.length - 1)]))
/*     */     {
/*     */       String[] packge;
/*     */       String[] packge;
/* 211 */       if (parts[0].equals("www"))
/*     */       {
/* 213 */         packge = new String[parts.length - 1];
/*     */       }
/*     */       else
/*     */       {
/* 217 */         packge = new String[parts.length];
/*     */       }
/*     */ 
/* 220 */       for (int i = 0; i < packge.length; i++)
/*     */       {
/* 222 */         packge[i] = parts[(parts.length - i - 1)];
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 227 */       packge = parts;
/*     */     }
/*     */ 
/* 230 */     return packge;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.tools.NamespacePackageMapping
 * JD-Core Version:    0.6.0
 */