/*     */ package org.jboss.ws.tools;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.net.URL;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.apache.xerces.impl.xs.SchemaGrammar;
/*     */ import org.apache.xerces.impl.xs.XMLSchemaLoader;
/*     */ import org.apache.xerces.impl.xs.XSModelImpl;
/*     */ import org.apache.xerces.xni.parser.XMLInputSource;
/*     */ import org.apache.xerces.xs.XSModel;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.core.utils.JBossWSEntityResolver;
/*     */ import org.jboss.ws.core.utils.ResourceURL;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLUtils;
/*     */ import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSEntityResolver;
/*     */ import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSErrorHandler;
/*     */ import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
/*     */ import org.jboss.ws.metadata.wsdl.xmlschema.WSSchemaUtils;
/*     */ import org.jboss.ws.metadata.wsdl.xsd.SchemaUtils;
/*     */ import org.jboss.ws.tools.helpers.JavaToXSDHelper;
/*     */ import org.jboss.ws.tools.interfaces.JavaToXSDIntf;
/*     */ import org.jboss.ws.tools.interfaces.SchemaCreatorIntf;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.LSInputAdaptor;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;
/*     */ import org.w3c.dom.ls.LSInput;
/*     */ import org.xml.sax.InputSource;
/*     */ 
/*     */ public class JavaToXSD
/*     */   implements JavaToXSDIntf
/*     */ {
/*  81 */   private static final Logger log = Logger.getLogger(JavaToXSD.class);
/*     */ 
/*  83 */   protected WSDLUtils utils = WSDLUtils.getInstance();
/*  84 */   protected SchemaUtils schemautils = SchemaUtils.getInstance();
/*  85 */   protected String jaxrpcAssert = "JAXRPC2.0 Assertion:";
/*     */ 
/*  87 */   protected JavaToXSDHelper helper = null;
/*     */ 
/*     */   public JavaToXSD()
/*     */   {
/*  94 */     this.helper = new JavaToXSDHelper();
/*  95 */     SchemaCreatorIntf creator = this.helper.getSchemaCreator();
/*  96 */     JBossXSModel xsmodel = creator.getXSModel();
/*  97 */     if (xsmodel == null)
/*  98 */       creator.setXSModel(new JBossXSModel());
/*     */   }
/*     */ 
/*     */   public JBossXSModel generateForSingleType(QName xmlType, Class javaType)
/*     */     throws IOException
/*     */   {
/* 106 */     SchemaCreatorIntf creator = this.helper.getSchemaCreator();
/* 107 */     creator.generateType(xmlType, javaType);
/* 108 */     return creator.getXSModel();
/*     */   }
/*     */ 
/*     */   public JBossXSModel generateForSingleType(QName xmlType, Class javaType, Map<String, QName> elementNames) throws IOException
/*     */   {
/* 113 */     SchemaCreatorIntf creator = this.helper.getSchemaCreator();
/* 114 */     creator.generateType(xmlType, javaType, elementNames);
/* 115 */     return creator.getXSModel();
/*     */   }
/*     */ 
/*     */   public SchemaCreatorIntf getSchemaCreator()
/*     */   {
/* 123 */     return this.helper.getSchemaCreator();
/*     */   }
/*     */ 
/*     */   public JBossXSModel parseSchema(URL xsdURL)
/*     */   {
/* 133 */     JBossXSErrorHandler xserr = new JBossXSErrorHandler();
/* 134 */     JBossWSEntityResolver resolver = new JBossWSEntityResolver();
/* 135 */     JBossXSEntityResolver xsresolve = new JBossXSEntityResolver(resolver, new HashMap());
/* 136 */     XMLSchemaLoader loader = (XMLSchemaLoader)this.schemautils.getXSLoader(xserr, xsresolve);
/*     */ 
/* 138 */     XSModel xsmodel = loader.loadURI(xsdURL.toExternalForm());
/* 139 */     if (xsmodel == null) {
/* 140 */       throw new WSException("Cannot load schema: " + xsdURL);
/*     */     }
/* 142 */     WSSchemaUtils sutils = WSSchemaUtils.getInstance(null, null);
/* 143 */     JBossXSModel jbxs = new JBossXSModel();
/* 144 */     sutils.copyXSModel(xsmodel, jbxs);
/* 145 */     return jbxs;
/*     */   }
/*     */ 
/*     */   public JBossXSModel parseSchema(Map<String, URL> locs)
/*     */   {
/* 155 */     if ((locs == null) || (locs.size() == 0)) {
/* 156 */       throw new IllegalArgumentException("Illegal schema location map");
/*     */     }
/* 158 */     JBossXSErrorHandler xserr = new JBossXSErrorHandler();
/* 159 */     JBossWSEntityResolver resolver = new JBossWSEntityResolver();
/* 160 */     JBossXSEntityResolver xsresolve = new JBossXSEntityResolver(resolver, locs);
/* 161 */     XMLSchemaLoader loader = (XMLSchemaLoader)this.schemautils.getXSLoader(xserr, xsresolve);
/*     */ 
/* 163 */     int index = 0;
/* 164 */     SchemaGrammar[] gs = new SchemaGrammar[locs.size()];
/* 165 */     Iterator it = locs.keySet().iterator();
/* 166 */     while (it.hasNext())
/*     */     {
/*     */       try
/*     */       {
/* 170 */         String nsURI = (String)it.next();
/* 171 */         URL orgURL = (URL)locs.get(nsURI);
/* 172 */         URL resURL = resolveNamespaceURI(resolver, nsURI);
/* 173 */         URL url = resURL != null ? resURL : orgURL;
/*     */ 
/* 175 */         log.debug("Load schema: " + nsURI + "=" + url);
/* 176 */         XMLInputSource inputSource = new XMLInputSource(null, url.toExternalForm(), null);
/*     */ 
/* 178 */         InputSource tmpSrc = resolver.resolveEntity(null, url.toExternalForm());
/* 179 */         InputStream in = tmpSrc.getByteStream() != null ? tmpSrc.getByteStream() : new ResourceURL(url).openStream();
/* 180 */         inputSource.setByteStream(in);
/*     */ 
/* 182 */         SchemaGrammar grammar = (SchemaGrammar)loader.loadGrammar(inputSource);
/* 183 */         if (grammar == null) {
/* 184 */           throw new IllegalStateException("Cannot load grammar: " + url);
/*     */         }
/* 186 */         gs[(index++)] = grammar;
/*     */       }
/*     */       catch (RuntimeException rte)
/*     */       {
/* 190 */         throw rte;
/*     */       }
/*     */       catch (Exception ex)
/*     */       {
/* 194 */         throw new IllegalStateException("Cannot parse schema", ex);
/*     */       }
/*     */     }
/* 197 */     XSModel xsmodel = new XSModelImpl(gs);
/*     */ 
/* 200 */     WSSchemaUtils sutils = WSSchemaUtils.getInstance(null, null);
/* 201 */     JBossXSModel jbxs = new JBossXSModel();
/* 202 */     sutils.copyXSModel(xsmodel, jbxs);
/*     */ 
/* 204 */     return jbxs;
/*     */   }
/*     */ 
/*     */   private URL resolveNamespaceURI(JBossWSEntityResolver resolver, String nsURI)
/*     */   {
/* 209 */     URL url = null;
/*     */ 
/* 211 */     String resource = (String)JBossWSEntityResolver.getEntityMap().get(nsURI);
/* 212 */     if (resource != null)
/*     */     {
/* 214 */       ClassLoader loader = Thread.currentThread().getContextClassLoader();
/* 215 */       url = loader.getResource(resource);
/* 216 */       if (url == null)
/*     */       {
/* 218 */         if (resource.endsWith(".dtd"))
/* 219 */           resource = "dtd/" + resource;
/* 220 */         else if (resource.endsWith(".xsd"))
/* 221 */           resource = "schema/" + resource;
/* 222 */         url = loader.getResource(resource);
/*     */       }
/*     */     }
/*     */ 
/* 226 */     return url;
/*     */   }
/*     */ 
/*     */   public void setPackageNamespaceMap(Map<String, String> map)
/*     */   {
/* 234 */     this.helper.setPackageNamespaceMap(map);
/*     */   }
/*     */ 
/*     */   public void setWSDLStyle(String style)
/*     */   {
/* 242 */     this.helper.setWsdlStyle(style);
/*     */   }
/*     */ 
/*     */   private SchemaBindingResolver getSchemaBindingResolver(Map<String, URL> map)
/*     */   {
/* 254 */     return new SchemaBindingResolver(map)
/*     */     {
/*     */       public String getBaseURI()
/*     */       {
/* 258 */         throw new UnsupportedOperationException("getBaseURI is not implemented.");
/*     */       }
/*     */ 
/*     */       public void setBaseURI(String baseURI)
/*     */       {
/* 263 */         throw new UnsupportedOperationException("setBaseURI is not implemented.");
/*     */       }
/*     */ 
/*     */       public SchemaBinding resolve(String nsUri, String baseURI, String schemaLocation)
/*     */       {
/* 268 */         throw new UnsupportedOperationException("resolve is not implemented.");
/*     */       }
/*     */ 
/*     */       public LSInput resolveAsLSInput(String nsUri, String baseUri, String schemaLocation)
/*     */       {
/* 273 */         URL url = (URL)this.val$map.get(nsUri);
/* 274 */         if (url != null)
/*     */           try
/*     */           {
/* 277 */             return new LSInputAdaptor(url.openStream(), null);
/*     */           }
/*     */           catch (IOException e)
/*     */           {
/* 281 */             JavaToXSD.log.error("URL is bad for schema parsing");
/*     */           }
/* 283 */         return null;
/*     */       }
/*     */     };
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.tools.JavaToXSD
 * JD-Core Version:    0.6.0
 */