/*     */ package org.jboss.ws.tools;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import javax.xml.rpc.encoding.TypeMapping;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMapping;
/*     */ import org.jboss.ws.metadata.umdm.EndpointMetaData;
/*     */ import org.jboss.ws.metadata.umdm.ServiceMetaData;
/*     */ import org.jboss.ws.metadata.umdm.UnifiedMetaData;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLUtils;
/*     */ import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
/*     */ import org.jboss.ws.tools.helpers.JavaToWSDLHelper;
/*     */ 
/*     */ public class JavaToWSDL11
/*     */ {
/*  51 */   private static final Logger log = Logger.getLogger(JavaToWSDL11.class);
/*     */ 
/*  54 */   private final String wsdlNamespace = "http://schemas.xmlsoap.org/wsdl/";
/*     */ 
/*  57 */   private HashMap<String, Boolean> features = new HashMap();
/*     */ 
/*  60 */   private Map<String, String> packageNamespaceMap = null;
/*     */ 
/*  62 */   private TypeMapping typeMapping = null;
/*     */ 
/*  64 */   private JavaWsdlMapping javaWsdlMapping = null;
/*     */ 
/*  66 */   private UnifiedMetaData umd = null;
/*     */ 
/*  68 */   private boolean qualifiedElements = false;
/*     */ 
/*     */   public JavaToWSDL11()
/*     */   {
/*  75 */     if (log.isDebugEnabled()) log.debug("Creating JavaToWSDL11 instance");
/*     */   }
/*     */ 
/*     */   public void addFeature(String name, boolean value)
/*     */   {
/*  86 */     this.features.put(name, new Boolean(value));
/*     */   }
/*     */ 
/*     */   public void addFeatures(Map<String, Boolean> map)
/*     */   {
/*  96 */     this.features.putAll(map);
/*     */   }
/*     */ 
/*     */   public boolean getFeature(String name)
/*     */   {
/* 108 */     Boolean val = (Boolean)this.features.get(name);
/* 109 */     if (val != null)
/* 110 */       return val.booleanValue();
/* 111 */     throw new WSException("Feature unrecognized");
/*     */   }
/*     */ 
/*     */   public void setPackageNamespaceMap(Map<String, String> map)
/*     */   {
/* 121 */     this.packageNamespaceMap = map;
/*     */   }
/*     */ 
/*     */   public TypeMapping getTypeMapping()
/*     */   {
/* 133 */     if (this.typeMapping == null)
/* 134 */       throw new WSException("TypeMapping has not been generated");
/* 135 */     return this.typeMapping;
/*     */   }
/*     */ 
/*     */   public void setUnifiedMetaData(UnifiedMetaData um)
/*     */   {
/* 146 */     this.umd = um;
/*     */   }
/*     */ 
/*     */   public WSDLDefinitions generate(Class endpoint)
/*     */   {
/* 154 */     WSDLDefinitions wsdl = null;
/*     */ 
/* 156 */     if (this.umd != null)
/*     */     {
/* 158 */       JavaToWSDLHelper helper = new JavaToWSDLHelper();
/*     */       try
/*     */       {
/* 161 */         helper.setPackageNamespaceMap(this.packageNamespaceMap);
/* 162 */         wsdl = handleJavaToWSDLGeneration(helper, endpoint.getName());
/*     */ 
/* 164 */         this.typeMapping = helper.getTypeMapping();
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/* 168 */         log.error("Error during Java->WSDL generation:", e);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 173 */     if (this.qualifiedElements)
/*     */     {
/* 175 */       JBossXSModel schemaModel = WSDLUtils.getSchemaModel(wsdl.getWsdlTypes());
/* 176 */       if (schemaModel != null) {
/* 177 */         schemaModel.setQualifiedElements(true);
/*     */       }
/*     */     }
/* 180 */     return wsdl;
/*     */   }
/*     */ 
/*     */   public boolean isQualifiedElements()
/*     */   {
/* 185 */     return this.qualifiedElements;
/*     */   }
/*     */ 
/*     */   public void setQualifiedElements(boolean qualifiedElements)
/*     */   {
/* 190 */     this.qualifiedElements = qualifiedElements;
/*     */   }
/*     */ 
/*     */   public JavaWsdlMapping getJavaWsdlMapping()
/*     */   {
/* 195 */     return this.javaWsdlMapping;
/*     */   }
/*     */ 
/*     */   private WSDLDefinitions handleJavaToWSDLGeneration(JavaToWSDLHelper helper, String endpointName)
/*     */     throws IOException
/*     */   {
/* 201 */     WSDLDefinitions wsdl = null;
/* 202 */     if (this.umd == null) {
/* 203 */       throw new WSException("Unified Meta Data Model is null");
/*     */     }
/* 205 */     for (ServiceMetaData service : this.umd.getServices())
/*     */     {
/* 207 */       EndpointMetaData epMetaData = service.getEndpointByServiceEndpointInterface(endpointName);
/* 208 */       if (epMetaData != null)
/*     */       {
/* 210 */         wsdl = helper.generate(service);
/* 211 */         break;
/*     */       }
/*     */     }
/* 214 */     this.javaWsdlMapping = helper.getJavaWsdlMapping();
/* 215 */     return wsdl;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.tools.JavaToWSDL11
 * JD-Core Version:    0.6.0
 */