/*     */ package org.jboss.ws.tools;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.FileWriter;
/*     */ import java.io.IOException;
/*     */ import java.util.HashMap;
/*     */ import javax.xml.rpc.holders.Holder;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLUtils;
/*     */ 
/*     */ public class HolderWriter
/*     */ {
/*  43 */   private static final WSDLUtils utils = WSDLUtils.getInstance();
/*     */   private static final String newline = "\n";
/*  51 */   private HashMap<String, String> createdHolders = new HashMap();
/*     */ 
/*     */   String getOrCreateHolder(String type, File pkgLoc)
/*     */   {
/*  56 */     String fullHolderName = (String)this.createdHolders.get(type);
/*  57 */     if (fullHolderName == null)
/*     */     {
/*  59 */       StringBuilder buf = new StringBuilder();
/*  60 */       fullHolderName = writeHolder(type, buf);
/*     */ 
/*  62 */       this.createdHolders.put(type, fullHolderName);
/*     */ 
/*  64 */       String holderName = fullHolderName.substring(fullHolderName.lastIndexOf('.') + 1);
/*     */       try
/*     */       {
/*  68 */         File sei = utils.createPhysicalFile(pkgLoc, holderName);
/*  69 */         FileWriter writer = new FileWriter(sei);
/*  70 */         writer.write(buf.toString());
/*  71 */         writer.flush();
/*  72 */         writer.close();
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/*  76 */         throw new WSException("Unable to create JAX-RPC holder.", e);
/*     */       }
/*     */     }
/*     */ 
/*  80 */     return fullHolderName;
/*     */   }
/*     */ 
/*     */   private String writeHolder(String type, StringBuilder buf)
/*     */   {
/*  85 */     String pkg = type.substring(0, type.lastIndexOf('.'));
/*  86 */     String typeName = type.substring(type.lastIndexOf('.') + 1);
/*  87 */     String holderName = typeName + "Holder";
/*     */ 
/*  89 */     utils.writeJbossHeader(buf);
/*  90 */     buf.append("\n");
/*  91 */     buf.append("package ").append(pkg).append(";").append("\n");
/*     */ 
/*  93 */     buf.append("\n");
/*  94 */     buf.append("public class ").append(holderName).append(" implements ").append(Holder.class.getName());
/*  95 */     buf.append("\n").append("{").append("\n");
/*     */ 
/*  98 */     buf.append("\n");
/*  99 */     buf.append("  public ").append(type).append(" value;");
/* 100 */     buf.append("\n");
/*     */ 
/* 103 */     buf.append("\n");
/* 104 */     buf.append("  ").append("public ").append(holderName).append("()").append("\n");
/* 105 */     buf.append("  {").append("\n");
/* 106 */     buf.append("    this.value = new ").append(type).append("();").append("\n");
/* 107 */     buf.append("  }").append("\n");
/*     */ 
/* 110 */     buf.append("\n");
/* 111 */     buf.append("  ").append("public ").append(holderName).append("(final ").append(type).append(" value)").append("\n");
/* 112 */     buf.append("  {").append("\n");
/* 113 */     buf.append("    this.value = value;").append("\n");
/* 114 */     buf.append("  }").append("\n");
/* 115 */     buf.append("\n");
/*     */ 
/* 117 */     buf.append("}").append("\n");
/* 118 */     return pkg + "." + holderName;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.tools.HolderWriter
 * JD-Core Version:    0.6.0
 */