/*    */ package org.jboss.ws.tools;
/*    */ 
/*    */ import java.util.ArrayList;
/*    */ import javax.xml.namespace.QName;
/*    */ import org.jboss.ws.metadata.wsdl.WSDLBinding;
/*    */ import org.jboss.ws.metadata.wsdl.WSDLBindingMessageReference;
/*    */ import org.jboss.ws.metadata.wsdl.WSDLBindingOperation;
/*    */ import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
/*    */ import org.jboss.ws.metadata.wsdl.WSDLInterface;
/*    */ import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperation;
/*    */ import org.jboss.ws.metadata.wsdl.WSDLSOAPHeader;
/*    */ 
/*    */ public class HeaderUtil
/*    */ {
/*    */   public static WSDLBindingOperation getWSDLBindingOperation(WSDLDefinitions wsdl, WSDLInterfaceOperation operation)
/*    */   {
/* 49 */     WSDLBindingOperation bindingOperation = null;
/*    */ 
/* 51 */     WSDLInterface wsdlInterface = operation.getWsdlInterface();
/* 52 */     QName operationName = operation.getName();
/*    */ 
/* 54 */     WSDLBinding binding = wsdl.getBindingByInterfaceName(wsdlInterface.getName());
/* 55 */     bindingOperation = binding.getOperationByRef(operationName);
/*    */ 
/* 57 */     return bindingOperation;
/*    */   }
/*    */ 
/*    */   public static WSDLSOAPHeader[] getSignatureHeaders(WSDLBindingMessageReference[] refs)
/*    */   {
/* 62 */     ArrayList headers = new ArrayList();
/*    */ 
/* 64 */     if (refs != null)
/*    */     {
/* 66 */       for (WSDLBindingMessageReference current : refs)
/*    */       {
/* 68 */         for (WSDLSOAPHeader header : current.getSoapHeaders())
/*    */         {
/* 70 */           headers.add(header);
/*    */         }
/*    */       }
/*    */     }
/*    */ 
/* 75 */     return (WSDLSOAPHeader[])headers.toArray(new WSDLSOAPHeader[headers.size()]);
/*    */   }
/*    */ 
/*    */   public static boolean containsMatchingPart(WSDLSOAPHeader[] headers, WSDLSOAPHeader header)
/*    */   {
/* 80 */     for (WSDLSOAPHeader current : headers)
/*    */     {
/* 82 */       if (!current.getPartName().equals(header.getPartName()))
/*    */         continue;
/* 84 */       if (current.getElement().equals(header.getElement()))
/*    */       {
/* 86 */         return true;
/*    */       }
/*    */ 
/*    */     }
/*    */ 
/* 91 */     return false;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.tools.HeaderUtil
 * JD-Core Version:    0.6.0
 */