/*     */ package org.jboss.ws.metadata.wsse;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.StringReader;
/*     */ import java.lang.reflect.Method;
/*     */ import java.net.URL;
/*     */ import java.util.HashMap;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.core.utils.ResourceURL;
/*     */ import org.jboss.xb.binding.JBossXBException;
/*     */ import org.jboss.xb.binding.ObjectModelFactory;
/*     */ import org.jboss.xb.binding.SimpleTypeBindings;
/*     */ import org.jboss.xb.binding.Unmarshaller;
/*     */ import org.jboss.xb.binding.UnmarshallerFactory;
/*     */ import org.jboss.xb.binding.UnmarshallingContext;
/*     */ import org.xml.sax.Attributes;
/*     */ 
/*     */ public class WSSecurityOMFactory
/*     */   implements ObjectModelFactory
/*     */ {
/*  50 */   public static String SERVER_RESOURCE_NAME = "jboss-wsse-server.xml";
/*     */ 
/*  52 */   public static String CLIENT_RESOURCE_NAME = "jboss-wsse-client.xml";
/*     */ 
/*  54 */   private static HashMap options = new HashMap(6);
/*     */   private static final Logger log;
/*     */ 
/*     */   public static WSSecurityOMFactory newInstance()
/*     */   {
/*  79 */     return new WSSecurityOMFactory();
/*     */   }
/*     */ 
/*     */   public WSSecurityConfiguration parse(URL configURL) throws IOException
/*     */   {
/*  84 */     if (configURL == null) {
/*  85 */       throw new IllegalArgumentException("Security config URL cannot be null");
/*     */     }
/*  87 */     InputStream is = new ResourceURL(configURL).openStream();
/*     */     try
/*     */     {
/*  90 */       Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
/*  91 */       WSSecurityConfiguration configuration = (WSSecurityConfiguration)unmarshaller.unmarshal(is, this, null);
/*  92 */       WSSecurityConfiguration localWSSecurityConfiguration1 = configuration;
/*     */       return localWSSecurityConfiguration1;
/*     */     }
/*     */     catch (JBossXBException e)
/*     */     {
/*  96 */       IOException ioex = new IOException("Cannot parse: " + configURL);
/*  97 */       Throwable cause = e.getCause();
/*  98 */       if (cause != null)
/*  99 */         ioex.initCause(cause);
/* 100 */       throw ioex;
/*     */     }
/*     */     finally
/*     */     {
/* 104 */       is.close(); } throw localObject;
/*     */   }
/*     */ 
/*     */   public WSSecurityConfiguration parse(String xmlString)
/*     */     throws JBossXBException
/*     */   {
/* 110 */     if (xmlString == null) {
/* 111 */       throw new IllegalArgumentException("Security config xml String cannot be null");
/*     */     }
/* 113 */     Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
/* 114 */     WSSecurityConfiguration configuration = (WSSecurityConfiguration)unmarshaller.unmarshal(xmlString, this, null);
/* 115 */     return configuration;
/*     */   }
/*     */ 
/*     */   public WSSecurityConfiguration parse(StringReader strReader)
/*     */     throws JBossXBException
/*     */   {
/* 121 */     if (strReader == null) {
/* 122 */       throw new IllegalArgumentException("Security InputStream cannot be null");
/*     */     }
/* 124 */     Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
/* 125 */     WSSecurityConfiguration configuration = (WSSecurityConfiguration)unmarshaller.unmarshal(strReader, this, null);
/* 126 */     return configuration;
/*     */   }
/*     */ 
/*     */   public Object newRoot(Object root, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/* 135 */     return new WSSecurityConfiguration();
/*     */   }
/*     */ 
/*     */   public Object completeRoot(Object root, UnmarshallingContext ctx, String uri, String name)
/*     */   {
/* 140 */     return root;
/*     */   }
/*     */ 
/*     */   public void setValue(WSSecurityConfiguration configuration, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*     */   {
/* 145 */     log.trace("setValue: [obj=" + configuration + ",value=" + value + "]");
/* 146 */     String method = (String)options.get(localName);
/* 147 */     if (method == null) {
/* 148 */       return;
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 153 */       WSSecurityConfiguration.class.getMethod(method, new Class[] { String.class }).invoke(configuration, new Object[] { value });
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 157 */       log.error("Could not set option: " + method + " to: " + value, e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object newChild(WSSecurityConfiguration configuration, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/* 166 */     log.trace("newChild: " + localName);
/* 167 */     if ("config".equals(localName))
/*     */     {
/* 169 */       return new Config();
/*     */     }
/* 171 */     if ("key-passwords".equals(localName))
/*     */     {
/* 173 */       HashMap pwds = new HashMap();
/* 174 */       configuration.setKeyPasswords(pwds);
/* 175 */       return pwds;
/*     */     }
/* 177 */     if ("port".equals(localName))
/*     */     {
/* 179 */       return new Port(attrs.getValue("", "name"));
/*     */     }
/* 181 */     return null;
/*     */   }
/*     */ 
/*     */   public Object newChild(HashMap passwords, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/* 189 */     log.trace("newChild: " + localName);
/* 190 */     if ("key-password".equals(localName))
/*     */     {
/* 192 */       String alias = attrs.getValue("", "alias");
/* 193 */       String pwd = attrs.getValue("", "password");
/* 194 */       passwords.put(alias, pwd);
/*     */     }
/* 196 */     return null;
/*     */   }
/*     */ 
/*     */   public void addChild(WSSecurityConfiguration configuration, Config defaultConfig, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 204 */     log.trace("addChild: [obj=" + configuration + ",child=" + defaultConfig + "]");
/* 205 */     configuration.setDefaultConfig(defaultConfig);
/*     */   }
/*     */ 
/*     */   public void addChild(WSSecurityConfiguration configuration, Port port, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 213 */     log.trace("addChild: [obj=" + configuration + ",child=" + port + "]");
/* 214 */     configuration.addPort(port);
/*     */   }
/*     */ 
/*     */   public Object newChild(Config config, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/* 222 */     log.trace("newChild: " + localName);
/* 223 */     if ("sign".equals(localName))
/*     */     {
/* 226 */       Boolean include = new Boolean(true);
/* 227 */       String timestamp = attrs.getValue("", "includeTimestamp");
/* 228 */       if (timestamp != null) {
/* 229 */         include = (Boolean)SimpleTypeBindings.unmarshal(timestamp, "boolean", null);
/*     */       }
/* 231 */       return new Sign(attrs.getValue("", "type"), attrs.getValue("", "alias"), include.booleanValue());
/*     */     }
/* 233 */     if ("encrypt".equals(localName))
/*     */     {
/* 235 */       return new Encrypt(attrs.getValue("", "type"), attrs.getValue("", "alias"), attrs.getValue("", "algorithm"));
/*     */     }
/* 237 */     if ("timestamp".equals(localName))
/*     */     {
/* 239 */       return new Timestamp(attrs.getValue("", "ttl"));
/*     */     }
/* 241 */     if ("requires".equals(localName))
/*     */     {
/* 243 */       return new Requires();
/*     */     }
/* 245 */     if ("username".equals(localName))
/*     */     {
/* 247 */       return new Username();
/*     */     }
/*     */ 
/* 250 */     return null;
/*     */   }
/*     */ 
/*     */   public void addChild(Config config, Encrypt encrypt, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 258 */     log.trace("addChild: [obj=" + config + ",child=" + encrypt + "]");
/* 259 */     config.setEncrypt(encrypt);
/*     */   }
/*     */ 
/*     */   public void addChild(Config config, Sign sign, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 267 */     log.trace("addChild: [obj=" + config + ",child=" + sign + "]");
/* 268 */     config.setSign(sign);
/*     */   }
/*     */ 
/*     */   public void addChild(Config config, Timestamp timestamp, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 276 */     log.trace("addChild: [obj=" + config + ",child=" + timestamp + "]");
/* 277 */     config.setTimestamp(timestamp);
/*     */   }
/*     */ 
/*     */   public void addChild(Config config, Username username, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 285 */     log.trace("addChild: [obj=" + config + ",child=" + username + "]");
/* 286 */     config.setUsername(username);
/*     */   }
/*     */ 
/*     */   public void addChild(Config config, Requires requires, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 294 */     log.trace("addChild: [obj=" + config + ",child=" + requires + "]");
/* 295 */     config.setRequires(requires);
/*     */   }
/*     */ 
/*     */   private Object handleTargets(Object object, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/* 300 */     log.trace("newChild: " + localName);
/* 301 */     if ("target".equals(localName))
/*     */     {
/* 303 */       Target target = new Target(attrs.getValue("", "type"));
/* 304 */       if ("true".equals(attrs.getValue("", "contentOnly"))) {
/* 305 */         target.setContentOnly(true);
/*     */       }
/* 307 */       return target;
/*     */     }
/* 309 */     return null;
/*     */   }
/*     */ 
/*     */   public Object newChild(Encrypt encrypt, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/* 317 */     return handleTargets(encrypt, navigator, namespaceURI, localName, attrs);
/*     */   }
/*     */ 
/*     */   public Object newChild(Sign sign, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/* 325 */     return handleTargets(sign, navigator, namespaceURI, localName, attrs);
/*     */   }
/*     */ 
/*     */   public Object newChild(Requires requires, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/* 333 */     log.trace("newChild: " + localName);
/* 334 */     if ("signature".equals(localName))
/*     */     {
/* 336 */       return new RequireSignature();
/*     */     }
/* 338 */     if ("encryption".equals(localName))
/*     */     {
/* 340 */       return new RequireEncryption();
/*     */     }
/* 342 */     if ("timestamp".equals(localName))
/*     */     {
/* 344 */       return new RequireTimestamp(attrs.getValue("", "maxAge"));
/*     */     }
/*     */ 
/* 347 */     return null;
/*     */   }
/*     */ 
/*     */   public Object newChild(RequireSignature requireSignature, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/* 355 */     return handleTargets(requireSignature, navigator, namespaceURI, localName, attrs);
/*     */   }
/*     */ 
/*     */   public Object newChild(RequireEncryption requireEncryption, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/* 363 */     return handleTargets(requireEncryption, navigator, namespaceURI, localName, attrs);
/*     */   }
/*     */ 
/*     */   public void setValue(Target target, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*     */   {
/* 368 */     log.trace("setValue: [obj=" + target + ",value=" + value + "]");
/*     */ 
/* 370 */     target.setValue(value);
/*     */   }
/*     */ 
/*     */   public void addChild(Encrypt encrypt, Target target, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 378 */     log.trace("addChild: [obj=" + encrypt + ",child=" + target + "]");
/* 379 */     encrypt.addTarget(target);
/*     */   }
/*     */ 
/*     */   public void addChild(Sign sign, Target target, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 387 */     log.trace("addChild: [obj=" + sign + ",child=" + target + "]");
/* 388 */     sign.addTarget(target);
/*     */   }
/*     */ 
/*     */   public void addChild(Requires requires, RequireEncryption requireEncryption, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 396 */     log.trace("addChild: [obj=" + requires + ",child=" + requireEncryption + "]");
/* 397 */     requires.setRequireEncryption(requireEncryption);
/*     */   }
/*     */ 
/*     */   public void addChild(Requires requires, RequireSignature requireSignature, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 405 */     log.trace("addChild: [obj=" + requires + ",child=" + requireSignature + "]");
/* 406 */     requires.setRequireSignature(requireSignature);
/*     */   }
/*     */ 
/*     */   public void addChild(Requires requires, RequireTimestamp requireTimestamp, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 414 */     log.trace("addChild: [obj=" + requires + ",child=" + requireTimestamp + "]");
/* 415 */     requires.setRequireTimestamp(requireTimestamp);
/*     */   }
/*     */ 
/*     */   public void addChild(RequireEncryption requireEncryption, Target target, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 423 */     log.trace("addChild: [obj=" + requireEncryption + ",child=" + target + "]");
/* 424 */     requireEncryption.addTarget(target);
/*     */   }
/*     */ 
/*     */   public void addChild(RequireSignature requireSignature, Target target, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 432 */     log.trace("addChild: [obj=" + requireSignature + ",child=" + target + "]");
/* 433 */     requireSignature.addTarget(target);
/*     */   }
/*     */ 
/*     */   public Object newChild(Port port, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/* 441 */     log.trace("newChild: " + localName);
/* 442 */     if ("operation".equals(localName))
/*     */     {
/* 444 */       return new Operation(attrs.getValue("", "name"));
/*     */     }
/* 446 */     if ("config".equals(localName))
/*     */     {
/* 448 */       return new Config();
/*     */     }
/* 450 */     return null;
/*     */   }
/*     */ 
/*     */   public void addChild(Port port, Operation operation, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 458 */     log.trace("addChild: [obj=" + port + ",child=" + operation + "]");
/* 459 */     port.addOperation(operation);
/*     */   }
/*     */ 
/*     */   public void addChild(Port port, Config config, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 467 */     log.trace("addChild: [obj=" + port + ",child=" + config + "]");
/* 468 */     port.setDefaultConfig(config);
/*     */   }
/*     */ 
/*     */   public Object newChild(Operation operation, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/* 476 */     log.trace("newChild: " + localName);
/* 477 */     if ("config".equals(localName))
/*     */     {
/* 479 */       return new Config();
/*     */     }
/* 481 */     return null;
/*     */   }
/*     */ 
/*     */   public void addChild(Operation operation, Config config, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 489 */     log.trace("addChild: [obj=" + operation + ",child=" + config + "]");
/* 490 */     operation.setConfig(config);
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  58 */     options.put("key-store-file", "setKeyStoreFile");
/*  59 */     options.put("key-store-type", "setKeyStoreType");
/*  60 */     options.put("key-store-password", "setKeyStorePassword");
/*  61 */     options.put("trust-store-file", "setTrustStoreFile");
/*  62 */     options.put("trust-store-type", "setTrustStoreType");
/*  63 */     options.put("trust-store-password", "setTrustStorePassword");
/*     */ 
/*  67 */     log = Logger.getLogger(WSSecurityOMFactory.class);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.metadata.wsse.WSSecurityOMFactory
 * JD-Core Version:    0.6.0
 */