/*     */ package org.jboss.ws.metadata.wsse;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URL;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
/*     */ 
/*     */ public class WSSecurityConfigFactory
/*     */ {
/*  44 */   final Logger log = Logger.getLogger(WSSecurityConfigFactory.class);
/*     */ 
/*     */   public static WSSecurityConfigFactory newInstance()
/*     */   {
/*  48 */     return new WSSecurityConfigFactory();
/*     */   }
/*     */ 
/*     */   public WSSecurityConfiguration createConfiguration(UnifiedVirtualFile vfsRoot, String resourceName) throws IOException
/*     */   {
/*  53 */     URL configLocation = null;
/*     */     try
/*     */     {
/*  56 */       configLocation = new URL(resourceName);
/*     */     }
/*     */     catch (MalformedURLException ex)
/*     */     {
/*     */     }
/*     */ 
/*  63 */     if (configLocation == null) {
/*  64 */       configLocation = getResource(vfsRoot, "WEB-INF/" + resourceName, false);
/*     */     }
/*  66 */     if (configLocation == null) {
/*  67 */       configLocation = getResource(vfsRoot, "META-INF/" + resourceName, false);
/*     */     }
/*  69 */     WSSecurityConfiguration config = null;
/*  70 */     if (configLocation != null)
/*     */     {
/*  72 */       this.log.debug("createConfiguration from: " + configLocation);
/*  73 */       config = WSSecurityOMFactory.newInstance().parse(configLocation);
/*     */ 
/*  75 */       initKeystorePath(vfsRoot, config);
/*     */     }
/*     */     else
/*     */     {
/*  80 */       this.log.trace("Unable to load ws-security config (" + resourceName + "). Security processing will be disabled");
/*     */     }
/*     */ 
/*  83 */     return config;
/*     */   }
/*     */ 
/*     */   public void initKeystorePath(UnifiedVirtualFile vfsRoot, WSSecurityConfiguration config)
/*     */   {
/*  89 */     URL keystoreLocation = null;
/*  90 */     if (config.getKeyStoreFile() != null)
/*     */     {
/*  92 */       keystoreLocation = getResource(vfsRoot, config.getKeyStoreFile(), true);
/*  93 */       this.log.debug("Add keystore: " + keystoreLocation);
/*  94 */       config.setKeyStoreURL(keystoreLocation);
/*     */     }
/*     */ 
/*  97 */     URL truststoreLocation = null;
/*  98 */     if (config.getTrustStoreFile() != null)
/*     */     {
/* 100 */       truststoreLocation = getResource(vfsRoot, config.getTrustStoreFile(), true);
/* 101 */       this.log.debug("Add truststore: " + truststoreLocation);
/* 102 */       config.setTrustStoreURL(truststoreLocation);
/*     */     }
/*     */   }
/*     */ 
/*     */   private URL getResource(UnifiedVirtualFile vfsRoot, String resource, boolean failOnNotFound)
/*     */   {
/* 108 */     URL resourceURL = null;
/*     */     try
/*     */     {
/* 111 */       UnifiedVirtualFile child = vfsRoot.findChild(resource);
/* 112 */       resourceURL = child.toURL();
/*     */     }
/*     */     catch (IOException ex)
/*     */     {
/* 116 */       if (failOnNotFound)
/* 117 */         throw new WSException("Cannot find required security resource: " + resource);
/*     */     }
/* 119 */     return resourceURL;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.metadata.wsse.WSSecurityConfigFactory
 * JD-Core Version:    0.6.0
 */