/*     */ package org.jboss.ws.metadata.wsdl.xsd;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.FileWriter;
/*     */ import java.io.IOException;
/*     */ import java.io.OutputStream;
/*     */ import java.io.StringWriter;
/*     */ import java.io.Writer;
/*     */ import java.net.URL;
/*     */ import org.apache.xerces.xs.XSModel;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
/*     */ import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
/*     */ import org.jboss.ws.metadata.wsdl.xmlschema.WSSchemaUtils;
/*     */ 
/*     */ public class XSDWriter
/*     */ {
/*  45 */   protected static final Logger log = Logger.getLogger(XSDWriter.class);
/*     */ 
/*  47 */   protected WSDLDefinitions wsdl = null;
/*     */ 
/*  49 */   protected SchemaUtils schemautils = SchemaUtils.getInstance();
/*     */ 
/*  51 */   protected WSSchemaUtils sutils = WSSchemaUtils.getInstance(null, null);
/*     */ 
/*     */   public void writeXSD(Writer writer, XSModel xsmodel, WSDLDefinitions wsdl)
/*     */   {
/*  55 */     if (xsmodel == null) {
/*  56 */       throw new IllegalArgumentException("xsmodel is NULL");
/*     */     }
/*  58 */     this.wsdl = wsdl;
/*     */ 
/*  60 */     if (this.schemautils.isEmptySchema(xsmodel)) return;
/*     */   }
/*     */ 
/*     */   public URL serialize(XSModel xsmodel, String ns)
/*     */     throws IOException
/*     */   {
/*  73 */     if (ns == null)
/*  74 */       throw new IllegalArgumentException("Illegal Null Argument:ns");
/*  75 */     String xsdString = "";
/*  76 */     if ((xsmodel instanceof JBossXSModel))
/*     */     {
/*  78 */       JBossXSModel jbxs = (JBossXSModel)xsmodel;
/*  79 */       xsdString = jbxs.serialize();
/*     */     }
/*     */     else
/*     */     {
/*  84 */       StringWriter strwr = new StringWriter();
/*  85 */       this.sutils.serialize(xsmodel, strwr);
/*  86 */       xsdString = strwr.toString();
/*     */     }
/*     */ 
/*  89 */     log.trace("serialize:\n" + xsdString);
/*     */ 
/*  92 */     File xsdFile = SchemaUtils.getSchemaTempFile(ns);
/*  93 */     FileWriter writer = new FileWriter(xsdFile);
/*  94 */     writer.write(xsdString);
/*  95 */     writer.close();
/*     */ 
/*  97 */     return xsdFile.toURL();
/*     */   }
/*     */ 
/*     */   public void serialize(XSModel xsmodel, String ns, OutputStream os)
/*     */     throws IOException
/*     */   {
/* 111 */     StringWriter strwr = new StringWriter();
/* 112 */     this.sutils.serialize(xsmodel, strwr);
/* 113 */     String xsdString = strwr.toString();
/* 114 */     log.trace("serialize:" + xsdString);
/*     */ 
/* 116 */     os.write(xsdString.getBytes());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.metadata.wsdl.xsd.XSDWriter
 * JD-Core Version:    0.6.0
 */