/*     */ package org.jboss.ws.metadata.wsdl.xsd;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.IOException;
/*     */ import java.net.URL;
/*     */ import java.util.HashMap;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.apache.xerces.impl.dv.xs.SchemaDVFactoryImpl;
/*     */ import org.apache.xerces.impl.xs.XMLSchemaLoader;
/*     */ import org.apache.xerces.util.XMLGrammarPoolImpl;
/*     */ import org.apache.xerces.xni.parser.XMLEntityResolver;
/*     */ import org.apache.xerces.xni.parser.XMLErrorHandler;
/*     */ import org.apache.xerces.xs.StringList;
/*     */ import org.apache.xerces.xs.XSComplexTypeDefinition;
/*     */ import org.apache.xerces.xs.XSElementDeclaration;
/*     */ import org.apache.xerces.xs.XSLoader;
/*     */ import org.apache.xerces.xs.XSModel;
/*     */ import org.apache.xerces.xs.XSModelGroup;
/*     */ import org.apache.xerces.xs.XSNamedMap;
/*     */ import org.apache.xerces.xs.XSObjectList;
/*     */ import org.apache.xerces.xs.XSParticle;
/*     */ import org.apache.xerces.xs.XSSimpleTypeDefinition;
/*     */ import org.apache.xerces.xs.XSTerm;
/*     */ import org.apache.xerces.xs.XSTypeDefinition;
/*     */ import org.jboss.ws.Constants;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSComplexTypeDefinition;
/*     */ import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSElementDeclaration;
/*     */ import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSErrorHandler;
/*     */ import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSSimpleTypeDefinition;
/*     */ import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSStringList;
/*     */ import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSTypeDefinition;
/*     */ import org.jboss.wsf.spi.SPIProvider;
/*     */ import org.jboss.wsf.spi.SPIProviderResolver;
/*     */ import org.jboss.wsf.spi.management.ServerConfig;
/*     */ import org.jboss.wsf.spi.management.ServerConfigFactory;
/*     */ 
/*     */ public class SchemaUtils
/*     */ {
/*  71 */   private static SchemaUtils ourInstance = new SchemaUtils();
/*     */ 
/*  73 */   protected static String xsNS = "http://www.w3.org/2001/XMLSchema";
/*     */ 
/*  75 */   private static Map<Class, QName> toolsTypeMappingOverride = new HashMap();
/*     */ 
/*     */   public static SchemaUtils getInstance()
/*     */   {
/*  84 */     return ourInstance;
/*     */   }
/*     */ 
/*     */   public boolean isArrayType(XSParticle xsparticle)
/*     */   {
/* 100 */     int maxOccurs = xsparticle.getMaxOccurs();
/* 101 */     return (xsparticle.getMaxOccursUnbounded()) || (maxOccurs > 1);
/*     */   }
/*     */ 
/*     */   public static boolean isWrapperArrayType(XSTypeDefinition xst)
/*     */   {
/* 106 */     return unwrapArrayType(xst) != null;
/*     */   }
/*     */ 
/*     */   public static XSElementDeclaration unwrapArrayType(XSTypeDefinition xst)
/*     */   {
/* 111 */     if (!(xst instanceof XSComplexTypeDefinition)) {
/* 112 */       return null;
/*     */     }
/* 114 */     XSComplexTypeDefinition xc = (XSComplexTypeDefinition)xst;
/* 115 */     if (xc.getContentType() == 0) {
/* 116 */       return null;
/*     */     }
/* 118 */     XSParticle xsp = xc.getParticle();
/* 119 */     if (xsp == null) {
/* 120 */       return null;
/*     */     }
/* 122 */     XSTerm xsterm = xsp.getTerm();
/* 123 */     if (!(xsterm instanceof XSModelGroup)) {
/* 124 */       return null;
/*     */     }
/* 126 */     XSModelGroup xm = (XSModelGroup)xsterm;
/* 127 */     XSObjectList xo = xm.getParticles();
/* 128 */     if (xo.getLength() != 1) {
/* 129 */       return null;
/*     */     }
/* 131 */     XSParticle xp = (XSParticle)xo.item(0);
/* 132 */     XSTerm term = xp.getTerm();
/* 133 */     if (((xp.getMaxOccursUnbounded()) || (xp.getMaxOccurs() > 1) ? 1 : 0) != 0) { if ((term instanceof XSElementDeclaration)); } else return null;
/*     */ 
/* 136 */     return (XSElementDeclaration)term;
/*     */   }
/*     */ 
/*     */   public static QName handleSimpleType(XSSimpleTypeDefinition simple)
/*     */   {
/* 146 */     if (simple == null) {
/* 147 */       throw new IllegalArgumentException("XSSimpleTypeDefinition passed is null");
/*     */     }
/*     */ 
/* 150 */     if ("http://www.w3.org/2001/XMLSchema".equals(simple.getNamespace())) {
/* 151 */       return createQNameFromXSSimpleType(simple);
/*     */     }
/* 153 */     switch (simple.getVariety())
/*     */     {
/*     */     case 2:
/* 156 */       return handleSimpleType(simple.getItemType());
/*     */     case 3:
/* 158 */       XSObjectList list = simple.getMemberTypes();
/* 159 */       if (list.getLength() > 0)
/* 160 */         return handleSimpleType((XSSimpleTypeDefinition)list.item(0));
/* 161 */       throw new WSException("Empty union type not expected");
/*     */     case 0:
/* 163 */       throw new WSException("Absent variety is not supported in simple types");
/*     */     case 1:
/*     */     }
/* 166 */     XSTypeDefinition base = simple.getBaseType();
/* 167 */     while (!"http://www.w3.org/2001/XMLSchema".equals(base.getNamespace())) {
/* 168 */       base = base.getBaseType();
/*     */     }
/* 170 */     if (!(base instanceof XSSimpleTypeDefinition)) {
/* 171 */       throw new WSException("Expected base type to be a simple type");
/*     */     }
/* 173 */     return new QName(base.getNamespace(), base.getName());
/*     */   }
/*     */ 
/*     */   public QName patchXSDQName(QName qname)
/*     */   {
/* 183 */     if (qname == null)
/* 184 */       return null;
/* 185 */     return new QName("http://www.w3.org/2001/XMLSchema", qname.getLocalPart(), "xsd");
/*     */   }
/*     */ 
/*     */   public XSElementDeclaration createXSElementDeclaration(QName xmlName, XSTypeDefinition xst)
/*     */   {
/* 197 */     String name = xmlName.getLocalPart();
/* 198 */     String ns = xmlName.getNamespaceURI();
/* 199 */     JBossXSElementDeclaration jbel = new JBossXSElementDeclaration(name, ns);
/* 200 */     jbel.setTypeDefinition(xst);
/* 201 */     jbel.setScope(1);
/* 202 */     return jbel;
/*     */   }
/*     */ 
/*     */   public static QName createQNameFromXSSimpleType(XSSimpleTypeDefinition xs)
/*     */   {
/* 212 */     String nsuri = xs.getNamespace();
/* 213 */     String localpart = xs.getName();
/* 214 */     if (xsNS.equals(nsuri))
/* 215 */       return new QName(nsuri, localpart, "xsd");
/* 216 */     return new QName(nsuri, localpart);
/*     */   }
/*     */ 
/*     */   public QName getToolsOverrideInTypeMapping(Class javaType)
/*     */   {
/* 227 */     return (QName)toolsTypeMappingOverride.get(javaType);
/*     */   }
/*     */ 
/*     */   public boolean hasGlobalElement(QName xmlName, XSModel xsmodel)
/*     */   {
/* 238 */     if (xmlName == null)
/* 239 */       throw new IllegalArgumentException("xmlName is null");
/* 240 */     if (xsmodel == null)
/* 241 */       throw new IllegalArgumentException("XSModel is null");
/* 242 */     boolean bool = false;
/* 243 */     String name = xmlName.getLocalPart();
/* 244 */     if (name == null)
/* 245 */       throw new IllegalArgumentException("xmlName has a null name");
/* 246 */     String ns = xmlName.getNamespaceURI();
/* 247 */     if (ns == null)
/* 248 */       throw new IllegalArgumentException("xmlName has a null namespace");
/* 249 */     if (xsmodel.getElementDeclaration(name, ns) != null)
/* 250 */       bool = true;
/* 251 */     return bool;
/*     */   }
/*     */ 
/*     */   public boolean hasComplexTypeDefinition(QName xmlType, URL xsdLocation)
/*     */   {
/* 262 */     if (xsdLocation == null)
/* 263 */       throw new IllegalArgumentException("xsdLocation is null");
/* 264 */     XSModel xsmodel = parseSchema(xsdLocation);
/* 265 */     return hasComplexTypeDefinition(xmlType, xsmodel);
/*     */   }
/*     */ 
/*     */   public boolean hasGlobalElement(QName xmlName, URL xsdLocation)
/*     */   {
/* 276 */     if (xmlName == null)
/* 277 */       throw new IllegalArgumentException("xmlName is null");
/* 278 */     if (xsdLocation == null)
/* 279 */       throw new IllegalArgumentException("xsdLocation is null");
/* 280 */     XSModel xsmodel = parseSchema(xsdLocation);
/* 281 */     boolean bool = false;
/* 282 */     String name = xmlName.getLocalPart();
/* 283 */     if (name == null)
/* 284 */       throw new IllegalArgumentException("xmlName has a null name");
/* 285 */     String ns = xmlName.getNamespaceURI();
/* 286 */     if (ns == null)
/* 287 */       throw new IllegalArgumentException("xmlName has a null namespace");
/* 288 */     if (xsmodel.getElementDeclaration(name, ns) != null)
/* 289 */       bool = true;
/* 290 */     return bool;
/*     */   }
/*     */ 
/*     */   public boolean hasComplexTypeDefinition(QName xmlType, XSModel xsmodel)
/*     */   {
/* 301 */     if (xmlType == null)
/* 302 */       throw new IllegalArgumentException("xmlType is null");
/* 303 */     if (xsmodel == null)
/* 304 */       throw new IllegalArgumentException("XSModel is null");
/* 305 */     boolean bool = false;
/* 306 */     String name = xmlType.getLocalPart();
/* 307 */     if (name == null)
/* 308 */       throw new IllegalArgumentException("xmlName has a null name");
/* 309 */     String ns = xmlType.getNamespaceURI();
/* 310 */     if (ns == null)
/* 311 */       throw new IllegalArgumentException("xmlName has a null namespace");
/* 312 */     if (xsmodel.getTypeDefinition(name, ns) != null)
/* 313 */       bool = true;
/* 314 */     return bool;
/*     */   }
/*     */ 
/*     */   public String getFormattedString(XSTypeDefinition xstype)
/*     */   {
/* 324 */     String ns = xstype.getNamespace();
/* 325 */     String name = xstype.getName();
/* 326 */     if (!ns.equals(xsNS)) {
/* 327 */       name = getPrefix(ns) + ":" + name;
/*     */     }
/* 329 */     return name;
/*     */   }
/*     */ 
/*     */   public QName getQName(XSTypeDefinition xstype)
/*     */   {
/* 339 */     String prefix = null;
/* 340 */     String ns = xstype.getNamespace();
/* 341 */     String name = xstype.getName();
/* 342 */     if (!ns.equals(xsNS))
/* 343 */       prefix = "tns";
/* 344 */     else prefix = "xsd";
/*     */ 
/* 346 */     return new QName(ns, name, prefix);
/*     */   }
/*     */ 
/*     */   public JBossXSTypeDefinition getSchemaBasicType(String localpart)
/*     */   {
/* 357 */     JBossXSTypeDefinition xt = null;
/*     */ 
/* 361 */     if ("anyType".equals(localpart))
/*     */     {
/* 363 */       JBossXSComplexTypeDefinition ct = new JBossXSComplexTypeDefinition(localpart, "http://www.w3.org/2001/XMLSchema");
/* 364 */       ct.setContentType(0);
/* 365 */       xt = ct;
/*     */     }
/*     */     else
/*     */     {
/* 369 */       XSSimpleTypeDefinition xstype = new SchemaDVFactoryImpl().getBuiltInType(localpart);
/* 370 */       xt = new JBossXSSimpleTypeDefinition(xstype);
/*     */     }
/*     */ 
/* 373 */     return xt;
/*     */   }
/*     */ 
/*     */   public XSLoader getXSLoader()
/*     */   {
/* 384 */     XMLSchemaLoader xsloader = new XMLSchemaLoader();
/* 385 */     JBossXSErrorHandler eh = new JBossXSErrorHandler();
/* 386 */     xsloader.setErrorHandler(eh);
/* 387 */     xsloader.setProperty("http://apache.org/xml/properties/internal/grammar-pool", new XMLGrammarPoolImpl());
/* 388 */     return xsloader;
/*     */   }
/*     */ 
/*     */   public XSLoader getXSLoader(XMLErrorHandler xeh, XMLEntityResolver xer)
/*     */   {
/* 400 */     XMLSchemaLoader xsloader = new XMLSchemaLoader();
/* 401 */     xsloader.setEntityResolver(xer);
/* 402 */     xsloader.setErrorHandler(xeh);
/* 403 */     xsloader.setProperty("http://apache.org/xml/properties/internal/grammar-pool", new XMLGrammarPoolImpl());
/* 404 */     return xsloader;
/*     */   }
/*     */ 
/*     */   public XSModel parseSchema(URL schemaLoc)
/*     */   {
/* 414 */     return parseSchema(schemaLoc.toExternalForm());
/*     */   }
/*     */ 
/*     */   public XSModel parseSchema(String schemaLoc)
/*     */   {
/* 424 */     XSLoader xsloader = getXSLoader();
/* 425 */     XSModel xsModel = xsloader.loadURI(schemaLoc);
/* 426 */     if (xsModel == null)
/* 427 */       throw new WSException("Cannot parse schema: " + schemaLoc);
/* 428 */     return xsModel;
/*     */   }
/*     */ 
/*     */   public XSModel parseSchema(List<String> locations)
/*     */   {
/* 440 */     JBossXSStringList slist = new JBossXSStringList(locations);
/* 441 */     XSLoader xsloader = getXSLoader();
/* 442 */     return xsloader.loadURIList(slist);
/*     */   }
/*     */ 
/*     */   public boolean isEmptySchema(XSModel xsmodel)
/*     */   {
/* 452 */     if (xsmodel == null)
/* 453 */       return true;
/* 454 */     String targetNS = getTargetNamespace(xsmodel);
/* 455 */     if (targetNS == null)
/* 456 */       throw new WSException("Target Namespace of xsmodel is null");
/* 457 */     XSNamedMap tmap = xsmodel.getComponentsByNamespace(3, targetNS);
/* 458 */     XSNamedMap emap = xsmodel.getComponentsByNamespace(2, targetNS);
/*     */ 
/* 460 */     if ((tmap != null) && (tmap.getLength() > 0)) {
/* 461 */       return false;
/*     */     }
/* 463 */     return (emap == null) || (emap.getLength() <= 0);
/*     */   }
/*     */ 
/*     */   public boolean isEmptySchema(XSModel xsmodel, String namespace)
/*     */   {
/* 476 */     if (xsmodel == null)
/* 477 */       return true;
/* 478 */     if (namespace == null)
/* 479 */       throw new WSException("Target Namespace of xsmodel is null");
/* 480 */     XSNamedMap tmap = xsmodel.getComponentsByNamespace(3, namespace);
/* 481 */     XSNamedMap emap = xsmodel.getComponentsByNamespace(2, namespace);
/*     */ 
/* 483 */     if ((tmap != null) && (tmap.getLength() > 0)) {
/* 484 */       return false;
/*     */     }
/* 486 */     return (emap == null) || (emap.getLength() <= 0);
/*     */   }
/*     */ 
/*     */   public static String getSchemaDefinitions(String targetNS)
/*     */   {
/* 498 */     StringBuilder buffer = new StringBuilder();
/* 499 */     buffer.append(" targetNamespace='" + targetNS + "'");
/* 500 */     buffer.append(" xmlns='http://www.w3.org/2001/XMLSchema'");
/* 501 */     buffer.append(" xmlns:soap11-enc='http://schemas.xmlsoap.org/soap/encoding/'");
/* 502 */     buffer.append(" xmlns:tns='" + targetNS + "'");
/*     */ 
/* 504 */     buffer.append(" xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'");
/* 505 */     buffer.append(">");
/* 506 */     return buffer.toString();
/*     */   }
/*     */ 
/*     */   public static File getSchemaTempFile(String targetNS)
/*     */     throws IOException
/*     */   {
/* 513 */     if (targetNS.length() == 0) {
/* 514 */       throw new IllegalArgumentException("Invalid null target namespace");
/*     */     }
/* 516 */     String fname = targetNS;
/* 517 */     if (fname.indexOf("://") > 0) {
/* 518 */       fname = fname.substring(fname.indexOf("://") + 3);
/*     */     }
/* 520 */     File tmpdir = null;
/*     */     try
/*     */     {
/* 523 */       SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
/* 524 */       ServerConfig serverConfig = ((ServerConfigFactory)spiProvider.getSPI(ServerConfigFactory.class)).getServerConfig(); File tmpDir = serverConfig.getServerTempDir();
/* 525 */       tmpdir = serverConfig.getServerTempDir();
/* 526 */       tmpdir = new File(tmpdir.getCanonicalPath() + "/jbossws");
/* 527 */       tmpdir.mkdirs();
/*     */     }
/*     */     catch (Throwable th)
/*     */     {
/*     */     }
/*     */ 
/* 535 */     fname = fname.replace('/', '_');
/* 536 */     fname = fname.replace(':', '_');
/* 537 */     File file = File.createTempFile("JBossWS_" + fname, ".xsd", tmpdir);
/* 538 */     return file;
/*     */   }
/*     */ 
/*     */   public static String getTargetNamespace(XSModel xsmodel)
/*     */   {
/* 546 */     if (xsmodel == null)
/* 547 */       throw new IllegalArgumentException("Illegal Null Argument: xsmodel");
/* 548 */     String targetNS = null;
/* 549 */     StringList slist = xsmodel.getNamespaces();
/* 550 */     int len = slist != null ? slist.getLength() : 0;
/* 551 */     for (int i = 0; i < len; i++)
/*     */     {
/* 553 */       String ns = slist.item(i);
/* 554 */       if ("http://www.w3.org/2001/XMLSchema".equals(ns))
/*     */         continue;
/* 556 */       targetNS = ns;
/* 557 */       break;
/*     */     }
/* 559 */     return targetNS;
/*     */   }
/*     */ 
/*     */   private String getPrefix(String namespace)
/*     */   {
/* 564 */     if ("http://schemas.xmlsoap.org/soap/encoding/".equals(namespace))
/* 565 */       return "soap11-enc";
/* 566 */     if (("http://schemas.xmlsoap.org/soap/envelope/".equals(namespace)) || ("http://www.w3.org/2003/05/soap-envelope".equals(namespace))) {
/* 567 */       return "env";
/*     */     }
/*     */ 
/* 570 */     return "tns";
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  79 */     toolsTypeMappingOverride.put([B.class, Constants.TYPE_LITERAL_BASE64BINARY);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.metadata.wsdl.xsd.SchemaUtils
 * JD-Core Version:    0.6.0
 */