/*     */ package org.jboss.ws.metadata.wsdl.xmlschema;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.Writer;
/*     */ import java.util.Arrays;
/*     */ import java.util.List;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.apache.xerces.xs.StringList;
/*     */ import org.apache.xerces.xs.XSAnnotation;
/*     */ import org.apache.xerces.xs.XSAttributeDeclaration;
/*     */ import org.apache.xerces.xs.XSAttributeUse;
/*     */ import org.apache.xerces.xs.XSComplexTypeDefinition;
/*     */ import org.apache.xerces.xs.XSElementDeclaration;
/*     */ import org.apache.xerces.xs.XSModel;
/*     */ import org.apache.xerces.xs.XSModelGroup;
/*     */ import org.apache.xerces.xs.XSNamedMap;
/*     */ import org.apache.xerces.xs.XSNamespaceItem;
/*     */ import org.apache.xerces.xs.XSNamespaceItemList;
/*     */ import org.apache.xerces.xs.XSObjectList;
/*     */ import org.apache.xerces.xs.XSParticle;
/*     */ import org.apache.xerces.xs.XSSimpleTypeDefinition;
/*     */ import org.apache.xerces.xs.XSTerm;
/*     */ import org.apache.xerces.xs.XSTypeDefinition;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.metadata.wsdl.xsd.SchemaUtils;
/*     */ import org.jboss.wsf.common.DOMWriter;
/*     */ import org.jboss.xb.binding.NamespaceRegistry;
/*     */ 
/*     */ public class WSSchemaUtils
/*     */ {
/*     */   private static final String xsNS = "http://www.w3.org/2001/XMLSchema";
/*  63 */   private static SchemaUtils utils = SchemaUtils.getInstance();
/*     */   private NamespaceRegistry namespaceRegistry;
/*  67 */   private String targetNamespace = null;
/*     */ 
/*     */   public static WSSchemaUtils getInstance(NamespaceRegistry namespaceRegistry, String targetNamespace)
/*     */   {
/*  71 */     return new WSSchemaUtils(namespaceRegistry, targetNamespace);
/*     */   }
/*     */ 
/*     */   private WSSchemaUtils(NamespaceRegistry namespaceRegistry, String targetNamespace)
/*     */   {
/*  76 */     this.namespaceRegistry = namespaceRegistry;
/*  77 */     this.targetNamespace = targetNamespace;
/*     */   }
/*     */ 
/*     */   public boolean checkCustomNamespace(String targetNS, String checkNS)
/*     */   {
/*  89 */     String[] nsarr = { "http://www.w3.org/2001/XMLSchema", "http://www.w3.org/2001/XMLSchema-instance" };
/*  90 */     List knownNamespaces = Arrays.asList(nsarr);
/*  91 */     boolean isCustom = false;
/*  92 */     if ("http://www.w3.org/2001/XMLSchema".equals(targetNS))
/*  93 */       throw new IllegalArgumentException("targetNamespace cannot be http://www.w3.org/2001/XMLSchema");
/*  94 */     if (checkNS == null)
/*  95 */       throw new IllegalArgumentException("checkNS is null");
/*  96 */     if ((!knownNamespaces.contains(checkNS)) && (!targetNS.equals(checkNS)))
/*  97 */       isCustom = true;
/*  98 */     return isCustom;
/*     */   }
/*     */ 
/*     */   public JBossXSElementDeclaration createGlobalXSElementDeclaration(String name, XSTypeDefinition xstype, String targetNS)
/*     */   {
/* 111 */     JBossXSElementDeclaration xsel = new JBossXSElementDeclaration();
/* 112 */     xsel.setName(name);
/* 113 */     xsel.setTypeDefinition(xstype);
/* 114 */     xsel.setTargetNamespace(targetNS);
/* 115 */     xsel.setNamespace(targetNS);
/* 116 */     xsel.setScope(1);
/* 117 */     return xsel;
/*     */   }
/*     */ 
/*     */   public JBossXSModel createXSModel()
/*     */   {
/* 127 */     return new JBossXSModel();
/*     */   }
/*     */ 
/*     */   public JBossXSComplexTypeDefinition createXSComplexTypeDefinition(String name, XSTypeDefinition baseType, List<XSParticle> xsparts, String typens)
/*     */   {
/* 133 */     if (xsparts == null) {
/* 134 */       return null;
/*     */     }
/* 136 */     JBossXSComplexTypeDefinition ct = new JBossXSComplexTypeDefinition();
/* 137 */     ct.setName(name);
/* 138 */     ct.setNamespace(typens);
/* 139 */     JBossXSModelGroup group = new JBossXSModelGroup();
/*     */ 
/* 141 */     group.setCompositor(1);
/* 142 */     group.setParticles(xsparts);
/*     */ 
/* 144 */     JBossXSParticle xspa = new JBossXSParticle(null, typens);
/* 145 */     xspa.setTerm(group);
/* 146 */     ct.setParticle(xspa);
/*     */ 
/* 148 */     if (baseType != null)
/*     */     {
/* 150 */       ct.setDerivationMethod(1);
/* 151 */       ct.setBaseType(baseType);
/*     */     }
/*     */ 
/* 154 */     return ct;
/*     */   }
/*     */ 
/*     */   public JBossXSElementDeclaration createXSElementDeclaration(String name, XSTypeDefinition xstype, boolean isNillable)
/*     */   {
/* 168 */     JBossXSElementDeclaration xsel = new JBossXSElementDeclaration();
/* 169 */     xsel.setName(name);
/* 170 */     xsel.setTypeDefinition(xstype);
/* 171 */     xsel.setNillable(isNillable);
/* 172 */     return xsel;
/*     */   }
/*     */ 
/*     */   public JBossXSParticle createXSParticle(String targetNS, boolean isArray, XSTerm xsterm)
/*     */   {
/* 177 */     JBossXSParticle xsp = new JBossXSParticle(null, targetNS);
/* 178 */     if (isArray)
/* 179 */       xsp.setMaxOccurs(-1);
/* 180 */     xsp.setTerm(xsterm);
/* 181 */     return xsp;
/*     */   }
/*     */ 
/*     */   public JBossXSTypeDefinition createXSTypeDefinition(QName qname)
/*     */   {
/* 192 */     JBossXSTypeDefinition jbxs = new JBossXSTypeDefinition();
/* 193 */     jbxs.setName(qname.getLocalPart());
/* 194 */     jbxs.setNamespace(qname.getNamespaceURI());
/* 195 */     return jbxs;
/*     */   }
/*     */ 
/*     */   public XSComplexTypeDefinition getExceptionType(String exname, String ns)
/*     */   {
/* 207 */     JBossXSParticle xsp = new JBossXSParticle();
/*     */ 
/* 213 */     XSComplexTypeDefinition ct = new JBossXSComplexTypeDefinition(exname, ns);
/*     */ 
/* 215 */     ((JBossXSComplexTypeDefinition)ct).setParticle(xsp);
/* 216 */     return ct;
/*     */   }
/*     */ 
/*     */   public JBossXSModel getJBossXSModel(XSModel xsmodel)
/*     */   {
/* 228 */     if ((xsmodel instanceof JBossXSModel))
/* 229 */       return (JBossXSModel)xsmodel;
/* 230 */     JBossXSModel jbxs = new JBossXSModel();
/* 231 */     copyXSModel(xsmodel, jbxs);
/* 232 */     return jbxs;
/*     */   }
/*     */ 
/*     */   public boolean isEmptySchema(JBossXSModel xsmodel, String namespace)
/*     */   {
/* 243 */     if (xsmodel == null)
/* 244 */       return true;
/* 245 */     if (namespace == null)
/* 246 */       throw new WSException("Target Namespace of xsmodel is null");
/* 247 */     XSNamedMap tmap = xsmodel.getComponentsByNamespace(3, namespace);
/* 248 */     XSNamedMap emap = xsmodel.getComponentsByNamespace(2, namespace);
/*     */ 
/* 250 */     if ((tmap != null) && (tmap.getLength() > 0)) {
/* 251 */       return false;
/*     */     }
/* 253 */     return (emap == null) || (emap.getLength() <= 0);
/*     */   }
/*     */ 
/*     */   public void serialize(XSModel xsmodel, Writer writer)
/*     */     throws IOException
/*     */   {
/* 266 */     StringBuilder buffer = new StringBuilder();
/* 267 */     if ((xsmodel instanceof JBossXSModel))
/*     */     {
/* 269 */       String str = ((JBossXSModel)xsmodel).serialize();
/* 270 */       buffer.append(str);
/*     */     }
/*     */     else
/*     */     {
/* 274 */       buffer.append("<schema ");
/* 275 */       XSNamespaceItemList itemlist = xsmodel.getNamespaceItems();
/* 276 */       appendSchemaDefinitions(buffer, itemlist);
/* 277 */       appendTypes(buffer, xsmodel);
/* 278 */       appendGlobalElements(buffer, xsmodel);
/* 279 */       buffer.append("</schema>");
/*     */     }
/* 281 */     writer.write(buffer.toString());
/*     */   }
/*     */ 
/*     */   public void serializeEmptySchema(XSModel xsmodel, Writer writer)
/*     */     throws IOException
/*     */   {
/* 293 */     StringBuilder buffer = new StringBuilder();
/* 294 */     buffer.append("<schema ");
/* 295 */     XSNamespaceItemList itemlist = xsmodel.getNamespaceItems();
/* 296 */     appendSchemaDefinitions(buffer, itemlist);
/* 297 */     appendTypes(buffer, xsmodel);
/* 298 */     appendGlobalElements(buffer, xsmodel);
/* 299 */     buffer.append("</schema>");
/* 300 */     writer.write(buffer.toString());
/*     */   }
/*     */ 
/*     */   public String write(XSElementDeclaration xsel, XSParticle xsp)
/*     */   {
/* 312 */     XSTypeDefinition xst = xsel.getTypeDefinition();
/* 313 */     if (xst == null) {
/* 314 */       throw new IllegalStateException("Type xst is null");
/*     */     }
/* 316 */     boolean isGlobalRef = xsel.getScope() == 1;
/* 317 */     boolean isAnonType = xst.getAnonymous();
/*     */ 
/* 319 */     StringBuilder buf = new StringBuilder();
/* 320 */     String elname = xsel.getName();
/* 321 */     String prefix = null;
/*     */ 
/* 323 */     if (isGlobalRef)
/*     */     {
/* 325 */       String namespace = xsel.getNamespace();
/* 326 */       prefix = getPrefix(namespace);
/* 327 */       buf.append("<element ref='" + prefix + ":" + elname + "'");
/*     */     }
/*     */     else
/*     */     {
/* 331 */       String namespace = xst.getNamespace();
/* 332 */       String typename = xst.getName();
/*     */ 
/* 334 */       if (!"http://www.w3.org/2001/XMLSchema".equals(namespace))
/*     */       {
/* 336 */         prefix = getPrefix(namespace);
/* 337 */         typename = prefix + ":" + typename;
/*     */       }
/* 339 */       buf.append("<element name='" + elname + "'");
/*     */ 
/* 341 */       if (!isAnonType) {
/* 342 */         buf.append(" type='" + typename + "' ");
/*     */       }
/*     */     }
/* 345 */     if (xsel.getNillable()) {
/* 346 */       buf.append(" nillable='true' ");
/*     */     }
/* 348 */     int minoccurs = xsp.getMinOccurs();
/* 349 */     int maxoccurs = xsp.getMaxOccurs();
/* 350 */     if (((minoccurs != 0) || (maxoccurs != 0)) && ((minoccurs != 1) || (maxoccurs != 1)))
/*     */     {
/* 352 */       if (xsp.getMaxOccursUnbounded())
/* 353 */         buf.append(" maxOccurs='unbounded' ");
/* 354 */       else buf.append(" maxOccurs='" + xsp.getMaxOccurs() + "'");
/*     */ 
/* 356 */       buf.append(" minOccurs='" + xsp.getMinOccurs() + "'");
/*     */     }
/*     */ 
/* 359 */     if ((!isAnonType) || (isGlobalRef == true))
/* 360 */       buf.append("/>");
/* 361 */     else buf.append(">").append(write(xst)).append("</element>");
/*     */ 
/* 363 */     return buf.toString();
/*     */   }
/*     */ 
/*     */   public String write(XSAttributeDeclaration decl)
/*     */   {
/* 368 */     XSTypeDefinition xst = decl.getTypeDefinition();
/* 369 */     if (xst == null) {
/* 370 */       throw new IllegalStateException("Type xst is null");
/*     */     }
/* 372 */     boolean isGlobalRef = decl.getScope() == 1;
/* 373 */     boolean isAnonType = xst.getAnonymous();
/*     */ 
/* 375 */     StringBuilder buf = new StringBuilder();
/* 376 */     String name = decl.getName();
/* 377 */     String prefix = null;
/*     */ 
/* 379 */     if (isGlobalRef)
/*     */     {
/* 381 */       String namespace = decl.getNamespace();
/* 382 */       prefix = getPrefix(namespace);
/* 383 */       buf.append("<attribute ref='" + prefix + ":" + name + "'");
/*     */     }
/*     */     else
/*     */     {
/* 387 */       String namespace = xst.getNamespace();
/* 388 */       String typename = xst.getName();
/*     */ 
/* 390 */       if (!"http://www.w3.org/2001/XMLSchema".equals(namespace))
/*     */       {
/* 392 */         prefix = getPrefix(namespace);
/* 393 */         typename = prefix + ":" + typename;
/*     */       }
/* 395 */       buf.append("<attribute name='" + name + "'");
/*     */ 
/* 397 */       if (!isAnonType) {
/* 398 */         buf.append(" type='" + typename + "' ");
/*     */       }
/*     */     }
/* 401 */     if (!isAnonType)
/* 402 */       buf.append("/>");
/* 403 */     else buf.append(">").append(write(xst)).append("</attribute>");
/*     */ 
/* 405 */     return buf.toString();
/*     */   }
/*     */ 
/*     */   public String write(XSElementDeclaration xsel)
/*     */   {
/* 416 */     boolean isAnonType = false;
/* 417 */     if (1 != xsel.getScope()) {
/* 418 */       throw new IllegalArgumentException("Element is not a global element");
/*     */     }
/* 420 */     StringBuilder buf = new StringBuilder();
/* 421 */     String elname = xsel.getName();
/* 422 */     XSTypeDefinition xst = xsel.getTypeDefinition();
/* 423 */     isAnonType = xst.getAnonymous();
/* 424 */     String typename = xst.getName();
/* 425 */     String namespace = xst.getNamespace();
/* 426 */     String prefix = null;
/*     */ 
/* 428 */     if (!"http://www.w3.org/2001/XMLSchema".equals(namespace))
/*     */     {
/* 430 */       prefix = getPrefix(namespace);
/* 431 */       typename = prefix + ":" + typename;
/*     */     }
/*     */ 
/* 434 */     buf.append("<element name='" + elname + "'");
/* 435 */     if (!isAnonType)
/* 436 */       buf.append(" type='" + typename + "' ");
/* 437 */     else buf.append(">").append(write(xst));
/*     */ 
/* 439 */     if ((xsel.getNillable()) && (xsel.getScope() != 1))
/* 440 */       buf.append(" nillable='true' ");
/* 441 */     if (!isAnonType)
/* 442 */       buf.append("/>");
/* 443 */     else buf.append("</element>");
/*     */ 
/* 445 */     return buf.toString();
/*     */   }
/*     */ 
/*     */   public String write(XSModelGroup xsm)
/*     */   {
/* 455 */     StringBuilder buf = new StringBuilder();
/* 456 */     XSObjectList objlist = xsm.getParticles();
/*     */ 
/* 458 */     int lenobj = objlist != null ? objlist.getLength() : 0;
/*     */ 
/* 460 */     for (int i = 0; i < lenobj; i++)
/*     */     {
/* 462 */       XSParticle jxsp = (XSParticle)objlist.item(i);
/* 463 */       XSTerm xterm = jxsp.getTerm();
/* 464 */       short termType = xterm.getType();
/* 465 */       if (termType == 2)
/*     */       {
/* 467 */         XSElementDeclaration xsel = (XSElementDeclaration)jxsp.getTerm();
/* 468 */         buf.append(write(xsel, jxsp));
/*     */       } else {
/* 470 */         if (termType != 7)
/*     */           continue;
/* 472 */         XSObjectList olist = ((XSModelGroup)xterm).getParticles();
/* 473 */         int lobj = olist != null ? olist.getLength() : 0;
/* 474 */         for (int k = 0; k < lobj; k++)
/*     */         {
/* 476 */           XSParticle jxp = (XSParticle)olist.item(k);
/* 477 */           XSTerm xsterm = jxp.getTerm();
/* 478 */           termType = xsterm.getType();
/* 479 */           if (termType == 2)
/* 480 */             buf.append(write((XSElementDeclaration)xsterm, jxsp));
/* 481 */           else if ((termType == 7) && (k > 0))
/* 482 */             buf.append(write((XSModelGroup)xsterm));
/*     */         }
/*     */       }
/*     */     }
/* 486 */     return buf.toString();
/*     */   }
/*     */ 
/*     */   public String write(XSTypeDefinition xstype)
/*     */   {
/* 496 */     StringBuilder buf = new StringBuilder();
/*     */ 
/* 499 */     if ((xstype instanceof XSComplexTypeDefinition))
/*     */     {
/* 501 */       XSComplexTypeDefinition jxstype = (XSComplexTypeDefinition)xstype;
/* 502 */       String jxsTypeName = jxstype.getName();
/* 503 */       boolean isSimple = jxstype.getContentType() == 1;
/*     */ 
/* 505 */       if (xstype.getAnonymous())
/* 506 */         buf.append("<complexType>");
/* 507 */       else buf.append("<complexType name='" + jxsTypeName + "'>");
/*     */ 
/* 509 */       XSTypeDefinition xsbase = jxstype.getBaseType();
/* 510 */       String baseType = null;
/* 511 */       if ((xsbase != null) && (!"anyType".equals(xsbase.getName()))) {
/* 512 */         baseType = getPrefix(xsbase.getNamespace()) + ":" + xsbase.getName();
/*     */       }
/* 514 */       if (baseType != null)
/*     */       {
/* 516 */         buf.append(isSimple ? "<simpleContent>" : "<complexContent>");
/* 517 */         buf.append("<extension base='" + baseType + "'>");
/*     */       }
/*     */ 
/* 520 */       XSParticle xsp = jxstype.getParticle();
/* 521 */       if (xsp != null) {
/* 522 */         appendComplexTypeDefinition(buf, jxstype);
/*     */       }
/* 524 */       XSObjectList list = jxstype.getAttributeUses();
/* 525 */       for (int i = 0; i < list.getLength(); i++)
/*     */       {
/* 527 */         XSAttributeUse use = (XSAttributeUse)list.item(i);
/* 528 */         XSAttributeDeclaration decl = use.getAttrDeclaration();
/* 529 */         buf.append(write(decl));
/*     */       }
/*     */ 
/* 532 */       if (baseType != null)
/*     */       {
/* 534 */         buf.append("</extension>");
/* 535 */         buf.append(isSimple ? "</simpleContent>" : "</complexContent>");
/*     */       }
/*     */ 
/* 538 */       buf.append("</complexType>");
/*     */     }
/* 541 */     else if ((xstype instanceof XSSimpleTypeDefinition))
/*     */     {
/* 543 */       XSTypeDefinition xsbase = xstype.getBaseType();
/* 544 */       buf.append("<simpleType name='" + xstype.getName() + "'>");
/* 545 */       if ((xsbase != null) && (!"anyType".equals(xsbase.getName())))
/*     */       {
/* 547 */         String baseType = xsbase.getName();
/* 548 */         String ns = xsbase.getNamespace();
/* 549 */         if (!"http://www.w3.org/2001/XMLSchema".equals(ns))
/*     */         {
/* 551 */           String prefix = getPrefix(ns);
/* 552 */           baseType = prefix + ":" + baseType;
/*     */         }
/*     */ 
/* 556 */         buf.append("<restriction base='" + baseType + "'>");
/* 557 */         StringList list = ((XSSimpleTypeDefinition)xstype).getLexicalEnumeration();
/* 558 */         for (int i = 0; i < list.getLength(); i++)
/*     */         {
/* 560 */           String listItem = DOMWriter.normalize(list.item(i), false);
/* 561 */           buf.append("<enumeration value='" + listItem + "'/>");
/*     */         }
/* 563 */         buf.append("</restriction>");
/*     */       }
/* 565 */       buf.append("</simpleType>");
/*     */     }
/*     */ 
/* 568 */     return buf.toString();
/*     */   }
/*     */ 
/*     */   private void appendSchemaDefinitions(StringBuilder buffer, XSNamespaceItemList itemlist)
/*     */   {
/* 575 */     int len = itemlist != null ? itemlist.getLength() : 0;
/*     */ 
/* 577 */     for (int i = 0; i < len; i++)
/*     */     {
/* 579 */       XSNamespaceItem nsitem = itemlist.item(i);
/* 580 */       String ns = nsitem.getSchemaNamespace();
/*     */ 
/* 583 */       if ("http://www.w3.org/2001/XMLSchema".equals(ns))
/*     */         continue;
/* 585 */       buffer.append(SchemaUtils.getSchemaDefinitions(ns));
/*     */     }
/*     */   }
/*     */ 
/*     */   private void appendComplexTypeDefinition(StringBuilder buf, XSComplexTypeDefinition jxstype)
/*     */   {
/* 592 */     XSParticle xsp = jxstype.getParticle();
/* 593 */     XSTerm xsterm = xsp.getTerm();
/* 594 */     short deriveMethod = jxstype.getDerivationMethod();
/*     */ 
/* 596 */     if ((xsterm instanceof XSElementDeclaration))
/*     */     {
/* 599 */       buf.append("<sequence>");
/*     */ 
/* 601 */       XSElementDeclaration xsel = (XSElementDeclaration)xsterm;
/* 602 */       buf.append(write(xsel, xsp));
/* 603 */       buf.append("</sequence>");
/*     */     }
/* 605 */     else if ((xsterm instanceof XSModelGroup))
/*     */     {
/* 607 */       XSModelGroup jmg = (XSModelGroup)xsterm;
/* 608 */       XSObjectList objlist = jmg.getParticles();
/* 609 */       String end = null;
/*     */ 
/* 611 */       switch (jmg.getCompositor())
/*     */       {
/*     */       case 3:
/* 614 */         buf.append("<all>");
/* 615 */         end = "</all>";
/* 616 */         break;
/*     */       case 2:
/* 618 */         buf.append("<choice>");
/* 619 */         end = "</choice>";
/* 620 */         break;
/*     */       case 1:
/*     */       default:
/* 623 */         buf.append("<sequence>");
/* 624 */         end = "</sequence>";
/*     */       }
/*     */ 
/* 628 */       int lenobj = objlist != null ? objlist.getLength() : 0;
/*     */ 
/* 630 */       for (int i = 0; i < lenobj; i++)
/*     */       {
/* 632 */         XSParticle jxsp = (XSParticle)objlist.item(i);
/* 633 */         XSTerm xterm = jxsp.getTerm();
/* 634 */         if ((xterm instanceof XSElementDeclaration))
/*     */         {
/* 636 */           XSElementDeclaration xsel = (XSElementDeclaration)jxsp.getTerm();
/* 637 */           buf.append(write(xsel, jxsp));
/*     */         } else {
/* 639 */           if (!(xterm instanceof XSModelGroup))
/*     */             continue;
/* 641 */           if ((deriveMethod == 1) && (i != lenobj - 1)) {
/*     */             continue;
/*     */           }
/* 644 */           if (i == 0)
/*     */             continue;
/* 646 */           XSObjectList olist = ((XSModelGroup)xterm).getParticles();
/* 647 */           int lobj = olist != null ? olist.getLength() : 0;
/* 648 */           for (int k = 0; k < lobj; k++)
/*     */           {
/* 650 */             XSParticle jxp = (XSParticle)olist.item(k);
/* 651 */             XSTerm jxpterm = jxp.getTerm();
/* 652 */             short termType = jxpterm.getType();
/* 653 */             if (termType == 2)
/* 654 */               buf.append(write((XSElementDeclaration)jxpterm, jxsp));
/* 655 */             else if (termType == 7) {
/* 656 */               buf.append(write((XSModelGroup)jxpterm));
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/* 661 */       buf.append(end);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void appendTypes(StringBuilder buffer, XSModel xsmodel)
/*     */   {
/* 667 */     XSNamedMap xsmap = xsmodel.getComponents(3);
/* 668 */     int len = xsmap != null ? xsmap.getLength() : 0;
/* 669 */     for (int i = 0; i < len; i++)
/*     */     {
/* 671 */       XSTypeDefinition xstype = (XSTypeDefinition)xsmap.item(i);
/* 672 */       if ("http://www.w3.org/2001/XMLSchema".equals(xstype.getNamespace()))
/*     */         continue;
/* 674 */       buffer.append(write(xstype));
/*     */     }
/*     */   }
/*     */ 
/*     */   private void appendGlobalElements(StringBuilder buffer, XSModel xsmodel)
/*     */   {
/* 680 */     XSNamedMap xsmap = xsmodel.getComponents(2);
/* 681 */     int len = xsmap != null ? xsmap.getLength() : 0;
/* 682 */     for (int i = 0; i < len; i++)
/*     */     {
/* 684 */       XSElementDeclaration xsel = (XSElementDeclaration)xsmap.item(i);
/* 685 */       if ("http://www.w3.org/2001/XMLSchema".equals(xsel.getNamespace()))
/*     */         continue;
/* 687 */       buffer.append(write(xsel));
/*     */     }
/*     */   }
/*     */ 
/*     */   public void copyXSModel(XSModel xsmodel, JBossXSModel jb)
/*     */   {
/* 694 */     if (xsmodel == null)
/* 695 */       throw new IllegalArgumentException("Illegal Null Argument:xsmodel");
/* 696 */     if (jb == null) {
/* 697 */       throw new IllegalArgumentException("Illegal Null Argument:jb");
/*     */     }
/* 699 */     jb.setXSNamespaceItemList(xsmodel.getNamespaceItems());
/*     */ 
/* 701 */     XSNamedMap xsmp = xsmodel.getComponents(2);
/* 702 */     int len = xsmp != null ? xsmp.getLength() : 0;
/*     */ 
/* 704 */     for (int i = 0; i < len; i++)
/*     */     {
/* 706 */       XSElementDeclaration xsel = (XSElementDeclaration)xsmp.item(i);
/* 707 */       jb.addXSElementDeclaration(xsel);
/*     */     }
/*     */ 
/* 710 */     xsmp = xsmodel.getComponents(3);
/* 711 */     len = xsmp != null ? xsmp.getLength() : 0;
/* 712 */     for (int i = 0; i < len; i++)
/*     */     {
/* 714 */       XSTypeDefinition xstype = (XSTypeDefinition)xsmp.item(i);
/* 715 */       if (!"http://www.w3.org/2001/XMLSchema".equals(xstype.getNamespace())) {
/* 716 */         jb.addXSTypeDefinition(xstype);
/*     */       }
/*     */     }
/*     */ 
/* 720 */     xsmp = xsmodel.getComponents(1);
/* 721 */     len = xsmp != null ? xsmp.getLength() : 0;
/* 722 */     for (int i = 0; i < len; i++)
/*     */     {
/* 724 */       XSAttributeDeclaration xsattr = (XSAttributeDeclaration)xsmp.item(i);
/* 725 */       jb.addXSAttributeDeclaration(xsattr);
/*     */     }
/*     */ 
/* 730 */     XSObjectList xo = xsmodel.getAnnotations();
/* 731 */     len = xo != null ? xo.getLength() : 0;
/*     */ 
/* 733 */     for (int i = 0; i < len; i++)
/*     */     {
/* 736 */       XSAnnotation xa = (XSAnnotation)xo.item(i);
/* 737 */       jb.addXSAnnotation(xa);
/*     */     }
/*     */   }
/*     */ 
/*     */   private String getPrefix(String namespace)
/*     */   {
/* 743 */     if (this.namespaceRegistry == null) {
/* 744 */       throw new IllegalArgumentException("nameespaceRegistry can not be null!");
/*     */     }
/* 746 */     if (namespace == null) {
/* 747 */       throw new IllegalArgumentException("namespace can not be null");
/*     */     }
/*     */ 
/* 750 */     if (namespace.equals("http://www.w3.org/XML/1998/namespace"))
/* 751 */       return "xml";
/* 752 */     if (namespace.equals(this.targetNamespace))
/* 753 */       return "tns";
/* 754 */     if (namespace.equals("http://schemas.xmlsoap.org/soap/encoding/"))
/* 755 */       return "soap11-enc";
/* 756 */     if (namespace.equals("http://www.w3.org/2001/XMLSchema-instance")) {
/* 757 */       return "xsi";
/*     */     }
/* 759 */     String prefix = this.namespaceRegistry.getPrefix(namespace);
/*     */ 
/* 762 */     return prefix == null ? "tns" : prefix;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.metadata.wsdl.xmlschema.WSSchemaUtils
 * JD-Core Version:    0.6.0
 */