/*     */ package org.jboss.ws.metadata.wsdl.xmlschema;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.Comparator;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.TreeSet;
/*     */ import org.apache.xerces.xs.StringList;
/*     */ import org.apache.xerces.xs.XSAnnotation;
/*     */ import org.apache.xerces.xs.XSAttributeDeclaration;
/*     */ import org.apache.xerces.xs.XSAttributeGroupDefinition;
/*     */ import org.apache.xerces.xs.XSComplexTypeDefinition;
/*     */ import org.apache.xerces.xs.XSElementDeclaration;
/*     */ import org.apache.xerces.xs.XSModelGroupDefinition;
/*     */ import org.apache.xerces.xs.XSNamedMap;
/*     */ import org.apache.xerces.xs.XSNamespaceItem;
/*     */ import org.apache.xerces.xs.XSNotationDeclaration;
/*     */ import org.apache.xerces.xs.XSObjectList;
/*     */ import org.apache.xerces.xs.XSSimpleTypeDefinition;
/*     */ import org.apache.xerces.xs.XSTypeDefinition;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.xb.binding.NamespaceRegistry;
/*     */ 
/*     */ public class JBossXSNamespaceItem
/*     */   implements XSNamespaceItem
/*     */ {
/*  59 */   private static final Logger log = Logger.getLogger(JBossXSNamespaceItem.class);
/*     */ 
/*  61 */   private String schemaNamespace = null;
/*  62 */   private List<String> docLocations = null;
/*     */ 
/*  64 */   private Map<String, XSAnnotation> anns = new HashMap();
/*  65 */   private Map<String, XSAttributeDeclaration> attrs = new HashMap();
/*  66 */   private Map<String, XSElementDeclaration> elements = new HashMap();
/*  67 */   private Map<String, XSTypeDefinition> types = new HashMap();
/*     */ 
/*  69 */   private boolean qualifiedElements = false;
/*     */   private NamespaceRegistry namespaceRegistry;
/*     */ 
/*     */   public JBossXSNamespaceItem(String ns, NamespaceRegistry namespaceRegistry, boolean qualifiedElements)
/*     */   {
/*  75 */     this.schemaNamespace = ns;
/*  76 */     this.namespaceRegistry = namespaceRegistry;
/*  77 */     this.qualifiedElements = qualifiedElements;
/*     */   }
/*     */ 
/*     */   public String getSchemaNamespace()
/*     */   {
/*  85 */     return this.schemaNamespace;
/*     */   }
/*     */ 
/*     */   public XSNamedMap getComponents(short objectType)
/*     */   {
/* 103 */     JBossXSNamedMap jbnm = new JBossXSNamedMap();
/* 104 */     if ((objectType == 2) && (this.elements.size() > 0)) {
/* 105 */       jbnm.addItems(this.elements.values());
/*     */     }
/* 108 */     else if ((objectType == 1) && (this.attrs.size() > 0))
/*     */     {
/* 110 */       jbnm.addItems(this.attrs.values());
/*     */     }
/* 113 */     else if ((objectType == 3) && (this.types.size() > 0))
/*     */     {
/* 115 */       jbnm.addItems(this.types.values());
/*     */     }
/* 118 */     else if (objectType == 15)
/*     */     {
/* 120 */       Collection col = this.types.values();
/* 121 */       jbnm.addItems(getTypes(col, 15));
/*     */     }
/* 124 */     else if (objectType == 16)
/*     */     {
/* 126 */       Collection col = this.types.values();
/* 127 */       jbnm.addItems(getTypes(col, 16));
/*     */     }
/*     */ 
/* 131 */     return jbnm;
/*     */   }
/*     */ 
/*     */   public XSObjectList getAnnotations()
/*     */   {
/* 140 */     List lst = new ArrayList();
/* 141 */     lst.addAll(this.anns.values());
/* 142 */     return new JBossXSObjectList(lst);
/*     */   }
/*     */ 
/*     */   public XSElementDeclaration getElementDeclaration(String name)
/*     */   {
/* 153 */     JBossXSElementDeclaration jbe = null;
/*     */ 
/* 155 */     if (this.elements != null)
/*     */     {
/* 157 */       XSElementDeclaration xe = (XSElementDeclaration)this.elements.get(name);
/* 158 */       if ((xe != null) && (!(xe instanceof JBossXSElementDeclaration)))
/* 159 */         jbe = new JBossXSElementDeclaration(xe);
/*     */       else
/* 161 */         return xe;
/*     */     }
/* 163 */     return jbe;
/*     */   }
/*     */ 
/*     */   public XSAttributeDeclaration getAttributeDeclaration(String name)
/*     */   {
/* 174 */     if (this.attrs != null) return (XSAttributeDeclaration)this.attrs.get(name);
/* 175 */     return null;
/*     */   }
/*     */ 
/*     */   public XSTypeDefinition getTypeDefinition(String name)
/*     */   {
/* 187 */     if (this.types != null) return (XSTypeDefinition)this.types.get(name);
/* 188 */     return null;
/*     */   }
/*     */ 
/*     */   public XSAttributeGroupDefinition getAttributeGroup(String name)
/*     */   {
/* 199 */     return null;
/*     */   }
/*     */ 
/*     */   public XSModelGroupDefinition getModelGroupDefinition(String name)
/*     */   {
/* 210 */     return null;
/*     */   }
/*     */ 
/*     */   public XSNotationDeclaration getNotationDeclaration(String name)
/*     */   {
/* 221 */     return null;
/*     */   }
/*     */ 
/*     */   public StringList getDocumentLocations()
/*     */   {
/* 230 */     if (this.docLocations == null) return new JBossXSStringList();
/* 231 */     JBossXSStringList strList = new JBossXSStringList(this.docLocations);
/* 232 */     return strList;
/*     */   }
/*     */ 
/*     */   public void addDocumentLocation(String uri)
/*     */   {
/* 240 */     if (this.docLocations == null)
/* 241 */       this.docLocations = new ArrayList();
/* 242 */     this.docLocations.add(uri);
/*     */   }
/*     */ 
/*     */   public void addDocumentLocations(List<String> uri)
/*     */   {
/* 247 */     if (this.docLocations == null)
/* 248 */       this.docLocations = new ArrayList();
/* 249 */     this.docLocations.addAll(uri);
/*     */   }
/*     */ 
/*     */   public void addXSAnnotation(XSAnnotation xa)
/*     */   {
/* 257 */     if (xa == null)
/* 258 */       throw new IllegalArgumentException("Illegal Null Argument:xa");
/* 259 */     this.anns.put(xa.getName(), xa);
/*     */   }
/*     */ 
/*     */   public void addXSAttributeDeclaration(XSAttributeDeclaration att)
/*     */   {
/* 267 */     if (att == null)
/* 268 */       throw new IllegalArgumentException("att is null");
/* 269 */     this.attrs.put(att.getName(), att);
/*     */   }
/*     */ 
/*     */   public void addXSElementDeclaration(XSElementDeclaration el)
/*     */   {
/* 278 */     if (el == null)
/* 279 */       throw new IllegalArgumentException("Element is null");
/* 280 */     this.elements.put(el.getName(), el);
/*     */   }
/*     */ 
/*     */   public void addXSTypeDefinition(XSTypeDefinition xsType)
/*     */   {
/* 289 */     if (xsType == null) {
/* 290 */       throw new IllegalArgumentException("type is null");
/*     */     }
/* 292 */     String xsTypeName = xsType.getName();
/* 293 */     log.trace("addXSTypeDefinition: " + xsTypeName);
/*     */ 
/* 295 */     this.types.put(xsTypeName, xsType);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 314 */     if (isEmpty()) return "";
/*     */ 
/* 316 */     WSSchemaUtils sutils = WSSchemaUtils.getInstance(this.namespaceRegistry, this.schemaNamespace);
/*     */ 
/* 318 */     StringBuilder buffer = new StringBuilder();
/* 319 */     buffer.append("<schema  targetNamespace='" + this.schemaNamespace + "'");
/* 320 */     buffer.append(" xmlns:soap11-enc='http://schemas.xmlsoap.org/soap/encoding/'");
/*     */ 
/* 322 */     if (!this.schemaNamespace.equals("http://www.w3.org/XML/1998/namespace"))
/* 323 */       buffer.append(" xmlns:tns='" + this.schemaNamespace + "'");
/* 324 */     buffer.append(" xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'");
/* 325 */     buffer.append(" xmlns='http://www.w3.org/2001/XMLSchema'");
/*     */ 
/* 328 */     Iterator iter = this.namespaceRegistry.getRegisteredPrefixes();
/* 329 */     while (iter.hasNext())
/*     */     {
/* 331 */       String prefix = (String)iter.next();
/* 332 */       String ns = this.namespaceRegistry.getNamespaceURI(prefix);
/* 333 */       if (((ns.equals(this.schemaNamespace)) && (!ns.equals("http://www.w3.org/XML/1998/namespace"))) || 
/* 335 */         (ns.equals("http://schemas.xmlsoap.org/soap/encoding/")) || 
/* 337 */         (ns.equals("http://www.w3.org/2001/XMLSchema-instance")))
/*     */         continue;
/* 339 */       buffer.append(" xmlns:" + prefix + "='" + ns + "'");
/*     */     }
/*     */ 
/* 342 */     if (this.qualifiedElements) {
/* 343 */       buffer.append(" elementFormDefault='qualified'");
/*     */     }
/* 345 */     buffer.append(">");
/*     */ 
/* 348 */     iter = this.namespaceRegistry.getRegisteredURIs();
/* 349 */     while (iter.hasNext())
/*     */     {
/* 351 */       String ns = (String)iter.next();
/* 352 */       if ((ns.equals(this.schemaNamespace)) || 
/* 354 */         (ns.equals("http://schemas.xmlsoap.org/soap/encoding/")) || 
/* 356 */         (ns.equals("http://www.w3.org/2001/XMLSchema-instance")))
/*     */         continue;
/* 358 */       buffer.append("<import namespace='" + ns + "'/>");
/*     */     }
/*     */ 
/* 363 */     TreeSet treeset = new TreeSet(new XSComparator(null));
/* 364 */     treeset.addAll(this.types.keySet());
/* 365 */     for (String key : treeset)
/*     */     {
/* 367 */       buffer.append(sutils.write((XSTypeDefinition)this.types.get(key)));
/*     */     }
/*     */ 
/* 372 */     treeset = new TreeSet(new XSComparator(null));
/* 373 */     treeset.addAll(this.elements.keySet());
/* 374 */     for (String key : treeset)
/*     */     {
/* 376 */       buffer.append(sutils.write((XSElementDeclaration)this.elements.get(key)));
/*     */     }
/* 378 */     buffer.append("</schema>");
/* 379 */     return buffer.toString();
/*     */   }
/*     */ 
/*     */   public void merge(JBossXSNamespaceItem nsi)
/*     */   {
/* 385 */     JBossXSNamedMap nmap = (JBossXSNamedMap)nsi.getComponents(1);
/* 386 */     int len = nmap.getLength();
/* 387 */     for (int i = 0; i < len; i++)
/*     */     {
/* 389 */       XSAttributeDeclaration xatt = (XSAttributeDeclaration)nmap.item(i);
/* 390 */       addXSAttributeDeclaration(xatt);
/*     */     }
/*     */ 
/* 394 */     nmap = (JBossXSNamedMap)nsi.getComponents(3);
/* 395 */     len = nmap.getLength();
/* 396 */     for (int i = 0; i < len; i++)
/*     */     {
/* 398 */       XSTypeDefinition xt = (XSTypeDefinition)nmap.item(i);
/* 399 */       addXSTypeDefinition(xt);
/*     */     }
/*     */ 
/* 403 */     nmap = (JBossXSNamedMap)nsi.getComponents(2);
/* 404 */     len = nmap.getLength();
/* 405 */     for (int i = 0; i < len; i++)
/*     */     {
/* 407 */       XSElementDeclaration xe = (XSElementDeclaration)nmap.item(i);
/* 408 */       addXSElementDeclaration(xe);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void removeXSTypeDefinition(XSTypeDefinition xst)
/*     */   {
/* 419 */     String name = xst.getName();
/* 420 */     this.types.remove(name);
/*     */   }
/*     */ 
/*     */   public void removeXSElementDeclaration(XSElementDeclaration xel)
/*     */   {
/* 430 */     String name = xel.getName();
/* 431 */     this.elements.remove(name);
/*     */   }
/*     */ 
/*     */   public boolean isQualifiedElements()
/*     */   {
/* 436 */     return this.qualifiedElements;
/*     */   }
/*     */ 
/*     */   public void setQualifiedElements(boolean qualifiedElements)
/*     */   {
/* 441 */     this.qualifiedElements = qualifiedElements;
/*     */   }
/*     */ 
/*     */   public NamespaceRegistry getNamespaceRegistry()
/*     */   {
/* 446 */     return this.namespaceRegistry;
/*     */   }
/*     */ 
/*     */   public void setNamespaceRegistry(NamespaceRegistry namespaceRegistry)
/*     */   {
/* 451 */     this.namespaceRegistry = namespaceRegistry;
/*     */   }
/*     */ 
/*     */   private Collection getTypes(Collection col, short objectType)
/*     */   {
/* 457 */     if ((objectType != 16) && (objectType != 15))
/* 458 */       throw new IllegalArgumentException("objectType should be simple type or complex type");
/* 459 */     Collection values = new ArrayList();
/* 460 */     for (Iterator i$ = col.iterator(); i$.hasNext(); ) { Object obj = i$.next();
/*     */ 
/* 462 */       if ((objectType == 15) && ((obj instanceof XSComplexTypeDefinition)))
/*     */       {
/* 464 */         values.add(obj);
/*     */       }
/* 466 */       else if ((objectType == 16) && ((obj instanceof XSSimpleTypeDefinition)))
/*     */       {
/* 468 */         values.add(obj);
/*     */       } }
/* 470 */     return values;
/*     */   }
/*     */ 
/*     */   private boolean isEmpty()
/*     */   {
/* 475 */     boolean bool = true;
/* 476 */     if (this.attrs.size() > 0) return false;
/* 477 */     if (this.types.size() > 0) return false;
/* 478 */     if (this.elements.size() > 0) return false;
/* 479 */     return bool;
/*     */   }
/*     */   private class XSComparator implements Comparator {
/*     */     private XSComparator() {
/*     */     }
/*     */ 
/*     */     public int compare(Object arg0, Object arg1) {
/* 486 */       String str1 = (String)arg0;
/* 487 */       String str2 = (String)arg1;
/*     */ 
/* 489 */       if ((Character.isUpperCase(str1.charAt(0))) && (Character.isLowerCase(str2.charAt(0))))
/*     */       {
/* 491 */         return 1;
/* 492 */       }return str1.compareTo(str2);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.metadata.wsdl.xmlschema.JBossXSNamespaceItem
 * JD-Core Version:    0.6.0
 */