/*     */ package org.jboss.ws.metadata.wsdl.xmlschema;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import org.apache.xerces.xs.XSAttributeUse;
/*     */ import org.apache.xerces.xs.XSComplexTypeDefinition;
/*     */ import org.apache.xerces.xs.XSObjectList;
/*     */ import org.apache.xerces.xs.XSParticle;
/*     */ import org.apache.xerces.xs.XSSimpleTypeDefinition;
/*     */ import org.apache.xerces.xs.XSWildcard;
/*     */ 
/*     */ public class JBossXSComplexTypeDefinition extends JBossXSTypeDefinition
/*     */   implements XSComplexTypeDefinition
/*     */ {
/*     */   private boolean isAbstract;
/*     */   private XSSimpleTypeDefinition xsSimple;
/*     */   private XSParticle xspart;
/*     */   private XSObjectList annots;
/*     */   private String prefix;
/*  51 */   private List<XSAttributeUse> attList = new ArrayList();
/*     */ 
/*  54 */   private short contentType = 2;
/*     */ 
/*  56 */   private short deriveMethod = 0;
/*     */ 
/*     */   public JBossXSComplexTypeDefinition()
/*     */   {
/*     */   }
/*     */ 
/*     */   public JBossXSComplexTypeDefinition(String name, String namespace)
/*     */   {
/*  64 */     super(name, namespace);
/*     */   }
/*     */ 
/*     */   public JBossXSComplexTypeDefinition(XSComplexTypeDefinition xc)
/*     */   {
/*  69 */     super(xc.getName(), xc.getNamespace());
/*  70 */     setAnonymous(xc.getAnonymous());
/*  71 */     this.xspart = xc.getParticle();
/*  72 */     this.xsSimple = xc.getSimpleType();
/*  73 */     this.deriveMethod = xc.getDerivationMethod();
/*  74 */     this.baseType = new JBossXSTypeDefinition(xc.getBaseType());
/*     */   }
/*     */ 
/*     */   public short getDerivationMethod()
/*     */   {
/*  84 */     return this.deriveMethod;
/*     */   }
/*     */ 
/*     */   public boolean getAbstract()
/*     */   {
/*  94 */     return this.isAbstract;
/*     */   }
/*     */ 
/*     */   public XSObjectList getAttributeUses()
/*     */   {
/* 103 */     JBossXSObjectList oblist = new JBossXSObjectList();
/* 104 */     for (XSAttributeUse xa : this.attList)
/*     */     {
/* 106 */       oblist.addItem(xa);
/*     */     }
/* 108 */     return oblist;
/*     */   }
/*     */ 
/*     */   public XSWildcard getAttributeWildcard()
/*     */   {
/* 116 */     return null;
/*     */   }
/*     */ 
/*     */   public short getContentType()
/*     */   {
/* 127 */     return this.contentType;
/*     */   }
/*     */ 
/*     */   public XSSimpleTypeDefinition getSimpleType()
/*     */   {
/* 136 */     return this.xsSimple;
/*     */   }
/*     */ 
/*     */   public XSParticle getParticle()
/*     */   {
/* 145 */     return this.xspart;
/*     */   }
/*     */ 
/*     */   public boolean isProhibitedSubstitution(short restriction)
/*     */   {
/* 157 */     return false;
/*     */   }
/*     */ 
/*     */   public short getProhibitedSubstitutions()
/*     */   {
/* 167 */     return 0;
/*     */   }
/*     */ 
/*     */   public XSObjectList getAnnotations()
/*     */   {
/* 176 */     return this.annots;
/*     */   }
/*     */ 
/*     */   public short getType()
/*     */   {
/* 185 */     return 15;
/*     */   }
/*     */ 
/*     */   public short getTypeCategory()
/*     */   {
/* 194 */     return 15;
/*     */   }
/*     */ 
/*     */   public void setAbstract(boolean anAbstract)
/*     */   {
/* 199 */     this.isAbstract = anAbstract;
/*     */   }
/*     */ 
/*     */   public void setDerivationMethod(short deriveMethod)
/*     */   {
/* 204 */     this.deriveMethod = deriveMethod;
/*     */   }
/*     */ 
/*     */   public void setSimpleType(XSSimpleTypeDefinition xsSimple)
/*     */   {
/* 213 */     this.xsSimple = xsSimple;
/*     */   }
/*     */ 
/*     */   public void setParticle(XSParticle xspart)
/*     */   {
/* 222 */     this.xspart = xspart;
/*     */   }
/*     */ 
/*     */   public void setAnnotations(XSObjectList annots)
/*     */   {
/* 231 */     this.annots = annots;
/*     */   }
/*     */ 
/*     */   public void setContentType(short contentType)
/*     */   {
/* 244 */     this.contentType = contentType;
/*     */   }
/*     */ 
/*     */   public void addXSAttributeUse(XSAttributeUse at)
/*     */   {
/* 252 */     this.attList.add(at);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 257 */     return "";
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.metadata.wsdl.xmlschema.JBossXSComplexTypeDefinition
 * JD-Core Version:    0.6.0
 */