/*     */ package org.jboss.ws.metadata.wsdl;
/*     */ 
/*     */ import javax.xml.namespace.QName;
/*     */ import org.apache.xerces.xs.XSElementDeclaration;
/*     */ import org.apache.xerces.xs.XSTypeDefinition;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
/*     */ 
/*     */ public class XSModelTypes extends WSDLTypes
/*     */ {
/*  40 */   private static final Logger log = Logger.getLogger(XSModelTypes.class);
/*     */   private JBossXSModel schemaModel;
/*     */ 
/*     */   public XSModelTypes()
/*     */   {
/*  46 */     this.schemaModel = new JBossXSModel();
/*     */   }
/*     */ 
/*     */   public void addSchemaModel(String nsURI, JBossXSModel schema)
/*     */   {
/*  60 */     if (nsURI == null)
/*     */     {
/*  62 */       log.trace("nsURI passed to addSchemaModel is null. Replacing Schema Model");
/*  63 */       this.schemaModel = schema;
/*     */     }
/*     */     else {
/*  66 */       this.schemaModel.merge(schema);
/*     */     }
/*     */   }
/*     */ 
/*     */   public JBossXSModel getSchemaModel()
/*     */   {
/*  75 */     return this.schemaModel;
/*     */   }
/*     */ 
/*     */   public QName getXMLType(QName xmlName)
/*     */   {
/*  82 */     QName xmlType = null;
/*  83 */     String nsURI = xmlName.getNamespaceURI();
/*  84 */     String localPart = xmlName.getLocalPart();
/*  85 */     XSElementDeclaration xsel = this.schemaModel.getElementDeclaration(localPart, nsURI);
/*  86 */     if (xsel != null)
/*     */     {
/*  88 */       XSTypeDefinition xstype = xsel.getTypeDefinition();
/*  89 */       if (xstype == null) {
/*  90 */         throw new WSException("Cannot obtain XSTypeDefinition for: " + xmlName);
/*     */       }
/*  92 */       if (!xstype.getAnonymous())
/*     */       {
/*  94 */         xmlType = new QName(xstype.getNamespace(), xstype.getName());
/*     */       }
/*     */       else
/*     */       {
/*  98 */         xmlType = new QName(xstype.getNamespace(), ">" + localPart);
/*     */       }
/*     */     }
/* 101 */     return xmlType;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 106 */     StringBuilder buffer = new StringBuilder("WSDLTypes:\n");
/* 107 */     buffer.append(this.schemaModel != null ? this.schemaModel.serialize() : "<schema/>");
/* 108 */     return buffer.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.metadata.wsdl.XSModelTypes
 * JD-Core Version:    0.6.0
 */