/*     */ package org.jboss.ws.metadata.wsdl;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Arrays;
/*     */ import java.util.LinkedHashMap;
/*     */ import java.util.Map;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class WSDLInterface extends Extendable
/*     */ {
/*  47 */   private static final Logger log = Logger.getLogger(WSDLInterface.class);
/*     */   private static final long serialVersionUID = 2453454924501233964L;
/*     */   private WSDLDefinitions wsdlDefinitions;
/*     */   private QName name;
/*     */   private QName[] extendList;
/*     */   private String styleDefault;
/*  66 */   private Map<QName, WSDLInterfaceOperation> operations = new LinkedHashMap();
/*     */ 
/*  68 */   private Map<QName, WSDLInterfaceFault> faults = new LinkedHashMap();
/*     */ 
/*     */   public WSDLInterface(WSDLDefinitions wsdlDefinitions, QName name)
/*     */   {
/*  73 */     this.wsdlDefinitions = wsdlDefinitions;
/*  74 */     this.name = name;
/*     */   }
/*     */ 
/*     */   public WSDLDefinitions getWsdlDefinitions()
/*     */   {
/*  79 */     return this.wsdlDefinitions;
/*     */   }
/*     */ 
/*     */   public QName getName()
/*     */   {
/*  84 */     return this.name;
/*     */   }
/*     */ 
/*     */   public QName[] getExtendList()
/*     */   {
/*  89 */     return this.extendList;
/*     */   }
/*     */ 
/*     */   public void setExtendList(QName[] extendList)
/*     */   {
/*  94 */     this.extendList = extendList;
/*     */   }
/*     */ 
/*     */   public String getStyleDefault()
/*     */   {
/*  99 */     return this.styleDefault;
/*     */   }
/*     */ 
/*     */   public void setStyleDefault(String styleDefault)
/*     */   {
/* 104 */     this.styleDefault = styleDefault;
/*     */   }
/*     */ 
/*     */   public WSDLInterfaceOperation[] getOperations()
/*     */   {
/* 109 */     WSDLInterfaceOperation[] arr = new WSDLInterfaceOperation[this.operations.size()];
/* 110 */     new ArrayList(this.operations.values()).toArray(arr);
/* 111 */     return arr;
/*     */   }
/*     */ 
/*     */   public WSDLInterfaceOperation[] getSortedOperations()
/*     */   {
/* 116 */     WSDLInterfaceOperation[] arr = new WSDLInterfaceOperation[this.operations.size()];
/* 117 */     new ArrayList(this.operations.values()).toArray(arr);
/* 118 */     Arrays.sort(arr);
/* 119 */     return arr;
/*     */   }
/*     */ 
/*     */   public WSDLInterfaceOperation getOperation(QName name)
/*     */   {
/* 124 */     WSDLInterfaceOperation operation = (WSDLInterfaceOperation)this.operations.get(name);
/* 125 */     return operation;
/*     */   }
/*     */ 
/*     */   public WSDLInterfaceOperation getOperation(String localName)
/*     */   {
/* 130 */     WSDLInterfaceOperation operation = (WSDLInterfaceOperation)this.operations.get(new QName(this.name.getNamespaceURI(), localName));
/* 131 */     return operation;
/*     */   }
/*     */ 
/*     */   public void addOperation(WSDLInterfaceOperation operation)
/*     */   {
/* 136 */     this.operations.put(operation.getName(), operation);
/*     */   }
/*     */ 
/*     */   public WSDLInterfaceFault[] getFaults()
/*     */   {
/* 141 */     WSDLInterfaceFault[] arr = new WSDLInterfaceFault[this.faults.size()];
/* 142 */     new ArrayList(this.faults.values()).toArray(arr);
/* 143 */     return arr;
/*     */   }
/*     */ 
/*     */   public WSDLInterfaceFault getFault(QName name)
/*     */   {
/* 148 */     WSDLInterfaceFault fault = (WSDLInterfaceFault)this.faults.get(name);
/* 149 */     return fault;
/*     */   }
/*     */ 
/*     */   public WSDLInterfaceFault getFault(String localName) {
/* 153 */     WSDLInterfaceFault fault = (WSDLInterfaceFault)this.faults.get(new QName(this.name.getNamespaceURI(), localName));
/* 154 */     return fault;
/*     */   }
/*     */ 
/*     */   public void addFault(WSDLInterfaceFault fault)
/*     */   {
/* 159 */     this.faults.put(fault.getName(), fault);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.metadata.wsdl.WSDLInterface
 * JD-Core Version:    0.6.0
 */