/*     */ package org.jboss.ws.metadata.wsdl;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.LinkedHashMap;
/*     */ import java.util.List;
/*     */ 
/*     */ public abstract class WSDLBindingMessageReference extends Extendable
/*     */ {
/*     */   private WSDLBindingOperation wsdlBindingOperation;
/*     */   private String messageLabel;
/*  42 */   private List<WSDLSOAPHeader> soapHeaders = new ArrayList();
/*  43 */   private LinkedHashMap<String, WSDLMIMEPart> mimeParts = new LinkedHashMap();
/*     */ 
/*     */   public WSDLBindingMessageReference(WSDLBindingOperation wsdlBindingOperation)
/*     */   {
/*  47 */     this.wsdlBindingOperation = wsdlBindingOperation;
/*     */   }
/*     */ 
/*     */   public WSDLBindingOperation getWsdlBindingOperation()
/*     */   {
/*  52 */     return this.wsdlBindingOperation;
/*     */   }
/*     */ 
/*     */   public String getMessageLabel()
/*     */   {
/*  63 */     return this.messageLabel;
/*     */   }
/*     */ 
/*     */   public void setMessageLabel(String messageLabel)
/*     */   {
/*  74 */     this.messageLabel = messageLabel;
/*     */   }
/*     */ 
/*     */   public List<WSDLSOAPHeader> getSoapHeaders()
/*     */   {
/*  84 */     return this.soapHeaders;
/*     */   }
/*     */ 
/*     */   public void setSoapHeaders(List<WSDLSOAPHeader> soapHeaders)
/*     */   {
/*  94 */     this.soapHeaders = soapHeaders;
/*     */   }
/*     */ 
/*     */   public void addSoapHeader(WSDLSOAPHeader soapHeader)
/*     */   {
/* 105 */     this.soapHeaders.add(soapHeader);
/*     */   }
/*     */ 
/*     */   public void addMimePart(WSDLMIMEPart mimePart)
/*     */   {
/* 115 */     this.mimeParts.put(mimePart.getPartName(), mimePart);
/*     */   }
/*     */ 
/*     */   public Collection<WSDLMIMEPart> getMimeParts()
/*     */   {
/* 125 */     return this.mimeParts.values();
/*     */   }
/*     */ 
/*     */   public WSDLMIMEPart getMimePart(String partName)
/*     */   {
/* 136 */     return (WSDLMIMEPart)this.mimeParts.get(partName);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.metadata.wsdl.WSDLBindingMessageReference
 * JD-Core Version:    0.6.0
 */