/*     */ package org.jboss.ws.metadata.wsdl;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.ArrayList;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.WSException;
/*     */ 
/*     */ public class WSDLBinding extends Extendable
/*     */   implements Serializable
/*     */ {
/*     */   private static final long serialVersionUID = -7699953670233209811L;
/*  48 */   private static final Logger log = Logger.getLogger(WSDLBinding.class);
/*     */   private final WSDLDefinitions wsdlDefinitions;
/*     */   private final QName name;
/*     */   private QName interfaceName;
/*     */   private String type;
/*  64 */   private ArrayList<WSDLBindingFault> faults = new ArrayList();
/*     */ 
/*  68 */   private ArrayList<WSDLBindingOperation> operations = new ArrayList();
/*     */ 
/*     */   public WSDLBinding(WSDLDefinitions wsdlDefinitions, QName name)
/*     */   {
/*  72 */     this.wsdlDefinitions = wsdlDefinitions;
/*  73 */     this.name = name;
/*     */   }
/*     */ 
/*     */   public WSDLDefinitions getWsdlDefinitions()
/*     */   {
/*  78 */     return this.wsdlDefinitions;
/*     */   }
/*     */ 
/*     */   public QName getName()
/*     */   {
/*  83 */     return this.name;
/*     */   }
/*     */ 
/*     */   public QName getInterfaceName()
/*     */   {
/*  88 */     return this.interfaceName;
/*     */   }
/*     */ 
/*     */   public void setInterfaceName(QName interfaceName)
/*     */   {
/*  93 */     log.trace("setInterfaceName: " + this.name);
/*  94 */     this.interfaceName = interfaceName;
/*     */   }
/*     */ 
/*     */   public WSDLInterface getInterface()
/*     */   {
/*  99 */     WSDLInterface wsdlInterface = this.wsdlDefinitions.getInterface(this.interfaceName);
/* 100 */     if (wsdlInterface == null)
/* 101 */       throw new WSException("Cannot get interface for name: " + this.interfaceName);
/* 102 */     return wsdlInterface;
/*     */   }
/*     */ 
/*     */   public String getType()
/*     */   {
/* 107 */     return this.type;
/*     */   }
/*     */ 
/*     */   public void setType(String type)
/*     */   {
/* 112 */     this.type = type;
/*     */   }
/*     */ 
/*     */   public WSDLBindingFault[] getFaults()
/*     */   {
/* 117 */     WSDLBindingFault[] arr = new WSDLBindingFault[this.faults.size()];
/* 118 */     this.faults.toArray(arr);
/* 119 */     return arr;
/*     */   }
/*     */ 
/*     */   public void addFault(WSDLBindingFault fault)
/*     */   {
/* 124 */     this.faults.add(fault);
/*     */   }
/*     */ 
/*     */   public WSDLBindingOperation[] getOperations()
/*     */   {
/* 129 */     WSDLBindingOperation[] arr = new WSDLBindingOperation[this.operations.size()];
/* 130 */     this.operations.toArray(arr);
/* 131 */     return arr;
/*     */   }
/*     */ 
/*     */   public WSDLBindingOperation getOperationByRef(QName qname)
/*     */   {
/* 136 */     WSDLBindingOperation wsdlBindingOperation = null;
/* 137 */     for (WSDLBindingOperation aux : this.operations)
/*     */     {
/* 139 */       if (aux.getRef().equals(qname))
/*     */       {
/* 141 */         if (wsdlBindingOperation != null)
/* 142 */           log.warn("Multiple binding operations reference: " + qname);
/* 143 */         wsdlBindingOperation = aux;
/*     */       }
/*     */     }
/*     */ 
/* 147 */     if (wsdlBindingOperation == null) {
/* 148 */       log.warn("Cannot obtain binding operation for ref: " + qname);
/*     */     }
/* 150 */     return wsdlBindingOperation;
/*     */   }
/*     */ 
/*     */   public void addOperation(WSDLBindingOperation operation)
/*     */   {
/* 155 */     this.operations.add(operation);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.metadata.wsdl.WSDLBinding
 * JD-Core Version:    0.6.0
 */