/*     */ package org.jboss.ws.metadata.wsdl;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.LinkedHashMap;
/*     */ import java.util.LinkedList;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public abstract class Extendable
/*     */   implements Serializable
/*     */ {
/*  44 */   private Logger log = Logger.getLogger(getClass());
/*     */ 
/*  46 */   private Map features = new LinkedHashMap();
/*  47 */   private Map properties = new LinkedHashMap();
/*  48 */   private Map<String, List<WSDLExtensibilityElement>> extElements = new LinkedHashMap();
/*     */ 
/*     */   public WSDLFeature[] getFeatures()
/*     */   {
/*  52 */     WSDLFeature[] arr = new WSDLFeature[this.features.size()];
/*  53 */     new ArrayList(this.features.values()).toArray(arr);
/*  54 */     return arr;
/*     */   }
/*     */ 
/*     */   public void addFeature(WSDLFeature feature)
/*     */   {
/*  59 */     this.log.trace("addFeature: " + feature);
/*  60 */     String uri = feature.getURI();
/*  61 */     this.features.put(uri, feature);
/*     */   }
/*     */ 
/*     */   public WSDLFeature getFeature(String uri)
/*     */   {
/*  66 */     WSDLFeature feature = (WSDLFeature)this.features.get(uri);
/*  67 */     return feature;
/*     */   }
/*     */ 
/*     */   public WSDLProperty[] getProperties()
/*     */   {
/*  72 */     WSDLProperty[] arr = new WSDLProperty[this.properties.size()];
/*  73 */     new ArrayList(this.properties.values()).toArray(arr);
/*  74 */     return arr;
/*     */   }
/*     */ 
/*     */   public void addProperty(WSDLProperty property)
/*     */   {
/*  79 */     this.log.trace("addProperty: " + property);
/*  80 */     String uri = property.getURI();
/*  81 */     this.properties.put(uri, property);
/*     */   }
/*     */ 
/*     */   public WSDLProperty getProperty(String uri)
/*     */   {
/*  86 */     WSDLProperty property = (WSDLProperty)this.properties.get(uri);
/*  87 */     return property;
/*     */   }
/*     */ 
/*     */   public void addExtensibilityElement(WSDLExtensibilityElement extElement)
/*     */   {
/*  92 */     this.log.trace("addExtensibilityElement: " + extElement);
/*  93 */     String uri = extElement.getUri();
/*  94 */     List list = (List)this.extElements.get(uri);
/*  95 */     if (list == null)
/*     */     {
/*  97 */       list = new LinkedList();
/*  98 */       this.extElements.put(uri, list);
/*     */     }
/* 100 */     list.add(extElement);
/*     */   }
/*     */ 
/*     */   public List<WSDLExtensibilityElement> getExtensibilityElements(String uri)
/*     */   {
/* 105 */     List list = (List)this.extElements.get(uri);
/* 106 */     return list == null ? new ArrayList() : list;
/*     */   }
/*     */ 
/*     */   public List<WSDLExtensibilityElement> getAllExtensibilityElements()
/*     */   {
/* 111 */     List list = new LinkedList();
/* 112 */     for (String k : this.extElements.keySet())
/*     */     {
/* 114 */       list.addAll((Collection)this.extElements.get(k));
/*     */     }
/* 116 */     return list;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.metadata.wsdl.Extendable
 * JD-Core Version:    0.6.0
 */