/*     */ package org.jboss.ws.metadata.umdm;
/*     */ 
/*     */ import java.util.Arrays;
/*     */ import java.util.List;
/*     */ import javax.xml.namespace.QName;
/*     */ 
/*     */ public class TypeMappingMetaData
/*     */ {
/*     */   private TypesMetaData typesMetaData;
/*     */   private QName xmlType;
/*     */   private String javaTypeName;
/*     */   private String qnameScope;
/*     */   public static final String QNAME_SCOPE_SIMPLE_TYPE = "simpleType";
/*     */   public static final String QNAME_SCOPE_COMPLEX_TYPE = "complexType";
/*     */   public static final String QNAME_SCOPE_ELEMENT = "element";
/*  51 */   private static List<String> allowedScopes = Arrays.asList(new String[] { "complexType", "simpleType", "element" });
/*     */ 
/*     */   public TypeMappingMetaData(TypesMetaData typesMetaData, QName xmlType, String javaTypeName)
/*     */   {
/*  55 */     if (xmlType == null)
/*  56 */       throw new IllegalArgumentException("Invalid null xmlType");
/*  57 */     if (javaTypeName == null) {
/*  58 */       throw new IllegalArgumentException("Invalid null javaTypeName");
/*     */     }
/*  60 */     this.typesMetaData = typesMetaData;
/*  61 */     this.javaTypeName = javaTypeName;
/*  62 */     this.xmlType = xmlType;
/*  63 */     this.qnameScope = "complexType";
/*     */   }
/*     */ 
/*     */   public TypesMetaData getTypesMetaData()
/*     */   {
/*  68 */     return this.typesMetaData;
/*     */   }
/*     */ 
/*     */   public String getJavaTypeName()
/*     */   {
/*  73 */     return this.javaTypeName;
/*     */   }
/*     */ 
/*     */   public QName getXmlType()
/*     */   {
/*  78 */     return this.xmlType;
/*     */   }
/*     */ 
/*     */   public String getQNameScope()
/*     */   {
/*  83 */     return this.qnameScope;
/*     */   }
/*     */ 
/*     */   public void setQNameScope(String qnameScope)
/*     */   {
/*  88 */     if (!allowedScopes.contains(qnameScope)) {
/*  89 */       throw new IllegalArgumentException("Invalid qname scope: " + qnameScope);
/*     */     }
/*  91 */     this.qnameScope = qnameScope;
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/*  96 */     return toString().hashCode();
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 101 */     if (!(obj instanceof TypeMappingMetaData)) return false;
/* 102 */     TypeMappingMetaData other = (TypeMappingMetaData)obj;
/* 103 */     return toString().equals(other.toString());
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 108 */     return "[" + this.qnameScope + "=" + this.xmlType + ",javaType=" + this.javaTypeName + "]";
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.metadata.umdm.TypeMappingMetaData
 * JD-Core Version:    0.6.0
 */