/*     */ package org.jboss.ws.metadata.umdm;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URL;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collections;
/*     */ import java.util.LinkedHashMap;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Properties;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.rpc.encoding.TypeMappingRegistry;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.core.binding.TypeMappingImpl;
/*     */ import org.jboss.ws.core.jaxrpc.TypeMappingRegistryImpl;
/*     */ import org.jboss.ws.core.jaxrpc.binding.jbossxb.SchemaBindingBuilder;
/*     */ import org.jboss.ws.core.soap.Use;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMapping;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMappingFactory;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLTypes;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLUtils;
/*     */ import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
/*     */ import org.jboss.ws.metadata.wsse.WSSecurityConfiguration;
/*     */ import org.jboss.ws.tools.wsdl.WSDLDefinitionsFactory;
/*     */ import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData.HandlerType;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
/*     */ 
/*     */ public class ServiceMetaData
/*     */ {
/*  66 */   private static final Logger log = Logger.getLogger(ServiceMetaData.class);
/*     */   private UnifiedMetaData wsMetaData;
/*  72 */   private Map<QName, EndpointMetaData> endpoints = new LinkedHashMap();
/*     */   private QName serviceName;
/*     */   private String serviceRefName;
/*     */   private String wsdName;
/*     */   private URL wsdlLocation;
/*     */   private String wsdlFile;
/*     */   private URL mappingLocation;
/*     */   private String wsdlPublishLocation;
/*  83 */   private List<HandlerMetaDataJAXWS> handlers = new ArrayList();
/*     */   private TypesMetaData types;
/*  87 */   private TypeMappingRegistry tmRegistry = new TypeMappingRegistryImpl();
/*     */   private SchemaBinding schemaBinding;
/*     */   private Properties properties;
/*     */   private Use encStyle;
/*     */   private WSSecurityConfiguration securityConfig;
/*     */   private String wsdlCacheKey;
/*     */ 
/*     */   public ServiceMetaData(UnifiedMetaData wsMetaData, QName serviceName)
/*     */   {
/* 104 */     this.wsMetaData = wsMetaData;
/* 105 */     this.serviceName = serviceName;
/* 106 */     this.types = new TypesMetaData(this);
/*     */   }
/*     */ 
/*     */   public UnifiedMetaData getUnifiedMetaData()
/*     */   {
/* 111 */     return this.wsMetaData;
/*     */   }
/*     */ 
/*     */   public void setServiceName(QName serviceName)
/*     */   {
/* 116 */     this.serviceName = serviceName;
/*     */   }
/*     */ 
/*     */   public QName getServiceName()
/*     */   {
/* 121 */     return this.serviceName;
/*     */   }
/*     */ 
/*     */   public String getServiceRefName()
/*     */   {
/* 126 */     return this.serviceRefName;
/*     */   }
/*     */ 
/*     */   public void setServiceRefName(String serviceRefName)
/*     */   {
/* 131 */     this.serviceRefName = serviceRefName;
/*     */   }
/*     */ 
/*     */   public String getWebserviceDescriptionName()
/*     */   {
/* 136 */     return this.wsdName;
/*     */   }
/*     */ 
/*     */   public void setWebserviceDescriptionName(String wsdName)
/*     */   {
/* 141 */     this.wsdName = wsdName;
/*     */   }
/*     */ 
/*     */   public String getWsdlFile()
/*     */   {
/* 146 */     return this.wsdlFile;
/*     */   }
/*     */ 
/*     */   public void setWsdlFile(String wsdlFile)
/*     */   {
/* 151 */     this.wsdlFile = wsdlFile;
/*     */   }
/*     */ 
/*     */   public URL getWsdlLocation()
/*     */   {
/* 156 */     return this.wsdlLocation;
/*     */   }
/*     */ 
/*     */   public void setWsdlLocation(URL wsdlLocation)
/*     */   {
/* 161 */     this.wsdlLocation = wsdlLocation;
/*     */   }
/*     */ 
/*     */   public String getWsdlPublishLocation()
/*     */   {
/* 166 */     return this.wsdlPublishLocation;
/*     */   }
/*     */ 
/*     */   public void setWsdlPublishLocation(String wsdlPublishLocation)
/*     */   {
/* 171 */     this.wsdlPublishLocation = wsdlPublishLocation;
/*     */   }
/*     */ 
/*     */   public Properties getProperties()
/*     */   {
/* 176 */     return this.properties;
/*     */   }
/*     */ 
/*     */   public void setProperties(Properties properties)
/*     */   {
/* 181 */     this.properties = properties;
/*     */   }
/*     */ 
/*     */   public TypesMetaData getTypesMetaData()
/*     */   {
/* 186 */     return this.types;
/*     */   }
/*     */ 
/*     */   public void addHandler(HandlerMetaDataJAXWS handler)
/*     */   {
/* 191 */     this.handlers.add(handler);
/*     */   }
/*     */ 
/*     */   public List<HandlerMetaDataJAXWS> getHandlerMetaData()
/*     */   {
/* 196 */     return Collections.unmodifiableList(this.handlers);
/*     */   }
/*     */ 
/*     */   public List<EndpointMetaData> getEndpoints()
/*     */   {
/* 201 */     return new ArrayList(this.endpoints.values());
/*     */   }
/*     */ 
/*     */   public EndpointMetaData getEndpoint(QName portName)
/*     */   {
/* 206 */     return (EndpointMetaData)this.endpoints.get(portName);
/*     */   }
/*     */ 
/*     */   public EndpointMetaData removeEndpoint(QName portName)
/*     */   {
/* 211 */     return (EndpointMetaData)this.endpoints.remove(portName);
/*     */   }
/*     */ 
/*     */   public EndpointMetaData getEndpointByServiceEndpointInterface(String seiName)
/*     */   {
/* 216 */     EndpointMetaData epMetaData = null;
/* 217 */     for (EndpointMetaData epmd : this.endpoints.values())
/*     */     {
/* 219 */       if (seiName.equals(epmd.getServiceEndpointInterfaceName()))
/*     */       {
/* 221 */         if (epMetaData != null)
/*     */         {
/* 224 */           log.warn("Multiple possible endpoints implementing SEI: " + seiName);
/*     */         }
/* 226 */         epMetaData = epmd;
/*     */       }
/*     */     }
/* 229 */     return epMetaData;
/*     */   }
/*     */ 
/*     */   public void addEndpoint(EndpointMetaData epMetaData)
/*     */   {
/* 234 */     QName portName = epMetaData.getPortName();
/*     */ 
/* 238 */     if (this.endpoints.get(portName) != null) {
/* 239 */       throw new WSException("EndpointMetaData name must be unique: " + portName);
/*     */     }
/* 241 */     this.endpoints.put(portName, epMetaData);
/*     */   }
/*     */ 
/*     */   public URL getMappingLocation()
/*     */   {
/* 246 */     return this.mappingLocation;
/*     */   }
/*     */ 
/*     */   public void setMappingLocation(URL mappingLocation)
/*     */   {
/* 251 */     this.mappingLocation = mappingLocation;
/*     */   }
/*     */ 
/*     */   public JavaWsdlMapping getJavaWsdlMapping()
/*     */   {
/* 256 */     JavaWsdlMapping javaWsdlMapping = null;
/* 257 */     if (this.mappingLocation != null)
/*     */     {
/* 259 */       javaWsdlMapping = this.wsMetaData.getMappingDefinition(this.mappingLocation.toExternalForm());
/* 260 */       if (javaWsdlMapping == null)
/*     */       {
/*     */         try
/*     */         {
/* 264 */           JavaWsdlMappingFactory mappingFactory = JavaWsdlMappingFactory.newInstance();
/* 265 */           javaWsdlMapping = mappingFactory.parse(this.mappingLocation);
/* 266 */           this.wsMetaData.addMappingDefinition(this.mappingLocation.toExternalForm(), javaWsdlMapping);
/*     */         }
/*     */         catch (IOException e)
/*     */         {
/* 270 */           throw new WSException("Cannot parse jaxrpc-mapping.xml", e);
/*     */         }
/*     */       }
/*     */     }
/* 274 */     return javaWsdlMapping;
/*     */   }
/*     */ 
/*     */   public WSDLDefinitions getWsdlDefinitions()
/*     */   {
/* 282 */     URL wsdlURL = this.wsdlLocation;
/* 283 */     if ((wsdlURL == null) && (this.wsdlFile != null))
/*     */     {
/*     */       try
/*     */       {
/* 288 */         wsdlURL = new URL(this.wsdlFile);
/*     */       }
/*     */       catch (MalformedURLException e)
/*     */       {
/*     */       }
/*     */ 
/* 296 */       if (wsdlURL == null)
/*     */       {
/*     */         try
/*     */         {
/* 300 */           UnifiedVirtualFile vfsRoot = getUnifiedMetaData().getRootFile();
/* 301 */           wsdlURL = vfsRoot.findChild(this.wsdlFile).toURL();
/*     */         }
/*     */         catch (IOException ex)
/*     */         {
/* 305 */           throw new IllegalStateException("Cannot find wsdl: " + this.wsdlFile);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 310 */     WSDLDefinitions wsdlDefinitions = null;
/* 311 */     if (wsdlURL != null)
/*     */     {
/* 314 */       if (this.wsdlCacheKey == null) {
/* 315 */         this.wsdlCacheKey = ("#" + (this.wsdlLocation != null ? this.wsdlLocation : this.wsdlFile));
/*     */       }
/* 317 */       wsdlDefinitions = this.wsMetaData.getWsdlDefinition(this.wsdlCacheKey);
/* 318 */       if (wsdlDefinitions == null)
/*     */       {
/* 320 */         WSDLDefinitionsFactory factory = WSDLDefinitionsFactory.newInstance();
/* 321 */         wsdlDefinitions = factory.parse(wsdlURL);
/* 322 */         this.wsMetaData.addWsdlDefinition(this.wsdlCacheKey, wsdlDefinitions);
/*     */       }
/*     */     }
/* 325 */     return wsdlDefinitions;
/*     */   }
/*     */ 
/*     */   public TypeMappingImpl getTypeMapping()
/*     */   {
/* 330 */     Use encStyle = getEncodingStyle();
/* 331 */     TypeMappingImpl typeMapping = (TypeMappingImpl)this.tmRegistry.getTypeMapping(encStyle.toURI());
/* 332 */     if (typeMapping == null) {
/* 333 */       throw new WSException("No type mapping for encoding style: " + encStyle);
/*     */     }
/* 335 */     return typeMapping;
/*     */   }
/*     */ 
/*     */   public WSSecurityConfiguration getSecurityConfiguration()
/*     */   {
/* 340 */     return this.securityConfig;
/*     */   }
/*     */ 
/*     */   public void setSecurityConfiguration(WSSecurityConfiguration securityConfiguration)
/*     */   {
/* 345 */     this.securityConfig = securityConfiguration;
/*     */   }
/*     */ 
/*     */   public Use getEncodingStyle()
/*     */   {
/* 350 */     if (this.encStyle == null)
/*     */     {
/* 352 */       if (this.endpoints.size() > 0)
/*     */       {
/* 354 */         for (EndpointMetaData epMetaData : this.endpoints.values())
/*     */         {
/* 356 */           if (this.encStyle == null)
/*     */           {
/* 358 */             this.encStyle = epMetaData.getEncodingStyle();
/*     */           }
/* 360 */           else if (!this.encStyle.equals(epMetaData.getEncodingStyle()))
/*     */           {
/* 362 */             throw new WSException("Conflicting encoding styles not supported");
/*     */           }
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 368 */         this.encStyle = Use.LITERAL;
/*     */       }
/*     */     }
/* 371 */     return this.encStyle;
/*     */   }
/*     */ 
/*     */   public SchemaBinding getSchemaBinding()
/*     */   {
/* 376 */     JavaWsdlMapping wsdlMapping = getJavaWsdlMapping();
/* 377 */     if ((this.schemaBinding == null) && (getEncodingStyle() == Use.LITERAL) && (wsdlMapping != null))
/*     */     {
/* 379 */       JBossXSModel xsModel = this.types.getSchemaModel();
/* 380 */       SchemaBindingBuilder bindingBuilder = new SchemaBindingBuilder();
/* 381 */       this.schemaBinding = bindingBuilder.buildSchemaBinding(xsModel, wsdlMapping);
/*     */     }
/* 383 */     return this.schemaBinding;
/*     */   }
/*     */ 
/*     */   public void validate()
/*     */   {
/* 390 */     if (this.securityConfig != null)
/*     */     {
/* 392 */       int handlerCount = 0;
/* 393 */       for (EndpointMetaData epMetaData : this.endpoints.values())
/*     */       {
/* 395 */         handlerCount += epMetaData.getHandlerMetaData(UnifiedHandlerMetaData.HandlerType.ALL).size();
/*     */       }
/* 397 */       if (handlerCount == 0) {
/* 398 */         log.warn("WS-Security requires a security handler to be configured");
/*     */       }
/*     */     }
/*     */ 
/* 402 */     for (EndpointMetaData epMetaData : this.endpoints.values())
/* 403 */       epMetaData.validate();
/*     */   }
/*     */ 
/*     */   public void eagerInitialize()
/*     */   {
/* 412 */     WSDLDefinitions definitions = getWsdlDefinitions();
/* 413 */     if (definitions != null)
/*     */     {
/* 415 */       WSDLTypes types = definitions.getWsdlTypes();
/* 416 */       if (types != null)
/*     */       {
/* 418 */         JBossXSModel model = WSDLUtils.getSchemaModel(types);
/* 419 */         if (model != null) {
/* 420 */           model.eagerInitialize();
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 425 */     getJavaWsdlMapping();
/*     */ 
/* 428 */     for (EndpointMetaData epMetaData : this.endpoints.values()) {
/* 429 */       epMetaData.eagerInitialize();
/*     */     }
/*     */ 
/* 432 */     getSchemaBinding();
/*     */   }
/*     */ 
/*     */   public void assertTargetNamespace(String targetNS)
/*     */   {
/* 438 */     if (!getServiceName().getNamespaceURI().equals(targetNS))
/* 439 */       throw new WSException("Requested namespace is not WSDL target namespace: " + targetNS);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 444 */     StringBuilder buffer = new StringBuilder("\nServiceMetaData:");
/* 445 */     buffer.append("\n qname=" + this.serviceName);
/* 446 */     buffer.append("\n refName=" + this.serviceRefName);
/* 447 */     buffer.append("\n wsdName=" + this.wsdName);
/* 448 */     buffer.append("\n wsdlFile=" + this.wsdlFile);
/* 449 */     buffer.append("\n wsdlLocation=" + this.wsdlLocation);
/* 450 */     buffer.append("\n jaxrpcMapping=" + this.mappingLocation);
/* 451 */     buffer.append("\n publishLocation=" + this.wsdlPublishLocation);
/* 452 */     buffer.append("\n securityConfig=" + (this.securityConfig != null ? "found" : null));
/* 453 */     buffer.append("\n properties=" + this.properties);
/* 454 */     buffer.append("\n" + this.types);
/* 455 */     buffer.append("\n");
/* 456 */     for (EndpointMetaData epMetaData : this.endpoints.values())
/*     */     {
/* 458 */       buffer.append(epMetaData);
/*     */     }
/* 460 */     return buffer.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.metadata.umdm.ServiceMetaData
 * JD-Core Version:    0.6.0
 */