/*     */ package org.jboss.ws.metadata.umdm;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Type;
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashSet;
/*     */ import java.util.List;
/*     */ import java.util.Set;
/*     */ import java.util.StringTokenizer;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.rpc.ParameterMode;
/*     */ import javax.xml.soap.SOAPElement;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.core.jaxrpc.ParameterWrapping;
/*     */ import org.jboss.ws.core.jaxws.DynamicWrapperGenerator;
/*     */ import org.jboss.ws.core.utils.HolderUtils;
/*     */ import org.jboss.ws.extensions.xop.jaxws.AttachmentScanResult;
/*     */ import org.jboss.ws.extensions.xop.jaxws.AttachmentScanResult.Type;
/*     */ import org.jboss.ws.extensions.xop.jaxws.ReflectiveAttachmentRefScanner;
/*     */ import org.jboss.ws.metadata.acessor.ReflectiveMethodAccessor;
/*     */ import org.jboss.ws.metadata.config.CommonConfig;
/*     */ import org.jboss.wsf.common.JavaUtils;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class ParameterMetaData
/*     */ {
/*  59 */   private final Logger log = Logger.getLogger(ParameterMetaData.class);
/*     */   private OperationMetaData opMetaData;
/*     */   private QName xmlName;
/*     */   private String partName;
/*     */   private QName xmlType;
/*     */   private String javaTypeName;
/*     */   private Class javaType;
/*     */   private ParameterMode mode;
/*     */   private Set<String> mimeTypes;
/*     */   private boolean inHeader;
/*     */   private boolean isSwA;
/*     */   private boolean isXOP;
/*     */   private boolean isSwaRef;
/*     */   private List<WrappedParameter> wrappedParameters;
/*     */   private int index;
/*     */   private boolean soapArrayParam;
/*     */   private QName soapArrayCompType;
/*  81 */   private AccessorFactoryCreator accessorFactoryCreator = ReflectiveMethodAccessor.FACTORY_CREATOR;
/*     */ 
/*  83 */   private static final List<String> messageTypes = new ArrayList();
/*     */ 
/*     */   public ParameterMetaData(OperationMetaData opMetaData, QName xmlName, QName xmlType, String javaTypeName)
/*     */   {
/*  92 */     this(opMetaData, xmlName, javaTypeName);
/*  93 */     setXmlType(xmlType);
/*     */   }
/*     */ 
/*     */   public ParameterMetaData(OperationMetaData opMetaData, QName xmlName, String javaTypeName)
/*     */   {
/*  98 */     if (xmlName == null) {
/*  99 */       throw new IllegalArgumentException("Invalid null xmlName argument");
/*     */     }
/*     */ 
/* 102 */     if (xmlName.getNamespaceURI().length() > 0) {
/* 103 */       xmlName = new QName(xmlName.getNamespaceURI(), xmlName.getLocalPart());
/*     */     }
/* 105 */     this.xmlName = xmlName;
/* 106 */     this.opMetaData = opMetaData;
/* 107 */     this.mode = ParameterMode.IN;
/* 108 */     this.javaTypeName = javaTypeName;
/* 109 */     this.partName = xmlName.getLocalPart();
/*     */   }
/*     */ 
/*     */   private static boolean matchParameter(Method method, int index, Class expectedType, Set<Integer> matches, boolean exact, boolean holder)
/*     */   {
/* 114 */     Class returnType = method.getReturnType();
/*     */ 
/* 116 */     if ((index == -1) && (matchTypes(returnType, expectedType, exact, false))) {
/* 117 */       return true;
/*     */     }
/* 119 */     Class[] classParameters = method.getParameterTypes();
/* 120 */     if ((index < 0) || (index >= classParameters.length))
/* 121 */       return false;
/*     */     boolean matchTypes;
/*     */     boolean matchTypes;
/* 125 */     if (JavaUtils.isRetro14())
/*     */     {
/* 127 */       matchTypes = matchTypes(classParameters[index], expectedType, exact, holder);
/*     */     }
/*     */     else
/*     */     {
/* 131 */       Type[] genericParameters = method.getGenericParameterTypes();
/* 132 */       matchTypes = matchTypes(genericParameters[index], expectedType, exact, holder);
/*     */     }
/*     */ 
/* 135 */     if (matchTypes)
/*     */     {
/* 137 */       matches.add(Integer.valueOf(index));
/* 138 */       return true;
/*     */     }
/*     */ 
/* 141 */     return false;
/*     */   }
/*     */ 
/*     */   private static boolean matchTypes(Type actualType, Class expectedType, boolean exact, boolean holder)
/*     */   {
/* 146 */     if ((holder) && (!HolderUtils.isHolderType(actualType))) {
/* 147 */       return false;
/*     */     }
/* 149 */     Type valueType = holder ? HolderUtils.getValueType(actualType) : actualType;
/* 150 */     Class valueClass = JavaUtils.erasure(valueType);
/*     */ 
/* 152 */     return matchTypesInternal(valueClass, expectedType, exact);
/*     */   }
/*     */ 
/*     */   private static boolean matchTypes(Class actualType, Class expectedType, boolean exact, boolean holder)
/*     */   {
/* 160 */     if ((holder) && (!HolderUtils.isHolderType(actualType))) {
/* 161 */       return false;
/*     */     }
/* 163 */     Class valueClass = holder ? HolderUtils.getValueType(actualType) : actualType;
/*     */ 
/* 165 */     return matchTypesInternal(valueClass, expectedType, exact);
/*     */   }
/*     */ 
/*     */   private static boolean matchTypesInternal(Class valueClass, Class expectedType, boolean exact)
/*     */   {
/* 171 */     List anyTypes = new ArrayList();
/* 172 */     anyTypes.add(SOAPElement.class);
/* 173 */     anyTypes.add(Element.class);
/*     */     boolean matched;
/* 176 */     if (exact)
/*     */     {
/* 178 */       boolean matched = valueClass.getName().equals(expectedType.getName());
/* 179 */       if ((!matched) && (anyTypes.contains(valueClass)))
/* 180 */         matched = anyTypes.contains(expectedType);
/*     */     }
/*     */     else
/*     */     {
/* 184 */       matched = JavaUtils.isAssignableFrom(valueClass, expectedType);
/*     */     }
/* 186 */     return matched;
/*     */   }
/*     */ 
/*     */   public OperationMetaData getOperationMetaData()
/*     */   {
/* 191 */     return this.opMetaData;
/*     */   }
/*     */ 
/*     */   public QName getXmlName()
/*     */   {
/* 196 */     return this.xmlName;
/*     */   }
/*     */ 
/*     */   public QName getXmlType()
/*     */   {
/* 201 */     return this.xmlType;
/*     */   }
/*     */ 
/*     */   public void setXmlType(QName xmlType)
/*     */   {
/* 206 */     if (xmlType == null) {
/* 207 */       throw new IllegalArgumentException("Invalid null xmlType");
/*     */     }
/*     */ 
/* 210 */     if (xmlType.getNamespaceURI().length() > 0)
/* 211 */       this.xmlType = new QName(xmlType.getNamespaceURI(), xmlType.getLocalPart());
/* 212 */     else this.xmlType = xmlType;
/*     */ 
/* 215 */     if ("http://www.jboss.org/jbossws/attachment/mimetype".equals(xmlType.getNamespaceURI()))
/*     */     {
/* 217 */       String mimeType = convertXmlTypeToMimeType(xmlType);
/* 218 */       setMimeTypes(mimeType);
/* 219 */       this.isSwA = true;
/*     */     }
/*     */   }
/*     */ 
/*     */   public String getJavaTypeName()
/*     */   {
/* 225 */     return this.javaTypeName;
/*     */   }
/*     */ 
/*     */   public void setJavaTypeName(String typeName)
/*     */   {
/* 231 */     UnifiedMetaData wsMetaData = this.opMetaData.getEndpointMetaData().getServiceMetaData().getUnifiedMetaData();
/* 232 */     if ((wsMetaData.isEagerInitialized()) && (!UnifiedMetaData.isFinalRelease())) {
/* 233 */       this.log.warn("Set java type name after eager initialization", new IllegalStateException());
/*     */     }
/* 235 */     this.javaTypeName = typeName;
/* 236 */     this.javaType = null;
/*     */   }
/*     */ 
/*     */   public Class loadWrapperBean()
/*     */   {
/* 241 */     Class wrapperBean = null;
/*     */     try
/*     */     {
/* 244 */       ClassLoader loader = getClassLoader();
/* 245 */       wrapperBean = JavaUtils.loadJavaType(this.javaTypeName, loader);
/*     */     }
/*     */     catch (ClassNotFoundException ex)
/*     */     {
/*     */     }
/*     */ 
/* 251 */     return wrapperBean;
/*     */   }
/*     */ 
/*     */   public Class getJavaType()
/*     */   {
/* 259 */     Class tmpJavaType = this.javaType;
/* 260 */     if ((tmpJavaType == null) && (this.javaTypeName != null))
/*     */     {
/*     */       try
/*     */       {
/* 264 */         ClassLoader loader = getClassLoader();
/* 265 */         tmpJavaType = JavaUtils.loadJavaType(this.javaTypeName, loader);
/*     */ 
/* 267 */         UnifiedMetaData wsMetaData = this.opMetaData.getEndpointMetaData().getServiceMetaData().getUnifiedMetaData();
/* 268 */         if (wsMetaData.isEagerInitialized())
/*     */         {
/* 271 */           this.javaType = tmpJavaType;
/*     */         }
/*     */       }
/*     */       catch (ClassNotFoundException ex)
/*     */       {
/* 276 */         throw new WSException("Cannot load java type: " + this.javaTypeName, ex);
/*     */       }
/*     */     }
/* 279 */     return tmpJavaType;
/*     */   }
/*     */ 
/*     */   public ParameterMode getMode()
/*     */   {
/* 284 */     return this.mode;
/*     */   }
/*     */ 
/*     */   public void setMode(String mode)
/*     */   {
/* 289 */     if ("IN".equals(mode))
/* 290 */       setMode(ParameterMode.IN);
/* 291 */     else if ("INOUT".equals(mode))
/* 292 */       setMode(ParameterMode.INOUT);
/* 293 */     else if ("OUT".equals(mode))
/* 294 */       setMode(ParameterMode.OUT);
/* 295 */     else throw new IllegalArgumentException("Invalid mode: " + mode);
/*     */   }
/*     */ 
/*     */   public void setMode(ParameterMode mode)
/*     */   {
/* 300 */     this.mode = mode;
/*     */   }
/*     */ 
/*     */   public Set<String> getMimeTypes()
/*     */   {
/* 305 */     return this.mimeTypes;
/*     */   }
/*     */ 
/*     */   public void setMimeTypes(String mimeStr)
/*     */   {
/* 310 */     this.mimeTypes = new HashSet();
/* 311 */     StringTokenizer st = new StringTokenizer(mimeStr, ",");
/* 312 */     while (st.hasMoreTokens())
/* 313 */       this.mimeTypes.add(st.nextToken().trim());
/*     */   }
/*     */ 
/*     */   public boolean isInHeader()
/*     */   {
/* 318 */     return this.inHeader;
/*     */   }
/*     */ 
/*     */   public void setInHeader(boolean inHeader)
/*     */   {
/* 323 */     this.inHeader = inHeader;
/*     */   }
/*     */ 
/*     */   public boolean isSwA()
/*     */   {
/* 328 */     return this.isSwA;
/*     */   }
/*     */ 
/*     */   public void setSwA(boolean isSwA)
/*     */   {
/* 333 */     this.isSwA = isSwA;
/*     */   }
/*     */ 
/*     */   public boolean isSwaRef()
/*     */   {
/* 338 */     return this.isSwaRef;
/*     */   }
/*     */ 
/*     */   public void setSwaRef(boolean swaRef)
/*     */   {
/* 343 */     this.isSwaRef = swaRef;
/*     */   }
/*     */ 
/*     */   public boolean isXOP()
/*     */   {
/* 348 */     return this.isXOP;
/*     */   }
/*     */ 
/*     */   public void setXOP(boolean isXOP)
/*     */   {
/* 353 */     this.isXOP = isXOP;
/*     */   }
/*     */ 
/*     */   public boolean isSOAPArrayParam()
/*     */   {
/* 358 */     return this.soapArrayParam;
/*     */   }
/*     */ 
/*     */   public void setSOAPArrayParam(boolean soapArrayParam)
/*     */   {
/* 363 */     this.soapArrayParam = soapArrayParam;
/*     */   }
/*     */ 
/*     */   public QName getSOAPArrayCompType()
/*     */   {
/* 368 */     return this.soapArrayCompType;
/*     */   }
/*     */ 
/*     */   public void setSOAPArrayCompType(QName compXmlType)
/*     */   {
/* 373 */     if ((compXmlType != null) && (!compXmlType.equals(this.soapArrayCompType)))
/*     */     {
/* 375 */       String logmsg = "SOAPArrayCompType: [xmlType=" + this.xmlType + ",compType=" + compXmlType + "]";
/* 376 */       this.log.debug((this.soapArrayCompType == null ? "set" : "reset") + logmsg);
/*     */     }
/*     */ 
/* 379 */     this.soapArrayCompType = compXmlType;
/*     */   }
/*     */ 
/*     */   @Deprecated
/*     */   public boolean isMessageType()
/*     */   {
/* 387 */     return messageTypes.contains(this.javaTypeName);
/*     */   }
/*     */ 
/*     */   @Deprecated
/*     */   public static boolean isMessageType(String javaTypeName) {
/* 393 */     return messageTypes.contains(javaTypeName);
/*     */   }
/*     */ 
/*     */   private String convertXmlTypeToMimeType(QName xmlType)
/*     */   {
/* 400 */     StringBuilder mimeName = new StringBuilder(xmlType.getLocalPart());
/* 401 */     int pos = mimeName.indexOf("_");
/* 402 */     if (pos == -1) {
/* 403 */       throw new IllegalArgumentException("Invalid mime type: " + xmlType);
/*     */     }
/* 405 */     mimeName.setCharAt(pos, '/');
/* 406 */     return mimeName.toString();
/*     */   }
/*     */ 
/*     */   public int getIndex()
/*     */   {
/* 411 */     return this.index;
/*     */   }
/*     */ 
/*     */   public void setIndex(int index)
/*     */   {
/* 422 */     this.index = index;
/*     */   }
/*     */ 
/*     */   public List<WrappedParameter> getWrappedParameters()
/*     */   {
/* 427 */     return this.wrappedParameters;
/*     */   }
/*     */ 
/*     */   public void setWrappedParameters(List<WrappedParameter> wrappedParameters)
/*     */   {
/* 432 */     this.wrappedParameters = wrappedParameters;
/*     */   }
/*     */ 
/*     */   public String getPartName()
/*     */   {
/* 438 */     String auxPartName = this.partName;
/* 439 */     if (this.opMetaData.getEndpointMetaData().getConfig().hasFeature("http://org.jboss.ws/binding/wsdl/dotnet"))
/*     */     {
/* 441 */       if ((this.opMetaData.isDocumentWrapped()) && (!this.inHeader))
/* 442 */         auxPartName = "parameters";
/*     */     }
/* 444 */     return auxPartName;
/*     */   }
/*     */ 
/*     */   public void setPartName(String partName)
/*     */   {
/* 449 */     this.partName = partName;
/*     */   }
/*     */ 
/*     */   public void validate()
/*     */   {
/*     */   }
/*     */ 
/*     */   public void eagerInitialize()
/*     */   {
/* 463 */     this.javaType = null;
/*     */ 
/* 466 */     EndpointMetaData.Type epType = getOperationMetaData().getEndpointMetaData().getType();
/*     */     AccessorFactory factory;
/* 467 */     if ((getOperationMetaData().isDocumentWrapped()) && (!isInHeader()) && (!isSwA()) && (!isMessageType()))
/*     */     {
/* 469 */       if (loadWrapperBean() == null)
/*     */       {
/* 471 */         if (epType == EndpointMetaData.Type.JAXRPC) {
/* 472 */           throw new WSException("Autogeneration of wrapper beans not supported with JAXRPC");
/*     */         }
/* 474 */         new DynamicWrapperGenerator(getClassLoader()).generate(this);
/*     */       }
/*     */ 
/* 478 */       factory = this.accessorFactoryCreator.create(this);
/* 479 */       for (WrappedParameter wrapped : this.wrappedParameters) {
/* 480 */         wrapped.setAccessor(factory.create(wrapped));
/*     */       }
/*     */     }
/* 483 */     this.javaType = getJavaType();
/* 484 */     if (this.javaType == null) {
/* 485 */       throw new WSException("Cannot load java type: " + this.javaTypeName);
/*     */     }
/* 487 */     initializeAttachmentParameter(epType);
/*     */   }
/*     */ 
/*     */   private void initializeAttachmentParameter(EndpointMetaData.Type epType)
/*     */   {
/* 499 */     if (epType == EndpointMetaData.Type.JAXWS)
/*     */     {
/* 501 */       ReflectiveAttachmentRefScanner scanner = new ReflectiveAttachmentRefScanner();
/* 502 */       AttachmentScanResult scanResult = scanner.scanBean(this.javaType);
/* 503 */       if (scanResult != null)
/*     */       {
/* 505 */         if (this.log.isDebugEnabled()) this.log.debug("Identified attachment reference: " + this.xmlName + ", type=" + scanResult.getType());
/* 506 */         if (scanResult.getType() == AttachmentScanResult.Type.XOP)
/* 507 */           setXOP(true);
/*     */         else
/* 509 */           setSwaRef(true);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private ClassLoader getClassLoader()
/*     */   {
/* 516 */     ClassLoader loader = this.opMetaData.getEndpointMetaData().getClassLoader();
/* 517 */     if (loader == null)
/* 518 */       throw new WSException("ClassLoader not available");
/* 519 */     return loader;
/*     */   }
/*     */ 
/*     */   public boolean matchParameter(Method method, Set<Integer> matches, boolean exact)
/*     */   {
/* 524 */     ClassLoader loader = getOperationMetaData().getEndpointMetaData().getClassLoader();
/* 525 */     List wrappedParameters = getWrappedParameters();
/* 526 */     Class wrapperType = getJavaType();
/*     */ 
/* 529 */     if (wrappedParameters == null) {
/* 530 */       return matchParameter(method, getIndex(), getJavaType(), matches, exact, this.mode != ParameterMode.IN);
/*     */     }
/*     */ 
/* 533 */     for (WrappedParameter wrapped : wrappedParameters)
/*     */     {
/* 535 */       String typeName = wrapped.getType();
/*     */       try
/*     */       {
/* 539 */         Class type = typeName != null ? JavaUtils.loadJavaType(typeName, loader) : ParameterWrapping.getWrappedType(wrapped.getVariable(), wrapperType);
/* 540 */         if (type == null)
/* 541 */           return false;
/* 542 */         if (!matchParameter(method, wrapped.getIndex(), type, matches, exact, wrapped.isHolder()))
/* 543 */           return false;
/*     */       }
/*     */       catch (Exception ex)
/*     */       {
/* 547 */         if (this.log.isDebugEnabled()) this.log.debug("Invalid wrapper type:" + typeName, ex);
/* 548 */         return false;
/*     */       }
/*     */     }
/*     */ 
/* 552 */     return true;
/*     */   }
/*     */ 
/*     */   public void setAccessorFactoryCreator(AccessorFactoryCreator accessorFactoryCreator)
/*     */   {
/* 557 */     this.accessorFactoryCreator = accessorFactoryCreator;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 562 */     boolean isReturn = this.opMetaData.getReturnParameter() == this;
/* 563 */     StringBuilder buffer = new StringBuilder("\n" + (isReturn ? "ReturnMetaData:" : "ParameterMetaData:"));
/* 564 */     buffer.append("\n xmlName=" + getXmlName());
/* 565 */     buffer.append("\n partName=" + getPartName());
/* 566 */     buffer.append("\n xmlType=" + getXmlType());
/*     */ 
/* 568 */     if (this.soapArrayParam) {
/* 569 */       buffer.append("\n soapArrayCompType=" + this.soapArrayCompType);
/*     */     }
/* 571 */     buffer.append("\n javaType=" + getJavaTypeName());
/* 572 */     buffer.append("\n mode=" + getMode());
/* 573 */     buffer.append("\n inHeader=" + isInHeader());
/* 574 */     buffer.append("\n index=" + this.index);
/*     */ 
/* 576 */     if (isSwA())
/*     */     {
/* 578 */       buffer.append("\n isSwA=" + isSwA());
/* 579 */       buffer.append("\n mimeTypes=" + getMimeTypes());
/*     */     }
/*     */ 
/* 582 */     if (isXOP())
/*     */     {
/* 584 */       buffer.append("\n isXOP=" + isXOP());
/* 585 */       buffer.append("\n mimeTypes=" + getMimeTypes());
/*     */     }
/*     */ 
/* 588 */     if (this.wrappedParameters != null) {
/* 589 */       buffer.append("\n wrappedParameters=" + this.wrappedParameters);
/*     */     }
/* 591 */     return buffer.toString();
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  86 */     messageTypes.add("javax.xml.soap.SOAPElement");
/*  87 */     messageTypes.add("org.w3c.dom.Element");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.metadata.umdm.ParameterMetaData
 * JD-Core Version:    0.6.0
 */