/*     */ package org.jboss.ws.metadata.umdm;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashSet;
/*     */ import java.util.List;
/*     */ import java.util.Set;
/*     */ import javax.jws.soap.SOAPBinding.ParameterStyle;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.rpc.ParameterMode;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.core.soap.Style;
/*     */ import org.jboss.ws.core.soap.Use;
/*     */ import org.jboss.wsf.common.JavaUtils;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class OperationMetaData extends ExtensibleMetaData
/*     */ {
/*  55 */   private final Logger log = Logger.getLogger(OperationMetaData.class);
/*     */   private EndpointMetaData epMetaData;
/*     */   private QName qname;
/*     */   private QName responseName;
/*     */   private String javaName;
/*     */   private Method javaMethod;
/*     */   private boolean oneWay;
/*     */   private String soapAction;
/*     */   private SOAPBinding.ParameterStyle parameterStyle;
/*  67 */   private List<ParameterMetaData> parameters = new ArrayList();
/*  68 */   private List<FaultMetaData> faults = new ArrayList();
/*     */   private ParameterMetaData returnParam;
/*     */ 
/*     */   public OperationMetaData(EndpointMetaData epMetaData, QName qname, String javaName)
/*     */   {
/*  73 */     this.log.trace("new OperationMetaData: [xmlName=" + qname + ",javaName=" + javaName + "]");
/*  74 */     initOperationMetaData(epMetaData, qname, javaName);
/*     */   }
/*     */ 
/*     */   private void initOperationMetaData(EndpointMetaData epMetaData, QName qname, String javaName)
/*     */   {
/*  79 */     this.epMetaData = epMetaData;
/*  80 */     this.qname = qname;
/*  81 */     this.javaName = javaName;
/*     */ 
/*  83 */     if (qname == null)
/*  84 */       throw new IllegalArgumentException("Invalid null qname argument");
/*  85 */     if (javaName == null) {
/*  86 */       throw new IllegalArgumentException("Invalid null javaName argument, for: " + qname);
/*     */     }
/*  88 */     String nsURI = qname.getNamespaceURI();
/*  89 */     String localPart = qname.getLocalPart();
/*  90 */     this.responseName = new QName(nsURI, localPart + "Response");
/*     */   }
/*     */ 
/*     */   public EndpointMetaData getEndpointMetaData()
/*     */   {
/*  95 */     return this.epMetaData;
/*     */   }
/*     */ 
/*     */   public QName getQName()
/*     */   {
/* 100 */     return this.qname;
/*     */   }
/*     */ 
/*     */   public QName getResponseName()
/*     */   {
/* 105 */     return this.responseName;
/*     */   }
/*     */ 
/*     */   public String getSOAPAction()
/*     */   {
/* 110 */     return this.soapAction;
/*     */   }
/*     */ 
/*     */   public void setSOAPAction(String soapAction)
/*     */   {
/* 115 */     this.soapAction = soapAction;
/*     */   }
/*     */ 
/*     */   public Style getStyle()
/*     */   {
/* 120 */     return this.epMetaData.getStyle();
/*     */   }
/*     */ 
/*     */   public Use getUse()
/*     */   {
/* 125 */     return this.epMetaData.getEncodingStyle();
/*     */   }
/*     */ 
/*     */   public SOAPBinding.ParameterStyle getParameterStyle()
/*     */   {
/* 130 */     return this.parameterStyle != null ? this.parameterStyle : this.epMetaData.getParameterStyle();
/*     */   }
/*     */ 
/*     */   public void setParameterStyle(SOAPBinding.ParameterStyle parameterStyle)
/*     */   {
/* 135 */     this.parameterStyle = parameterStyle;
/*     */   }
/*     */ 
/*     */   public boolean isRPCLiteral()
/*     */   {
/* 140 */     return (getStyle() == Style.RPC) && (getUse() == Use.LITERAL);
/*     */   }
/*     */ 
/*     */   public boolean isRPCEncoded()
/*     */   {
/* 145 */     return (getStyle() == Style.RPC) && (getUse() == Use.ENCODED);
/*     */   }
/*     */ 
/*     */   public boolean isDocumentBare()
/*     */   {
/* 150 */     return (getStyle() == Style.DOCUMENT) && (getParameterStyle() == SOAPBinding.ParameterStyle.BARE);
/*     */   }
/*     */ 
/*     */   public boolean isDocumentWrapped()
/*     */   {
/* 155 */     return (getStyle() == Style.DOCUMENT) && (getParameterStyle() == SOAPBinding.ParameterStyle.WRAPPED);
/*     */   }
/*     */ 
/*     */   public String getJavaName()
/*     */   {
/* 160 */     return this.javaName;
/*     */   }
/*     */ 
/*     */   public Method getJavaMethod()
/*     */   {
/* 165 */     Method tmpMethod = this.javaMethod;
/* 166 */     Class seiClass = this.epMetaData.getServiceEndpointInterface();
/* 167 */     if ((tmpMethod == null) && (seiClass != null))
/*     */     {
/* 169 */       for (Method method : seiClass.getMethods())
/*     */       {
/* 171 */         if (!isJavaMethod(method))
/*     */           continue;
/* 173 */         tmpMethod = method;
/*     */ 
/* 175 */         UnifiedMetaData wsMetaData = this.epMetaData.getServiceMetaData().getUnifiedMetaData();
/* 176 */         if (!wsMetaData.isEagerInitialized())
/*     */           break;
/* 178 */         if (!UnifiedMetaData.isFinalRelease()) {
/* 179 */           this.log.warn("Loading java method after eager initialization", new IllegalStateException());
/*     */         }
/* 181 */         this.javaMethod = method; break;
/*     */       }
/*     */ 
/* 188 */       if (tmpMethod == null)
/* 189 */         throw new WSException("Cannot find java method: " + this.javaName);
/*     */     }
/* 191 */     return tmpMethod;
/*     */   }
/*     */ 
/*     */   public boolean isJavaMethod(Method method)
/*     */   {
/* 196 */     boolean isJavaMethod = method.equals(this.javaMethod);
/* 197 */     if (!isJavaMethod)
/*     */     {
/* 199 */       String methodName = method.getName();
/* 200 */       if (this.javaName.equals(methodName))
/*     */       {
/* 202 */         this.log.trace("Found java method: " + method);
/*     */ 
/* 205 */         if (matchParameters(method, true))
/*     */         {
/* 207 */           if (this.log.isDebugEnabled()) this.log.debug("Found best matching java method: " + method);
/* 208 */           isJavaMethod = true;
/*     */         }
/*     */ 
/* 212 */         if ((!isJavaMethod) && (matchParameters(method, false)))
/*     */         {
/* 214 */           if (this.log.isDebugEnabled()) this.log.debug("Found possible matching java method: " + method);
/* 215 */           isJavaMethod = true;
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 220 */     if (this.log.isTraceEnabled()) {
/* 221 */       this.log.trace("Synchronized java method:\n" + method + "\nwith: " + toString());
/*     */     }
/* 223 */     return isJavaMethod;
/*     */   }
/*     */ 
/*     */   private boolean matchParameters(Method method, boolean exact)
/*     */   {
/* 228 */     Class[] paramTypes = method.getParameterTypes();
/* 229 */     Set matches = new HashSet(paramTypes.length);
/*     */ 
/* 231 */     for (ParameterMetaData param : getParameters())
/*     */     {
/* 233 */       if (!param.matchParameter(method, matches, exact)) {
/* 234 */         return false;
/*     */       }
/*     */     }
/* 237 */     ParameterMetaData returnMetaData = getReturnParameter();
/* 238 */     if ((returnMetaData != null) && (!returnMetaData.matchParameter(method, matches, exact))) {
/* 239 */       return false;
/*     */     }
/*     */ 
/* 242 */     return matches.size() == paramTypes.length;
/*     */   }
/*     */ 
/*     */   public boolean isMessageEndpoint()
/*     */   {
/* 249 */     boolean isMessageEndpoint = false;
/* 250 */     if (this.parameters.size() == 1)
/*     */     {
/* 252 */       ParameterMetaData inParam = (ParameterMetaData)this.parameters.get(0);
/* 253 */       if (JavaUtils.isAssignableFrom(Element.class, inParam.getJavaType()))
/*     */       {
/* 255 */         isMessageEndpoint = true;
/*     */       }
/*     */     }
/* 258 */     return isMessageEndpoint;
/*     */   }
/*     */ 
/*     */   public boolean isOneWay()
/*     */   {
/* 263 */     return this.oneWay;
/*     */   }
/*     */ 
/*     */   public void setOneWay(boolean oneWay)
/*     */   {
/* 268 */     this.oneWay = oneWay;
/* 269 */     assertOneWayOperation();
/*     */   }
/*     */ 
/*     */   public ParameterMetaData getParameter(QName xmlName)
/*     */   {
/* 274 */     ParameterMetaData paramMetaData = null;
/* 275 */     for (int i = 0; (paramMetaData == null) && (i < this.parameters.size()); i++)
/*     */     {
/* 277 */       ParameterMetaData aux = (ParameterMetaData)this.parameters.get(i);
/* 278 */       if (xmlName.equals(aux.getXmlName()))
/* 279 */         paramMetaData = aux;
/*     */     }
/* 281 */     return paramMetaData;
/*     */   }
/*     */ 
/*     */   public List<ParameterMetaData> getInputParameters()
/*     */   {
/* 287 */     List retList = new ArrayList();
/* 288 */     for (ParameterMetaData paramMetaData : this.parameters)
/*     */     {
/* 290 */       ParameterMode mode = paramMetaData.getMode();
/* 291 */       if ((mode == ParameterMode.IN) || (mode == ParameterMode.INOUT))
/* 292 */         retList.add(paramMetaData);
/*     */     }
/* 294 */     return retList;
/*     */   }
/*     */ 
/*     */   public List<ParameterMetaData> getOutputParameters()
/*     */   {
/* 300 */     List retList = new ArrayList();
/* 301 */     for (ParameterMetaData paramMetaData : this.parameters)
/*     */     {
/* 303 */       ParameterMode mode = paramMetaData.getMode();
/* 304 */       if ((mode == ParameterMode.OUT) || (mode == ParameterMode.INOUT))
/* 305 */         retList.add(paramMetaData);
/*     */     }
/* 307 */     return retList;
/*     */   }
/*     */ 
/*     */   public List<ParameterMetaData> getNonHeaderParameters()
/*     */   {
/* 313 */     List retList = new ArrayList();
/* 314 */     for (ParameterMetaData paramMetaData : this.parameters)
/*     */     {
/* 316 */       if (!paramMetaData.isInHeader())
/* 317 */         retList.add(paramMetaData);
/*     */     }
/* 319 */     return retList;
/*     */   }
/*     */ 
/*     */   public List<ParameterMetaData> getParameters()
/*     */   {
/* 324 */     return new ArrayList(this.parameters);
/*     */   }
/*     */ 
/*     */   public void addParameter(ParameterMetaData pmd)
/*     */   {
/* 329 */     this.log.trace("addParameter: [xmlName=" + pmd.getXmlName() + ",xmlType=" + pmd.getXmlType() + "]");
/* 330 */     this.parameters.add(pmd);
/* 331 */     assertOneWayOperation();
/*     */   }
/*     */ 
/*     */   public void removeAllParameters()
/*     */   {
/* 336 */     this.parameters.clear();
/*     */   }
/*     */ 
/*     */   public ParameterMetaData getReturnParameter()
/*     */   {
/* 341 */     return this.returnParam;
/*     */   }
/*     */ 
/*     */   public void setReturnParameter(ParameterMetaData returnParam)
/*     */   {
/* 346 */     this.log.trace("setReturnParameter: " + returnParam);
/* 347 */     returnParam.setMode(ParameterMode.OUT);
/* 348 */     returnParam.setIndex(-1);
/* 349 */     this.returnParam = returnParam;
/* 350 */     assertOneWayOperation();
/*     */   }
/*     */ 
/*     */   public List<FaultMetaData> getFaults()
/*     */   {
/* 355 */     return new ArrayList(this.faults);
/*     */   }
/*     */ 
/*     */   public FaultMetaData getFault(QName xmlName)
/*     */   {
/* 360 */     FaultMetaData faultMetaData = null;
/* 361 */     for (int i = 0; (faultMetaData == null) && (i < this.faults.size()); i++)
/*     */     {
/* 363 */       FaultMetaData aux = (FaultMetaData)this.faults.get(i);
/* 364 */       if (aux.getXmlName().equals(xmlName))
/* 365 */         faultMetaData = aux;
/*     */     }
/* 367 */     return faultMetaData;
/*     */   }
/*     */ 
/*     */   public FaultMetaData getFaultMetaData(Class javaType)
/*     */   {
/* 372 */     FaultMetaData faultMetaData = null;
/* 373 */     for (FaultMetaData aux : this.faults)
/*     */     {
/* 375 */       if (aux.getJavaType().equals(javaType))
/*     */       {
/* 377 */         faultMetaData = aux;
/* 378 */         break;
/*     */       }
/*     */     }
/* 381 */     return faultMetaData;
/*     */   }
/*     */ 
/*     */   public void addFault(FaultMetaData fault)
/*     */   {
/* 386 */     this.log.trace("addFault: " + fault);
/* 387 */     this.faults.add(fault);
/* 388 */     assertOneWayOperation();
/*     */   }
/*     */ 
/*     */   private void assertOneWayOperation()
/*     */   {
/* 396 */     if (this.oneWay)
/*     */     {
/* 398 */       if (this.returnParam != null) {
/* 399 */         throw new WSException("OneWay operations cannot have a return parameter");
/*     */       }
/* 401 */       if (this.faults.size() > 0) {
/* 402 */         throw new WSException("OneWay operations cannot have checked exceptions");
/*     */       }
/* 404 */       for (ParameterMetaData paramMetaData : this.parameters)
/*     */       {
/* 406 */         if (paramMetaData.getMode() != ParameterMode.IN)
/* 407 */           throw new WSException("OneWay operations cannot have INOUT or OUT parameters");
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void assertDocumentBare()
/*     */   {
/* 414 */     if (isDocumentBare())
/*     */     {
/* 416 */       int in = 0;
/* 417 */       int out = 0;
/*     */ 
/* 419 */       for (ParameterMetaData paramMetaData : this.parameters)
/*     */       {
/* 421 */         if (paramMetaData.isInHeader()) {
/*     */           continue;
/*     */         }
/* 424 */         ParameterMode mode = paramMetaData.getMode();
/* 425 */         if (mode != ParameterMode.OUT)
/* 426 */           in++;
/* 427 */         if (mode != ParameterMode.IN) {
/* 428 */           out++;
/*     */         }
/*     */       }
/* 431 */       if ((this.returnParam != null) && (!this.returnParam.isInHeader())) {
/* 432 */         out++;
/*     */       }
/* 434 */       if (in <= 1) { if (out <= (this.oneWay ? 0 : 1)); } else throw new WSException("The body of a document/literal bare message requires at most 1 input and at most 1 output (or 0 if oneway). method: " + this.javaName + " in: " + in + " out: " + out);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void validate()
/*     */   {
/* 442 */     for (ParameterMetaData parameter : this.parameters) {
/* 443 */       parameter.validate();
/*     */     }
/* 445 */     for (FaultMetaData fault : this.faults)
/* 446 */       fault.validate();
/*     */   }
/*     */ 
/*     */   public void eagerInitialize(List<Method> unsynchronizedMethods)
/*     */   {
/* 455 */     this.javaMethod = null;
/*     */ 
/* 457 */     for (ParameterMetaData parameter : this.parameters) {
/* 458 */       parameter.eagerInitialize();
/*     */     }
/* 460 */     if (this.returnParam != null) {
/* 461 */       this.returnParam.eagerInitialize();
/*     */     }
/* 463 */     for (FaultMetaData fault : this.faults) {
/* 464 */       fault.eagerInitialize();
/*     */     }
/*     */ 
/* 467 */     for (Method method : unsynchronizedMethods)
/*     */     {
/* 469 */       if (isJavaMethod(method))
/*     */       {
/* 471 */         this.javaMethod = method;
/* 472 */         break;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 477 */     if (this.javaMethod == null)
/*     */     {
/* 479 */       StringBuilder errMsg = new StringBuilder("Cannot synchronize to any of these methods:");
/* 480 */       for (Method method : unsynchronizedMethods)
/*     */       {
/* 482 */         errMsg.append("\n" + method);
/*     */       }
/* 484 */       errMsg.append("\n" + toString());
/* 485 */       throw new IllegalStateException(errMsg.toString());
/*     */     }
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 491 */     StringBuilder buffer = new StringBuilder("\nOperationMetaData:");
/* 492 */     buffer.append("\n qname=" + this.qname);
/* 493 */     buffer.append("\n javaName=" + this.javaName);
/* 494 */     buffer.append("\n style=" + getStyle() + "/" + getUse());
/* 495 */     if (getStyle() == Style.DOCUMENT)
/*     */     {
/* 497 */       buffer.append("/" + getParameterStyle());
/*     */     }
/* 499 */     buffer.append("\n oneWay=" + this.oneWay);
/* 500 */     buffer.append("\n soapAction=" + this.soapAction);
/* 501 */     for (ParameterMetaData param : this.parameters)
/*     */     {
/* 503 */       buffer.append(param);
/*     */     }
/* 505 */     if (this.returnParam != null)
/*     */     {
/* 507 */       buffer.append(this.returnParam.toString());
/*     */     }
/* 509 */     for (FaultMetaData fault : this.faults)
/*     */     {
/* 511 */       buffer.append(fault);
/*     */     }
/* 513 */     return buffer.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.metadata.umdm.OperationMetaData
 * JD-Core Version:    0.6.0
 */