/*     */ package org.jboss.ws.metadata.umdm;
/*     */ 
/*     */ import java.beans.IntrospectionException;
/*     */ import java.beans.PropertyDescriptor;
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.Arrays;
/*     */ import javax.xml.bind.annotation.XmlAccessType;
/*     */ import javax.xml.bind.annotation.XmlAccessorType;
/*     */ import javax.xml.bind.annotation.XmlType;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.ws.WebServiceException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.core.jaxws.DynamicWrapperGenerator;
/*     */ import org.jboss.ws.metadata.acessor.ReflectiveFieldAccessor;
/*     */ import org.jboss.ws.metadata.acessor.ReflectiveMethodAccessor;
/*     */ import org.jboss.wsf.common.JavaUtils;
/*     */ 
/*     */ public class FaultMetaData
/*     */ {
/*  57 */   private final Logger log = Logger.getLogger(FaultMetaData.class);
/*     */   private OperationMetaData opMetaData;
/*     */   private QName xmlName;
/*     */   private QName xmlType;
/*     */   private String javaTypeName;
/*     */   private String faultBeanName;
/*     */   private Class javaType;
/*     */   private Class faultBean;
/*     */   private Method faultInfoMethod;
/*     */   private Constructor serviceExceptionConstructor;
/*     */   private Method[] serviceExceptionGetters;
/*     */   private WrappedParameter[] faultBeanProperties;
/*     */   private Class[] propertyTypes;
/*     */ 
/*     */   public FaultMetaData(OperationMetaData operation, QName xmlName, QName xmlType, String javaTypeName)
/*     */   {
/*  79 */     this(operation, xmlName, javaTypeName);
/*  80 */     setXmlType(xmlType);
/*     */   }
/*     */ 
/*     */   public FaultMetaData(OperationMetaData operation, QName xmlName, String javaTypeName)
/*     */   {
/*  85 */     if (xmlName == null)
/*  86 */       throw new IllegalArgumentException("Invalid null xmlName argument");
/*  87 */     if (javaTypeName == null) {
/*  88 */       throw new IllegalArgumentException("Invalid null javaTypeName argument, for: " + xmlName);
/*     */     }
/*  90 */     this.opMetaData = operation;
/*  91 */     this.xmlName = xmlName;
/*  92 */     this.javaTypeName = javaTypeName;
/*     */   }
/*     */ 
/*     */   public OperationMetaData getOperationMetaData()
/*     */   {
/*  97 */     return this.opMetaData;
/*     */   }
/*     */ 
/*     */   public QName getXmlName()
/*     */   {
/* 102 */     return this.xmlName;
/*     */   }
/*     */ 
/*     */   public QName getXmlType()
/*     */   {
/* 107 */     return this.xmlType;
/*     */   }
/*     */ 
/*     */   public void setXmlType(QName xmlType)
/*     */   {
/* 112 */     if (xmlType == null) {
/* 113 */       throw new IllegalArgumentException("Invalid null xmlType argument, for: " + this.xmlName);
/*     */     }
/* 115 */     this.xmlType = xmlType;
/*     */   }
/*     */ 
/*     */   public String getJavaTypeName()
/*     */   {
/* 120 */     return this.javaTypeName;
/*     */   }
/*     */ 
/*     */   public Class getJavaType()
/*     */   {
/* 128 */     if (this.javaType != null) {
/* 129 */       return this.javaType;
/*     */     }
/* 131 */     if (this.javaTypeName == null) {
/* 132 */       return null;
/*     */     }
/*     */     try
/*     */     {
/* 136 */       ClassLoader loader = this.opMetaData.getEndpointMetaData().getClassLoader();
/* 137 */       Class exceptionType = JavaUtils.loadJavaType(this.javaTypeName, loader);
/* 138 */       if (!Exception.class.isAssignableFrom(exceptionType)) {
/* 139 */         throw new IllegalStateException("Is not assignable to exception: " + exceptionType);
/*     */       }
/* 141 */       if (this.opMetaData.getEndpointMetaData().getServiceMetaData().getUnifiedMetaData().isEagerInitialized())
/*     */       {
/* 143 */         this.log.warn("Loading java type after eager initialization");
/* 144 */         this.javaType = exceptionType;
/*     */       }
/* 146 */       return exceptionType;
/*     */     }
/*     */     catch (ClassNotFoundException ex) {
/*     */     }
/* 150 */     throw new WSException("Cannot load java type: " + this.javaTypeName, ex);
/*     */   }
/*     */ 
/*     */   public String getFaultBeanName()
/*     */   {
/* 156 */     return this.faultBeanName;
/*     */   }
/*     */ 
/*     */   public void setFaultBeanName(String faultBeanName)
/*     */   {
/* 161 */     this.faultBeanName = faultBeanName;
/*     */   }
/*     */ 
/*     */   public Class loadFaultBean()
/*     */   {
/* 166 */     Class faultBean = null;
/*     */     try
/*     */     {
/* 169 */       ClassLoader loader = getOperationMetaData().getEndpointMetaData().getClassLoader();
/* 170 */       faultBean = JavaUtils.loadJavaType(this.faultBeanName, loader);
/*     */     }
/*     */     catch (ClassNotFoundException ex)
/*     */     {
/*     */     }
/*     */ 
/* 176 */     return faultBean;
/*     */   }
/*     */ 
/*     */   public Class getFaultBean()
/*     */   {
/* 181 */     Class tmpFaultBean = this.faultBean;
/* 182 */     if ((tmpFaultBean == null) && (this.faultBeanName != null))
/*     */     {
/*     */       try
/*     */       {
/* 186 */         ClassLoader loader = this.opMetaData.getEndpointMetaData().getClassLoader();
/* 187 */         tmpFaultBean = JavaUtils.loadJavaType(this.faultBeanName, loader);
/*     */       }
/*     */       catch (ClassNotFoundException ex)
/*     */       {
/* 191 */         throw new WSException("Cannot load fault bean: " + this.faultBeanName, ex);
/*     */       }
/*     */     }
/* 194 */     return tmpFaultBean;
/*     */   }
/*     */ 
/*     */   public void validate()
/*     */   {
/*     */   }
/*     */ 
/*     */   public void eagerInitialize()
/*     */   {
/* 204 */     EndpointMetaData.Type epType = getOperationMetaData().getEndpointMetaData().getType();
/* 205 */     if ((epType == EndpointMetaData.Type.JAXWS) && (this.faultBeanName != null))
/*     */     {
/* 207 */       if (loadFaultBean() == null)
/*     */       {
/* 209 */         ClassLoader loader = this.opMetaData.getEndpointMetaData().getClassLoader();
/* 210 */         new DynamicWrapperGenerator(loader).generate(this);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 215 */     this.javaType = getJavaType();
/* 216 */     if (this.javaType == null) {
/* 217 */       throw new WSException("Cannot load java type: " + this.javaTypeName);
/*     */     }
/* 219 */     if (!JavaUtils.isAssignableFrom(Exception.class, this.javaType)) {
/* 220 */       throw new WSException("Fault java type is not a java.lang.Exception: " + this.javaTypeName);
/*     */     }
/* 222 */     if (epType == EndpointMetaData.Type.JAXWS)
/*     */     {
/* 224 */       this.faultBean = getFaultBean();
/* 225 */       if (this.faultBean != null)
/* 226 */         initializeFaultBean();
/*     */     }
/*     */   }
/*     */ 
/*     */   private void initializeFaultBean()
/*     */   {
/*     */     try
/*     */     {
/* 244 */       this.serviceExceptionConstructor = this.javaType.getConstructor(new Class[] { String.class, this.faultBean });
/* 245 */       this.faultInfoMethod = this.javaType.getMethod("getFaultInfo", new Class[0]);
/*     */     }
/*     */     catch (NoSuchMethodException nsme)
/*     */     {
/* 254 */       XmlType xmlType = (XmlType)this.faultBean.getAnnotation(XmlType.class);
/* 255 */       if (xmlType == null) {
/* 256 */         throw new WebServiceException("@XmlType missing from fault bean: " + this.faultBeanName);
/*     */       }
/* 258 */       AccessorFactory accessorFactory = getAccessorFactory(this.faultBean);
/*     */ 
/* 260 */       String[] propertyNames = xmlType.propOrder();
/* 261 */       int propertyCount = propertyNames.length;
/* 262 */       this.propertyTypes = new Class[propertyCount];
/* 263 */       this.faultBeanProperties = new WrappedParameter[propertyCount];
/* 264 */       this.serviceExceptionGetters = new Method[propertyCount];
/*     */ 
/* 266 */       for (int i = 0; i < propertyCount; i++)
/*     */       {
/* 268 */         String propertyName = propertyNames[i];
/*     */         try
/*     */         {
/* 272 */           PropertyDescriptor propertyDescriptor = new PropertyDescriptor(propertyName, this.faultBean);
/* 273 */           Class propertyType = propertyDescriptor.getPropertyType();
/*     */ 
/* 275 */           WrappedParameter faultBeanProperty = new WrappedParameter(null, propertyType.getName(), propertyName, i);
/* 276 */           faultBeanProperty.setAccessor(accessorFactory.create(faultBeanProperty));
/* 277 */           this.faultBeanProperties[i] = faultBeanProperty;
/*     */ 
/* 279 */           this.propertyTypes[i] = propertyType;
/*     */         }
/*     */         catch (IntrospectionException ie)
/*     */         {
/* 283 */           throw new WSException("Property '" + propertyName + "' not found in fault bean '" + this.faultBeanName + "'", ie);
/*     */         }
/*     */ 
/*     */         try
/*     */         {
/* 292 */           PropertyDescriptor propertyDescriptor = new PropertyDescriptor(propertyName, this.javaType, "is" + JavaUtils.capitalize(propertyName), null);
/* 293 */           this.serviceExceptionGetters[i] = propertyDescriptor.getReadMethod();
/*     */         }
/*     */         catch (IntrospectionException ie)
/*     */         {
/* 297 */           throw new WSException("Property '" + propertyName + "' not found in service exception '" + this.javaTypeName, ie);
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */       try
/*     */       {
/* 304 */         this.serviceExceptionConstructor = this.javaType.asSubclass(Exception.class).getConstructor(this.propertyTypes);
/*     */       }
/*     */       catch (NoSuchMethodException e)
/*     */       {
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private AccessorFactory getAccessorFactory(Class faultBean)
/*     */   {
/* 318 */     XmlAccessorType type = (XmlAccessorType)faultBean.getAnnotation(XmlAccessorType.class);
/* 319 */     if ((type != null) && (type.value() == XmlAccessType.FIELD)) {
/* 320 */       return ReflectiveFieldAccessor.FACTORY_CREATOR.create(this);
/*     */     }
/* 322 */     return ReflectiveMethodAccessor.FACTORY_CREATOR.create(this);
/*     */   }
/*     */ 
/*     */   public Object toFaultBean(Exception serviceException)
/*     */   {
/*     */     Object faultBeanInstance;
/*     */     try
/*     */     {
/*     */       Object faultBeanInstance;
/* 332 */       if (this.faultInfoMethod != null)
/*     */       {
/* 335 */         faultBeanInstance = this.faultInfoMethod.invoke(serviceException, new Object[0]);
/*     */       }
/*     */       else
/*     */       {
/*     */         try
/*     */         {
/* 342 */           faultBeanInstance = this.faultBean.newInstance();
/*     */         }
/*     */         catch (InstantiationException e)
/*     */         {
/* 346 */           throw new WebServiceException("Fault bean class is not instantiable", e);
/*     */         }
/*     */ 
/* 350 */         for (int i = 0; i < this.serviceExceptionGetters.length; i++)
/*     */         {
/* 352 */           Object propertyValue = this.serviceExceptionGetters[i].invoke(serviceException, new Object[0]);
/*     */ 
/* 354 */           WrappedParameter faultBeanProperty = this.faultBeanProperties[i];
/* 355 */           if (this.log.isTraceEnabled()) {
/* 356 */             this.log.trace("copying from " + this.javaType.getSimpleName() + '.' + this.serviceExceptionGetters[i].getName() + " to " + this.faultBean.getSimpleName() + '.' + faultBeanProperty.getVariable() + "<->" + faultBeanProperty.getName() + ": " + propertyValue);
/*     */           }
/*     */ 
/* 359 */           faultBeanProperty.accessor().set(faultBeanInstance, propertyValue);
/*     */         }
/*     */       }
/*     */     }
/*     */     catch (IllegalAccessException e)
/*     */     {
/* 365 */       throw new WebServiceException(e);
/*     */     }
/*     */     catch (InvocationTargetException e)
/*     */     {
/* 369 */       throw new WebServiceException(e.getTargetException());
/*     */     }
/* 371 */     return faultBeanInstance;
/*     */   }
/*     */ 
/*     */   public Exception toServiceException(Object faultBean, String message)
/*     */   {
/*     */     Exception serviceException;
/*     */     try
/*     */     {
/*     */       Exception serviceException;
/* 382 */       if (this.faultInfoMethod != null)
/*     */       {
/* 384 */         serviceException = (Exception)this.serviceExceptionConstructor.newInstance(new Object[] { message, faultBean });
/*     */       }
/*     */       else
/*     */       {
/* 388 */         if (this.serviceExceptionConstructor == null) {
/* 389 */           throw new WSException("Could not instantiate service exception (" + this.javaType.getSimpleName() + "), since neither a faultInfo nor sorted constructor is present: " + Arrays.toString(this.propertyTypes));
/*     */         }
/*     */ 
/* 392 */         int propertyCount = this.faultBeanProperties.length;
/* 393 */         Object[] propertyValues = new Object[propertyCount];
/*     */ 
/* 395 */         for (int i = 0; i < propertyCount; i++) {
/* 396 */           propertyValues[i] = this.faultBeanProperties[i].accessor().get(faultBean);
/*     */         }
/* 398 */         this.log.debug("constructing " + this.javaType.getSimpleName() + ": " + Arrays.toString(propertyValues));
/* 399 */         serviceException = (Exception)this.serviceExceptionConstructor.newInstance(propertyValues);
/*     */       }
/*     */     }
/*     */     catch (InstantiationException e)
/*     */     {
/* 404 */       throw new WebServiceException("Service exception is not instantiable", e);
/*     */     }
/*     */     catch (IllegalAccessException e)
/*     */     {
/* 408 */       throw new WebServiceException(e);
/*     */     }
/*     */     catch (InvocationTargetException e)
/*     */     {
/* 412 */       throw new WebServiceException(e.getTargetException());
/*     */     }
/* 414 */     return serviceException;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 419 */     StringBuilder buffer = new StringBuilder("\nFaultMetaData");
/* 420 */     buffer.append("\n xmlName=" + this.xmlName);
/* 421 */     buffer.append("\n xmlType=" + this.xmlType);
/* 422 */     buffer.append("\n javaType=" + this.javaTypeName);
/* 423 */     buffer.append("\n faultBean=" + this.faultBeanName);
/* 424 */     return buffer.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.metadata.umdm.FaultMetaData
 * JD-Core Version:    0.6.0
 */