/*     */ package org.jboss.ws.metadata.umdm;
/*     */ 
/*     */ import java.lang.ref.WeakReference;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Arrays;
/*     */ import java.util.Collection;
/*     */ import java.util.Collections;
/*     */ import java.util.HashMap;
/*     */ import java.util.HashSet;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Observable;
/*     */ import java.util.Observer;
/*     */ import java.util.Properties;
/*     */ import java.util.Set;
/*     */ import javax.jws.soap.SOAPBinding.ParameterStyle;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.rpc.ParameterMode;
/*     */ import javax.xml.ws.Service.Mode;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.core.CommonBindingProvider;
/*     */ import org.jboss.ws.core.CommonSOAPBinding;
/*     */ import org.jboss.ws.core.binding.TypeMappingImpl;
/*     */ import org.jboss.ws.core.jaxrpc.binding.JBossXBDeserializerFactory;
/*     */ import org.jboss.ws.core.jaxrpc.binding.JBossXBSerializerFactory;
/*     */ import org.jboss.ws.core.jaxrpc.binding.SOAPArrayDeserializerFactory;
/*     */ import org.jboss.ws.core.jaxrpc.binding.SOAPArraySerializerFactory;
/*     */ import org.jboss.ws.core.jaxws.JAXBContextCache;
/*     */ import org.jboss.ws.core.jaxws.JAXBDeserializerFactory;
/*     */ import org.jboss.ws.core.jaxws.JAXBSerializerFactory;
/*     */ import org.jboss.ws.core.jaxws.client.DispatchBinding;
/*     */ import org.jboss.ws.core.soap.Style;
/*     */ import org.jboss.ws.core.soap.Use;
/*     */ import org.jboss.ws.metadata.config.CommonConfig;
/*     */ import org.jboss.ws.metadata.config.Configurable;
/*     */ import org.jboss.ws.metadata.config.ConfigurationProvider;
/*     */ import org.jboss.ws.metadata.config.JBossWSConfigFactory;
/*     */ import org.jboss.wsf.common.JavaUtils;
/*     */ import org.jboss.wsf.spi.binding.BindingCustomization;
/*     */ import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData.HandlerType;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedPortComponentRefMetaData;
/*     */ 
/*     */ public abstract class EndpointMetaData extends ExtensibleMetaData
/*     */   implements ConfigurationProvider
/*     */ {
/*  82 */   private static Logger log = Logger.getLogger(EndpointMetaData.class);
/*     */ 
/*  89 */   public static final Set<String> SUPPORTED_BINDINGS = new HashSet();
/*     */   private ServiceMetaData serviceMetaData;
/*     */   private CommonConfig config;
/*     */   private QName portName;
/*     */   private String bindingId;
/*     */   private QName portTypeName;
/*     */   protected String configName;
/*     */   protected String configFile;
/*     */   private String seiName;
/*     */   private Class seiClass;
/*     */   private String authMethod;
/*     */   private Properties properties;
/*     */   private Style style;
/*     */   private Use use;
/*     */   private SOAPBinding.ParameterStyle parameterStyle;
/*     */   private Service.Mode serviceMode;
/*     */   private Type type;
/* 134 */   private List<OperationMetaData> operations = new ArrayList();
/*     */ 
/* 136 */   private List<HandlerMetaData> handlers = new ArrayList();
/*     */   private boolean handlersInitialized;
/* 140 */   private Map<Method, OperationMetaData> opMetaDataCache = new HashMap();
/*     */ 
/* 142 */   private List<Class> registeredTypes = new ArrayList();
/*     */ 
/* 144 */   private ConfigObservable configObservable = new ConfigObservable();
/*     */ 
/* 146 */   private List<UnifiedPortComponentRefMetaData> serviceRefContrib = new ArrayList();
/*     */ 
/* 148 */   private JAXBContextCache jaxbCache = new JAXBContextCache();
/*     */ 
/* 150 */   private List<BindingCustomization> bindingCustomization = new ArrayList();
/*     */ 
/*     */   public EndpointMetaData(ServiceMetaData service, QName portName, QName portTypeName, Type type)
/*     */   {
/* 154 */     this.serviceMetaData = service;
/* 155 */     this.portName = portName;
/* 156 */     this.portTypeName = portTypeName;
/* 157 */     this.type = type;
/*     */ 
/* 160 */     this.bindingId = "http://schemas.xmlsoap.org/wsdl/soap/http";
/*     */   }
/*     */ 
/*     */   public ServiceMetaData getServiceMetaData()
/*     */   {
/* 165 */     return this.serviceMetaData;
/*     */   }
/*     */ 
/*     */   public QName getPortName()
/*     */   {
/* 170 */     return this.portName;
/*     */   }
/*     */ 
/*     */   public void setPortName(QName portName)
/*     */   {
/* 175 */     this.portName = portName;
/*     */   }
/*     */ 
/*     */   public QName getPortTypeName()
/*     */   {
/* 180 */     return this.portTypeName;
/*     */   }
/*     */   public abstract String getEndpointAddress();
/*     */ 
/*     */   public abstract void setEndpointAddress(String paramString);
/*     */ 
/*     */   public String getBindingId() {
/* 189 */     return this.bindingId;
/*     */   }
/*     */ 
/*     */   public void setBindingId(String bindingId)
/*     */   {
/* 194 */     if (!SUPPORTED_BINDINGS.contains(bindingId)) {
/* 195 */       throw new WSException("Unsupported binding: " + bindingId);
/*     */     }
/* 197 */     this.bindingId = bindingId;
/*     */   }
/*     */ 
/*     */   public String getServiceEndpointInterfaceName()
/*     */   {
/* 202 */     return this.seiName;
/*     */   }
/*     */ 
/*     */   public void setServiceEndpointInterfaceName(String seiName)
/*     */   {
/* 207 */     this.seiName = seiName;
/* 208 */     this.seiClass = null;
/*     */ 
/* 210 */     UnifiedMetaData wsMetaData = this.serviceMetaData.getUnifiedMetaData();
/* 211 */     if (wsMetaData.isEagerInitialized())
/*     */     {
/* 213 */       if (!UnifiedMetaData.isFinalRelease()) {
/* 214 */         log.warn("Set SEI name after eager initialization", new IllegalStateException());
/*     */       }
/*     */ 
/* 217 */       initializeInternal();
/*     */     }
/*     */   }
/*     */ 
/*     */   public ClassLoader getClassLoader()
/*     */   {
/* 224 */     return getServiceMetaData().getUnifiedMetaData().getClassLoader();
/*     */   }
/*     */ 
/*     */   public Class getServiceEndpointInterface()
/*     */   {
/* 233 */     Class tmpClass = this.seiClass;
/* 234 */     if ((tmpClass == null) && (this.seiName != null))
/*     */     {
/*     */       try
/*     */       {
/* 238 */         ClassLoader classLoader = getClassLoader();
/* 239 */         tmpClass = classLoader.loadClass(this.seiName);
/* 240 */         if (this.serviceMetaData.getUnifiedMetaData().isEagerInitialized())
/*     */         {
/* 242 */           log.warn("Loading SEI after eager initialization");
/* 243 */           this.seiClass = tmpClass;
/*     */         }
/*     */       }
/*     */       catch (ClassNotFoundException ex)
/*     */       {
/* 248 */         throw new WSException("Cannot load service endpoint interface: " + this.seiName, ex);
/*     */       }
/*     */     }
/* 251 */     return tmpClass;
/*     */   }
/*     */ 
/*     */   public Use getEncodingStyle()
/*     */   {
/* 256 */     if (this.use == null)
/*     */     {
/* 258 */       this.use = Use.getDefaultUse();
/* 259 */       log.debug("Using default encoding style: " + this.use);
/*     */     }
/* 261 */     return this.use;
/*     */   }
/*     */ 
/*     */   public void setEncodingStyle(Use value)
/*     */   {
/* 266 */     if ((value != null) && (this.use != null) && (!this.use.equals(value))) {
/* 267 */       throw new WSException("Mixed encoding styles not supported");
/*     */     }
/* 269 */     log.trace("setEncodingStyle: " + value);
/* 270 */     this.use = value;
/*     */   }
/*     */ 
/*     */   public Style getStyle()
/*     */   {
/* 275 */     if (this.style == null)
/*     */     {
/* 277 */       this.style = Style.getDefaultStyle();
/* 278 */       log.debug("Using default style: " + this.style);
/*     */     }
/* 280 */     return this.style;
/*     */   }
/*     */ 
/*     */   public void setStyle(Style value)
/*     */   {
/* 285 */     if ((value != null) && (this.style != null) && (!this.style.equals(value))) {
/* 286 */       throw new WSException("Mixed styles not supported");
/*     */     }
/* 288 */     log.trace("setStyle: " + value);
/* 289 */     this.style = value;
/*     */   }
/*     */ 
/*     */   public SOAPBinding.ParameterStyle getParameterStyle()
/*     */   {
/* 294 */     if (this.parameterStyle == null)
/*     */     {
/* 296 */       this.parameterStyle = SOAPBinding.ParameterStyle.WRAPPED;
/* 297 */       log.debug("Using default parameter style: " + this.parameterStyle);
/*     */     }
/* 299 */     return this.parameterStyle;
/*     */   }
/*     */ 
/*     */   public void setParameterStyle(SOAPBinding.ParameterStyle value)
/*     */   {
/* 304 */     if ((value != null) && (this.parameterStyle != null) && (!this.parameterStyle.equals(value))) {
/* 305 */       throw new WSException("Mixed SOAP parameter styles not supported");
/*     */     }
/* 307 */     log.debug("setParameterStyle: " + value);
/* 308 */     this.parameterStyle = value;
/*     */   }
/*     */ 
/*     */   public Service.Mode getServiceMode()
/*     */   {
/* 313 */     return this.serviceMode;
/*     */   }
/*     */ 
/*     */   public void setServiceMode(Service.Mode serviceMode)
/*     */   {
/* 318 */     this.serviceMode = serviceMode;
/*     */   }
/*     */ 
/*     */   public Type getType()
/*     */   {
/* 323 */     return this.type;
/*     */   }
/*     */ 
/*     */   public Collection<BindingCustomization> getBindingCustomizations()
/*     */   {
/* 328 */     return this.bindingCustomization;
/*     */   }
/*     */ 
/*     */   public String getAuthMethod()
/*     */   {
/* 333 */     return this.authMethod;
/*     */   }
/*     */ 
/*     */   public void setAuthMethod(String authMethod)
/*     */   {
/* 338 */     this.authMethod = authMethod;
/*     */   }
/*     */ 
/*     */   public Properties getProperties()
/*     */   {
/* 343 */     if (null == this.properties)
/* 344 */       this.properties = new Properties();
/* 345 */     return this.properties;
/*     */   }
/*     */ 
/*     */   public void setProperties(Properties properties)
/*     */   {
/* 350 */     this.properties = properties;
/*     */   }
/*     */ 
/*     */   public List<OperationMetaData> getOperations()
/*     */   {
/* 355 */     return new ArrayList(this.operations);
/*     */   }
/*     */ 
/*     */   public OperationMetaData getOperation(QName xmlName)
/*     */   {
/* 360 */     OperationMetaData opMetaData = null;
/* 361 */     for (OperationMetaData aux : this.operations)
/*     */     {
/* 363 */       QName opQName = aux.getQName();
/* 364 */       String javaName = aux.getJavaName();
/* 365 */       if ((opQName.equals(xmlName)) && (!javaName.endsWith("Async")))
/*     */       {
/* 367 */         if (opMetaData == null)
/*     */         {
/* 369 */           opMetaData = aux;
/*     */         }
/*     */         else
/*     */         {
/* 373 */           throw new WSException("Cannot uniquely indentify operation: " + xmlName);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 378 */     if ((opMetaData == null) && (getStyle() == Style.DOCUMENT))
/*     */     {
/* 380 */       for (OperationMetaData auxOperation : this.operations)
/*     */       {
/* 382 */         ParameterMetaData paramMetaData = null;
/* 383 */         for (ParameterMetaData auxParam : auxOperation.getParameters())
/*     */         {
/* 385 */           ParameterMode mode = auxParam.getMode();
/* 386 */           if ((!auxParam.isInHeader()) && (mode != ParameterMode.OUT))
/*     */           {
/* 388 */             paramMetaData = auxParam;
/* 389 */             break;
/*     */           }
/*     */         }
/* 392 */         if ((paramMetaData != null) && (paramMetaData.getXmlName().equals(xmlName)))
/*     */         {
/* 394 */           if (opMetaData == null)
/*     */           {
/* 396 */             opMetaData = auxOperation;
/*     */           }
/*     */           else
/*     */           {
/* 400 */             throw new WSException("Cannot uniquely indentify operation: " + xmlName);
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 406 */     return opMetaData;
/*     */   }
/*     */ 
/*     */   public OperationMetaData getOperation(Method method)
/*     */   {
/* 411 */     if (this.opMetaDataCache.size() == 0)
/*     */     {
/* 414 */       log.warn("Access to empty operation meta data cache, reinitializing");
/* 415 */       initializeInternal();
/*     */     }
/*     */ 
/* 418 */     OperationMetaData opMetaData = (OperationMetaData)this.opMetaDataCache.get(method);
/* 419 */     if (opMetaData == null)
/*     */     {
/* 421 */       for (OperationMetaData aux : this.operations)
/*     */       {
/* 423 */         boolean doesMatch = aux.getJavaMethod().equals(method);
/*     */ 
/* 426 */         if ((!doesMatch) && (method.getName().endsWith("Async")))
/*     */         {
/* 428 */           String name = method.getName();
/* 429 */           name = name.substring(0, name.length() - 5);
/* 430 */           doesMatch = aux.getJavaName().equals(name);
/*     */         }
/*     */ 
/* 433 */         if (doesMatch)
/*     */         {
/* 435 */           this.opMetaDataCache.put(method, aux);
/* 436 */           opMetaData = aux;
/* 437 */           break;
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 442 */     return opMetaData;
/*     */   }
/*     */ 
/*     */   public void addOperation(OperationMetaData opMetaData)
/*     */   {
/* 447 */     this.operations.add(opMetaData);
/*     */   }
/*     */ 
/*     */   public void clearOperations()
/*     */   {
/* 452 */     this.operations.clear();
/*     */   }
/*     */ 
/*     */   public void addHandlers(List<HandlerMetaData> configHandlers)
/*     */   {
/* 457 */     this.handlers.addAll(configHandlers);
/*     */   }
/*     */ 
/*     */   public void addHandler(HandlerMetaData handler)
/*     */   {
/* 462 */     handler.setEndpointMetaData(this);
/* 463 */     this.handlers.add(handler);
/*     */   }
/*     */ 
/*     */   public void clearHandlers()
/*     */   {
/* 468 */     this.handlers.clear();
/* 469 */     this.handlersInitialized = false;
/*     */   }
/*     */ 
/*     */   public List<HandlerMetaData> getHandlerMetaData(UnifiedHandlerMetaData.HandlerType type)
/*     */   {
/* 474 */     List typeHandlers = new ArrayList();
/* 475 */     for (HandlerMetaData hmd : this.handlers)
/*     */     {
/* 477 */       if ((hmd.getHandlerType() == type) || (type == UnifiedHandlerMetaData.HandlerType.ALL))
/* 478 */         typeHandlers.add(hmd);
/*     */     }
/* 480 */     return typeHandlers;
/*     */   }
/*     */ 
/*     */   public boolean isHandlersInitialized()
/*     */   {
/* 485 */     return this.handlersInitialized;
/*     */   }
/*     */ 
/*     */   public void setHandlersInitialized(boolean flag)
/*     */   {
/* 490 */     this.handlersInitialized = flag;
/*     */   }
/*     */ 
/*     */   public void validate()
/*     */   {
/* 495 */     for (HandlerMetaData handler : this.handlers) {
/* 496 */       handler.validate();
/*     */     }
/* 498 */     for (OperationMetaData opMetaData : this.operations)
/* 499 */       opMetaData.validate();
/*     */   }
/*     */ 
/*     */   public void eagerInitialize()
/*     */   {
/* 507 */     initializeInternal();
/*     */   }
/*     */ 
/*     */   private void initializeInternal()
/*     */   {
/* 513 */     this.seiClass = null;
/*     */ 
/* 516 */     for (HandlerMetaData handler : this.handlers) {
/* 517 */       handler.eagerInitialize();
/*     */     }
/* 519 */     eagerInitializeOperations();
/* 520 */     eagerInitializeTypes();
/*     */   }
/*     */ 
/*     */   private void eagerInitializeOperations()
/*     */   {
/* 525 */     this.seiClass = getServiceEndpointInterface();
/*     */     List unsynchronizedMethods;
/* 526 */     if (this.seiClass != null)
/*     */     {
/* 528 */       unsynchronizedMethods = new ArrayList();
/* 529 */       unsynchronizedMethods.addAll(Arrays.asList(this.seiClass.getMethods()));
/*     */ 
/* 531 */       for (OperationMetaData opMetaData : this.operations)
/*     */       {
/* 533 */         opMetaData.eagerInitialize(unsynchronizedMethods);
/* 534 */         Method method = opMetaData.getJavaMethod();
/* 535 */         if (method != null)
/*     */         {
/* 537 */           this.opMetaDataCache.put(method, opMetaData);
/* 538 */           unsynchronizedMethods.remove(method);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void eagerInitializeTypes()
/*     */   {
/* 546 */     TypeMappingImpl typeMapping = this.serviceMetaData.getTypeMapping();
/* 547 */     List typeMappings = this.serviceMetaData.getTypesMetaData().getTypeMappings();
/* 548 */     this.registeredTypes = new ArrayList(typeMappings.size());
/* 549 */     for (TypeMappingMetaData tmMetaData : typeMappings)
/*     */     {
/* 551 */       String javaTypeName = tmMetaData.getJavaTypeName();
/* 552 */       QName xmlType = tmMetaData.getXmlType();
/* 553 */       if (xmlType != null)
/*     */       {
/* 555 */         List types = typeMapping.getJavaTypes(xmlType);
/*     */ 
/* 558 */         boolean registered = false;
/* 559 */         for (Class current : types)
/*     */         {
/* 561 */           if (current.getName().equals(javaTypeName))
/*     */           {
/* 563 */             this.registeredTypes.add(current);
/* 564 */             registered = true;
/* 565 */             break;
/*     */           }
/*     */         }
/*     */ 
/* 569 */         if (!registered)
/*     */         {
/*     */           try
/*     */           {
/* 573 */             ClassLoader classLoader = getClassLoader();
/* 574 */             Class javaType = JavaUtils.loadJavaType(javaTypeName, classLoader);
/*     */ 
/* 576 */             if (JavaUtils.isPrimitive(javaTypeName)) {
/* 577 */               javaType = JavaUtils.getWrapperType(javaType);
/*     */             }
/*     */ 
/* 580 */             this.registeredTypes.add(javaType);
/*     */ 
/* 582 */             if ((getEncodingStyle() == Use.ENCODED) && (javaType.isArray()))
/*     */             {
/* 584 */               typeMapping.register(javaType, xmlType, new SOAPArraySerializerFactory(), new SOAPArrayDeserializerFactory());
/*     */             }
/* 588 */             else if (getType() == Type.JAXWS)
/*     */             {
/* 590 */               typeMapping.register(javaType, xmlType, new JAXBSerializerFactory(), new JAXBDeserializerFactory());
/*     */             }
/*     */             else
/*     */             {
/* 594 */               typeMapping.register(javaType, xmlType, new JBossXBSerializerFactory(), new JBossXBDeserializerFactory());
/*     */             }
/*     */ 
/*     */           }
/*     */           catch (ClassNotFoundException e)
/*     */           {
/* 600 */             log.warn("Cannot load class for type: " + xmlType + "," + javaTypeName);
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void configure(Configurable configurable)
/*     */   {
/* 616 */     if (this.config == null) {
/* 617 */       initEndpointConfig();
/*     */     }
/*     */ 
/* 620 */     if ((configurable instanceof CommonBindingProvider))
/*     */     {
/* 622 */       log.debug("Configure SOAPBinding");
/*     */ 
/* 624 */       if (this.config.hasFeature("http://org.jboss.ws/mtom"))
/*     */       {
/* 626 */         CommonBindingProvider provider = (CommonBindingProvider)configurable;
/* 627 */         ((CommonSOAPBinding)provider.getCommonBinding()).setMTOMEnabled(true);
/* 628 */         log.debug("Enable MTOM on endpoint " + getPortName());
/*     */       }
/*     */     }
/* 631 */     else if ((configurable instanceof DispatchBinding))
/*     */     {
/* 633 */       DispatchBinding dpb = (DispatchBinding)configurable;
/* 634 */       dpb.setValidateDispatch(this.config.hasFeature("http://org.jboss.ws/dispatch/validate"));
/*     */     }
/*     */   }
/*     */ 
/*     */   public UnifiedVirtualFile getRootFile()
/*     */   {
/* 640 */     return getServiceMetaData().getUnifiedMetaData().getRootFile();
/*     */   }
/*     */ 
/*     */   public void registerConfigObserver(Configurable observer)
/*     */   {
/* 645 */     this.configObservable.addObserver(observer);
/*     */   }
/*     */ 
/*     */   public JAXBContextCache getJaxbCache()
/*     */   {
/* 650 */     return this.jaxbCache;
/*     */   }
/*     */ 
/*     */   public String getConfigFile()
/*     */   {
/* 655 */     return this.configFile;
/*     */   }
/*     */ 
/*     */   public String getConfigName()
/*     */   {
/* 660 */     return this.configName;
/*     */   }
/*     */ 
/*     */   public CommonConfig getConfig()
/*     */   {
/* 666 */     if (this.config == null) {
/* 667 */       initEndpointConfig();
/*     */     }
/* 669 */     return this.config;
/*     */   }
/*     */ 
/*     */   public void setConfigName(String configName)
/*     */   {
/* 674 */     setConfigNameInternal(configName, null);
/*     */   }
/*     */ 
/*     */   public void setConfigName(String configName, String configFile)
/*     */   {
/* 679 */     setConfigNameInternal(configName, configFile);
/*     */   }
/*     */ 
/*     */   private void setConfigNameInternal(String configName, String configFile)
/*     */   {
/* 684 */     if (configName == null) {
/* 685 */       throw new IllegalArgumentException("Config name cannot be null");
/*     */     }
/* 687 */     if (configFile != null) {
/* 688 */       this.configFile = configFile;
/*     */     }
/* 690 */     if (!configName.equals(this.configName))
/*     */     {
/* 692 */       this.configName = configName;
/*     */ 
/* 694 */       log.debug("Reconfiguration forced, new config is '" + configName + "'");
/* 695 */       initEndpointConfig();
/* 696 */       this.configObservable.doNotify(configName);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void initEndpointConfig()
/*     */   {
/* 702 */     log.debug("Create new config [name=" + getConfigName() + ",file=" + getConfigFile() + "]");
/* 703 */     JBossWSConfigFactory factory = JBossWSConfigFactory.newInstance();
/* 704 */     this.config = factory.getConfig(getRootFile(), getConfigName(), getConfigFile());
/*     */ 
/* 706 */     reconfigHandlerMetaData();
/*     */   }
/*     */ 
/*     */   private void reconfigHandlerMetaData()
/*     */   {
/* 711 */     log.debug("Configure EndpointMetaData");
/*     */ 
/* 713 */     List sepHandlers = getHandlerMetaData(UnifiedHandlerMetaData.HandlerType.ENDPOINT);
/* 714 */     clearHandlers();
/*     */ 
/* 716 */     List preHandlers = this.config.getHandlers(this, UnifiedHandlerMetaData.HandlerType.PRE);
/* 717 */     List postHandlers = this.config.getHandlers(this, UnifiedHandlerMetaData.HandlerType.POST);
/*     */ 
/* 719 */     addHandlers(preHandlers);
/* 720 */     addHandlers(sepHandlers);
/* 721 */     addHandlers(postHandlers);
/*     */ 
/* 723 */     log.debug("Added " + preHandlers.size() + " PRE handlers");
/* 724 */     log.debug("Added " + sepHandlers.size() + " ENDPOINT handlers");
/* 725 */     log.debug("Added " + postHandlers.size() + " POST handlers");
/*     */   }
/*     */ 
/*     */   public List<Class> getRegisteredTypes()
/*     */   {
/* 730 */     return Collections.unmodifiableList(this.registeredTypes);
/*     */   }
/*     */ 
/*     */   public List<UnifiedPortComponentRefMetaData> getServiceRefContrib()
/*     */   {
/* 784 */     return this.serviceRefContrib;
/*     */   }
/*     */ 
/*     */   public boolean matches(UnifiedPortComponentRefMetaData pcRef)
/*     */   {
/* 789 */     String seiName = pcRef.getServiceEndpointInterface();
/* 790 */     QName portName = pcRef.getPortQName();
/*     */     boolean match;
/*     */     boolean match;
/* 793 */     if ((seiName != null) && (portName != null))
/*     */     {
/* 795 */       match = (getServiceEndpointInterfaceName().equals(seiName)) && (getPortName().equals(portName));
/*     */     }
/*     */     else
/*     */     {
/* 799 */       match = (getServiceEndpointInterfaceName().equals(seiName)) || (getPortName().equals(portName));
/*     */     }
/* 801 */     return match;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  92 */     SUPPORTED_BINDINGS.add("http://schemas.xmlsoap.org/wsdl/soap/http");
/*  93 */     SUPPORTED_BINDINGS.add("http://www.w3.org/2003/05/soap/bindings/HTTP/");
/*  94 */     SUPPORTED_BINDINGS.add("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true");
/*  95 */     SUPPORTED_BINDINGS.add("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true");
/*  96 */     SUPPORTED_BINDINGS.add("http://www.w3.org/2004/08/wsdl/http");
/*     */   }
/*     */ 
/*     */   class ConfigObservable extends Observable
/*     */   {
/* 736 */     private List<WeakReference<Observer>> observer = new ArrayList();
/*     */ 
/*     */     ConfigObservable() {
/*     */     }
/* 740 */     public void doNotify(Object object) { setChanged();
/* 741 */       notifyObservers(object);
/*     */     }
/*     */ 
/*     */     public synchronized void addObserver(Observer o)
/*     */     {
/* 746 */       this.observer.add(new WeakReference(o));
/*     */     }
/*     */ 
/*     */     public synchronized void deleteObserver(Observer o)
/*     */     {
/* 751 */       for (WeakReference w : this.observer)
/*     */       {
/* 753 */         Observer tmp = (Observer)w.get();
/* 754 */         if (tmp.equals(o))
/*     */         {
/* 756 */           this.observer.remove(o);
/* 757 */           break;
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/*     */     public void notifyObservers()
/*     */     {
/* 765 */       notifyObservers(null);
/*     */     }
/*     */ 
/*     */     public void notifyObservers(Object arg)
/*     */     {
/* 770 */       if (hasChanged())
/*     */       {
/* 772 */         for (WeakReference w : this.observer)
/*     */         {
/* 774 */           Observer tmp = (Observer)w.get();
/* 775 */           tmp.update(this, arg);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public static enum Type
/*     */   {
/*  86 */     JAXRPC, JAXWS;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.metadata.umdm.EndpointMetaData
 * JD-Core Version:    0.6.0
 */