/*    */ package org.jboss.ws.metadata.umdm;
/*    */ 
/*    */ import javax.xml.namespace.QName;
/*    */ import javax.xml.ws.handler.PortInfo;
/*    */ import org.jboss.ws.core.jaxws.handler.PortInfoImpl;
/*    */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData.HandlerType;
/*    */ 
/*    */ public class ClientEndpointMetaData extends EndpointMetaData
/*    */ {
/*    */   private String endpointAddress;
/*    */ 
/*    */   public ClientEndpointMetaData(ServiceMetaData service, QName qname, QName portTypeName, EndpointMetaData.Type type)
/*    */   {
/* 46 */     super(service, qname, portTypeName, type);
/* 47 */     this.configName = "Standard Client";
/*    */ 
/* 49 */     if (type == EndpointMetaData.Type.JAXRPC)
/* 50 */       this.configFile = "META-INF/standard-jaxrpc-client-config.xml";
/*    */     else
/* 52 */       this.configFile = "META-INF/standard-jaxws-client-config.xml";
/*    */   }
/*    */ 
/*    */   public String getEndpointAddress()
/*    */   {
/* 57 */     return this.endpointAddress;
/*    */   }
/*    */ 
/*    */   public void setEndpointAddress(String endpointAddress)
/*    */   {
/* 62 */     this.endpointAddress = endpointAddress;
/*    */   }
/*    */ 
/*    */   public PortInfo getPortInfo()
/*    */   {
/* 67 */     QName serviceName = getServiceMetaData().getServiceName();
/* 68 */     QName portName = getPortName();
/* 69 */     String bindingID = getBindingId();
/* 70 */     PortInfo portInfo = new PortInfoImpl(serviceName, portName, bindingID);
/* 71 */     return portInfo;
/*    */   }
/*    */ 
/*    */   public String toString()
/*    */   {
/* 76 */     StringBuilder buffer = new StringBuilder("\nClientEndpointMetaData:");
/* 77 */     buffer.append("\n type=").append(getType());
/* 78 */     buffer.append("\n qname=").append(getPortName());
/* 79 */     buffer.append("\n address=").append(getEndpointAddress());
/* 80 */     buffer.append("\n binding=").append(getBindingId());
/* 81 */     buffer.append("\n seiName=").append(getServiceEndpointInterfaceName());
/* 82 */     buffer.append("\n configFile=").append(getConfigFile());
/* 83 */     buffer.append("\n configName=").append(getConfigName());
/* 84 */     buffer.append("\n authMethod=").append(getAuthMethod());
/* 85 */     buffer.append("\n properties=").append(getProperties());
/*    */ 
/* 87 */     for (OperationMetaData opMetaData : getOperations())
/*    */     {
/* 89 */       buffer.append("\n").append(opMetaData);
/*    */     }
/* 91 */     for (HandlerMetaData hdlMetaData : getHandlerMetaData(UnifiedHandlerMetaData.HandlerType.ALL))
/*    */     {
/* 93 */       buffer.append("\n").append(hdlMetaData);
/*    */     }
/* 95 */     return buffer.toString();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.metadata.umdm.ClientEndpointMetaData
 * JD-Core Version:    0.6.0
 */