/*     */ package org.jboss.ws.metadata.jaxrpcmapping;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import javax.xml.namespace.QName;
/*     */ 
/*     */ public class WsdlMessageMapping
/*     */   implements Serializable
/*     */ {
/*     */   private static final long serialVersionUID = -3212852147033081838L;
/*     */   private MethodParamPartsMapping methodParamPartsMapping;
/*     */   private QName wsdlMessage;
/*     */   private String wsdlMessagePartName;
/*     */   private String parameterMode;
/*     */   private boolean soapHeader;
/*     */ 
/*     */   public WsdlMessageMapping(MethodParamPartsMapping methodParamPartsMapping)
/*     */   {
/*  53 */     this.methodParamPartsMapping = methodParamPartsMapping;
/*     */   }
/*     */ 
/*     */   public MethodParamPartsMapping getMethodParamPartsMapping()
/*     */   {
/*  58 */     return this.methodParamPartsMapping;
/*     */   }
/*     */ 
/*     */   public String getParameterMode()
/*     */   {
/*  63 */     return this.parameterMode;
/*     */   }
/*     */ 
/*     */   public void setParameterMode(String parameterMode)
/*     */   {
/*  68 */     if ((!"IN".equals(parameterMode)) && (!"OUT".equals(parameterMode)) && (!"INOUT".equals(parameterMode)))
/*  69 */       throw new IllegalArgumentException("Invalid parameter mode: " + parameterMode);
/*  70 */     this.parameterMode = parameterMode;
/*     */   }
/*     */ 
/*     */   public boolean isSoapHeader()
/*     */   {
/*  75 */     return this.soapHeader;
/*     */   }
/*     */ 
/*     */   public void setSoapHeader(boolean soapHeader)
/*     */   {
/*  80 */     this.soapHeader = soapHeader;
/*     */   }
/*     */ 
/*     */   public QName getWsdlMessage()
/*     */   {
/*  85 */     return this.wsdlMessage;
/*     */   }
/*     */ 
/*     */   public void setWsdlMessage(QName wsdlMessage)
/*     */   {
/*  90 */     this.wsdlMessage = wsdlMessage;
/*     */   }
/*     */ 
/*     */   public String getWsdlMessagePartName()
/*     */   {
/*  95 */     return this.wsdlMessagePartName;
/*     */   }
/*     */ 
/*     */   public void setWsdlMessagePartName(String wsdlMessagePartName)
/*     */   {
/* 100 */     this.wsdlMessagePartName = wsdlMessagePartName;
/*     */   }
/*     */ 
/*     */   public String serialize()
/*     */   {
/* 105 */     StringBuffer sb = new StringBuffer();
/* 106 */     sb.append(" <wsdl-message-mapping> <wsdl-message xmlns:");
/* 107 */     sb.append(this.wsdlMessage.getPrefix()).append("='").append(this.wsdlMessage.getNamespaceURI()).append("'>");
/* 108 */     sb.append(this.wsdlMessage.getPrefix()).append(":").append(this.wsdlMessage.getLocalPart()).append("</wsdl-message>");
/* 109 */     sb.append("<wsdl-message-part-name>").append(this.wsdlMessagePartName).append("</wsdl-message-part-name>");
/* 110 */     sb.append("<parameter-mode>").append(this.parameterMode).append("</parameter-mode>");
/* 111 */     if (this.soapHeader)
/* 112 */       sb.append("<soap-header/>");
/* 113 */     sb.append("</wsdl-message-mapping>");
/* 114 */     return sb.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.metadata.jaxrpcmapping.WsdlMessageMapping
 * JD-Core Version:    0.6.0
 */